@extends('layouts.app')
@section('title','Raw Gate Pass | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<x-datatable-js type="css"/>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
{{-- <link rel="stylesheet" href="{{ asset('backend/print.min.css') }}"/> --}}
<style>
.select2-selection { overflow: hidden; }
.select2-selection__rendered { white-space: normal; word-break: break-all; }
</style>


    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Raw Gate Pass</strong> Information
                            <a href="{{ route('supplier.retrive')}}" class="btn btn-info btn-sm float-right">Pending Orders</a>
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="supplier" class="form-control-label" >Supplier Name</label>
                                                <select name="supplier" id="supplier" class="form-control form-control-sm select2" style="width: 100% !important">
                                                    <option value="">Please select</option>
                                                    @forelse ($suppliers as $supplier)
                                                        <option value="{{ $supplier->id }}">{{ $supplier->supplier_name }}</option>
                                                    @empty
                                                        
                                                    @endforelse
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="date_picker" class="form-control-label mr-3">Date Picker</label>
                                                <input type="text" id="date_picker" name="date_picker" placeholder="Date Picker" class="form-control form-control-sm"> 
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="supplier" class="form-control-label" >Type</label>
                                                <select name="type" id="type" class="form-control form-control-sm">
                                                    <option value="">Please select</option>
                                                    <option value="1">Check In</option>
                                                    <option value="2">Check Out</option>
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <label for="date_picker" class="form-control-label mr-3">-</label><br>
                                            <a href="javascript:;" class="btn btn-success btn-sm" id="search_change"><i class="fas fa-search" aria-hidden="true"></i> Search</a>
                                        </div>
                                        
                                        
                                    </div>
                                    <!--style="display:none"-->
                                    <div style="display:none">
                                        <!---->
                                   <form id="pdfGatePass" action="{{route('pdf.gate.pass')}}" method="POST">
                                    @csrf
                                    <input type="text" id="supplier_id" name="supplier_id" value="ALL"/>
                                    <input type="text" id="start_date" name="start_date"/>
                                    <input type="text" id="end_date" name="end_date"/>
                                    <input type="text" id="po_id2" name="po_id2"/>
                                    <input type="text" id="rec_id2" name="rec_id2"/>
                                    <input type="text" id="gate_pass_serial" name="gate_pass_serial"/>
                                    <button class="btn btn-success btn-sm " type="submit" id="makePDF">PDF</button>
                                    <button class="btn btn-success btn-sm " type="button" id="makePrint">Print</button>
                                </form> 
                                </div>
                                    
    
                                    

                                {{-- </div> --}}
                                
                               
                            {{-- </div> --}}
                            <hr>
                            <div class="table-responsive">
                                <table class="table  table-bordered  table-striped" cellspacing="0" width="100%" id="posts" data-id='' data-start='' data-end='' data-supplier-name=''>
                                    <thead>
                                        <tr class="thead-dark">
                                            <th>Assign Date</th>
                                            <th>Assign ID</th>
                                            <th>Supplier Name</th>
                                            <th>Type</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="{{ asset('backend/toast/jquery.toast.min.js') }}"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>

<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
{{-- <script type="text/javascript" src="{{ asset('backend/print.min.js') }}"></script> --}}


<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<x-datatable-js type="js"/>



<script>
    // var start = moment().subtract(29, 'days');
   
    var start = moment();
    var end = moment();
    var date_options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    var today = new Date().toLocaleDateString('en-UK',date_options);


    function cb(start, end) {
        $('#date_picker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#posts").attr("data-start",start.format('YYYY-MM-DD'));
        $("#posts").attr("data-end",end.format('YYYY-MM-DD'));
        
        $("#start_date").val(start.format('YYYY-MM-DD'));
        $("#end_date").val(end.format('YYYY-MM-DD'));
        
        get_po_list();
    }

    $('#date_picker').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);
    

    $('.select2').select2({
        width: '100%'
    });
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    
    var table =$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        fixedHeader: {
            header: true,
            footer: true
        },
        "ajax":{
                    "url": "{{ route('raw.gatepass') }}",
                //  "dataType": "json",
                    "type": "POST",
                    data:function(d){
                    d._token= "{{csrf_token()}}";
                    d.supplier_id=$('#posts').attr('data-id');
                    d.start_date=$("#posts").attr("data-start");
                    d.end_date=$("#posts").attr("data-end");
                },
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
            {"searchable":false,"targets":[4]}
        ],
        lengthMenu: [[10, 25, 50,100,500, -1], [10, 25, 50,100,500, "All"]],
        bSort: false,
        "ordering": false,
        "columns": [
            { "data": "assign_date","name":"assign_date" },
            { "data": "assign_id","name":"assign_quantity_raw.assign_id" },
            { "data": "supplier_name","name":"supplier_name" },
            { "data": "type_name","name":"type_name" },
            { "data": "action","name":"action" },
            // { "data": "created_at","name":"created_at" },//Order QTY
        ],
        initComplete: function () {
            $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button');
            $('.buttons-pdf').html('<i class="fas fa-file-pdf"></i> Pdf').removeClass('dt-button');
            $('.buttons-print').html('<i class="fas fa-print"></i> Print').removeClass('dt-button');
            $('.buttons-page-length').html('<i class="far fa-file"></i> Page Length').removeClass('dt-button').css('color','white');
            $('.button-page-length').removeClass('dt-button').addClass('btn btn-primary');
            $('.dataTables_paginate > span .paginate_button').addClass('btn btn-primary');
            $('.clpdf').removeClass('dt-button');
            $('.dt-buttons').addClass('ml-5');
        },dom: 'lfrtip',
        buttons: [
                {   extend: 'excelHtml5', 
                    className: 'btn btn-danger',
                    footer: true,
                    header:false,
                    
                    customize: function ( xlsx ) {
                        var sheet = xlsx.xl.worksheets['sheet1.xml'];
                        //Bold Header Row
                        $('row[r=5] c', sheet).attr( 's', '2' );
                        //Make You Input Cells Bold Too
                        $('c[r=A2]', sheet).attr( 's', '2' );
                        $('c[r=F2]', sheet).attr( 's', '2' );
                        $('c[r=A3]', sheet).attr( 's', '2' );
                        $('c[r=F3]', sheet).attr( 's', '2' );

                    },
                    customizeData: function(data){
                        var desc = [
                            ['',''],
                            ['Report from',$('#posts').attr('data-start'),'','Report TO',$('#posts').attr('data-end')],
                            ['Supplier Name',$('#posts').attr('data-supplier-name'),'','Dated',today],

                        ];
                        data.body.unshift(data.header)
                        for (var i = 0; i < desc.length; i++) {
                            data.body.unshift(desc[i]);
                        };
                    }
                },
                // {   extend: 'pdfHtml5', 
                //     footer: true,
                //     className: 'btn btn-success',
                //     messageTop: function(){
                //         return "Supplier Name : " + $('#posts').attr('data-supplier-name')+'                   Dated : '+ today +'                  Report :'+$('#posts').attr('data-start')+'  -  '+$('#posts').attr('data-end');
                //     },
                    
                    
                //  },
                 {
                    className: 'btn btn-success clpdf',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    action: function ( e, dt, node, config ) {
                        $('#makePDF').click();
                    }
                },
                {
                    className: 'btn btn-warning clpdf',
                    text: '<i class="fas fa-print"></i> GRN Print',
                    action: function ( e, dt, node, config ) {
                        $('#makePrint').click();
                    }
                },
                {   extend: 'print', 
                    className: 'btn btn-info',
                    footer: true,
                    autoPrint: true,
                    exportOptions: { stripHtml: false, },
                    messageTop: function(){
                        return "Supplier Name : " + $('#posts').attr('data-supplier-name')+'<br>Report Date : '+ today+'<br>Report :'+$('#posts').attr('data-start')+'  -  '+$('#posts').attr('data-end');
                    },
                },
                // { extend: 'pageLength', className: 'btn btn-primary'}
            ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
            var info = $('#posts').DataTable().page.info();
                tot = info.recordsTotal;
                
                if (tot > 0) {
                    $('#posts').DataTable().buttons().enable();   
                } else {
                    $('#posts').DataTable().buttons().disable();    
                }
            $('#posts').on( 'search.dt', function () {
                    var val=$('#posts').DataTable().search();
                    if(val !=''){
                        $('.dt-buttons .clpdf').hide();
                    }else{
                        $('.dt-buttons .clpdf').show();
                    }
                    
                });
                
                // $('#posts').on( 'order.dt', function () {
                //     $('.dt-buttons .clpdf').hide();
                // });
                
                $('#supplier').on('change',function(){
                     $('.dt-buttons .clpdf').show();
                })
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 4 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                 
                
                // Update footer by showing the total with the reference of the column index 
                $( api.column( 0 ).footer() ).html('TOTAL');
                $( api.column( 4 ).footer() ).html(wedTotal);
                $('#rec_qty').text(wedTotal);
        },
    });

    function loader(id,show=1){
        if(show){
            $(id).css({
                'position':'relative',
            });
            $('<div>',{
                class:'loaderShow bg-info'
            }).css({
                'z-index': '1000','position':'absolute','font-size': '12px',
                'top':'5%','left':'50%','padding':'10px','border-radius':'10px'
            }).prependTo(id)
            .html('<i class="fas fa-spinner fa-pulse fa-3x fa-spin" style="color:white"></i><span class="sr-only">Loading...</span>');
        }else{
            $(id+' .loaderShow').remove();
        }
    }
    
    $('#supplier').change(function(){
        get_po_list();
    });
    
    $('#po_id').change(function(){
        get_serial_list();
    });
    
    function get_serial_list(){
        $.ajax({
            url:"{{route('gate.po_list_gatepass_serial')}}",
            type:'POST',
            data:{
                _token: "{{csrf_token()}}",
                supplier_id:$('#supplier').val(),
                start_date:$("#posts").attr("data-start"),
                end_date:$("#posts").attr("data-end"),
                po_id:$('#po_id option:selected').val()
            },
            dataType:'json',
            success:function(data){
                $('#serial_id').html(data.html);
            }
        })
    }
    
    function get_po_list(){
        $.ajax({
            url:"{{route('gate.gate_pass_po_list')}}",
            type:'POST',
            data:{
                _token: "{{csrf_token()}}",
                supplier_id:$('#supplier').val(),
                start_date:$("#posts").attr("data-start"),
                end_date:$("#posts").attr("data-end"),
            },
            dataType:'json',
            success:function(data){
                $('#po_id').html(data.pohtml);
                $('#serial_id').html(data.serialhtml);
                // $('#po_id2').val('ALL');
            }
        })
    }

    $('#search_change').on('click',function(){
        $('#posts').attr('data-supplier-name',$("#supplier option:selected").text());
        $('#posts').attr('data-id',$('#supplier').val());
        $('#supplier_id').val($("#supplier").val());
        
        $('#rec_id2').val($('#serial_id option:selected').val());
        $('#po_id2').val($('#po_id option:selected').val());
        // $.ajax({
        //     url:"{{route('gate.pass.serial')}}",
        //     data:{
        //       supplier_id:$("#supplier").val(),
        //       _token : "{{csrf_token()}}"
        //     },
        //     type:'POST',
        //     dataType:'JSON',
        //     success:function(data){
        //         $('#gate_pass_serial').val(data.gate_pass_serial);
        //     }
        // })
        $('#posts').DataTable().ajax.reload().draw();
    });

    
    $('#posts').on('click', 'tbody .print_btn', function () {
        print_label(table.row($(this).closest('tr')).data());

    });
    
    $('#makePrint').click(function(){
        print_po();
    });
    
    $(document).on('click','.reverse_gatepass',function(){
        var last_receiving_id=$(this).attr('data-last_receiving_id');
        var result = prompt("Are you sure want to Reverse ? Please Provide Reason for Reverse");
        if (result === null) {
            return;
        }else{
            console.log(result);
            $.ajax({
                url:"{{route('gate.reverse_gatepass')}}",
                type:'POST',
                data:{
                    _token: "{{csrf_token()}}",
                    last_receiving_id:last_receiving_id,
                    reason:result
                },
                dataType:'json',
                success:function(data){
                    if(data.success=='1'){
                        $.toast({
                            heading: 'Success',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                }
            })
        }
        
        
    });
    
    function print_po(){
        
        var formData=$('#pdfGatePass').serializeArray();
        formData.push({ name: "is_print", value: "1" });
        // console.log(formData);return;
        var url = '{{route('pdf.gate.pass')}}';
        // url = url.replace(':id',id);
        var w;
        $.ajax({
            url:url,
            type:'POST',
            cache: false,
            datatype: 'json',
            data:formData,
            async: false,
            success:function(data){
                if(data.success==true){
                    
                    w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    w.document.open();
                    w.document.write(data.html);
                    
                    // 
                    
                    w.document.close();
                    setTimeout(function(){ w.print(); }, 2000);
                    
                    // $('#no_of_label').val('');
                    // $('#blister_qty').val('');
                    // $('#blisterModal').modal('hide');
                    
                    // $('<html>').html(data.html).print(); 
                }
            }
        });
    }

    function print_label(data_row){
        
        var val=$('#receiving_qty_'+data_row.id).val();
        var url = '{{ route("supplier.print.label", ":id") }}';
        url = url.replace(':id', data_row.id);
        $.ajax({
            url:url,
            type:'POST',
            cache: false,
            datatype: 'json',
            data:{
                receive_qty:val,
                _token: "{{csrf_token()}}"
            },
            async: false,
            success:function(data){
                if(data.success==true){
                    $('<html>').html(data.html).print(); 
                }
            }
        });
    }
    
    $(document).on('click', '.viewgatePass', function() {
    var self = $(this);
    var assign_id = self.data('assign_id');
    var supplier_id = self.data('supplier_id');
    var type = self.data('type');

    $.ajax({
        url: "{{ route('raw.view.gatepass') }}",
        type: 'POST',
        cache: false,
        dataType: 'json',
        data: {
            assign_id: assign_id,
            supplier_id: supplier_id,
            type: type,
            _token: "{{ csrf_token() }}"
        },
        async: false,
        success: function(data) {
            
                var w = window.open('about:blank', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                w.document.open();
                w.document.write(data.html);
                w.document.close();
                setTimeout(function() {
                    w.print();
                }, 2000);
            
        },
        error: function(xhr, status, error) {
            console.error('AJAX Error:', status, error);
        }
    });
});


     
      
</script>

    
@endsection