@extends('layouts.app')
@section('title','Process Orders | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Process Order </strong> List
                            <a href="javascript:;" id="assign_qty" class="float-right btn btn-success btn-sm ml-1 assign_qty" style="display:none"><i class="fas fa-check"></i> Update Quantity</a>
                            
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            {{-- <a href="{{ route('create')}}" class="btn btn-info float-left mb-2">Add New Sku</a> --}}
                            <div id="showAlert"></div>
                            <div class="container custom_filter bg-light pt-3 pb-3 border  rounded">
                                <div class="row">
                                    <div class="col-12 col-md-5">
                                        <select name="store" id="store" class="form-control select2">
                                            <option value="">Select Store</option>
                                            @forelse ($stores as $store)
                                                <option value="{{ $store->id }}">{{ $store->strong_name}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-5">
                                        <select name="shipment_type" id="shipment_type" class="form-control select2">
                                            <option value="">Select Type</option>
                                            <option value="1">Air Cargo</option>
                                            <option value="2">Sea Cargo</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-2" style="display:none" id="download_div">
                                        <a href="javascript:;" id="download_po_excel" class="btn btn-info btn-sm "><i class="fas fa-file-excel"></i> Download Excel</a>
                                    </div>
                                    <!--<div class="col-12 col-md-4">-->
                                    <!--    <select name="status" id="status" class="form-control select2">-->
                                    <!--        <option value="">Select Status</option>-->
                                    <!--        <option value="1">Urgent</option>-->
                                    <!--        <option value="2">Normal</option>-->
                                    <!--    </select>-->
                                    <!--</div>-->
                                </div>
                            </div>
                            <form method="POST" id="assign_form" class="mt-3">
                                @csrf
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                        <thead >
                                            <tr class="thead-light">
                                                
                                                <th colspan="4" class="text-right">Total</th>
                                                <th id="instock_total"></th>
                                                <th id="order_total" colspan="2"></th>
                                            </tr>
                                            <tr class="thead-dark">
                                                <th>
                                                
                                                    Date
                                                </th>
                                                <th>Product Image</th>
                                                <th>Product Name</th>
                                                <th>Size</th>
                                                <th>In Stock</th>
                                                <th>Order Quantity</th>
                                                <th>Supply</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr>
                                                
                                                <th colspan="4" class="text-right"></th>
                                                <th></th>
                                                <th colspan="2"></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                
                            </form>
                            <hr>
                            <a href="javascript:;" id="assign_qty2" class="float-right btn btn-success btn-sm ml-1 mt-1 assign_qty" style="display:none"><i class="fas fa-check"></i> Update Quantity</a>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="{{ asset('/backend/toast/jquery.toast.min.js') }}"charset="utf8"></script>


<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('shipment.process.order') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.store= $('#store option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                        d.status=$('#status option:selected').val();
                        
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,1,6] },
            { "width": "10%", "targets": [] },
            { "width": "5%", "targets": [] },
        ],
        bSort: false,
        "ordering": false,
        stateSave: true,
        fixedHeader: {
            header: true
        },
        "columns":[
            { "data": "created_at","name":"created_at" },
            { "data": "product_img","name":"product_img" },
            { "data": "product_name","name":"product_name" },
            { "data": "size","name":"size" },
            { "data": "instock","name":"instock" },
            { "data": "given_qty","name":"given_qty" },
            { "data": "receiving_input","name":"receiving_input" },
        ],
        // createdRow: (row, data, dataIndex, cells) => {
        //     var status='';
        //     if(data.shipment_type =='1'){
        //         status='<span class="text-primary text-sm">Air Cargo</span>';
        //     }else if(data.shipment_type =='2'){
        //       status='<span class="text-primary text-sm">Sea Cargo</span>'; 
        //     }
        //     $(cells[5]).html(status);
        //     $(cells[4]).addClass('text-success font-weight-bold');
        // },
        "drawCallback": function( settings ) {
            loader('#posts',0);
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#download_div').show();   
            } else {
                $('#download_div').hide();    
            }
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#download_div').show();   
            } else {
                $('#download_div').hide();    
            }
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 4 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var thuTotal = api
                .column( 5 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    // b = b.replace('Order QTY : ', "");
                    return intVal(a) + intVal(b);
                }, 0 );
                
                // Update footer by showing the total with the reference of the column index 
                $( api.column( 3 ).footer() ).html('Total');
                $('#instock_total').text(wedTotal);
                $('#order_total').text(thuTotal);
                $( api.column( 4 ).footer() ).html(wedTotal);
                $( api.column( 5 ).footer() ).html(thuTotal);
        },
    });
    
    $('.select2').on('change',function(){
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    
    // $('#posts').on('click','tbody .assign_qty',function(){
    //     var id=$(this).attr('data-id');
    //     $.ajax({
    //         url:"{{route('shipment.send.process')}}",
    //         type:"POST",
    //         data:{
    //             pr_id:$('#pr_id_'+id).val(),
    //             store_id:$('#store_id_'+id).val(),
    //             shipment_type:$('#shipment_type_'+id).val(),
    //             urgent_status:$('#urgent_status_'+id).val(),
    //             instock:$('#instock_'+id).val(),
    //             variation_id:$('#variation_id_'+id).val(),
    //             variation_design:$('#variation_design_'+id).val(),
    //             filled_qty:$('#filled_qty_'+id).val(),
    //             approve_qty:$('#approve_qty_'+id).val(),
    //             _token: "{{csrf_token()}}"
    //         },
    //         success:function(data){
    //             if(data){
    //                 $.toast({
    //                     heading: 'Success',
    //                     text: 'Assign Quantity Successfully',
    //                     showHideTransition: 'slide',
    //                     icon: 'success',
    //                     position: 'top-center',
    //                 });
    //                 $('#posts').DataTable().ajax.reload().draw();
    //                 $('#date_check').prop('checked',false);
    //             }else{
    //                 $.toast({
    //                     heading: 'Error',
    //                     text: 'Error in Assign Quantity',
    //                     showHideTransition: 'slide',
    //                     icon: 'error',
    //                     position: 'top-center',
    //                 });
    //             }
    //         }
    //     })
        
    // });
    $('#assign_qty').click(function(){
        var reqSupplier=$('.id_check').filter(':checked').length;
        if(reqSupplier ==0){
            row = $('#posts_wrapper tbody tr:first-child');
            $(row).addClass('table-warning');
            $.toast({
                heading: 'Error',
                text: 'Please Enter the Supply',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
            return; 
        }
        var obj= {};
        var array=[];
        var id;
        var value = $('.id_check').filter(':checked').filter(function () {
            id=$(this).attr('id').split("_")[2];
            console.log(id);
            obj.store_id=$('#store_id_'+id).val();
            obj.shipment_type=$('#shipment_type_'+id).val();
            obj.instock=$('#instock2_'+id).text();
            obj.variation_id=$('#variation_id_'+id).val();
            obj.variation_design=$('#variation_design_'+id).val();
            obj.filled_qty=$('#filled_qty_'+id).val();
            obj.approve_qty=$('#approve_qty_'+id).val();
            if($('#checkbox_'+id).is(':checked')==true){
                obj.checkbox=$('#checkbox_'+id).val();
            }else{
                obj.checkbox=0;
            }
            
            obj.id=id;

            array.push(obj);
            obj={};
            
        });
        // return;
        // console.log(array);return;
        // console.log(value.length +'==='+reqSupplier);
        // if (value.length>=0 && (value.length !== reqSupplier)) {
        //     $.toast({
        //         heading: 'Error',
        //         text: 'Please Enter the Supply',
        //         showHideTransition: 'slide',
        //         icon: 'error',
        //         position: 'top-center',
        //     });
        // } else {
            $.ajax({
                url:"{{ route('shipment.send.process') }}",
                type:"POST",
                data:{
                    array:array,
                    _token: "{{csrf_token()}}"
                },
                success:function(data){
                    if(data){
                        $.toast({
                            heading: 'Success',
                            text: 'Assign Quantity Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-center',
                        });
                        $('#posts').DataTable().ajax.reload().draw();
                        $('.assign_qty').hide();
                        $('#date_check').prop('checked',false);
                    }else{
                        $.toast({
                            heading: 'Error',
                            text: 'Error in Assign Quantity',
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-center',
                        });
                    }
                }
            })
        // }
        
        
    });
    
    $('#posts').on('input','tbody .input_filled',function(){
        var id=$(this).attr('data-id');
        var instock=parseInt($('#instock2_'+id).text());
        console.log(instock);
        var rec_qty=parseInt($('#filled_qty_'+id).val().trim());
        
        if(rec_qty ==0){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#assign_qty_'+id).hide();
            $('.assign_qty').hide();
            
            return false;
        }
        if(!/^[0-9]+$/.test(rec_qty) && rec_qty !=0){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#assign_qty_'+id).hide();
            $('.assign_qty').hide();
        }else{
            if(rec_qty<=instock){
                $('#id_check_'+id).prop('checked','checked');
                $('#error_'+id).hide();
                $('#assign_qty_'+id).show();
                $('.assign_qty').show();
            }else{
                $('#error_'+id).text('Receive Quantity Exceed from InStock');
                $('#error_'+id).show();
                $('#id_check_'+id).prop('checked',false);
                $('#assign_qty_'+id).hide();
                $('.assign_qty').hide();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Exceed from InStock',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return;
            }
        }
    });
    
    
    
    $('#assign_qty2').click(function(){
        $('#assign_qty').click();
    })
    
    $('#download_po_excel').click(function(){
        var store=$('#store option:selected').val();
        var shipment_type=$('#shipment_type option:selected').val();
        var url = '{{ route("excel.process.order", [":store_id",":shipment_type"]) }}';
        url = url.replace(':store_id',store);
        url = url.replace(':shipment_type',shipment_type);
        
        window.location.href=url;
    });

    

    

    
    
</script>

    
@endsection