@extends('layouts.app')
@section('title','Bundle List | Mini Opex')
@section('add_css')
<x-datatable-js type="css"/>

@endsection

@section('content')
<div class="modal fade" id="adjustModal" tabindex="-1" role="dialog" aria-labelledby="adjustModalLabel" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="adjustModalLabel">Cancellation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" id="closebtn">
                    <span aria-hidden="true" >&times;</span>
                </button>
            </div>
            <form  id="item_adjust">
                @csrf
                <div class="modal-body">
                    <div class="form-group " id="comment_div">
                        <label for="text-input" class=" form-control-label">Reason </label>
                        <textarea class="form-control" id="comments" name="comments" required></textarea>
                    </div>
                    
                    
                    
                    
                    <div class="form-group">
                        <div class="form-check" id="issued_div">
                            <div class="checkbox">
                                <label for="issued_po" class="form-check-label ">
                                    <input type="checkbox" id="issued_po" name="issued_po" value="YES" class="form-check-input"> PO Issued
                                </label>
                            </div>
                        </div>
                        
                        <div class="form-check" id="supplier_div">
                            <div class="checkbox">
                                <label for="supplier_order" class="form-check-label ">
                                    <input type="checkbox" id="supplier_order" name="supplier_order" value="YES" class="form-check-input">Cancel Supplier Orders
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group" id="given_div" style="display:none;">
                        <label for="text-input" class=" form-control-label">Given Qty </label>
                        <input type="number" class="form-control" id="new_given_qty" name="new_given_qty" pattern="^[0-9]*$" min="1"/>
                    </div>
                </div>
                
                
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="adjustBtn">Cancelled</button>
                
                </div>
            </form>
        </div>
    </div>
</div>
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row ml-2 mr-2 mb-2">
                <div class="col-lg-4 col-md-4 col-sm-12 col-12 mt-1">
                    <div class="statistic__item border_grey bg-grey">
                        <h2 class="number text-white"><span id="total_pending_ex">0</span></h2>
                        <span class="desc text-white">Total Pending</span>
                        <div class="icon text-white">
                            <i class="fas fa-clock-o"></i>
                        </div>
                    </div>
                    
                </div>
                <div class="col-lg-8 col-md-8 col-sm-12 col-12 mt-1">
                    <div class="row custom_filter pt-4 pb-3 border  rounded">
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <select name="store" id="store_id" class="form-control select2">
                                <option value="">Select Store</option>
                                @forelse ($stores as $store)
                                    <option value="{{ $store->id }}">{{ $store->strong_name}}</option>
                                @empty
                                    
                                @endforelse
                            </select>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <select name="shipment_type" id="shipment_type" class="form-control select2">
                                <option value="">Select Type</option>
                                <option value="1">Air Cargo</option>
                                <option value="2">Sea Cargo</option>
                            </select>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <div style="display:none" id="download_div" class="">
                                 <a href="javascript:;" id="download_po_excel" class="btn bg-orange text-dark btn-sm"><i class="fas fa-file-excel"></i> Excel</a>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Bundle </strong> List
                            <button type="button" id="export_excel" class="float-right btn btn-info btn-sm ml-1" style="display:none"><i class="fas fa-file-pdf"></i> Update Quantity</button>
                            @can('process-cancel')
                            <button type="button" id="cancellation_btn" class="btn btn-danger btn-sm ml-5" style="display:none"><i class="fas fa-close"></i> Cancellation</button>
                            @endcan
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            
                            
                            
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr class="thead-light">
                                            <th colspan="2" class="text-right">Total</th>
                                            <th id="instock_qty">0</th>
                                            <th colspan="2" id="approve_qty">0</th>
                                        </tr>
                                        <tr class="thead-dark">
                                            <th><input type="checkbox" id="date_check"class="ml-2 date_check">&nbsp;Bundle Image</th>
                                            <th>Bundle Name</th>
                                            <th>Instock</th>
                                            <th>Approve QTY</th>
                                            <th>Supply QTY</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr class="thead-light">
                                            <th colspan="2" class="text-right">Total</th>
                                            <th>0</th>
                                            <th colspan="2">0</th>
                                        </tr>
                                       
                                    </tfoot>
                                </table>
                            </div>
                            
                    </div>
                    
                </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
    </div>
</div>
@endsection

@section('add_js')
<x-datatable-js type="js"/>
<script>
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        fixedColumns: true,
        fixedHeader: true,
        scrollX: true,
        lengthMenu: [
            [10, 25, 50,100,500],
            [10, 25, 50,100,500],
        ],
        "ajax":{
                    "url": "{{ route('shipment.bundle.list') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.store= $('#store_id option:selected').val();
                        d.shipment_type=$('#shipment_type option:selected').val();
                        
                        get_process_count($('#store_id option:selected').val(),$('#shipment_type option:selected').val())
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,4] },
            { "searchable": false, "targets": [0,2] },
        ],
        "order": [[ 1, "desc" ]],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "bundleImage","name":"bundleImage" },
            { "data": "bundleDetail","name":"bundleDetail" },
            { "data": "instock","name":"instock" },
            { "data": "orderqty","name":"orderqty" },
            { "data": "supply_qty","name":"supply_qty" },
            
            
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#download_div').show();   
            } else {
                $('#download_div').hide();    
            }
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#download_div').show();   
            } else {
                $('#download_div').hide();    
            }
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Total InStock : ')[1];
                    // console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                
            var wedTotal1 = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    b = b.split('<hr>')[0];
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Available Bundle : ')[1];
                    console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var thuTotal = api
                .column( 3 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Out from InStock : ')[1];
                    // b = b.replace('Order QTY : ', "");
                    console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                
                var thuTotal1 = api
                .column( 3 )
                .data()
                .reduce( function (a, b) {
                    b = b.split('<hr>')[0];
                    b = b.replace(/<\/?[^>]+(>|$)/g, "").split('Order Quantity : ')[1];
                    console.log(b);
                    return intVal(a) + intVal(b);
                }, 0 );
                
                var new_instock='Stock : '+wedTotal+' | Avg Bundle : '+wedTotal1;
                var new_approve='Out of Stock : '+thuTotal+' | Order QTY : '+thuTotal1;
                
                //Update footer by showing the total with the reference of the column index 
                $( api.column( 1 ).footer() ).html('Total');
                $('#instock_qty').text(new_instock);
                $('#approve_qty').text(new_approve);
                $( api.column( 2 ).footer() ).html(new_instock);
                $( api.column( 3 ).footer() ).html(new_approve);
        },
    });
    
    $('.select2').on('change',function(){
        var id=$(this).attr('id');
        // if($('#store_id option:selected').val() !='' && $('#shipment_type  option:selected').val() !=''){
            
        //     $('#export_excel').show();
        // }else{
        //     $('#export_excel').hide();
        // }
        $('#'+id+'2').val($('#'+id +' option:selected').val());
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    $('#posts').on('input','tbody .supply_qty',function(){
      var id=$(this).attr('data-id');
      var val=parseInt($('#supply_qty_'+id).val().trim());
      var instock=parseInt($('#avail_'+id).text());
      var order_qty=parseInt($('#outstock_'+id).text());
      console.log(instock);
      if(!/^[0-9]+$/.test(val) || val ==0){
          
            $('#error_'+id).text('Receive Quantity Only Numbers And Not Equal to "0"');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers And Not Equal to "0"',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });  
            $('#id_check_'+id).prop('checked',false);
            $('#export_excel').hide();
      }else if(val !=''){
          if(val<=instock && val <= order_qty){
              $('#error_'+id).hide();
              $('#id_check_'+id).prop('checked','checked');
              $('#export_excel').show();
          }else{
            $('#error_'+id).text('Receive Quantity Exceeded');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Exceeded',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('#export_excel').hide();
          }
      }else{
         $('#error_'+id).hide(); 
      }
    });
    
    $('#export_excel').click(function(){
        var reqSupplier=$('.id_check').filter(':checked').length;
        if(reqSupplier ==0){
            return; 
        }
        
        var obj= {};
        var array=[];
        var id;
        var input_id=[];
        var value = $('.id_check').filter(':checked').filter(function () {
            id=$(this).attr('id').split("_")[2];
            input_id.push(id);
            console.log(id);
            
            obj.supply_qty=$('#supply_qty_'+id).val();
            obj.pr_id=$('#pr_id_'+id).val();
            obj.store_id=$('#store_id option:selected').val();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.order_qty=$('#outstock_'+id).text();
            obj.bundle_set_variation=$(this).val();
            obj.id=id;
            
            if(!/^[0-9]+$/.test($('#supply_qty_'+id).val()) || $('#supply_qty_'+id).val() ==0){
                $('#error_'+id).text('Receive Quantity Only Numbers And Not Equal to "0"');
                $('#error_'+id).show();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Only Numbers And Not Equal to "0"',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                });  
                $('#id_check_'+id).prop('checked',false);
                array=[];
                obj={};
                return false;
            }else{
                array.push(obj);
                obj={};
            }

            
        });
        
        if(array.length !=0){
            $('#id_list').val(input_id.join(','));
            $.ajax({
                url:"{{route('add.bundle.processed')}}",
                type:'POST',
                data:{
                    _token:"{{csrf_token()}}",
                    array:array,
                },
                dataType:'JSON',
                success:function(data){
                    if(data.success){
                        $.toast({
                            heading: 'Success',
                            text: 'Bundle Processed Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        
                        $('#posts').DataTable().ajax.reload().draw();
                        // $('#pick_pdf').submit();
                        
                    }
                }
            })    
        }
        
    });
    
    $(document).on('change','.id_check2',function(){
       var self=$(this);
       var checked=self.filter(":checked").length;
        //   alert(self);
       
       if(checked>0){
           $('#cancellation_btn').show();
       }else{
           $('#cancellation_btn').hide();
       }
    });
    
    $('#cancellation_btn').click(function(){
        var self=$(this);
        if(confirm('Are you sure Want to Cancel ?')){
            $('#item_adjust').trigger("reset");
            $('#adjustModal').modal('show');
        }
    });
    
    $('#issued_po').click(function(){
        var self=$(this);
        if(self.is(':checked')){
            $('#given_div').show();
        }else{
            $('#given_div').hide();
        }
    })
    
    $('#item_adjust').on('submit',function(e){
        
        
        e.preventDefault();
        var formdata=$(this).serializeArray();
        
        var obj= {};
        var array=[];
        $('.id_check2').filter(':checked').filter(function(){
            var idSelf=$(this);
            
            obj.id=idSelf.data('id');
            obj.store_id=$('#store_id option:selected').val();
            obj.shipment_type=$('#shipment_type  option:selected').val();
            obj.variation_design=idSelf.val();
            obj.given_qty=idSelf.data('given_qty');
            obj.var_list=$('#bun_'+idSelf.val()).data('stock_bundle');
            
            array.push(obj);
            obj={};
        });
        formdata.push({ name: "variation_list", value: JSON.stringify(array) });
        
        console.log(formdata);
        
        $.ajax({
            url:"{{route('shipment.cancel.bundle')}}",
            data:formdata,
            type:'POST',
            dataType:'JSON',
            success:function(data){
                if(data.code='200'){
                    $.toast({
                        heading: 'Success',
                        text: 'Product Cancelled Successfully',
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-center',
                    });
                    $('#adjustModal').modal('hide');
                    $('#item_adjust').trigger("reset");
                    $('#cancellation_btn').hide();
                    $('#date_check').prop('checked',false);
                    $('#posts').DataTable().ajax.reload().draw();
                }
            }
        })
    });
    
    //added by sufian 08-04-23
    $('#download_po_excel').click(function(){
        var store=$('#store_id option:selected').val();
        var shipment_type=$('#shipment_type option:selected').val();
        var url = '{{ route("excel.process.bundle.order", [":store_id",":shipment_type"]) }}';
        url = url.replace(':store_id',store);
        url = url.replace(':shipment_type',shipment_type);
        
        window.location.href=url;
    });
    
    $('#date_check').click(function(){
        if($('#date_check').is(':checked')){
            $('.id_check2').prop('checked',true);
            $('#cancellation_btn').show();
            // check_variation_design()
        }else{
            $('.id_check2').prop('checked',false);
            // $('#variation_list').val('');
            $('#cancellation_btn').hide();
        }
    });
    
    function get_process_count($store_id,$shipment_id){
        $.ajax({
            url:"{{route('get_process_count')}}",
            data:{
                store_id:$store_id,
                shipment_type:$shipment_id,
                _token:"{{csrf_token()}}"
            },
            type:'POST',
            dataType:'JSON',
            success:function(data){
                $('#total_pending_ex').text(data.bundle_pending);
            }
        })
    }
</script>

    
@endsection