<!DOCTYPE html>
<html lang="en">
<head>
    <title>View Order</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        table, td, th {
          border: 1px solid;
        }
        
        table {
          width: 100%;
          border-collapse: collapse;
        }
    </style>
</head>
<body>
    <table>
        <thead>
            <tr style="font-weight:bold;">
                <td colspan="8" style="text-align:center"><h3>Goods Receiving Notes</h3></td>
            </tr>
        </thead>
    </table><br>
    <table>
        <thead>
            <tr style="font-weight:bold;">
                <td>Supplier Name</td>
                <td>{{$supplier_name}}</td>
            </tr>
            <tr style="font-weight:bold;">
                <td>Report Date</td>
                <td>{{date('d-F-Y')}}</td>
            </tr>
            <tr style="font-weight:bold;">
                <td>REC No </td>
                <td>{{$rec_id}}</td>
            </tr>
        </thead>
    </table><br>
  <table>
        <thead>
            
            <tr style="font-weight:bold;background-color:#d3d3d3">
                <td>S#</td>
                <td>Receiving Date</td>
                <td>PO ID</td>
                <td>REC ID</td>
                <td>SKU</td>
                <td>Product Name</td>
                <td>Color</td>
                <td>Size</td>
                <td>Received QTY</td>
            </tr>
        </thead>
        <tbody>
            @php
                $count=1;
                $order_count=0;
            @endphp
            @forelse ($records as $record)
                @php 
                    $exp=explode(',',$record->product_name);
                    $name=$exp[0];
                    $exp2=explode('|',$name);
                    $color=$exp2[1];
                    $name=$exp2[0];
                    $size=$exp[1];
                @endphp
                <tr >
                    <td>{{$count}}</td>
                    <td>{{date('d-m-Y',strtotime($record->created_date))}}</td>
                    <td>{{$record->po_id}}</td>
                    <td>REC{{$record->gatepass_serial}}</td>
                    <td>{{$record->variation_id}}</td>
                    <td>{{$name}}</td>
                    <td>{{$color}}</td>
                    <td>{{$size}}</td>
                    <td style="text-align:center">{{$record->receive_qtn}}</td>
                </tr>
                @php
                    $count++;
                    $order_count+=$record->receive_qtn;
                @endphp
            @empty
                <tr>
                    <td colspan="9" class="text-center">No Record Found</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot style="font-weight:bold;background-color:#d3d3d3">
            <tr>
                <td colspan="8" style="text-align:right">Total</td>
                <td style="text-align:center">{{$order_count}}</td>
            </tr>
        </tfoot>
  </table>
  <table>
        <thead>
            <tr style="font-weight:bold;">
                <td colspan="8" style="text-align:left"><h3>Received by : </h3></td>
            </tr>
        </thead>
    </table>
    


</body>
</html>
