@php
    $logoImgDark='logo/miniopex_dark.png';
    $logoImgWhite='logo/miniopex_white.png';
    if(env('APP_NAME') =='SampMini'){
        $logoImgDark='logo/miniopex_dark_12.png';
        $logoImgWhite='logo/miniopex_dark_12.png';
    }
@endphp
 <!-- HEADER DESKTOP-->
 <header class="header-desktop">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="header-wrap">
                <form class="form-header" action="" method="POST">
                    {{-- <input class="au-input au-input--xl" type="text" name="search" placeholder="Search for datas &amp; reports..." />
                    <button class="au-btn--submit" type="submit">
                        <i class="zmdi zmdi-search"></i>
                    </button> --}}
                    @php
                        if(auth('web')->check()){
                            $route_dashboard=route('dashboard');
                        }elseif (auth('supplier')->check()) {
                            $route_dashboard=route('supplier.quantity');
                        }
                    @endphp
                    <a class="logo mr-3 hide_screen" href="{{ $route_dashboard }}" id="logo_hide" style="display: none">
                        <img src="{{asset($logoImgDark)}}" alt="{{strtoupper(env('APP_NAME'))}}" />
                        <!--<h1 class="{{env('HONE_COLOR')}}">{{strtoupper(env('APP_NAME'))}}</h1>-->
                    </a>
                    <button
                            class="float-left btn btn-dark hide_screen"
                            id="toggle_menu"
                            type="button"
                            
                            >
                            <i class="zmdi zmdi-menu"></i>
                    </button>
                    <div class="noti__item js-item-menu ml-2 btn btn-dark hide_screen size-dom" style="display: none" id="tab_menu">
                            <i class="zmdi zmdi-caret-down-circle text-white"></i>
                            <div class="mess-dropdown js-dropdown ">
                                <div class="navbar-sidebar list-menu js-scrollbar1 ps ps--active-y">
                                    <ul class="list-unstyled">
                                        <x-menu-bar type="collapse" />
                                    </ul>
                                </div>
                            </div>
                        </div>
                </form>
                
                <div class="header-button">
                    @if(in_array(auth()->user()->id,[21,26,37]))
                    <div class="mr-5">
                        <div class="btn btn-dark  main_refresh_btn mr-1 mb-1"  data-store="decrum" id="decrum_refresh_btn">
                            <i class="zmdi zmdi-refresh text-white"></i> Decrum WH Refresh
                        </div>
                        <div class="btn bg-orange text-dark  main_refresh_btn mr-1 mb-1"  data-store="urban" id="urban_refresh_btn">
                            <i class="zmdi zmdi-refresh text-dark"></i> Urban WH Refresh
                        </div>
                    </div>
                    @endif
                    <div class="account-wrap">
                        <div class="account-item clearfix js-item-menu">
                            <div class="image">
                                @php
                                    if(auth('web')->check()){
                                        $str=auth()->user()->name;
                                        $str=$str[0].$str[1];
                                    }elseif (auth('supplier')->check()) {
                                        $str=auth('supplier')->user()->supplier_name;
                                        $str=$str[0];
                                    }
                                @endphp
                                <div class="bg-grey d-flex justify-content-center py-2 px-4" style=""><h4 class="text-white">{{ strtoupper($str) }}</h4> </div> 
                                {{-- <img src="{{ asset('backend/images/icon/avatar-01.jpg') }}" alt="John Doe" /> --}}
                            </div>
                            <div class="content">
                                <a class="js-acc-btn" href="#">
                                    @if (auth('web')->check())
                                        {{ auth()->user()->name}}
                                        
                                    @elseif(auth('supplier')->check())
                                        {{ auth('supplier')->user()->supplier_name }}
                                        
                                    @endif
                                </a>
                            </div>
                            <div class="account-dropdown js-dropdown">
                                <div class="info clearfix">
                                    <div class="image">
                                        <a href="javascript:;" style="cursor: context-menu !important;">
                                            <div class="bg-grey d-flex justify-content-center py-2 px-4" style="">
                                                <h1 class="text-white">{{ strtoupper($str) }}</h1>
                                            </div> 
                                            {{-- <img src="{{ asset('backend/images/icon/avatar-01.jpg') }}" alt="John Doe" /> --}}
                                        </a>
                                    </div>
                                    <div class="content " style="cursor: context-menu !important;">
                                        <h5 class="name">
                                            <!--class="name"-->
                                            <a style="cursor: context-menu !important;">
                                                @if (auth('web')->check())
                                                    {{ auth()->user()->name}}
                                                    
                                                @elseif(auth('supplier')->check())
                                                    {{ auth('supplier')->user()->supplier_name }}
                                                @endif
                                            </a>
                                        </h5>
                                        @if (auth('web')->check())
                                            <!--class="email"-->
                                            <span class="email">{{auth()->user()->email}}</span>
                                                    
                                        @elseif(auth('supplier')->check())
                                            {{ auth('supplier')->user()->supplier_name }}
                                            
                                        @endif
                                       
                                    </div>
                                </div>
                                {{-- <div class="account-dropdown__body">
                                    <div class="account-dropdown__item">
                                        <a href="#">
                                            <i class="zmdi zmdi-account"></i>Account</a>
                                    </div>
                                    <div class="account-dropdown__item">
                                        <a href="#">
                                            <i class="zmdi zmdi-settings"></i>Setting</a>
                                    </div>
                                    <div class="account-dropdown__item">
                                        <a href="#">
                                            <i class="zmdi zmdi-money-box"></i>Billing</a>
                                    </div>
                                </div> --}}
                                <div class="account-dropdown__footer">
                                    <a href="javascript:;" id="logout_id">
                                        <i class="zmdi zmdi-power"></i>Logout
                                    </a>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- HEADER DESKTOP-->