@extends('layouts.app')
@section('title','Item Alteration Log | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Item Alteration </strong> Log
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-striped table-earning table-bordered" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>Product Detail</th>
                                            <th>Quantity</th>
                                            <th>Type</th>
                                            <th>Supplier Name</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
    
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('log.item.return') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":{ _token: "{{csrf_token()}}"}
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 0, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "productDetail","name":"productDetail" },
            { "data": "quantity","name":"item_return_log.quantity" },
            { "data": "return_check","name":"item_return_log.return_check" },
            { "data": "supplier_name","name":"suppliers.supplier_name" },
            { "data": "name","name":"users.name" },
            { "data": "created_at","name":"created_at" },
            
        ],
        createdRow: (row, data, dataIndex, cells) => {
            $(cells[2]).html('<span class="text-primary text-sm">'+data.return_check+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

        
    

    
</script>

    
@endsection