@extends('layouts.app')
@section('title','Supplier Statistics | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.6.5/css/buttons.dataTables.min.css"/>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<x-datatable-js type="css"/>

{{-- <link rel="stylesheet" href="{{ asset('backend/print.min.css') }}"/> --}}
<style>
.margin{
    margin-left:15%;
}
</style>


    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Supplier</strong> Statistcs
                            <a href="{{ route('items.alteration.add')}}" class="btn btn-info btn-sm float-right"><i class="fas fa-plus"></i> Add New Item Alteration</a>
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="row">
                                <div class="col-md-4 pb-1">
                                    <h2 style="text-align: center;">Item Alteration Summary</h2><hr>
                                    <div class="form-group form-inline ml-3">
                                        <label for="date_picker" class="form-control-label mr-3">Select Date</label>
                                        <input type="text" id="date_picker" name="date_picker" placeholder="Date Picker" class="form-control form-control-sm">
                                        <a href="javascript:;" class="btn btn-success btn-sm ml-1" id="search_change"><i class="fas fa-search" aria-hidden="true"></i></a>
                                    </div>
                                    
                                    <hr>
                                    <div class="table-responsive">
                                        <table class="table  table-bordered  table-striped" id="posts" data-start='' data-end='' cellspacing="0" width="100%">
                                            <thead class="table-dark" style="color:white">
                                                <tr>
                                                    <th>Supplier Name</th>
                                                    <th>Total Return Check</th>
                                                    <th>Total Return</th>
                                                    <th>Total Alteration</th>
                                                    
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                    <th></th>
                                                    <th></th>
                                                    <th></th>
                                                    <th></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                    
                                </div>
                                <div class="col-md-8 " id='posts2_div'>
                                    <h2 style="text-align: center;">Supplier Wise Alteration Summary</h2><hr><br><br>
                                    <div class="mt-2">
                                        <div class="table-responsive">
                                            <table class=" table  table-bordered  table-striped" cellspacing="0" width="100%" id="posts2" data-id="" data-supplier-name="">
                                                <thead class="table-dark" style="color: white">
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Team</th>
                                                        <th>Product Name</th>
                                                        
                                                        <th>Type</th>
                                                        <th>Quantity</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                    
                                    
                                </div>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<x-datatable-js type="js"/>

<script>
    var today = new Date().toLocaleDateString();
    var start = moment().subtract(29, 'days');
    var end = moment();
    var today = new Date().toLocaleDateString();


    function cb(start, end) {
        $('#date_picker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#posts").attr("data-start",start.format('YYYY-MM-DD'));
        $("#posts").attr("data-end",end.format('YYYY-MM-DD'));
    }

    $('#date_picker').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});

    // $('.dataTables_filter').addClass('float-left');
    var table =$('#posts').DataTable({
        "bPaginate": false,
        "bLengthChange": false,
        "bFilter": true,
        "bInfo": false,
        
        "processing": true,
        "serverSide": true,
        "pageLength": -1,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('alteration.supplier.statistics') }}",
                    "type": "POST",
                    data:function(d){
                        d._token= "{{csrf_token()}}";
                        d.start_date=$("#posts").attr("data-start");
                        d.end_date=$("#posts").attr("data-end");
                    },
        },
        "language": {
            "search": "Supplier:"
        },
        "columnDefs": [
            { "orderable": false, "targets": [] },
            { "searchable": false, "targets": [1,2,3] },
        ],
        bSort: false,
        "ordering": true,
        "columns": [
            { "data": "supplier_name2","name":"supplier_name2" },//0
            { "data": "return_check","name":"return_check" },//1
            { "data": "return_qty","name":"return_qty" },//2
            { "data": "alter_qty","name":"alter_qty" },//3
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
            // $('#posts_filter').css({'margin-right':'%'});
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
            
            if (tot > 0) {
                $('#posts').DataTable().buttons().enable();
            } else {
                $('#posts').DataTable().buttons().disable();
            }
            
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        initComplete: function () {
            $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button');
            $('.buttons-pdf').html('<i class="fas fa-file-pdf"></i> Pdf').removeClass('dt-button');
            $('.buttons-print').html('<i class="fas fa-print"></i> Print').removeClass('dt-button');
           
            
        },dom: 'Bfrtip',
        buttons: [
                {   extend: 'excelHtml5', 
                    className: 'btn btn-danger btn-sm small',
                    footer: true,
                    header:false,
                    customize: function ( xlsx ) {
                        var sheet = xlsx.xl.worksheets['sheet1.xml'];
                        //Bold Header Row
                        $('row[r=4] c', sheet).attr( 's', '2' );
                        //Make You Input Cells Bold Too
                        $('c[r=A2]', sheet).attr( 's', '2' );
                        $('c[r=F2]', sheet).attr( 's', '2' );

                    },
                    customizeData: function(data){
                        var desc = [
                            ['',''],
                            ['','','Dated',today],

                        ];
                        data.body.unshift(data.header)
                        for (var i = 0; i < desc.length; i++) {
                            data.body.unshift(desc[i]);
                        };
                    }
                },
                {   extend: 'print', 
                    className: 'btn btn-info btn-sm small',
                    footer: true,
                    
                    messageTop: function(){
                        return "<br>Dated : "+ today;
                    },
                },
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            // computing column Total of the complete result 
            var monTotal = api
                .column( 1 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
				
            var tueTotal = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var wedTotal = api
                .column( 3 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            
                    
            
                
                    
                // Update footer by showing the total with the reference of the column index 
            $( api.column( 0 ).footer() ).html('Total');
            $( api.column( 1 ).footer() ).html(monTotal);
            $( api.column( 2 ).footer() ).html(tueTotal);
            $( api.column( 3 ).footer() ).html(wedTotal);
        },
    });
    
    $('#search_change').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });

    $('#posts2').DataTable({
        "processing": true,
        "pageLength": 50,
        "serverSide": true,
        "dataSrc": "",
        "bInfo": false,
        "language": {
            "search": "Product:"
        },
        "ajax":{
            "url": "{{ route('supplier.wise.statistics') }}",
        //  "dataType": "json",
            "type": "POST",
            "data":function(d){
                d._token= "{{csrf_token()}}";
                d.supplier_id=$('#posts2').attr('data-id');
            }
        },
        "columnDefs": [
            { "orderable": false, "targets": [] },
            { "searchable": true, "targets": [2] },
            { "searchable": false, "targets": [0,1,3,4] },
            { "width": "20%", "targets": [3] }
        ],
        bSort: false,
        "ordering": true,
        "columns": [
            { "data": "assign_date","name":"assign_date" },//0
            { "data": "team_name","name":"teams.team_name" },//1
            { "data": "product_name","name":"product_name" },//2
            
            { "data": "return_check","name":"item_return.return_check" },//3
            { "data": "quantity","name":"item_return.quantity" },//4
        ],
        createdRow: (row, data, dataIndex, cells) => {
            var status;
            if(data.return_check=='1'){
                status='Return';
            }else if(data.return_check=='2'){
                status='Alteration'
            }
            $(cells[3]).html('<span class="text-primary text-sm">'+status+'</span>')
        },
        'preDrawCallback': function(settings) {
            loader('#posts2');
            // $('.dataTables_length').css({'margin-left':'23%'});
        },
        "drawCallback": function( settings ) {
            loader('#posts2',0);
            // $('.dataTables_length').css({'margin-left':'23%'});
            var info = $('#posts2').DataTable().page.info();
            tot = info.recordsTotal;
            
            if (tot > 0) {
                $('#posts2').DataTable().buttons().enable();
            } else {
                $('#posts2').DataTable().buttons().disable();
            }
        },
        dom: 'Bfrtip',
        buttons: [
                {   extend: 'excelHtml5', 
                    className: 'btn btn-danger btn-sm small',
                    footer: true,
                    header:false,
                    customize: function ( xlsx ) {
                        var sheet = xlsx.xl.worksheets['sheet1.xml'];
                        //Bold Header Row
                        $('row[r=4] c', sheet).attr( 's', '2' );
                        //Make You Input Cells Bold Too
                        $('c[r=A2]', sheet).attr( 's', '2' );
                        $('c[r=F2]', sheet).attr( 's', '2' );

                    },
                    customizeData: function(data){
                        var desc = [
                            ['',''],
                            ['Supplier Name',$('#posts2').attr('data-supplier-name'),'','Dated',today],

                        ];
                        data.body.unshift(data.header)
                        for (var i = 0; i < desc.length; i++) {
                            data.body.unshift(desc[i]);
                        };
                    }
                },
                {   extend: 'print', 
                    className: 'btn btn-info btn-sm small',
                    footer: true,
                    autoPrint: true,
                    exportOptions: { stripHtml: false, },
                    messageTop: function(){
                        return "Supplier Name : " + $('#posts2').attr('data-supplier-name')+"                   Dated : "+ today; 
                    },
                },
                
        ],	
    });



    function loader(id,show=1){
        if(show){
            $(id).css({
                'position':'relative',
            });
            $('<div>',{
                class:'loaderShow bg-info'
            }).css({
                'z-index': '1000','position':'absolute','font-size': '12px',
                'top':'5%','left':'50%','padding':'10px','border-radius':'10px'
            }).prependTo(id)
            .html('<i class="fas fa-spinner fa-pulse fa-3x fa-spin" style="color:white"></i><span class="sr-only">Loading...</span>');
        }else{
            $(id+' .loaderShow').remove();
        }
    }

    $('#posts').on('click', 'tbody .supplier_name', function () {
        var data_row=table.row($(this).closest('tr')).data();
        $('#posts2').attr('data-id',data_row.id);
        $('#posts2').attr('data-supplier-name',data_row.supplier_name);
        $('#posts2').DataTable().ajax.reload().draw(); 
    });
      
</script>

    
@endsection