@extends('layouts.app')
@section('title',($string=='alteration')?'Item Alteration | Mini Opex':'Item Return | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Item {{ $string=='alteration' ? 'Alteration' : 'Return' }}</strong> List
                            @can('item-alteration-add')
                                <a href="{{ route('items.alteration.add')}}" class="btn btn-info btn-sm float-right"><i class="fas fa-plus"></i> Add New Item Alteration</a>
                            @endcan
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-striped table-earning table-bordered" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>Product Detail</th>
                                            <th>Quantity</th>
                                            <th>Type</th>
                                            <th>Supplier Name</th>
                                            <th>Created By</th>
                                            <th>Created Date</th>
    
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<!--<script src="//code.jquery.com/jquery-latest.js"></script>-->
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>


<script>
    $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    var string="{{$string}}";
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('items.alteration.list','return') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){
                         d._token= "{{csrf_token()}}";
                         if(string =='alteration'){
                             d.type=2;
                         }else{
                             d.type=1;
                         }
                        //  d.type=$('#type option:selected').val();
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 5, "desc" ]],
        bSort: false,
        "ordering": true,
        "columns":[
            { "data": "productDetail","name":"productDetail" },
            { "data": "quantity","name":"item_return.quantity" },
            { "data": "return_check","name":"item_return.return_check" },
            { "data": "supplier_name","name":"suppliers.supplier_name" },
            { "data": "name","name":"users.name" },
            { "data": "created_at","name":"created_at" },
            
        ],
        initComplete: function () {
            $('#posts_filter input').addClass('form-control-sm');
            // $("#posts_filter").append(`
            //     <select class="float-right form-control-sm ml-1" name="type" id="type">
            //         <option value="">Select Type</option>
            //         <option value="1">Return</option>
            //         <option value="2">Alteration</option>
            //     </select>
            // `);
            
        },
        createdRow: (row, data, dataIndex, cells) => {
            var status;
            if(data.return_check=='1'){
                status='Return';
            }else if(data.return_check=='2'){
                status='Alteration'
            }
            $(cells[2]).html('<span class="text-primary text-sm">'+status+'</span>')
        },
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
    });

    $('#posts_filter').on('change','#type',function(e){
        e.preventDefault();
        $('#posts').DataTable().ajax.reload().draw();
    })

        
    

    
</script>

    
@endsection