@extends('layouts.app')
@section('title','Edit Role | Mini Opex')
@section('add_css')
<style>
input[type="checkbox"][readonly] {
    pointer-events: none !important;
}
</style>
    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Edit Roles</strong> form
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <form action="{{ route('roles.update',$role->id) }}" method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                                @csrf
                                {{ method_field('PATCH') }}
                                <div class="row form-group ">
                                    <div class="col col-md-3">
                                        <label for="text-input" class=" form-control-label">Role Name </label>
                                    </div>
                                    <div class="col-12 col-md-3">
                                        <input type="text" id="name" name="name" placeholder="add new role" class="form-control" value="{{ $role->name }}" maxlength="25">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col col-md-12">
                                        <label class=" form-control-label">Permission List</label>
                                    </div>
                                    @foreach($permission as $value)
                                        <div class="col col-md-3">
                                            <div class="form-check-inline form-check">
                                                @php
                                                    if($value->name =='dashboard' ){
                                                        $readonly='readonly';
                                                    }else{
                                                        $readonly='';
                                                    }
                                                @endphp
                                                    
                                                <label for="{{ $value->name  }}" class="form-check-label text-primary">
                                                    <input  type="checkbox" 
                                                            id="{{ $value->name  }}" 
                                                            name="permission[]" 
                                                            value="{{ $value->id }}" 
                                                            class="form-check-input "
                                                            {{ $readonly }}
                                                            @if($value->name =='dashboard' ) onclick="return false" @endif
                                                            {{in_array($value->id, $rolePermissions) ? 'checked' : '' }}
                                                            > 
                                                    {{ str_replace('-',' ',$value->name) }}
                                                </label> &nbsp;
                                                
                                            
                                                
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm" id="submitbtn">
                                    <i class="fa fa-dot-circle-o"></i> Submit
                                </button>
                                <button type="reset" class="btn btn-danger btn-sm">
                                     <i class="fa fa-ban"></i> Reset
                                </button>
                            </form>
                            </div>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>


<script>
    $(document).ready(function() {
        

        $('#form_id').validate({
            errorClass:'text-danger',
            success:'text-success',
            rules:{
                supplier_name: {
                    required: true
                },
                username:{
                    required:true,
                },
                supplier_address:{
                    required:true
                },
                password:{
                    required:true,
                    minlength:6
                },
                
                
            },
            messages:{
                supplier_name:{
                    required:"Supplier Name is required"
                },
                username:{
                    required:"Username is required",
                },
                supplier_address:{
                    required:"Supplier address is required"
                },
                password:{
                    required:"password is required",
                    minlength:"Password length must be 6 to 8"
                },
                
            },
            highlight: function(element, errorClass, validClass) {
                $(element).closest('.form-control').addClass('has-warning');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                
                if(element.hasClass('select2') && element.next('.select2-container').length) {
                    error.insertAfter(element.next('.select2-container'));
                }else if(element.hasClass('radio') && element.next('label .form-check-label').length) {
                    error.insertAfter(element.next('label .form-check-label'));
                }else{
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                console.log("Submitted!");
                form.submit();
            }

        });

        $('#username').blur(function(){
            var val=$('#username').val();
            if(val !=''){
                $.ajax({
                    url:"{{ route('supplier.check_username') }}",
                    type:'POST',
                    dataType: "html",
                    data:{
                        _token: "{{csrf_token()}}",
                        username:val
                    },
                    success:function(data){
                        console.log(data);
                        if(data ==1){
                            $('#unameerror').show();
                            $('#submitbtn').hide();
                        }else{
                            $('#unameerror').hide();
                            $('#submitbtn').show();
                        }
                    }
                });
            }
        })

        $.validator.addMethod(
            "checkUsername", 
            function(value, element) {
                var response;
                var flag = 0;
                $.ajax({
                    url:"{{ route('supplier.check_username') }}",
                    type:'POST',
                    dataType: "html",
                    data:{
                        _token: "{{csrf_token()}}",
                        username:value
                    },
                    success:function(data){
                        console.log(data);
                        response=(data =='1')? false:true;
                        console.log(response);
                        return response;
                    }
                });
                // console.log(flag);
                // if(flag== 0){
                //     return true;
                // }
                // console.log(response);
                
               
            },
            ""
        );


    });
</script>

    
@endsection