@extends('layouts.app')
@section('title','Add New Alteration| Mini Opex')
@section('add_css')
<style>
.select_width{
    width:600px !important;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background: #bfbfbf;
}
@media only screen and (max-width: 768px) {
    .select_width{
        width:200px !important;
    }
    
}
</style>
    
@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Add New Alteration</strong> form
                            <a href="javascript:;" class="btn btn-primary btn-sm float-right ml-1" id="submitform"><i class="fas fa-arrow-circle-right"></i> Submit</a> 
                            <a href="javascript:;" class="btn btn-success btn-sm add_button float-right "><i class="fas fa-plus"></i> Add</a> 
                            

                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <form action="{{ route('items.alteration.add') }}" method="post" enctype="multipart/form-data" class="form-horizontal" id="form_id">
                                @csrf
                                <div class="table-responsive-sm">
                                    <table class="table  table-bordered  table-striped table-sm " id="posts">
                                        <thead class="table-dark" style="color:white">
                                            <tr>
                                                {{-- <th>S#</th> --}}
                                                <th>Select SKU</th>
                                                <th>Quantity</th>
                                                <th>Select Supplier</th>
                                                <th>Return</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody_item">
                                            
                                        </tbody>
                                    </table>
                                </div>
                                
                            </div>
                               

                                
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary btn-sm" id="submitbtn">
                                    <i class="fas fa-arrow-circle-right"></i> Submit
                                </button>
                            </form>
                            </div>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script src="{{ asset('backend/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('backend/js/additional-methods.min.js') }}"></script>


<script>
    $(document).ready(function() {
        $("#form_id").validate();
        var addButton = $('.add_button');
        var wrapper = $('#tbody_item');
        var maxField = 10;
        var x = 0;
        var count=1;

        // var fieldHTML = `<tr class="tr_`+count+`">
        //                     <td id="product_`+count+`" class="select_width">
        //                         <select class="product_list select_width" name="sku[]" id="sku_`+count+`"></select><br>
        //                         <span class="text-danger" id="sku_error_`+count+`"></span>
        //                     </td>
        //                     <td>
        //                         <input type="text" name="quantity[]"  class="form-control-sm quantity" style="border:1px solid;" id="qty_`+count+`" /><br>
        //                         <span class="text-danger" id="qty_error_`+count+`"></span>
        //                     </td>
        //                     <td id="suppliertd_`+count+`">
        //                         <select class="supplier_list" name="supplier_id[]" id="sup_`+count+`"></select><br>
        //                         <span class="text-danger" id="sup_error_`+count+`"></span>

        //                     </td>
        //                     <td>
        //                         <select class="type" name="type[]" id=type_`+count+`>
        //                             <option value="">Please Select</option>
        //                             <option value="1">Return</option>
        //                             <option value="2">Alteration</option>
        //                         </select><br>
        //                         <span class="text-danger" id="type_error_`+count+`"></span>
        //                     </td>
        //                     <td>
        //                         <a href="javascript:void(0);" class="btn btn-danger btn-sm remove_button" id="remove_`+count+`"><i class="fas fa-minus"></i> Remove</a>
        //                     </td> 
        //                 </tr>`;
        
        
        // $(wrapper).append(fieldHTML);
        // $('#sku_'+count).select2({
        //     placeholder: 'Please Search ......',
        //     delay: 250,
        //     width: 'resolve',
        //     height:'120px',
        //     allowClear: true,
        //     'style':{'height':'120px'},
        //     ajax:{
        //         url: "{{ route('item.sku.list') }}",
        //         dataType: 'json',
        //         data: function (params) {
                    
        //             var query = {
        //                 search: params.term,
        //                 page: params.page || 1,
        //                 _token:"{{ csrf_token() }}" 
        //             }

        //             return query;
        //         },
        //         cache: true
        //     },
        //     minimumInputLength: 1,
        //     templateResult: formatRepo,
        //     templateSelection: formatRepo

        // });
        // $('#product_'+count+' .select2-container--default .select2-selection--single').css({'height': '120px'});
        

        $('.add_button').click(function(e){
            e.preventDefault();
            if(x < maxField){ 
                x++; //Increment field counter
                count++;
                $('#product_count').removeAttr('id');
                $(wrapper).append(`<tr class="tr_`+count+` table-sm text-sm">
                            <td id="product_`+count+`"  class="select_width">
                                <select class="product_list select_width" name="sku[]" id="sku_`+count+`"></select>
                                <br><span class="text-danger" id="sku_error_`+count+`"></span>
                            </td>
                            <td>
                                <input type="text" name="quantity[]"  class="form-control-sm quantity" style="border:1px solid;" id="qty_`+count+`"/><br>
                                <span class="text-danger" id="qty_error_`+count+`"></span>
                            </td>
                            <td id="suppliertd_`+count+`">
                                <select class="supplier_list" name="supplier_id[]" id="sup_`+count+`"></select><br>
                                <span class="text-danger" id="sup_error_`+count+`"></span>
                            </td>
                            <td>
                                <select class="type form-control-sm" name="type[]" id=type_`+count+`>
                                    <option value="">Please Select</option>
                                    <option value="1">Return</option>
                                    <option value="2">Alteration</option>
                                </select>
                                <br><span class="text-danger" id="type_error_`+count+`"></span>
                            </td>
                            <td>
                                <a href="javascript:void(0);" class="btn btn-danger btn-sm remove_button" id="remove_`+count+`"><i class="fas fa-minus"></i> Remove</a>
                            </td> 
                        </tr>`); //Add field html
               
                $('.supplier_list').select2({
                    placeholder: 'Please Select ......',
                    delay: 250,
                    width: '350px',
                    allowClear: true,
                    ajax:{
                        url: "{{ route('item.supplier.list') }}",
                        dataType: 'json',
                        data: function (params) {
                            var query = {
                                search: params.term,
                                page: params.page || 1 
                            }

                            return query;
                        },
                        
                        cache: true
                    }
                });

                $('#sku_'+count).select2({
                    placeholder: 'Please Search ......',
                    delay: 250,
                    width: '350px',
                    height:'120ps',
                    allowClear: true,
                    
                    'style':{'height':'120px'},
                    ajax:{
                        url: "{{ route('item.sku.list') }}",
                        dataType: 'json',
                        type:'POST',
                        data: function (params) {
                            
                            var query = {
                                search: params.term,
                                page: params.page || 1,
                                _token:"{{ csrf_token() }}" 
                            }

                            

                            return query;
                        },
                        
                        cache: true
                    },
                    minimumInputLength: 1,
                    templateResult: formatRepo,
                    templateSelection: formatRepo

                });
                $('#product_'+parseInt(count-1)+' .select2-container--default .select2-selection--single').css({'height': '100px'});
                $('#product_'+count+' .select2-container--default .select2-selection--single').css({'height': '100px'});
                
                
                
                  
            }
        });

        //Once remove button is clicked
        $(wrapper).on('click', '.remove_button', function(e){
            e.preventDefault();
            $(this).closest('tr').remove(); //Remove field html
            x--; //Decrement field counter  
        });

       

        // $('.supplier_list').select2({
        //     placeholder: 'Please Select ......',
        //     delay: 250,
        //     width: '350px',
        //     allowClear: true,
        //     ajax:{
        //         url: "{{ route('item.supplier.list') }}",
        //         dataType: 'json',
        //         data: function (params) {
        //             var query = {
        //                 search: params.term,
        //                 page: params.page || 1 
        //             }

        //             return query;
        //         },
        //         cache: true
        //     }
        // });

        function formatRepo (repo) {
            if (repo.loading) {
                return repo.text;
            }

            if(typeof repo.product_name === "undefined"){
                return '';
            }

            var href='';
            if(repo.product_url !=''){
                href=repo.product_url;
            }else{
                href="{{ asset('uploads/sku_images/') }}"+repo.prod_img;
            }

            var $container=$(`
                <div class="row mt-1">
                    <div class="col-md-2">
                        <img src='`+ href + `' class='rounded img-thumbnail' alt='Cinque Terre' width='600' height='600'/>
                    </div>
                    <div class="col-md-8 ">
                        `+repo.product_name+`<br>
                        <span class="text-success text-sm"> SKU : <strong>`+repo.variation_id+`</strong></span> 
                        <span class="text-sm ml-5" style="color:#D35400"> Group ID : <strong>`+repo.group_id+`</strong></span><br>
                        <span class="text-info text-sm">Size : <strong>`+repo.size+`</strong></span>
                        <span class="text-sm float-right pr-5" style="color:#6C3483">&nbsp;&nbsp;&nbsp; Quantity : <strong>`+repo.quantity+`</strong></span><br>


                    </div>
                </div>
            `);
            return $container;
        }

        function form_check(){
            var p_list=0;
            var q_list=0;
            var s_list=0;
            var t_list=0;

            $('.product_list').each(function(index,e){
                var id=$(this).attr('id').split("_")[1];
                var id2=$(this).attr('id');
                if($('#'+id2).val() === null){
                    p_list=1;
                    $('#product_'+id+' .select2-container--default .select2-selection--single').removeAttr('style');
                    $('#product_'+id+' .select2-container--default .select2-selection--single').css({   'height': '120px',
                                                                                                        'border-style': 'solid',
                                                                                                        'border-color': 'red'
                                                                                                    });
                    $('#sku_error_'+id).html('Please Select This');
                    
                }else{
                    $('#product_'+id+' .select2-container--default .select2-selection--single').removeAttr('style');
                    $('#product_'+id+' .select2-container--default .select2-selection--single').css({'height': '120px'});
                    $('#sku_error_'+id).html('');
                }
            });

            $('.quantity').each(function(index,e){
                var id=$(this).attr('id').split("_")[1];
                var pattern =/[^0-9]/g;
                // console.log(id);
                if(pattern.test($('#qty_'+id).val())){
                    console.log($('#qty_'+id).val());
                    q_list=1;
                    $('#qty_'+id).removeAttr('style');
                    $('#qty_'+id).css({'border':'1px solid red'});
                    $('#qty_error_'+id).text('Accept Only Numbers');
                }else{
                    if($('#qty_'+id).val()==''){
                        q_list=1;
                        $('#qty_'+id).removeAttr('style');
                        $('#qty_'+id).css({'border':'1px solid red'});
                        $('#qty_error_'+id).text('Accept Only Numbers');
                    }else{
                        $('#qty_error_'+id).html('');
                        $('#qty_'+id).css({'border':'1px solid'})
                    }
                    
                }
            });

            $('.supplier_list').each(function(index,e){
                var id=$(this).attr('id').split("_")[1];
                var id2=$(this).attr('id');
                if($('#'+id2).val() === null){
                    s_list=1;
                    $('#suppliertd_'+id+' .select2-container--default .select2-selection--single').css({  
                                                                                                        'border-style': 'solid',
                                                                                                        'border-color': 'red'
                                                                                                    });
                    $('#sup_error_'+id).html('Please Select This');
                    
                }else{
                    $('#suppliertd_'+id+' .select2-container--default .select2-selection--single').removeAttr('style');
                    $('#sup_error_'+id).html('');
                }
            });

            $('.type').each(function(index,e){
                var id=$(this).attr('id').split("_")[1];
                var id2=$(this).attr('id');
                if($(this).val() ==''){
                    t_list=1;
                   $(this).css({'border-style': 'solid',
                                'border-color': 'red'})
                    $('#type_error_'+id).html('Please Select This');
                    
                }else{
                    $(this).removeAttr('style');
                    $('#type_error_'+id).html('');
                }
            });

            if(p_list==0&& q_list==0&& s_list==0&& t_list==0){
                $('#form_id').submit();

            }else{
                $.toast({
                    heading: 'Error',
                    text: "Please Enter Valid Inputs",
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                });
            }
        }

        $('#submitbtn').click(function(e){
            e.preventDefault();
            if(x!=0){
                form_check();    
            }
            
        });

        $('#submitform').click(function(e){
            e.preventDefault();
            if(x!=0){
                form_check();    
            }
        });
    });
</script>

    
@endsection