@extends('layouts.app')
@section('title','History MO | Mini Opex')
@section('add_css')
<link href="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.css" type="text/css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">

@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>MO </strong> List
                            
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr class="thead-light">
                                             <th colspan="2" class="text-right">Total</th>
                                            <th id="approve_qty">Approve QTY</th>
                                            <th colspan="6"></th>
                                            <th id="remaining_qty">Remaining QTY</th>
                                            <th colspan="2" id="ready_to_ship">Ready To Ship</th>
                                        </tr>
                                        <tr class="thead-dark">
                                            <th>ID</th>
                                            <th>Mo No</th>
                                            <th>Approve QTY</th>
                                            <th>Supplier Assign</th>
                                            <th>Supplier Rec</th>
                                            <th>Supplier Remaining</th>
                                            <th>Warehouse</th>
                                            <th>Warehouse Out</th>
                                            <th>Warehouse Remaining</th>
                                            <th>Shipment Process</th>
                                            <th>Ready To Ship</th>
                                            <th>Created Date</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr class="thead-light">
                                             <th colspan="2" class="text-right">Total</th>
                                            <th>Approve QTY</th>
                                            <th colspan="6"></th>
                                            <th>Remaining QTY</th>
                                            <th colspan="2">Ready To Ship</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<script src="//cdn.jsdelivr.net/npm/featherlight@1.7.14/release/featherlight.min.js" type="text/javascript" charset="utf-8"></script>
<script>
     $('.single_image').featherlight({type: 'image',targetAttr: 'href'});
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('mo.history') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":{ _token: "{{csrf_token()}}"}
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
        ],
        "order": [[ 0, "desc" ]],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "id","name":"pr_data.id" },
            { "data": "pr_name","name":"pr_data.pr_name" },
            { "data": "approve_qty","name":"approve_qty" },
            { "data": "supplier_assign","name":"supplier_assign" },
            { "data": "supplier_receive","name":"supplier_receive" },
            { "data": "supplier_pending","name":"supplier_pending" },
            { "data": "warehouse","name":"warehouse" },
            { "data": "warehouse_out","name":"warehouse_out" },
            { "data": "warehouse_remaining","name":"warehouse_remaining" },
            { "data": "remaining_qty","name":"remaining_qty" },
            { "data": "ready_to_ship","name":"ready_to_ship" },
            { "data": "created_at","name":"created_at" },
            
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            var tueTotal = api
                .column( 2 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
            var wedTotal = api
                .column( 9 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                  
                
            var thuTotal = api
                .column( 10 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    // b = b.replace('Order QTY : ', "");
                    return intVal(a) + intVal(b);
                }, 0 );
                
                // Update footer by showing the total with the reference of the column index 
                $( api.column( 1 ).footer() ).html('TOTAL');
                
                $( api.column( 2 ).footer() ).html(tueTotal);
                $('#approve_qty').text(tueTotal);
                $( api.column( 9 ).footer() ).html(wedTotal);
                $('#remaining_qty').text(wedTotal);
                $( api.column( 10 ).footer() ).html(thuTotal);
                $('#ready_to_ship').text(thuTotal);
                
                
        },
    });
</script>

    
@endsection