@extends('layouts.app')
@section('title','Gate Pass | Mini Opex')
@section('add_css')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<x-datatable-js type="css"/>
<style>
.select2-selection { overflow: hidden; }
.select2-selection__rendered { white-space: normal; word-break: break-all; }
</style>


    
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Gate Pass</strong> Information
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="supplier" class="form-control-label" >Supplier Name</label>
                                                <select name="supplier" id="supplier" class="form-control form-control-sm select2" style="width: 100% !important">
                                                    <option value="">Please select</option>
                                                    @forelse ($suppliers as $supplier)
                                                        <option value="{{ $supplier->id }}">{{ $supplier->supplier_name }}</option>
                                                    @empty
                                                        
                                                    @endforelse
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="date_picker" class="form-control-label mr-3">Date Picker</label>
                                                <input type="text" id="date_picker" name="date_picker" placeholder="Date Picker" class="form-control form-control-sm"> 
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="supplier" class="form-control-label" >PO ID</label>
                                                <select name="po_id" id="po_id" class="form-control form-control-sm select2" style="width: 100% !important">
                                                    <option value="">Please select Supplier</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="supplier" class="form-control-label" >Gate Pass Serial</label>
                                                <select name="serial_id" id="serial_id" class="form-control form-control-sm select2" style="width: 100% !important">
                                                    <option value="">Please select</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        
                                        <div class="col-md-2">
                                            <label for="date_picker" class="form-control-label mr-3">&nbsp;</label><br>
                                            <a href="javascript:;" class="btn btn-dark btn-sm" id="search_change"><i class="fas fa-search" aria-hidden="true"></i> Search</a>
                                        </div>
                                        
                                        
                                    </div>
                                    <!--style="display:none"-->
                                    <div style="display:none">
                                        <!---->
                                   <form id="pdfGatePass" action="{{route('pdf.gate.pass')}}" method="POST">
                                    @csrf
                                    <input type="text" id="supplier_id" name="supplier_id" value="ALL"/>
                                    <input type="text" id="start_date" name="start_date"/>
                                    <input type="text" id="end_date" name="end_date"/>
                                    <input type="text" id="po_id2" name="po_id2"/>
                                    <input type="text" id="rec_id2" name="rec_id2"/>
                                    <input type="text" id="gate_pass_serial" name="gate_pass_serial"/>
                                    <button class="btn btn-success btn-sm " type="submit" id="makePDF">PDF</button>
                                    <button class="btn btn-success btn-sm " type="button" id="makePrint">Print</button>
                                </form> 
                                </div>
                                    
    
                                    

                                {{-- </div> --}}
                                
                               
                            {{-- </div> --}}
                            <hr>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" cellspacing="0" width="100%" id="posts" data-id='' data-start='' data-end='' data-supplier-name=''>
                                    <thead>
                                        <tr class="thead-light">
                                            <th colspan="7" class="text-right">TOTAL</th>
                                            <th colspan="2" id="rec_qty">0</th>
                                        </tr>
                                        <tr class="thead-dark">
                                            <th class="notexport">Image</th>
                                            <th>Date</th>
                                            <th>PO#</th>
                                            <th>REC#</th>
                                            <th>TXS</th>
                                            <th>SKU</th>
                                            <th>Product Name</th>
                                            <th>Receive QTY</th>
                                            <th class="notexport">Action</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th colspan="7" class="text-right"></th>
                                            <th colspan="2"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
<x-datatable-js type="js"/>
<script>
    // var start = moment().subtract(29, 'days');
   
    var start = moment();
    var end = moment();
    var date_options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    var today = new Date().toLocaleDateString('en-UK',date_options);


    function cb(start, end) {
        $('#date_picker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#posts").attr("data-start",start.format('YYYY-MM-DD'));
        $("#posts").attr("data-end",end.format('YYYY-MM-DD'));
        
        $("#start_date").val(start.format('YYYY-MM-DD'));
        $("#end_date").val(end.format('YYYY-MM-DD'));
        
        get_po_list();
    }

    $('#date_picker').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);
    

    $('.select2').select2({
        width: '100%'
    });

    
    var table =$('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        "dataSrc": "",
        fixedHeader: {
            header: true,
            footer: true
        },
        "ajax":{
                    "url": "{{ route('gatepass.get_all') }}",
                //  "dataType": "json",
                    "type": "POST",
                    data:function(d){
                    d._token= "{{csrf_token()}}";
                    d.supplier_id=$('#posts').attr('data-id');
                    d.start_date=$("#posts").attr("data-start");
                    d.end_date=$("#posts").attr("data-end");
                    d.po_id=$('#po_id option:selected').val();
                    d.serial_id=$('#serial_id option:selected').val();
                },
                },
        "columnDefs": [
            { "orderable": false, "targets": [] },
            {"searchable":false,"targets":[0,1,7,8]}
        ],
        lengthMenu: [[10, 25, 50,100,500, -1], [10, 25, 50,100,500, "All"]],
        bSort: false,
        "ordering": false,
        "columns": [
            { "data": "product_img","name":"product_img" },
            { "data": "created_at","name":"created_at" },//Order QTY
            { "data": "po_id","name":"product_receiving.po_id" },
            { "data": "rec_id","name":"product_receiving.rec_id" },
            { "data": "txs","name":"txs" },
            { "data": "variation_id","name":"product_receiving.variation_id" },
            { "data": "product_name","name":"product_info.product_name" },
            { "data": "receive_qtn","name":"receive_qtn" },
            { "data": "action","name":"action" },//Order QTY
        ],
        initComplete: function () {
            $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button');
            $('.buttons-pdf').html('<i class="fas fa-file-pdf"></i> Pdf').removeClass('dt-button');
            $('.buttons-print').html('<i class="fas fa-print"></i> Print').removeClass('dt-button');
            $('.buttons-page-length').html('<i class="far fa-file"></i> Page Length').removeClass('dt-button').css('color','white');
            $('.button-page-length').removeClass('dt-button').addClass('btn btn-primary');
            $('.dataTables_paginate > span .paginate_button').addClass('btn btn-primary');
            $('.clpdf').removeClass('dt-button');
            $('.dt-buttons').addClass('ml-5');
        },dom: 'lBfrtip',
        buttons: [
                {   extend: 'excelHtml5', 
                    className: 'btn btn-dark btn-sm ml-5',
                    footer: true,
                    header:false,
                    
                    customize: function ( xlsx ) {
                        var sheet = xlsx.xl.worksheets['sheet1.xml'];
                        //Bold Header Row
                        $('row[r=5] c', sheet).attr( 's', '2' );
                        //Make You Input Cells Bold Too
                        $('c[r=A2]', sheet).attr( 's', '2' );
                        $('c[r=F2]', sheet).attr( 's', '2' );
                        $('c[r=A3]', sheet).attr( 's', '2' );
                        $('c[r=F3]', sheet).attr( 's', '2' );

                    },
                    customizeData: function(data){
                        var desc = [
                            ['',''],
                            ['Report from',$('#posts').attr('data-start'),'','Report TO',$('#posts').attr('data-end')],
                            ['Supplier Name',$('#posts').attr('data-supplier-name'),'','Dated',today],

                        ];
                        data.body.unshift(data.header)
                        for (var i = 0; i < desc.length; i++) {
                            data.body.unshift(desc[i]);
                        };
                    },
                    exportOptions: {
                        modifier: {
                            search: 'none'
                        },
                        columns: ':not(.notexport)'
                    },
                },
                 {
                    className: 'btn bg-orange btn-sm text-dark clpdf',
                    text: '<i class="fas fa-file-pdf"></i> PDF',
                    action: function ( e, dt, node, config ) {
                        $('#makePDF').click();
                    }
                },
                {
                    className: 'btn btn-dark btn-sm clpdf',
                    text: '<i class="fas fa-print"></i> GRN Print',
                    action: function ( e, dt, node, config ) {
                        $('#makePrint').click();
                    }
                },
                {   extend: 'print', 
                    className: 'btn bg-orange btn-sm text-dark',
                    footer: true,
                    autoPrint: true,
                    exportOptions: { stripHtml: false, },
                    messageTop: function(){
                        return "Supplier Name : " + $('#posts').attr('data-supplier-name')+'<br>Report Date : '+ today+'<br>Report :'+$('#posts').attr('data-start')+'  -  '+$('#posts').attr('data-end');
                    },
                    exportOptions: {
                        modifier: {
                            search: 'none'
                        },
                        columns: ':not(.notexport)'
                    },
                },
            ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
            var info = $('#posts').DataTable().page.info();
                tot = info.recordsTotal;
                
                if (tot > 0) {
                    $('#posts').DataTable().buttons().enable();   
                } else {
                    $('#posts').DataTable().buttons().disable();    
                }
            $('#posts').on( 'search.dt', function () {
                    var val=$('#posts').DataTable().search();
                    if(val !=''){
                        $('.dt-buttons .clpdf').hide();
                    }else{
                        $('.dt-buttons .clpdf').show();
                    }
                    
                });
                
                // $('#posts').on( 'order.dt', function () {
                //     $('.dt-buttons .clpdf').hide();
                // });
                
                $('#supplier').on('change',function(){
                     $('.dt-buttons .clpdf').show();
                })
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 7 )
                .data()
                .reduce( function (a, b) {
                    // b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                 
                
                // Update footer by showing the total with the reference of the column index 
                $( api.column( 0 ).footer() ).html('TOTAL');
                $( api.column( 7 ).footer() ).html(wedTotal);
                $('#rec_qty').text(wedTotal);
        },
    });

    
    
    $('#supplier').change(function(){
        get_po_list();
    });
    
    $('#po_id').change(function(){
        get_serial_list();
    });
    
    function get_serial_list(){
        $.ajax({
            url:"{{route('gate.po_list_gatepass_serial')}}",
            type:'POST',
            data:{
                _token: "{{csrf_token()}}",
                supplier_id:$('#supplier').val(),
                start_date:$("#posts").attr("data-start"),
                end_date:$("#posts").attr("data-end"),
                po_id:$('#po_id option:selected').val()
            },
            dataType:'json',
            success:function(data){
                $('#serial_id').html(data.html);
            }
        })
    }
    
    function get_po_list(){
        $.ajax({
            url:"{{route('gate.gate_pass_po_list')}}",
            type:'POST',
            data:{
                _token: "{{csrf_token()}}",
                supplier_id:$('#supplier').val(),
                start_date:$("#posts").attr("data-start"),
                end_date:$("#posts").attr("data-end"),
            },
            dataType:'json',
            success:function(data){
                $('#po_id').html(data.pohtml);
                $('#serial_id').html(data.serialhtml);
                // $('#po_id2').val('ALL');
            }
        })
    }

    $('#search_change').on('click',function(){
        $('#posts').attr('data-supplier-name',$("#supplier option:selected").text());
        $('#posts').attr('data-id',$('#supplier').val());
        $('#supplier_id').val($("#supplier").val());
        
        $('#rec_id2').val($('#serial_id option:selected').val());
        $('#po_id2').val($('#po_id option:selected').val());
        // $.ajax({
        //     url:"{{route('gate.pass.serial')}}",
        //     data:{
        //       supplier_id:$("#supplier").val(),
        //       _token : "{{csrf_token()}}"
        //     },
        //     type:'POST',
        //     dataType:'JSON',
        //     success:function(data){
        //         $('#gate_pass_serial').val(data.gate_pass_serial);
        //     }
        // })
        $('#posts').DataTable().ajax.reload().draw();
    });

    
    $('#posts').on('click', 'tbody .print_btn', function () {
        print_label(table.row($(this).closest('tr')).data());

    });
    
    $('#makePrint').click(function(){
        print_po();
    });
    
    $(document).on('click','.reverse_gatepass',function(){
        var last_receiving_id=$(this).attr('data-last_receiving_id');
        var result = prompt("Are you sure want to Reverse ? Please Provide Reason for Reverse");
        if (result === null) {
            return;
        }else{
            console.log(result);
            $.ajax({
                url:"{{route('gate.reverse_gatepass')}}",
                type:'POST',
                data:{
                    _token: "{{csrf_token()}}",
                    last_receiving_id:last_receiving_id,
                    reason:result
                },
                dataType:'json',
                success:function(data){
                    if(data.success=='1'){
                        $.toast({
                            heading: 'Success',
                            text: data.message,
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-right',
                        });
                        $('#posts').DataTable().ajax.reload().draw();
                    }
                }
            })
        }
        
        
    });
    
    function print_po(){
        
        var formData=$('#pdfGatePass').serializeArray();
        formData.push({ name: "is_print", value: "1" });
        // console.log(formData);return;
        var url = '{{route('pdf.gate.pass')}}';
        // url = url.replace(':id',id);
        var w;
        $.ajax({
            url:url,
            type:'POST',
            cache: false,
            datatype: 'json',
            data:formData,
            async: false,
            success:function(data){
                if(data.success==true){
                    
                    w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    w.document.open();
                    w.document.write(data.html);
                    
                    // 
                    
                    w.document.close();
                    setTimeout(function(){ w.print(); }, 2000);
                    
                    // $('#no_of_label').val('');
                    // $('#blister_qty').val('');
                    // $('#blisterModal').modal('hide');
                    
                    // $('<html>').html(data.html).print(); 
                }
            }
        });
    }

    function print_label(data_row){
        
        var val=$('#receiving_qty_'+data_row.id).val();
        var url = '{{ route("supplier.print.label", ":id") }}';
        url = url.replace(':id', data_row.id);
        $.ajax({
            url:url,
            type:'POST',
            cache: false,
            datatype: 'json',
            data:{
                receive_qty:val,
                _token: "{{csrf_token()}}"
            },
            async: false,
            success:function(data){
                if(data.success==true){
                    $('<html>').html(data.html).print(); 
                }
            }
        });
    }

     
      
</script>

    
@endsection