@extends('layouts.app')
@section('title','SKU | Mini Opex')
@section('add_css')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
<x-datatable-js type="css"/>
<style>
select {
    font-family: 'FontAwesome', 'Poppins';
    font-weight: normal;
    font-style : normal;
}
</style>

    
@endsection

@section('content')

<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12  text-sm">
                    
                    <div class="card">
                        
                        <div class="card-header">
                            <strong>Sales </strong> Dashboard
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="container custom_filter pt-3 pb-3 border  rounded" id="custom_div">
                                <form action="{{route('get_products_excel')}}" method="post">
                                    <input type="hidden" id="dataShow" value="0"/>
                                    @csrf
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" id="child_sku" name="child_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="child_sku">Child SKU Wise</label>
                                        </div>
                                    </div>
                            
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" id="discarded_sku" name="discarded_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="discarded_sku">With Discarded SKU</label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" id="predicted_tenure" name="predicted_tenure" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="predicted_tenure">Predicted Tenure</label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                        <hr>
                                        <div class="fs--1 fw-bold mb-1">Compare Date Filter</div>
                                        <div class="row" id="tbody_add"></div>
                                    </div>
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12" id="showBtn" style="display:none">
                                        <label  class="form-control-label mr-3">&nbsp;</label><br>
                                        <button type="button" class="btn btn-primary btn-sm" id="clearBtn">Clear Filter</button>
                                        <button type="submit" class="btn btn-primary btn-sm" id="btn_excel">Download Excel</button>
                                    </div>
                                    
                                    
                                    <div class="col-md-12 mt-2 ">
                                        <p class="fw-bold text-danger  fs--1">Note : This action will take Atleast 2-3 minutes to complete.</p>
                                    </div>
                                    
                                </div>
                                </form>
                            </div>
                            
                            @php
                                $keyArr=[
                                    "th_1" => 3,
                                    "th_2" => 4,
                                    "th_3" => 5,
                                    "th_4" => 6,
                                    "th_5" => 7
                                ];
                                
                                $keyArr=json_encode($keyArr);
                             @endphp
                                        <div class="table-responsive mt-2 table-responsive-data2">
                                            <table class="table  table-bordered  table-striped" id="posts" cellspacing="0" width="100%">
                                                <thead class="table-dark">
                                                    <tr>
                                                        <th>Image</th>
                                                        <th>SKU</th>
                                                        <th>Title</th>
                                                        <th id="th_1" data-id="3"></th>
                                                        <th id="th_2" data-id="4"></th>
                                                        <th id="th_3" data-id="5"></th>
                                                        <th id="th_4" data-id="6"></th>
                                                        <th id="th_5" data-id="7"></th>
                                                        <th id="up_comming_1" data-id="8">Predicted Tenure 1</th>
                                                        <th id="up_comming_2" data-id="9">Predicted Tenure 2</th>
                                                    </tr>
                                                </thead>
                                                
                                                <tbody id="backorderhtml">
                                                    <tr>
                                                        <td colspan="10"><span class="text-center text-danger">No Record Found</span></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<x-datatable-js type="js"/>



<script>
    let addButton = $('.add_button');
    let wrapper = $('#tbody_add');
    let maxField = 4;
    let x = 0;
    let count=2;
    
    var start = moment().subtract(1, 'days');
    var end = moment().subtract(1, 'days');
    
    function default_in(count=1,add_btn=1){
        let btn=`<a href="javascript:;" class="btn btn-success btn-sm add_button mr-1"><i class="fa fa-plus"></i></a>`;
        let d='1';
        if(add_btn==2){
            btn=` <a href="javascript:;" class="btn btn-danger btn-sm remove_button mr-1" id="remove_btn_${count}" data-id="${count}"><i class="fa fa-minus"></i></i></a>`;
            d='N';
                
        }
        
        let default_in=`<div class="col-lg-4 col-md-4 col-sm-12 col-12" id="div_${count}">
                <div class="row  border-left border-secondary m-1">
                    <div class="col-lg-10 col-md-10 col-sm-12 col-12">
                        <div class="form-group">
                            <select class="form-control form-control-sm select2_new mt-1" id="countrySelector_${count}">
                                <option value="US" selected>United States</option>
                                <option value="CA">Canada</option>
                                <option value="UK">United Kingdom</option>
                                <option value="AU">Australia</option>
                                <option value="EU">Europe</option>
                            </select>
                            
                            <input type="text" id="DateSelector_${count}" name="DateSelector_${count}" data-count_id="${count}" data-track_id="${count}" data-title="" data-start="" data-end="" class="form-control form-control-sm DateSelector DateSelector${d}  mt-1"  />
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-12 col-12">
                        <div class="form-group mt-1">
                            ${btn}
                        </div>
                    </div>
                </div>
                
            </div>`; 
        return default_in;
    }
    
    $('#tbody_add').html(default_in(1));
        
    $(document).on('click','.add_button',function(e){
        e.preventDefault();
        
        if(x < maxField){ 
            
            x++; //Increment field counter
            $(wrapper).append(default_in(count,2)); //Add field html
            count++;
            datepickerLoad();
            track_id_update();
        }
    });
    
    //Once remove button is clicked
    $(wrapper).on('click', '.remove_button', function(e){
        e.preventDefault();
        var self=$(this);
        var id=self.data('id');
        
        $('#div_'+id).remove();
        x--; //Decrement field counter 
        count--;
        track_id_update();
    });
    
    function track_id_update(){
        var count=1;
        $(wrapper).find('.DateSelector').each(function(){
           var self=$(this);
           
           self.attr('data-track_id',count);
           count++;
        });
    }
    
    function datepickerLoad(){
        $('.DateSelectorN').daterangepicker({
            startDate: start,
            endDate: end,
            useCurrent: false,
            ranges: {
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(7, 'days'), moment().subtract(1, 'days')],
                'Last 14 Days': [moment().subtract(14, 'days'), moment().subtract(1, 'days')],
                'Last 30 Days': [moment().subtract(30, 'days'), moment().subtract(1, 'days')],
                'Last 60 Days': [moment().subtract(60, 'days'), moment().subtract(1, 'days')],
                'Last 90 Days': [moment().subtract(90, 'days'), moment().subtract(1, 'days')],
                'Last 180 Days': [moment().subtract(180, 'days'), moment().subtract(1, 'days')],
                'Last 365 Days': [moment().subtract(365, 'days'), moment().subtract(1, 'days')],
            },
            isInvalidDate: function(date) {
                // Disable the current date
                var ntoday=moment();
                return date.isSameOrAfter(ntoday, 'day');
            },
        });
        
        $(wrapper).find('.DateSelector').removeClass('DateSelectorN');
        // Bind 'apply.daterangepicker' event to dynamically added fields
        apply_datepicker();
    }
        
    $('.DateSelector1').daterangepicker({
        startDate: start,
        endDate: end,
        useCurrent: false,
        ranges: {
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(7, 'days'), moment().subtract(1, 'days')],
            'Last 14 Days': [moment().subtract(14, 'days'), moment().subtract(1, 'days')],
            'Last 30 Days': [moment().subtract(30, 'days'), moment().subtract(1, 'days')],
            'Last 60 Days': [moment().subtract(60, 'days'), moment().subtract(1, 'days')],
            'Last 90 Days': [moment().subtract(90, 'days'), moment().subtract(1, 'days')],
            'Last 180 Days': [moment().subtract(180, 'days'), moment().subtract(1, 'days')],
            'Last 365 Days': [moment().subtract(365, 'days'), moment().subtract(1, 'days')],
        },
        isInvalidDate: function(date) {
            // Disable the current date
            var ntoday=moment();
            return date.isSameOrAfter(ntoday, 'day');
        },
    });
        
        
        
    $('.DateSelector').attr("data-start",start.format('YYYY-MM-DD'));
    $('.DateSelector').attr("data-end",end.format('YYYY-MM-DD'));
        
    apply_datepicker();
        
    function apply_datepicker(){
        $(wrapper).find('.DateSelector').on('apply.daterangepicker', function(ev, picker) {
            console.log('moce');
            let self=$(this);
            
            let count_id=self.data('count_id');
            
            var countrySelector=[];
            
            $(`#countrySelector_${count_id} option:selected`).each(function(i, sel){ 
                countrySelector.push($(sel).val());
            });
            
            var text='';
            if(countrySelector.length>0){
                text='<br>('+countrySelector.join(', ')+')';
            }
            
            console.log(text);
            
            var title=picker.startDate.format('DD_MMM_YY')+'<br>to<br>'+picker.endDate.format('DD_MMM_YY')+text;
            var track_id=self.data('track_id');
            
            
            self.attr("data-start",picker.startDate.format('YYYY-MM-DD'));
            self.attr("data-end",picker.endDate.format('YYYY-MM-DD'));
            self.attr('data-title',title)
            
            dateWiseSave(picker.startDate.format('YYYY-MM-DD'),picker.endDate.format('YYYY-MM-DD'),title,track_id,count_id)
            
        });
    }
    
    

    $('#select2').select2();
    
        // $("a .single_image").fancybox();
    $('#posts').DataTable({
        "processing": true,
        "pageLength": 100,
        "serverSide": true,
        "dataSrc": "",
        "language": {
            "search": "Search Products",
            "lengthMenu":"Show _MENU_ Entries" 
        },
        "ajax":{
                 "url": "{{ route('trendsSaleOrders.ajaxDatatable') }}",
                //  "dataType": "json",
                 "type": "POST",
                 "data":function(d){
                    d._token= "{{csrf_token()}}";
                    d.child_sku = $('#child_sku:checked').val();
                    d.is_discarded = $('#discarded_sku:checked').val();
                    
                    var dataShow=$('#dataShow').val();
                    d.data_show=dataShow;
                 }
               },
        "columnDefs": [
            {'searchable': false,'targets': [0,1,2,3,4,5,6,7,8,9] },
            { 'visible': false, 'targets': [3,4,5,6,7,8,9] }
            
        ],
        "order": [[ 1, "ASC" ]],
        bSort: false,
        "ordering": false,
        "columns": [
            { "data": "ProductImg", "name":"ProductImg" },
            { "data": "variation","name":'variation' },
            { "data": "ProductDetail" ,"name":'ProductDetail'},
            { "data": "th_1","name":"th_1" },//3
            { "data": "th_2","name":"th_2" },//4
            { "data": "th_3","name":"th_3" },//5
            { "data": "th_4","name":"th_4" },//6
            { "data": "th_5","name":"th_5" },//7
            { "data": "up_comming_1","name":"up_comming_1" },//8
            { "data": "up_comming_2","name":"up_comming_2"},//9

        ],
        
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        "drawCallback": function( settings ) {
            $('.loader').select2();
            loader('#posts',0);
        }	
        	 

    });

        
    

    

    

    $('#custom_filter').click(function(){
        $('#custom_div').toggle();
    });
    
    

    
    
    $('#SearchBtn').click(function(){
        if($('#child_sku').is(':checked')){
            $('#posts').DataTable().column(5).visible(false);
        }else{
            $('#posts').DataTable().column(5).visible(true);
        }
        
        $('#btn_excel').hide();            
        $('#posts').DataTable().ajax.reload().draw();
        $('#btn_excel').show();
              
    });
    
    function dateWiseSave(start,end,title,track_id,count_id){
        var child_sku=$('#child_sku:checked').val();
        
        
        var keyArr=JSON.parse('{!!$keyArr!!}');
        var countrySelector=[];
        $(`#countrySelector_${count_id} option:selected`).each(function(i, sel){ 
            countrySelector.push($(sel).val()); 
        });
        
        $('#dataShow').val(1);
        
        
        if(start !='' && end !=''){
            $('#backorderhtml').html(`<tr>
                <td colspan="10"><span class="text-center text-info">Please Wait loading data ....</span></td>
            </tr>`);
                        
            $('#showBtn').hide();
            $.ajax({
                "url": "{{ route('DateWiseFilter') }}",
                "dataType": "json",
                "type": "POST",
                "data":{
            	    start_date :start,
            	    end_date : end,
            	    child_sku : child_sku,
            	    countrySelector:countrySelector,
            	    title:title,
            	    track_id:track_id,
            	    _token:"{{csrf_token()}}"
	            },
	            success:function(data){
	                if(data.code == 200){
	                   // $('#backorderhtml').html(data.html);
	                    $('#showBtn').show();
	                    
	                    
	                    $('#posts').DataTable().column(keyArr["th_"+track_id]).visible(true);
	                    $('#th_'+track_id).html(`<span class="text-wrap" style="width: 6rem;word-wrap: break-word;">${title}</span>`);
	                    
	                    if($('#predicted_tenure').is(':checked')){
	                        $('#posts').DataTable().column(8).visible(true);
	                        $('#posts').DataTable().column(9).visible(true);
	                    }
	                    
	                    
	                    $('#dataShow').val(1);
	                    
                        $('#posts').DataTable().ajax.reload();
                        $('#posts').DataTable().draw();
	                }
	            }
            });
        }
    }
    
    $('#clearBtn').click(function(){
        $.ajax({
           url:"{{route('trendsSaleOrders.clearFilter')}}",
           type:"POST",
           dataType:'JSON',
           data:{
               _token:"{{csrf_token()}}"
           },
           success:function(resp){
               if(resp.code=='200'){
                   location.reload();
               }
           }
        });
    });
    
    

</script>

    
@endsection