@extends('layouts.app')

@section('title','SKU | Mini Opex')
@section('add_css')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
<x-datatable-js type="css"/>
<style>
select {
    font-family: 'FontAwesome', 'Poppins';
    font-weight: normal;
    font-style : normal;
}
</style>

    
@endsection

@section('content')
    <!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12  text-sm">
                    
                    <div class="card">
                        
                        <div class="card-header">
                            <strong>Stock </strong> Dashboard
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="container custom_filter pt-3 pb-3 border  rounded" id="custom_div">
                                <form action="{{route('stockDashboard.excelDownload')}}" method="post">
                                    <input type="hidden" id="dataShow" value="0"/>
                                    @csrf
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                        <input type="text" id="DateSelector" name="DateSelector" data-start="" data-end="" class="form-control form-control-sm mb-2"  />
                                        <input type="hidden" id="dataShow" value="0"/>
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                        <select name="store" id="store" class="form-control form-control-lg select2">
                                            <option value="">Select Store</option>
                                            @forelse ($stores as $store)
                                                <option value="{{ $store->id }}">{{ $store->strong_name}}</option>
                                            @empty
                                                
                                            @endforelse
                                        </select>
                                    </div>
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                        <select class="form-control form-control-sm mt-2 select2_new" multiple id="stockTypeSelector" name="stockTypeSelector[]" placeholder="Select Stock Type">
                                            <option value="1">Amazon Instock</option>
                                            <option value="2">Amazon Inbound</option>
                                            <option value="3">Amazon Reserved</option>
                                            <option value="3">AWD Instock</option>
                                        </select> 
                                    </div>
                                    
                                    
                                    <!--<div class="col-lg-4 col-md-4 col-sm-6 col-12">-->
                                    <!--    <select class="form-control form-control-sm mt-2 select2_new" multiple id="genderSelector" name="genderSelector[]" placeholder="Select Gender">-->
                                    <!--        <option value="1">Men</option>-->
                                    <!--        <option value="2">Women</option>-->
                                    <!--        <option value="3">Other</option>-->
                                    <!--    </select> -->
                                    <!--</div>-->
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" id="child_sku" name="child_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="child_sku">Child SKU Wise</label>
                                        </div>
                                    </div>
                            
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" id="discarded_sku" name="discarded_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="discarded_sku">With Discarded SKU</label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-12">
                                        <div class="form-check">
                                            <input class="form-check-input" id="occasional_sku" name="occasional_sku" type="checkbox" value="yes"/>
                                            <label class="form-check-label" for="occasional_sku">Occasional</label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-4 col-md-4 col-sm-6 col-12" id="showBtn">
                                        <label  class="form-control-label mr-3">&nbsp;</label><br>
                                        <button type="button" class="btn btn-primary btn-sm" id="searchBtn">Search</button>
                                        <button type="submit" class="btn btn-primary btn-sm" id="btn_excel">Download Excel</button>
                                    </div>
                                    
                                    
                                    <div class="col-md-12 mt-2 ">
                                        <p class="fw-bold text-danger  fs--1">Note : This action will take Atleast 2-3 minutes to complete.</p>
                                    </div>
                                    
                                </div>
                                </form>
                            </div>
                            
                            <div class="table-responsive mt-2">
                                            <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%">
                                                <thead>
                                                        <tr class="fw-bold thead-light">
                                                            <th colspan="1"><span class="float-end">Instock Rate</span></th>
                                                            <th id="instock_rate">0%</th>
                                                            <th >Total</th>
                                                            <th id="total_avail">0</th>
                                                            <th id="total_avg">0</th>
                                                            <th></th>
                                                            <th id="total_stock">0</th>
                                                            
                                                        </tr>
                                                        <tr class="thead-dark">
                                                            <th>Image</th>
                                                            <th>Product SKU</th>
                                                            <th>Product Title</th>
                                                            <!--<th>Gender</th>-->
                                                            <th>Available Stock</th>
                                                            <th>Total Sale</th>
                                                            <th>Stock %</th>
                                                            <th>Usable Stock</th>
                                                            
                                                        </tr>
                                                    </thead>
                                                
                                                <tbody id="backorderhtml">
                                                    <tr>
                                                        <td colspan="9"><span class="text-center text-danger">No Record Found</span></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
    
@endsection

@section('add_js')
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <x-datatable-js type="js"/>
    
    <script>
    $(document).ready(function(){
       
        
        $('.select2_new').each(function() {
            var placeholder=$(this).attr('placeholder');
            $(this).select2({
                placeholder: placeholder
            });
        });
        
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        var start = moment().subtract(1, 'days');
        var end = moment().subtract(1, 'days');

        
        function cbtwo(start, end) {
            $('#DateSelector span').html(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
            $('#DateSelector').attr("data-start",start.format('YYYY-MM-DD'));
            $('#DateSelector').attr("data-end",end.format('YYYY-MM-DD'));
        }
    
        $('#DateSelector').attr("data-start",start.format('YYYY-MM-DD'));
        $('#DateSelector').attr("data-end",end.format('YYYY-MM-DD'));
   
        $('#DateSelector').daterangepicker({
            startDate: start,
            endDate: end,
            useCurrent: false,
            ranges: {
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(7, 'days'), moment().subtract(1, 'days')],
                'Last 14 Days': [moment().subtract(14, 'days'), moment().subtract(1, 'days')],
                'Last 30 Days': [moment().subtract(30, 'days'), moment().subtract(1, 'days')],
                'Last 60 Days': [moment().subtract(60, 'days'), moment().subtract(1, 'days')],
                'Last 90 Days': [moment().subtract(90, 'days'), moment().subtract(1, 'days')],
                'Last 180 Days': [moment().subtract(180, 'days'), moment().subtract(1, 'days')],
                'Last 365 Days': [moment().subtract(365, 'days'), moment().subtract(1, 'days')],
            },
            isInvalidDate: function(date) {
                // Disable the current date
                var ntoday=moment();
                return date.isSameOrAfter(ntoday, 'day');
            },
        }, cbtwo);
        
        $('#DateSelector').on('apply.daterangepicker', function(ev, picker) {
            console.log('moce');
            var a = moment(picker.startDate);
            var b = moment(picker.endDate);
            var diff = a.diff(b, 'days');
            var numday = diff.toString();
            var d = numday.replace("-", "");
            var dnum = parseInt(d);
            
            
        
            $(document).find("#DateSelector").attr("data-start",picker.startDate.format('YYYY-MM-DD'));
            $(document).find("#DateSelector").attr("data-end",picker.endDate.format('YYYY-MM-DD'));
        });
        
        var posts = $('#posts').DataTable({
            scrollX : 'TRUE',
            "processing": true,
            "serverSide": true,
            "pageLength": 25,
            lengthMenu: [[25,50,100,500,1000,2000,3000,-1], [25,50,100,500,1000,2000,3000,'All']],
            
            "dataSrc": "",
            "ajax":{
                        "url": "{{ route('stockDashboard.ajaxDatatable') }}",
                    //  "dataType": "json",
                        "type": "POST",
                        "data":function(d){
                            var child_sku=$('#child_sku:checked').val();
                            var discarded_sku=$('#discarded_sku:checked').val();
                            var dataShow=$('#dataShow').val();
                            let occasional_sku=$('#occasional_sku:checked').val(); 
                            
                            // var genderSelector=[];
                            // $('#genderSelector option:selected').each(function(i, sel){ 
                            //     genderSelector.push($(sel).val());
                            // });
                            
                            // var countrySelector=[];
                            // $('#countrySelector option:selected').each(function(i, sel){ 
                            //     countrySelector.push($(sel).val()); 
                            
                            // });
                            
                            var stockType=[];
                            $('#stockTypeSelector option:selected').each(function(i, sel){ 
                                stockType.push($(sel).val()); 
                            
                            });
                            
                            d.child_sku=child_sku;
                            d.is_discarded=discarded_sku;
                            // d.gender=genderSelector;
                            d.data_show=dataShow;
                            // d.countrySelector=countrySelector;
                            d.stockType=stockType;
                            d._token="{{csrf_token()}}";
                            d.occasional_sku = occasional_sku;
        	            }
                    },
            bSort: false,
            "ordering": false,
            
            'columnDefs' : [
                {'searchable': false,'targets': [0,1,2,3,4,5,6] }//,7
            ],
             scrollX: true,
             autoWidth: false, 
             dom: 'lfrtip',//lBfrtip
            "columns":[
                { "data": "checkbox","name":"checkbox" },//0
                { "data": "sku","name":"sku" },//1
                { "data": "title","name":"title" },//2
                // { "data": "gender","name":"gender" },//3
                { "data": "available_stock","name":"available_stock" },//5
                { "data": "total_sale","name":"total_sale" },//6
                { "data": "sale_percentage","name":"sale_percentage" },//7
                { "data": "usable_stock","name":"usable_stock" },//8
            ],
            drawCallback: function(settings) {
                $('#total_stock').text(settings.json.total_usable);
                $('#total_avg').text(settings.json.total_avg);
                $('#instock_rate').text(settings.json.instock_per+'%');
                $('#total_avail').text(settings.json.total_avail);
            },
            
            buttons: [
                   {
                       extend: 'excel',
                    },

            ],
            initComplete: function () {
                $('.buttons-excel').addClass('btn btn-info btn-sm').removeClass('dt-button').html('<i class="fas fa-file-excel"></i> Excel');
            },
        });
        
        
        
        
        $("#searchBtn").click(function(){
            let start = $("#DateSelector").attr("data-start");
            let end = $("#DateSelector").attr("data-end");
            
            let child_sku=$('#child_sku:checked').val();
            
            let store=$('#store option:selected').val();
            
            
            
            // var countrySelector=[];
            // $('#countrySelector option:selected').each(function(i, sel){ 
            //     countrySelector.push($(sel).val()); 
            
            // });
            
            $('#dataShow').val(1);
            
            
            if(start !='' && end !=''){
                $('#backorderhtml').html(`<tr>
                                <td colspan="15"><span class="text-center text-info">Please Wait loading data ....</span></td>
                            </tr>`);
                            
                $('#btn_excel').hide();
                $('#child_sku_base_sale').prop('checked',false);
                $('.as_date').hide();
                $.ajax({
                    "url": "{{ route('stockDashboard') }}",
                    "dataType": "json",
                    "type": "POST",
                    "data":{
                	    start_date :start,
                	    end_date : end,
                	   // countrySelector:countrySelector,
                	    store:store,
                	    child_sku : child_sku,
                	    
                	    _token:"{{csrf_token()}}"
    	            },
    	            success:function(data){
    	                if(data.code == 200){
    	                    $('#date_text').html(data.html);
    	                    $('#btn_excel').show();
    	                    
    	                    $('#dataShow').val(1);
    	                    
                            posts.ajax.reload();
                            posts.draw();
    	                }
    	            }
                });
            }
    
	    });
	    
	    
	    
    });    
        
        
        
        
    
    
  
    </script>

@endsection