@extends('layouts.app')
@section('title','Return Dashboard | Mini Opex')
@section('add_css')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
<x-datatable-js type="css"/>
<style>
select {
    font-family: 'FontAwesome', 'Poppins';
    font-weight: normal;
    font-style : normal;
}
</style>

    
@endsection

@section('content')

@include('sku.skuReturnModal',['htmlType' => '1','page' => 'product_info_design'])
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row ml-2 mr-2 mb-2">
                <div class="col-lg-6 col-md-6 col-sm-12 col-12 mt-1">
                    <div class="statistic__item border_dark bg-dark">
                        <h2 class="number text-white"><span id="orp">0 / 0 / 0%</span></h2>
                        <span class="desc text-white">Total Orders / Total Returns / Percentage</span>
                        <div class="icon text-white">
                            <i class="fas fa-history"></i>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-12 mt-1">
                    <div class="container custom_filter pt-3 pb-3 border  rounded" id="custom_div">
                        <form action="{{route('poDashboard.excelDownload')}}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                    <input type="text" id="date_picker" name="date_picker" data-start="" data-end="" class="form-control form-control-sm mb-2"  />
                                    <input type="hidden" id="dataShow" value="0"/>
                                </div>
                                
                                <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                    <div class="form-check">
                                        <input class="form-check-input" id="child_sku" name="child_sku" type="checkbox" value="yes"/>
                                        <label class="form-check-label" for="child_sku">Child SKU Wise</label>
                                    </div>
                                </div>
                                
                                <div class="col-lg-4 col-md-4 col-sm-6 col-12" id="showBtn">
                                    <button type="button" class="btn btn-primary btn-sm" id="searchBtn">Search</button>
                                    <!--<button type="submit" class="btn btn-primary btn-sm" id="btn_excel" style="display:none">Download Excel</button>-->
                                </div>
                                
                                
                                <div class="col-md-12 mt-2 ">
                                    <p class="fw-bold text-danger  fs--1">Note : This action will take Atleast 2-3 minutes to complete.</p>
                                </div>
                                
                            </div>
                        </form>
                    </div>
                        
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12  text-sm">
                    
                    <div class="card">
                        
                        <div class="card-header">
                            <strong>Return </strong> Dashboard
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            
                            
                            
                            <div class="table-responsive mt-2 table-responsive-data2">
                                <table class="table  table-bordered  table-striped" id="posts" cellspacing="0" width="100%">
                                    <thead>
                                        <tr class="thead-light">
                                            <th colspan="3">Total</th>
                                            <th id="totalSales">0</th>
                                            <th id="totalFull">0</th>
                                            <th id="percentage" colspan="2">0%</th>
                                        </tr>
                                        <tr class="thead-dark">
                                            <th>Sno</th>
                                            <th>Product SKU</th>
                                            <th>Product Title</th>
                                            <th>Total Sales</th>
                                            <th>Total Returns</th>
                                            <th>Return %</th>
                                            <th>Action</th>
                                        </tr>
                                      </thead>
                                      <tbody id="backorderhtml">
                                        <tr>
                                            <td colspan="10"><span class="text-center text-danger">No Record Found</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<x-datatable-js type="js"/>



<script>
    
    let start = moment().subtract(1, 'days');
    let end = moment().subtract(1, 'days');
    
    function cbtwo(start, end) {
        $('#date_picker span').html(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
        $('#date_picker').attr("data-start",start.format('YYYY-MM-DD'));
        $('#date_picker').attr("data-end",end.format('YYYY-MM-DD'));
    }
    
    $('#date_picker').attr("data-start",start.format('YYYY-MM-DD'));
    $('#date_picker').attr("data-end",end.format('YYYY-MM-DD'));
   
    $('#date_picker').daterangepicker({
        startDate: start,
        endDate: end,
        useCurrent: false,
        ranges: {
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(7, 'days'), moment().subtract(1, 'days')],
            'Last 14 Days': [moment().subtract(14, 'days'), moment().subtract(1, 'days')],
            'Last 30 Days': [moment().subtract(30, 'days'), moment().subtract(1, 'days')],
            'Last 60 Days': [moment().subtract(60, 'days'), moment().subtract(1, 'days')],
            'Last 90 Days': [moment().subtract(90, 'days'), moment().subtract(1, 'days')],
            'Last 180 Days': [moment().subtract(180, 'days'), moment().subtract(1, 'days')],
            'Last 365 Days': [moment().subtract(365, 'days'), moment().subtract(1, 'days')],
        },
        isInvalidDate: function(date) {
            // Disable the current date
            let ntoday=moment();
            return date.isSameOrAfter(ntoday, 'day');
        },
    }, cbtwo);
        
    $('#date_picker').on('apply.daterangepicker', function(ev, picker) {
        console.log('moce');
        let a = moment(picker.startDate);
        let b = moment(picker.endDate);
        let diff = a.diff(b, 'days');
        let numday = diff.toString();
        let d = numday.replace("-", "");
        let dnum = parseInt(d);
        
        $(document).find("#date_picker").attr("data-start",picker.startDate.format('YYYY-MM-DD'));
        $(document).find("#date_picker").attr("data-end",picker.endDate.format('YYYY-MM-DD'));
    });
    
    let ReturnReasonList = $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 10,
        lengthMenu: [
            [10, 25, 50,100,200],
            [10, 25, 50,100,200]
        ],
        
        "ajax":{
            "url": "{{ route('returnDashboard.ajaxDatatable') }}",
            "type": "POST",
            "data":function(d){
                d._token= "{{csrf_token()}}";

            }
        },
        bSort: false,
        "ordering": false,
        fixedHeader: {
            header: true
        },
        'columnDefs' : [
            // {'searchable': false,'targets': [8,9,10,11] },
        ],
         scrollX: true,
        "columns":[
            { "data": "DT_RowIndex","name":"DT_RowIndex","width":"50px" },//0
            { "data": "sku","name":"sku","width":"50px" },//1
            { "data": "product_title","name":"product_title","width":"30%" },//2
            { "data": "total_sale","name":"total_sale" },//3
            { "data": "total_full","name":"total_full" },//4
            { "data": "fr_per","name":"fr_per" },//5
            { "data": "action","name":"action" },//6
        ],
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        drawCallback: function(settings) {
            if (settings.json.oPercentage !== undefined) {
                $('#orp').text(settings.json.oPercentage);
                $('#totalSales').text(settings.json.totalSale);
                $('#totalFull').text(settings.json.totalFull);
                $('#percentage').text(settings.json.percentage + ' %');
            }
            
            loader('#posts',0);
        },
        
        createdRow: function (row, data, dataIndex) {
            if (data.higher_refund == 2) {
                $(row).addClass('table-danger');
            }else if(data.higher_refund == 1) {
                $(row).addClass('table-warning');
            }
        }
    });
    
    $("#searchBtn").click(function(){
        let start = $("#date_picker").attr("data-start");
        let end = $("#date_picker").attr("data-end");
            
        let child_sku=$('#child_sku:checked').val();
            
        $('#dataShow').val(1);
        
        
        if(start !='' && end !=''){
            $('#backorderhtml').html(`<tr>
                <td colspan="15"><span class="text-center text-info">Please Wait loading data ....</span></td>
            </tr>`);
                        
            $('#btn_excel').hide();
            
            $.ajax({
                "url": "{{ route('returnDashboard') }}",
                "dataType": "json",
                "type": "POST",
                "data":{
            	    start_date :start,
            	    end_date : end,
            	    child_sku : child_sku,
            	    _token:"{{csrf_token()}}"
	            },
	            success:function(data){
	                if(data.code == 200){
	                    $('#btn_excel').show();
	                    $('#dataShow').val(1);
	                    
                        ReturnReasonList.ajax.reload();
                        ReturnReasonList.draw();
	                }
	            }
            });
        }

    });
    
     @include('sku.skuReturnModal',['htmlType' => '2','page' => 'product_info_design'])
    
</script>

    
@endsection