@extends('layouts.app')
@section('title','Dashboard | Mini Opex')

@section('add_css')
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="overview-wrap">
                        <h2 class="title-1">overview</h2>
                        <div class="float-right">
                            @can('mo-history')
                            <a href="{{ route('mo.mo_list') }}" id="mo_history" class="btn btn-dark btn-sm ml-1"><i class="fas fa-history"></i> MO Detail</a>
                            @endcan
                            @can('inventory-summary')
                            <a href="{{ route('inventory.summary','decrum') }}" id="inventory_summary_de" class="btn bg-orange text-dark btn-sm ml-1"><i class="fas fa-warehouse"></i> Decrum WH Inventory</a>
                            @endcan
                            
                            @can('inventory-summary-uc')
                            <a href="{{ route('inventory.summary','urban') }}" id="inventory_summary_uc" class="btn btn-dark btn-sm ml-1"><i class="fas fa-warehouse"></i> Urban WH Inventory</a>
                            @endcan
                            @can('inventory-summary-uc')
                            <a href="{{ route('inventory.summary','safetyStock') }}" id="inventory_summary_ss" class="btn bg-orange text-dark btn-sm ml-1"><i class="fas fa-warehouse"></i> safetyStock WH Inventory</a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-lg-12 col-md-12 col-md-12 col-12">
                        <table class="table table-bordered mb-5">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Pending MOs</th>
                                        <th>Drop-In Today</th>
                                        <th>Drop-In Last 7 Days</th>
                                        <th>Air Cargo Pending</th>
                                        <th>Sea Cargo Pending</th>
                                        <th>Total Pending</th>
                                        <th>Ready to Ship Order #</th>
                                        <th>Ready to Ship Bundle #</th>
                                        <th>Urgent Urban Pending</th>
                                        <th>Urgent Decrum Pending</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {!!$system_summary['system_summary_one'] !!}
                                </tbody>
                        </table>
                        
                        <div class="mb-5">
                            <h5 class="mb-3">Supplier Statistics</h5>
                            
                            <table class="table table-bordered">
                                <thead class="thead-dark">
                                    <tr>
                                        <th scope="col">Supplier</th>
                                        <th scope="col">Remaining</th>
                                        <th scope="col">Last 7 Days Received</th>
                                        <th scope="col">Last 30 Days Received</th>
                                    </tr>
                                  </thead>
                                <tbody>
                                    {!!$inventory_summary_supplier_wise !!}
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mb-5">
                            <h5 class="mb-3">Store Wise In-Process / Shipped Statistics</h5>
                            <table class="table table-bordered">
                                <thead class="thead-dark">
                                    <tr>
                                        <th scope="col">Store</th>
                                        <th scope="col">Type</th>
                                        <th scope="col">Pending</th>
                                        <th scope="col">Ready To Ship Order</th>
                                        <th scope="col">Ready To Ship Bundle</th>
                                        <th scope="col">Last 7 Days Shipped</th>
                                        <th scope="col">Last 30 Days Shipped</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {!! $store_wise_summary !!}
                                </tbody>
                            </table>
                        </div>
                        
                
                    
                    
                    
                    
                    
                    
                    
                    
                </div>
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
<!-- end of Main CONTENT -->
    
@endsection

@section('add_js')
@endsection