@extends('layouts.app')
@section('title','Dashboard | Mini Opex')

@section('add_css')
@endsection

@section('content')
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-md-12 col-12">
                        @if(auth()->user()->can('graph-dashboard'))
                            
                            <div class="form-group float-right">
                                <select class="form-control form-control-sm mt-1" id="countrySelector">
                                    <option value="us" selected>United States</option>
                                    <option value="ca">Canada</option>
                                    <option value="uk" class="d-none">United Kingdom</option>
                                    <option value="au" class="d-none">Australia</option>
                                    <option value="eu" class="d-none">Europe</option>
                                </select>
                            </div>
                            
                            <table class="table table-bordered mb-5 tbhide" id="us_show">
                                <thead >
                                    <tr>
                                        <th class="table-dark">US Sale</th>
                                        <th class="table-dark">US Stock (On Hand)</th>
                                        <th class="table-dark">US Active Demand Stock</th>
                                        <th class="table-dark">US Stock (On Hand %)</th>
                                        <th class="table-dark">US AWD Instock</th>
                                        <th class="table-dark">US Inbound</th>
                                        <th class="table-dark">US Reserved</th>
                                        <th class="table-dark">US Total Stock</th>
                                        <th class="table-dark">US Stock (On Hand + AWD + Inbound) %</th>
                                        <th class="table-dark">US OverStock</th>
                                        <th class="table-dark">US OverStock %</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['total_sale_short_us'] ?? 0}}</td>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['total_stock_short_us'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['total_usable_short_us'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['instock_per_short_us'] ?? 0}}%</td>
                                        <td>{{$getInstockRateAndOverStock['total_awd_us'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['total_inbound_us'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['total_res_us'] ?? 0}}</td>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['total_stock_long_us'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['instock_per_long_us'] ?? 0}}%</td>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['all_overstock_us'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['alloverStock_per_us'] ?? 0}}%</td>
                                    </tr>
                                </tbody>
                            </table>
                            
                        
                            <table class="table table-bordered mb-5 tbhide" id="ca_show" style="display:none">
                                <thead >
                                    <tr>
                                        <th class="table-dark">CA Sale</th>
                                        <th class="table-dark">CA Stock (On Hand)</th>
                                        <th class="table-dark">CA Active Demand Stock</th>
                                        <th class="table-dark">CA Stock (On Hand %)</th>
                                        <th class="table-dark">CA AWD Instock</th>
                                        <th class="table-dark">CA Inbound</th>
                                        <th class="table-dark">CA Reserved</th>
                                        <th class="table-dark">CA Total Stock</th>
                                        <th class="table-dark">CA Stock (On Hand + AWD + Inbound) %</th>
                                        <th class="table-dark">CA OverStock</th>
                                        <th class="table-dark">CA OverStock %</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['total_sale_short_ca'] ?? 0}}</td>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['total_stock_short_ca'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['total_usable_short_ca'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['instock_per_short_ca'] ?? 0}}%</td>
                                        <td>{{$getInstockRateAndOverStock['total_awd_ca'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['total_inbound_ca'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['total_res_ca'] ?? 0}}</td>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['total_stock_long_ca'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['instock_per_long_ca'] ?? 0}}%</td>
                                        <td class="font-weight-bold">{{$getInstockRateAndOverStock['all_overstock_ca'] ?? 0}}</td>
                                        <td>{{$getInstockRateAndOverStock['alloverStock_per_ca'] ?? 0}}%</td>
                                    </tr>
                                </tbody>
                            </table>
                        @endif
                        <table class="table table-bordered mb-5">
                                <thead >
                                    <tr>
                                        <th class="table-dark">Pending MOs</th>
                                        <th class="table-dark">Drop-In Today</th>
                                        <th class="table-dark">Drop-In Last 7 Days</th>
                                        <th class="table-dark">Air Cargo Pending</th>
                                        <th class="table-dark">Sea Cargo Pending</th>
                                        <th class="table-dark">Total Pending</th>
                                        <th class="table-dark">Ready to Ship Order #</th>
                                        <th class="table-dark">Ready to Ship Bundle #</th>
                                        <th class="bg-orange text-dark">Urgent Urban Pending</th>
                                        <th class="bg-orange text-dark">Urgent Decrum Pending</th>
                                        <th class="bg-orange text-dark">last 30 days Returns</th>
                                        <th class="bg-orange text-dark">Return %</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {!!$system_summary['system_summary_one'] !!}
                                </tbody>
                        </table>
                        
                        
                        <div class="mb-5">
                            <h5 class="mb-3">Store Wise In-Process / Shipped Statistics</h5>
                            <table class="table table-bordered">
                                <thead class="thead-dark">
                                    <tr>
                                        <th scope="col">Store</th>
                                        <th scope="col">Type</th>
                                        <th scope="col">Pending</th>
                                        <th scope="col">Ready To Ship Order</th>
                                        <th scope="col">Ready To Ship Bundle</th>
                                        <th scope="col">Last 7 Days Shipped</th>
                                        <th scope="col">Last 30 Days Shipped</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {!! $store_wise_summary !!}
                                </tbody>
                            </table>
                        </div>
                </div>
            </div>
            
            <div class="row">
                {!! $store_view !!}
            </div>
            
            <div class="mb-5">
                <h5 class="mb-3">Supplier Statistics</h5>
                
                <table class="table table-bordered">
                    <thead class="thead-dark">
                        <tr>
                            <th scope="col">Supplier</th>
                            <th scope="col">Remaining</th>
                            <th scope="col">Last 7 Days Received</th>
                            <th scope="col">Last 30 Days Received</th>
                        </tr>
                      </thead>
                    <tbody>
                        {!!$inventory_summary_supplier_wise !!}
                    </tbody>
                </table>
            </div>
            
            <div class="row">
                    @if(auth()->user()->can('graph-dashboard'))
                            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="au-card m-b-30">
                                    <div class="au-card-inner">
                                        <h3 class="title-2 m-b-40">DropIn Shipments Chart </h3>
                                        <div class="mt-1">
                                            
                                            <div class="form-group float-right">
                                                <input type="text" id="date_picker" name="date_picker" placeholder="Date Picker" class="form-control form-control-sm date_picker"> 
                                            </div>
                                            <div class="form-check-inline form-check">
                                                <div class="checkbox ml-2">
                                                    <input class="form-check-input" id="drop_in" name="drop_in" type="checkbox" value="yes" checked/>
                                                    <label class="form-check-label" for="drop_in">Drop IN</label>
                                                </div>&nbsp;&nbsp;&nbsp;
                                                <div class="checkbox">
                                                    <input class="form-check-input" id="shipments" name="shipments" type="checkbox" value="yes" checked/>
                                                    <label class="form-check-label" for="shipments">Shipments</label>
                                                </div>&nbsp;&nbsp;&nbsp;
                                                <div class="checkbox">
                                                    <input class="form-check-input" id="sales" name="sales" type="checkbox" value="yes" checked/>
                                                    <label class="form-check-label" for="sales">Sales</label>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        
                                        <hr>
                                        <canvas id="sales-chart-new"></canvas>
                                    </div>
                                </div>
                            </div>
                    @endif
            </div>
            
           
            @include('partials.copyrights')
        </div>
    </div>
</div>
<!-- end of Main CONTENT -->
    
@endsection

@section('add_js')
<script>
    $(document).ready(function(){
        
    
    let month_name = @json($chart_data['month_name']);
    let dropin = @json($chart_data['receivings']);
    let shipments = @json($chart_data['shipments']);
    let sales= @json($chart_data['sales']);
    
    let myChart=null;
    
    // console.log(month_name,dropin,shipments,sales);
    
    generate_chart(month_name,dropin,shipments,sales);
    
    $(document).on('change','#countrySelector',function(){
        let self=$(this);
        
        let val= self.val();
        
        $('.tbhide').hide();
        $('#'+val+'_show').show();
    })
    
    $(document).find('#date_picker').on('apply.daterangepicker', function(ev, picker) {
        let self=$(this);
        
        let start_date = picker.startDate.format('YYYY-MM-DD');
        let end_date = picker.endDate.format('YYYY-MM-DD');
        
        let dropInCheck=0;
        let shipmentsCheck=0;
        let salesCheck=0;
        
        if($('#drop_in').is(':checked')){
            dropInCheck=1;
        }
        
        if($('#shipments').is(':checked')){
            shipmentsCheck=1;
        }
        
        if($('#sales').is(':checked')){
            salesCheck=1;
        }
        
        
        $.ajax({
            url:"{{route('generate_chart')}}",
            type:"POST",
            dataType:'JSON',
            data:{
                _token:"{{csrf_token()}}",
                start_date:start_date,
                end_date:end_date
            },
            success:function(data){
                if(data.code =='200'){
                    let month_name=data.month_name;
                    let receivings=data.receivings;
                    let shipments=data.shipments;
                    let sales=data.sales;
                    
                    if(dropInCheck==0){
                        receivings='';
                    }
                    
                    if(shipmentsCheck ==0){
                        shipments='';
                    }
                    
                    if(salesCheck ==0){
                        sales='';
                    }
                    
                    if(myChart !=null){
                      myChart.destroy();
                    }
                    
                    generate_chart(month_name,receivings,shipments,sales);
                }
            }
        })
        
    });
    
    
    function generate_chart(month_name, dropIn = '', shipments = '', sales = '') {
        let ctx = document.getElementById("sales-chart-new");
        let dataSets = [];

        if (dropIn !== '') {
            dataSets.push({
                label: "DropIn",
                data: dropIn,
                backgroundColor: 'transparent',
                borderColor: 'rgba(220,53,69,0.75)',
                borderWidth: 3,
                pointStyle: 'circle',
                pointRadius: 5,
                pointBorderColor: 'transparent',
                pointBackgroundColor: 'rgba(220,53,69,0.75)'
            });
        }
    
        if (shipments !== '') {
            dataSets.push({
                label: "Shipments",
                data: shipments,
                backgroundColor: 'transparent',
                borderColor: 'rgba(0,0,255,0.75)',
                borderWidth: 3,
                pointStyle: 'circle',
                pointRadius: 5,
                pointBorderColor: 'transparent',
                pointBackgroundColor: 'rgba(0,0,255,0.75)',
            });
        }
    
        if (sales !== '') {
            dataSets.push({
                label: "Sales",
                data: sales,  // Pass sales directly as a parameter
                backgroundColor: 'transparent',
                borderColor: 'rgba(40,167,69,0.75)',
                borderWidth: 3,
                pointStyle: 'circle',
                pointRadius: 5,
                pointBorderColor: 'transparent',
                pointBackgroundColor: 'rgba(40,167,69,0.75)',
            });
        }
    
        try {
            if (ctx) {
                ctx.height = 150;
                myChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: month_name,
                        type: 'line',
                        defaultFontFamily: 'Poppins',
                        datasets: dataSets
                    },
                    options: {
                        responsive: true,
                        tooltips: {
                            mode: 'index',
                            titleFontSize: 12,
                            titleFontColor: '#000',
                            bodyFontColor: '#000',
                            backgroundColor: '#fff',
                            titleFontFamily: 'Poppins',
                            bodyFontFamily: 'Poppins',
                            cornerRadius: 3,
                            intersect: false,
                        },
                        legend: {
                            display: true,
                            labels: {
                                usePointStyle: true,
                                fontFamily: 'Poppins',
                            },
                        },
                        scales: {
                            xAxes: [{
                                display: true,
                                gridLines: {
                                    display: true,
                                    drawBorder: true
                                },
                                scaleLabel: {
                                    display: true,
                                    labelString: 'Month'
                                },
                                ticks: {
                                    fontFamily: "Poppins"
                                }
                            }],
                            yAxes: [{
                                display: true,
                                gridLines: {
                                    display: true,
                                    drawBorder: true
                                },
                                scaleLabel: {
                                    display: true,
                                    labelString: 'Value',
                                    fontFamily: "Poppins"
                                },
                                ticks: {
                                    fontFamily: "Poppins"
                                }
                            }]
                        },
                        title: {
                            display: false,
                            text: 'Normal Legend'
                        }
                    }
                });
            }
        } catch (error) {
            console.log(error);
        }
    }

})
    
 

  
  </script>
@endsection