@php
    if($type=='mobile'){
        $class='navbar-mobile-sub__list list-unstyled js-sub-list ';
    }elseif($type=='desktop'){
        $class='list-unstyled navbar__sub-list js-sub-list';
    }elseif($type=='collapse'){
        $class="navbar-mobile-sub__list list-unstyled js-sub-list mt-2 mb-2 text-dark";
    }
    $routes = \Route::currentRouteName();
@endphp

@can('dashboard')
    <li class="has-sub {{ Request::segment(1)=='dashboard' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='inventory' ? 'open' : '' }}" href="#">
            <i class="fas fa-tachometer-alt"></i>Dashboard</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='dashboard')style="display:block" @endif>
                <li>
                    <a href="{{ route('dashboard') }}"
                        @if($routes=='dashboard') class="a-active" @endif>Analytics</a>
                </li>
                <li>
                    <a href="{{ route('supplierPending.dashboard') }}"
                        @if($routes=='supplierPending.dashboard') class="a-active" @endif>Supplier Pending</a>
                </li>
                <li>
                    <a href="{{ route('operational.dashboard') }}"
                        @if($routes=='operational.dashboard') class="a-active" @endif>Operational</a>
                </li>
            </ul>    
    </li>
@endcan


@canany(['process-supplier','pending-orders','dropin-warehouse','supplier-statistics','print-label'])
<li class="has-sub {{ Request::segment(1)=='order' ? 'active' : '' }} {{ Request::segment(1)=='orders' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='order' ? 'open' : '' }} {{ Request::segment(1)=='orders' ? 'open' : '' }}" href="#">
            <i class="fas fa-shopping-bag"></i> Purchase Orders</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='order'||Request::segment(1)=='orders')style="display:block" @endif>
                @can('process-supplier')
                    <li>
                        <a href="{{ route('order.show') }}" 
                            @if($routes=='order.show') class="a-active" @endif>Process Supplier</a>
                    </li>
                @endcan
                @can('pending-orders')
                    <li>
                        <a href="{{ route('supplier.retrive') }}" 
                            @if($routes=='supplier.retrive') class="a-active" @endif>Edit View Orders (Switch)</a>
                    </li>
                @endcan
                
                @can('dropin-warehouse')
                    <li>
                        <a href="{{ route('supplier.receiving.add','receiving') }}" 
                            @if($routes=='supplier.receiving.add' && Request::segment(2)=='receiving') class="a-active" @endif>Dropin Warehouse</a>
                    </li>
                @endcan
                
                
                {{--
                @can('print-label')
                    <li>
                        <a href="{{ route('supplier.label.list') }}" 
                            @if($routes=='supplier.label.list') class="a-active" @endif>Print Label</a>
                    </li>
                @endcan
                --}}
                @can('gatepass-list')
                    <li>
                        <a href="{{ route('gatepass.index') }}" 
                            @if($routes=='gatepass.index') class="a-active" @endif>QC/Gate Pass (Reverse)</a>
                    </li>
                @endcan
                @can('supplier-statistics')
                    <li>
                        <a href="{{ route('order.statistics') }}" 
                            @if($routes=='order.statistics') class="a-active" @endif>Supplier Statistics</a>
                    </li>
                @endcan
                
                @can('supplier-statistics')
                    <li>
                        <a href="{{ route('order.storewise_statistics') }}" 
                            @if($routes=='order.storewise_statistics') class="a-active" @endif>Store Statistics</a>
                    </li>
                @endcan
                @can('complete-orders')
                    <li>
                        <a href="{{ route('supplier.receiving.add','complete') }}" 
                            @if($routes=='supplier.receiving.add' && Request::segment(2)=='complete') class="a-active" @endif>Complete Orders</a>
                    </li>
                @endcan
            </ul>
    </li>
@endcanany
<!--@if(Gate::check('process-supplier') || Gate::check('pending-orders') || Gate::check('dropin-warehouse') ||Gate::check('gatepass-list')||Gate::check('supplier-statistics') ||Gate::check('print-label'))-->
<!--    <li class="has-sub {{ Request::segment(1)=='order' ? 'active' : '' }} {{ Request::segment(1)=='orders' ? 'active' : '' }}">-->
<!--        <a class="js-arrow  {{ Request::segment(1)=='order' ? 'open' : '' }} {{ Request::segment(1)=='orders' ? 'open' : '' }}" href="#">-->
<!--            <i class="fas fa-shopping-bag"></i> Purchase Orders</a>-->
<!--            <ul class="{{ $class }}" @if(Request::segment(1)=='order'||Request::segment(1)=='orders')style="display:block" @endif>-->
<!--                @can('process-supplier')-->
<!--                    <li>-->
<!--                        <a href="{{ route('order.show') }}" -->
<!--                            @if($routes=='order.show') class="a-active" @endif>Process Supplier</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--                @can('pending-orders')-->
<!--                    <li>-->
<!--                        <a href="{{ route('supplier.retrive') }}" -->
<!--                            @if($routes=='supplier.retrive') class="a-active" @endif>Pending Orders</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--                @can('complete-orders')-->
<!--                    <li>-->
<!--                        <a href="{{ route('supplier.receiving.add','complete') }}" -->
<!--                            @if($routes=='supplier.receiving.add' && Request::segment(2)=='complete') class="a-active" @endif>Complete Orders</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--                @can('dropin-warehouse')-->
<!--                    <li>-->
<!--                        <a href="{{ route('supplier.receiving.add','receiving') }}" -->
<!--                            @if($routes=='supplier.receiving.add' && Request::segment(2)=='receiving') class="a-active" @endif>Dropin Warehouse</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--                @can('print-label')-->
<!--                    <li>-->
<!--                        <a href="{{ route('supplier.label.list') }}" -->
<!--                            @if($routes=='supplier.label.list') class="a-active" @endif>Print Label</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--                @can('gatepass-list')-->
<!--                    <li>-->
<!--                        <a href="{{ route('gatepass.index') }}" -->
<!--                            @if($routes=='gatepass.index') class="a-active" @endif>Gate Pass</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--                @can('supplier-statistics')-->
<!--                    <li>-->
<!--                        <a href="{{ route('order.statistics') }}" -->
<!--                            @if($routes=='order.statistics') class="a-active" @endif>Supplier Statistics</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--            </ul>-->
<!--    </li>-->
<!--@endif-->

<!--@if(Gate::check('sale-orders') || Gate::check('approve-sale-orders') || Gate::check('pending-sale-orders'))-->
<!--    <li class="has-sub {{ Request::segment(1)=='sale' ? 'active' : '' }}">-->
<!--        <a class="js-arrow  {{ Request::segment(1)=='sale' ? 'open' : '' }}" href="#">-->
<!--            <i class="fas fa-cart-plus"></i>Sale Orders</a>-->
<!--            <ul class="{{ $class }}"  @if(Request::segment(1)=='sale')style="display:block" @endif>-->
<!--                @can('sale-orders')-->
<!--                    <li>-->
<!--                        <a href="{{ route('sale.orders') }}"-->
<!--                            @if($routes=='sale.orders') class="a-active" @endif>Upload Sale Orders</a>-->
<!--                    </li>-->
<!--                @endcan-->

<!--                @can('approve-sale-orders')-->
<!--                    <li>-->
<!--                        <a href="{{ route('approve.sale.orders','approve') }}"-->
<!--                            @if($routes=='approve.sale.orders'&& Request::segment(2)=='approve') class="a-active" @endif>Approve Sale Order</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--                @can('pending-sale-orders')-->
<!--                    <li>-->
<!--                        <a href="{{ route('approve.sale.orders','pending') }}"-->
<!--                            @if($routes=='approve.sale.orders'&& Request::segment(2)=='pending') class="a-active" @endif>Pending Sale Order</a>-->
<!--                    </li>-->
<!--                @endcan-->
<!--            </ul>-->
<!--    </li>-->
<!--@endif-->

@if(Gate::check('upload-shippment'))
    <li class="has-sub {{ Request::segment(1)=='shipment' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='shipment' ? 'open' : '' }}" href="#">
            <i class="fas fa-shipping-fast"></i>Shipment</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='shipment')style="display:block" @endif>
                @if(auth()->user()->id !=34)
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('shipment.process.order') }}" 
                            @if($routes=='shipment.process.order') class="a-active" @endif>Process Order</a>
                    </li>
                @endcan
                @can('upload-shippment')
                <!--added by sufian-->
                    <li>
                        <a href="{{ route('shipment.bundle.list') }}" 
                            @if($routes=='shipment.bundle.list') class="a-active" @endif>Bundle Order</a>
                    </li>
                @endcan
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('shipment.processed.order') }}" 
                            @if($routes=='shipment.processed.order') class="a-active" @endif>Ready To Shipment</a>
                    </li>
                @endcan
                @endif
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('upload.shippment') }}" 
                            @if($routes=='upload.shippment') class="a-active" @endif>Upload Shipment</a>
                    </li>
                @endcan
                
                @if(auth()->user()->id !=34)
                
                
                
                @endif
            </ul>
    </li>

@endif

@if(Gate::check('mo-history'))
    <li class="has-sub {{ Request::segment(1)=='mo' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='mo' ? 'open' : '' }}" href="#">
            <i class="fas fa-history"></i>History</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='mo')style="display:block" @endif>
                @can('mo-history')
                    <li>
                        <a href="{{ route('mo.history') }}" 
                            @if($routes=='mo.history') class="a-active" @endif>MO History</a>
                    </li>
                    <li>
                        <a href="{{ route('mo.mo_list') }}" 
                            @if($routes=='mo.mo_list') class="a-active" @endif>MO Detail</a>
                    </li>
                    <li>
                        <a href="{{ route('mo.list') }}" 
                            @if($routes=='mo.list') class="a-active" @endif>MO Supplier Wise</a>
                    </li>
                    <li>
                        <a href="{{ route('shipped.list') }}" 
                            @if($routes=='shipped.list') class="a-active" @endif>Shipped List</a>
                    </li>
                @endcan
            </ul>
    </li>

@endif



@canany(['inventory-summary','inventory-summary-uc'])
    <li class="has-sub {{ Request::segment(1)=='inventory' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='inventory' ? 'open' : '' }}" href="#">
            <i class="fas fa-warehouse"></i>WareHouse Inventory</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='inventory')style="display:block" @endif>
                @can('inventory-summary')
                    <li>
                        <a href="{{ route('inventory.summary','decrum') }}"
                            @if($routes=='inventory.summary' && Request::segment(3)=='decrum') class="a-active" @endif>Decrum WH Inventory</a>
                    </li>
                @endcan 
                
                @can('inventory-summary-uc')
                    <li>
                        <a href="{{ route('inventory.summary','urban') }}"
                            @if($routes=='inventory.summary' && Request::segment(3)=='urban') class="a-active" @endif>Urban WH Inventory</a>
                    </li>
                @endcan
                
                @can('sku-list')
                    <li>
                        <a href="{{ route('show')}}" @if($routes=='show') class="a-active" @endif>SKU Wise Inventory</a>
                    </li>
              @endcan
            </ul>
            
            
    </li>
@endcanany
{{--
@if(Gate::check('item-alteration-add') || Gate::check('item-alteration') ||Gate::check('item-return') || Gate::check('alteration-supplier-statistics')|| Gate::check('alteration-received'))
    <li class="has-sub {{ Request::segment(1)=='items' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='items' ? 'open' : '' }}" href="#">
            <i class="fas fa-exchange-alt"></i> Item Alteration</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='items')style="display:block" @endif>
                @can('item-alteration-add')
                    <li>
                        <a href="{{ route('items.alteration.add') }}" 
                            @if($routes=='items.alteration.add') class="a-active" @endif>Add New Alteration</a>
                    </li>
                @endcan

                @can('item-alteration')
                    <li>
                        <a href="{{ route('items.alteration.list','alteration') }}" 
                            @if($routes=='items.alteration.list' && Request::segment(2)=='alteration')) class="a-active" @endif>Item Alteration List</a>
                    </li>
                @endcan
                @can('item-return')
                    <li>
                        <a href="{{ route('items.alteration.list','return') }}" 
                            @if($routes=='items.alteration.list' && Request::segment(2)=='return'))) class="a-active" @endif>Item Return List</a>
                    </li>
                @endcan
                
                @can('alteration-received')
                    <li>
                        <a href="{{ route('alteration.item.received') }}" 
                            @if($routes=='alteration.item.received') class="a-active" @endif>Alteration Item  Received</a>
                    </li>
                @endcan
                @can('alteration-supplier-statistics')
                    <li>
                        <a href="{{ route('alteration.supplier.statistics') }}" 
                            @if($routes=='alteration.supplier.statistics') class="a-active" @endif>Alteration Supplier Statistics</a>
                    </li>
                @endcan
                
            </ul>
    </li>

@endif--}}



@if(Gate::check('sku-with-design') ||Gate::check('design-list') ||Gate::check('sku-create') || Gate::check('add-new-bundle') ||Gate::check('sku-list') || Gate::check('article-list') || Gate::check('color-list') || Gate::check('item-adjust')|| Gate::check('sku-create'))
    <li class="has-sub {{ Request::segment(1)=='sku' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='sku' ? 'open' : '' }}" href="#">
            <i class="fas fa-barcode"></i> SKU</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='sku')style="display:block" @endif>
                @can('sku-create')
                    <li>
                        <a href="{{ route('create') }}"
                            @if($routes=='create') class="a-active" @endif>Add new SKU</a>
                    </li>
                @endcan
                
                @can('add-new-bundle')
                    <li>
                        <a href="{{ route('add.new.bundle') }}"
                            @if($routes=='add.new.bundle') class="a-active" @endif>Add new Bundle</a>
                    </li>
                @endcan
                
                @can('launch-list')
                    <li>
                        <a href="{{ route('supplier.images') }}"
                            @if($routes=='supplier.images') class="a-active" @endif>Articles Launch List</a>
                    </li>
                @endcan
                
                @can('bundle-list')
                    <li>
                        <a href="{{ route('sku.bundle.list') }}"
                            @if($routes=='sku.bundle.list') class="a-active" @endif>Bundle List</a>
                    </li>
                @endcan
                @can('sku-list')
                    <li>
                        <a href="{{ route('sku.with.design') }}"
                            @if($routes=='sku.with.design') class="a-active" @endif>SKU List</a>
                    </li>
                @endcan

                
                
            </ul>
    </li>

@endif

@can('upload-reports')
    <li class="  text-grey mb-2 {{ Request::segment(1)=='report' ? 'active' : '' }}">
        <a href="{{ route('report.inventory.upload') }}">
            <i class="fas fa-bar-chart"></i><span class="text-sm">Report Upload</span></a>
    </li>
@endcan  


@can('supplier-list')
    <li class="has-sub {{ Request::segment(1)=='supplier' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='supplier' ? 'open' : '' }}" href="#">
            <i class="fas fa-user-plus"></i>Supplier</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='supplier')style="display:block" @endif>
                @can('supplier-list')
                    <li>
                        <a href="{{ route('supplier.show') }}"
                            @if($routes=='supplier.show') class="a-active" @endif>Supplier List</a>
                    </li>
                @endcan 
            </ul>
    </li>
@endcan

@auth('supplier')
    <li class="has-sub {{ Request::segment(1)=='supplier' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='supplier' ? 'open' : '' }}" href="#">
            <i class="fas fa-user-plus"></i>Supplier</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='supplier')style="display:block" @endif>
                <li>
                    <a href="{{ route('supplier.quantity') }}"
                        @if($routes=='supplier.quantity') class="a-active" @endif>Orders</a>
                </li> 
                <!--<li>-->
                <!--    <a href="{{ route('supplier.items.list','return') }}"-->
                <!--        @if($routes=='supplier.items.list' && Request::segment(2)=='return') class="a-active" @endif>Item Return List</a>-->
                <!--</li> -->
                <!--<li>-->
                <!--    <a href="{{ route('supplier.items.list','alteration') }}"-->
                <!--        @if($routes=='supplier.items.list' && Request::segment(2)=='alteration') class="a-active" @endif>Item Alteration List</a>-->
                <!--</li> -->
                
            </ul>
    </li>
@endauth

@if(Gate::check('role-list') || Gate::check('user-list'))
    <li class="has-sub {{ Request::segment(1)=='roles' ? 'active' : '' }} {{ Request::segment(1)=='users' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='roles' ? 'open' : '' }} {{ Request::segment(1)=='users' ? 'open' : '' }}" href="#">
            <i class="fas fa-user-secret"></i> Users</a>
            <ul class="{{ $class }}"  @if(Request::segment(1)=='roles'||Request::segment(1)=='users')style="display:block" @endif>
                @can('role-list')
                    <li>
                        <a href="{{ route('roles.index') }}"
                            @if($routes=='roles.index') class="a-active" @endif>Roles</a>
                    </li>
                @endcan
                @can('user-list')
                    <li>
                        <a href="{{ route('users') }}"
                            @if($routes=='users') class="a-active" @endif>Users List</a>
                    </li>
                @endcan
            </ul>
    </li> 
@endif

@can('excel-list')
    <li class="  text-grey mb-2 {{ Request::segment(1)=='list' ? 'active' : '' }}">
        <a href="{{ route('list.excel') }}">
            <i class="fas fa-file-excel-o"></i> Excel List</a>
    </li>
@endcan

@if(Gate::check('item-log'))
    <li class="has-sub {{ Request::segment(1)=='log' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='log' ? 'open' : '' }}" href="#">
            <i class="fas fa-history"></i>Log</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='log')style="display:block" @endif>
                @can('item-log')
                    <li>
                        <a href="{{ route('log.item') }}"
                            @if($routes=='log.item') class="a-active" @endif>Items Log</a>
                    </li>
                @endcan
                
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('sku.ship.info') }}" 
                            @if($routes=='sku.ship.info') class="a-active" @endif>SKU Ship Info</a>
                    </li>
                @endcan
                {{--@can('item-return-log')
                    <li>
                        <a href="{{ route('log.item.return') }}"
                            @if($routes=='log.item.return') class="a-active" @endif>Items Alteration Log</a>
                    </li>
                @endcan
                
                @can('barcode-change-log')
                    <li>
                        <a href="{{ route('barcode.change.log') }}"
                            @if($routes=='barcode.change.log') class="a-active" @endif>Barcode Change Log</a>
                    </li>
                @endcan--}}
            </ul>
    </li> 
@endif





