@php
    if($type=='mobile'){
        $class='navbar-mobile-sub__list list-unstyled js-sub-list ';
    }elseif($type=='desktop'){
        $class='list-unstyled navbar__sub-list js-sub-list';
    }elseif($type=='collapse'){
        $class="navbar-mobile-sub__list list-unstyled js-sub-list mt-2 mb-2 text-dark";
    }
    $routes = \Route::currentRouteName();
@endphp

@can('dashboard')
    <li class="has-sub {{ Request::segment(1)=='dashboard' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='inventory' ? 'open' : '' }}" href="#">
            <i class="fas fa-tachometer-alt"></i>Dashboard</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='dashboard')style="display:block" @endif>
                <li>
                    <a href="{{ route('dashboard') }}"
                        @if($routes=='dashboard') class="a-active" @endif>Analytics</a>
                </li>
                <li>
                    <a href="{{ route('supplierPending.dashboard') }}"
                        @if($routes=='supplierPending.dashboard') class="a-active" @endif>Supplier Pending</a>
                </li>
                <li>
                    <a href="{{ route('operational.dashboard') }}"
                        @if($routes=='operational.dashboard') class="a-active" @endif>Operational</a>
                </li>
                @can('trend-dashboard')
                <li>
                    <a href="{{ route('DateWiseFilter') }}"
                        @if($routes=='DateWiseFilter') class="a-active" @endif>Sales Dashboard</a>
                </li>
                @endcan
                
                @can('trend-dashboard')
                <li>
                    <a href="{{ route('stockDashboard') }}"
                        @if($routes=='stockDashboard') class="a-active" @endif>Stock Dashboard</a>
                </li>
                @endcan
                
                @can('trend-dashboard')
                <li>
                    <a href="{{ route('poDashboard') }}"
                        @if($routes=='poDashboard') class="a-active" @endif>PO Dashboard</a>
                </li>
                @endcan
            </ul>    
    </li>
@endcan


@canany(['process-supplier','pending-orders','dropin-warehouse','supplier-statistics','print-label'])
<li class="has-sub {{ Request::segment(1)=='order' ? 'active' : '' }} {{ Request::segment(1)=='orders' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='order' ? 'open' : '' }} {{ Request::segment(1)=='orders' ? 'open' : '' }}" href="#">
            <i class="fas fa-shopping-bag"></i> Purchase Orders</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='order'||Request::segment(1)=='orders')style="display:block" @endif>
                @can('process-supplier')
                    <li>
                        <a href="{{ route('order.show') }}" 
                            @if($routes=='order.show') class="a-active" @endif>Process Supplier</a>
                    </li>
                @endcan
                @can('pending-orders')
                    <li>
                        <a href="{{ route('supplier.retrive') }}" 
                            @if($routes=='supplier.retrive') class="a-active" @endif>Edit View Orders (Switch)</a>
                    </li>
                @endcan
                
                @can('dropin-warehouse')
                    <li style="display:none">
                        <a href="{{ route('supplier.receiving.add','receiving') }}" 
                            @if($routes=='supplier.receiving.add' && Request::segment(2)=='receiving') class="a-active" @endif>Dropin Warehouse</a>
                    </li>
                @endcan
                
                @can('dropin-warehouse')
                    <li>
                        <a href="{{ route('dropInOrder') }}" 
                            @if($routes=='dropInOrder') class="a-active" @endif>Dropin Warehouse New</a>
                    </li>
                @endcan
                
                @can('gatepass-list')
                    <li>
                        <a href="{{ route('gatepass.index') }}" 
                            @if($routes=='gatepass.index') class="a-active" @endif>QC/Gate Pass (Reverse)</a>
                    </li>
                @endcan
                
            </ul>
    </li>
@endcanany


@if(Gate::check('upload-shippment'))
    <li class="has-sub {{ Request::segment(1)=='shipment' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='shipment' ? 'open' : '' }}" href="#">
            <i class="fas fa-shipping-fast"></i>Shipment</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='shipment')style="display:block" @endif>
                
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('shipment.process.order') }}" 
                            @if($routes=='shipment.process.order') class="a-active" @endif>Process Order</a>
                    </li>
                @endcan
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('shipment.bundle.list') }}" 
                            @if($routes=='shipment.bundle.list') class="a-active" @endif>Bundle Order</a>
                    </li>
                @endcan
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('shipment.processed.order') }}" 
                            @if($routes=='shipment.processed.order') class="a-active" @endif>Ready To Shipment</a>
                    </li>
                @endcan
               
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('upload.shippment') }}" 
                            @if($routes=='upload.shippment') class="a-active" @endif>Upload Shipment</a>
                    </li>
                @endcan
                
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('shipment.urgentMark.uploader') }}" 
                            @if($routes=='shipment.urgentMark.uploader') class="a-active" @endif>Upload Urgent Marking</a>
                    </li>
                @endcan
            </ul>
    </li>

@endif

@if(Gate::check('awd-print-label'))
    <li class="has-sub {{ Request::segment(1)=='awd' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='awd' ? 'open' : '' }}" href="#">
            <i class="fas fa-box"></i>AWD</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='awd') style="display:block" @endif>
                
                @can('awd-print-label')
                    <li>
                        <a href="{{ route('awd.printLabel') }}" 
                            @if($routes=='awd.printLabel') class="a-active" @endif>Print Label</a>
                    </li>
                @endcan
                
                @can('awd-print-label')
                    <li>
                        <a href="{{ route('awd.ReadyCasePack') }}" 
                            @if($routes=='awd.ReadyCasePack') class="a-active" @endif>Ready Case Pack</a>
                    </li>
                @endcan
            </ul>
    </li>

@endif

@canany(['qc-scorecard'])
    <li class="has-sub {{ Request::segment(1)=='scoreCard' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='scoreCard' ? 'open' : '' }}" href="#">
            <i class="fas fa-list"></i>Score Card</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='scoreCard') style="display:block" @endif>
                
                @can('qc-scorecard')
                    <li>
                        <a href="{{ route('qcScoreCard') }}" 
                            @if($routes=='qcScoreCard') class="a-active" @endif>QC</a>
                    </li>
                @endcan
            </ul>
    </li>

@endcanany

@if(Gate::check('mo-history'))
    <li class="has-sub {{ Request::segment(1)=='mo' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='mo' ? 'open' : '' }}" href="#">
            <i class="fas fa-history"></i>History</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='mo')style="display:block" @endif>
                @can('mo-history')
                    <li>
                        <a href="{{ route('mo.history') }}" 
                            @if($routes=='mo.history') class="a-active" @endif>MO History</a>
                    </li>
                    <li>
                        <a href="{{ route('mo.mo_list') }}" 
                            @if($routes=='mo.mo_list') class="a-active" @endif>MO Detail</a>
                    </li>
                    <li>
                        <a href="{{ route('mo.list') }}" 
                            @if($routes=='mo.list') class="a-active" @endif>MO Supplier Wise</a>
                    </li>
                    <li>
                        <a href="{{ route('shipped.list') }}" 
                            @if($routes=='shipped.list') class="a-active" @endif>Shipped List</a>
                    </li>
                @endcan
            </ul>
    </li>

@endif



@canany(['inventory-summary','inventory-summary-uc'])
    <li class="has-sub {{ Request::segment(1)=='inventory' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='inventory' ? 'open' : '' }}" href="#">
            <i class="fas fa-warehouse"></i>WareHouse Inventory</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='inventory')style="display:block" @endif>
                @can('inventory-summary')
                    <li>
                        <a href="{{ route('inventory.summary','decrum') }}"
                            @if($routes=='inventory.summary' && Request::segment(3)=='decrum') class="a-active" @endif>Decrum WH Inventory</a>
                    </li>
                @endcan 
                
                @can('inventory-summary-uc')
                    <li>
                        <a href="{{ route('inventory.summary','urban') }}"
                            @if($routes=='inventory.summary' && Request::segment(3)=='urban') class="a-active" @endif>Urban WH Inventory</a>
                    </li>
                @endcan
                
                @can('inventory-summary')
                    <li>
                        <a href="{{ route('inventory.summary','safetyStock') }}"
                            @if($routes=='inventory.summary' && Request::segment(3)=='safetyStock') class="a-active" @endif>SafetyStock Inventory</a>
                    </li>
                @endcan 
                
                @can('sku-list')
                    <li>
                        <a href="{{ route('show')}}" @if($routes=='show') class="a-active" @endif>SKU Wise Inventory</a>
                    </li>
              @endcan
            </ul>
            
            
    </li>
@endcanany

@can('upload-reports')
    <li class="  text-grey mb-2 {{ Request::segment(1)=='report' ? 'active' : '' }}">
        <a href="{{ route('report.inventory.upload') }}">
            <i class="fas fa-bar-chart"></i><span class="text-sm">Report Upload</span></a>
    </li>
@endcan 

@if(Gate::check('sku-with-design') ||Gate::check('design-list') ||Gate::check('sku-create') || Gate::check('add-new-bundle') ||Gate::check('sku-list') || Gate::check('article-list') || Gate::check('color-list') || Gate::check('item-adjust')|| Gate::check('sku-create'))
    <li class="has-sub {{ Request::segment(1)=='sku' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='sku' ? 'open' : '' }}" href="#">
            <i class="fas fa-barcode"></i> SKU</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='sku')style="display:block" @endif>
                @can('sku-create')
                    <li>
                        <a href="{{ route('create') }}"
                            @if($routes=='create') class="a-active" @endif>Add new SKU</a>
                    </li>
                @endcan
                
                @can('add-new-bundle')
                    <li>
                        <a href="{{ route('add.new.bundle') }}"
                            @if($routes=='add.new.bundle') class="a-active" @endif>Add new Bundle</a>
                    </li>
                @endcan
                
                @can('launch-list')
                    <li>
                        <a href="{{ route('supplier.articles') }}"
                            @if($routes=='supplier.articles') class="a-active" @endif>Articles List</a>
                    </li>
                @endcan
                
                @can('bundle-list')
                    <li>
                        <a href="{{ route('sku.bundle.list') }}"
                            @if($routes=='sku.bundle.list') class="a-active" @endif>Bundle List</a>
                    </li>
                @endcan
                @can('sku-list')
                    <li>
                        <a href="{{ route('sku.with.design') }}"
                            @if($routes=='sku.with.design') class="a-active" @endif>SKU List</a>
                    </li>
                @endcan

                
                
            </ul>
    </li>

@endif
  
@can('supplier-list')
    <li class="has-sub {{ Request::segment(1)=='supplier' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='supplier' ? 'open' : '' }}" href="#">
            <i class="fas fa-user-plus"></i>Supplier</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='supplier')style="display:block" @endif>
                @can('supplier-list')
                    <li>
                        <a href="{{ route('supplier.show') }}"
                            @if($routes=='supplier.show') class="a-active" @endif>Supplier List</a>
                    </li>
                @endcan 
                
                @can('supplier-statistics')
                    <li>
                        <a href="{{ route('order.statistics') }}" 
                            @if($routes=='order.statistics') class="a-active" @endif>Supplier Statistics</a>
                    </li>
                @endcan
                
                @can('supplier-statistics')
                    <li>
                        <a href="{{ route('order.storewise_statistics') }}" 
                            @if($routes=='order.storewise_statistics') class="a-active" @endif>Store Statistics</a>
                    </li>
                @endcan
                
                @can('complete-orders')
                    <li>
                        <a href="{{ route('supplier.complete.orders','complete') }}" 
                            @if($routes=='supplier.complete.orders' && Request::segment(2)=='complete') class="a-active" @endif>Complete Orders</a>
                    </li>
                @endcan
            </ul>
    </li>
@endcan

@auth('supplier')
    <li class="has-sub {{ Request::segment(1)=='supplier' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='supplier' ? 'open' : '' }}" href="#">
            <i class="fas fa-user-plus"></i>Supplier</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='supplier')style="display:block" @endif>
                <li>
                    <a href="{{ route('supplier.quantity') }}"
                        @if($routes=='supplier.quantity') class="a-active" @endif>Orders</a>
                </li>
            </ul>
    </li>
@endauth

@if(Gate::check('role-list') || Gate::check('user-list'))
    <li class="has-sub {{ Request::segment(1)=='roles' ? 'active' : '' }} {{ Request::segment(1)=='users' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='roles' ? 'open' : '' }} {{ Request::segment(1)=='users' ? 'open' : '' }}" href="#">
            <i class="fas fa-user-secret"></i> Users</a>
            <ul class="{{ $class }}"  @if(Request::segment(1)=='roles'||Request::segment(1)=='users')style="display:block" @endif>
                @can('role-list')
                    <li>
                        <a href="{{ route('roles.index') }}"
                            @if($routes=='roles.index') class="a-active" @endif>Roles</a>
                    </li>
                @endcan
                @can('user-list')
                    <li>
                        <a href="{{ route('users') }}"
                            @if($routes=='users') class="a-active" @endif>Users List</a>
                    </li>
                @endcan
            </ul>
    </li> 
@endif

@if(Gate::check('item-log'))
    <li class="has-sub {{ Request::segment(1)=='log' ? 'active' : '' }}">
        <a class="js-arrow  {{ Request::segment(1)=='log' ? 'open' : '' }}" href="#">
            <i class="fas fa-history"></i>Log</a>
            <ul class="{{ $class }}" @if(Request::segment(1)=='log')style="display:block" @endif>
                @can('item-log')
                    <li>
                        <a href="{{ route('log.item') }}"
                            @if($routes=='log.item') class="a-active" @endif>Items Log</a>
                    </li>
                @endcan
                
                @can('upload-shippment')
                    <li>
                        <a href="{{ route('sku.ship.info') }}" 
                            @if($routes=='sku.ship.info') class="a-active" @endif>SKU Ship Info</a>
                    </li>
                @endcan
                
                @can('excel-list')
                    <li>
                        <a href="{{ route('list.excel') }}" @if($routes=='list.excel') class="a-active" @endif>Excel List</a>
                    </li>
                @endcan
            </ul>
    </li> 
@endif





