@extends('layouts.app')
@section('title','Ready Case Pack | Mini Opex')
@section('add_css')
<x-datatable-js type="css"/>
@endsection

@section('content')

<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row ml-2 mr-2 mb-2">
                <div class="col-lg-3 col-md-3 col-sm-6 col-12 mt-1">
                    <div class="statistic__item border_grey bg-grey">
                        <h2 class="number text-white"><span id="total_pending_single">0</span></h2>
                        <span class="desc text-white">Total RCP Single</span>
                        <div class="icon text-white">
                            <i class="fas fa-dolly"></i>
                        </div>
                    </div>
                    
                </div>
                <div class="col-lg-3 col-md-3 col-sm-6 col-12 mt-1">
                    <div class="statistic__item border_orange bg-orange">
                        <h2 class="number text-dark"><span id="total_pending_bundle">0</span></h2>
                        <span class="desc text-dark">Total RCP Bundle</span>
                        <div class="icon text-white">
                            <i class="fas fa-dolly"></i>
                        </div>
                    </div>
                    
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12 col-12 mt-1">
                    <div class="row custom_filter pt-4 pb-3 border  rounded">
                        <div class="col-lg-8 col-md-8 col-sm-6 col-6 mt-1">
                            <select name="store" id="store_id" class="form-control select2">
                                <option value="">Select Store</option>
                                @forelse ($stores as $store)
                                    <option value="{{ $store->id }}">{{ $store->strong_name}}</option>
                                @empty
                                    
                                @endforelse
                            </select>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <div style="display:none" id="download_div" class="">
                                 <!--<a href="javascript:;" id="download_rts_excel" class="btn bg-orange text-dark btn-sm"><i class="fas fa-file-excel"></i> Excel</a>-->
                                 <a href="javascript:;" id="export_excel" class="btn bg-orange text-dark btn-sm ml-1" ><i class="fas fa-file-excel"></i> Excel</a>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>Ready Case Pack</strong>
                            <!--<a href="javascript:;" id="assign_qty" class="float-right btn btn-success btn-sm ml-1"><i class="fas fa-check"></i> Update Quantity</a>-->
                            
                                
                                @can('process-cancel')
                                <button type="button" id="cancellation_btn" class="btn btn-danger btn-sm ml-5" style="display:none"><i class="fas fa-close"></i> Cancellation</button>
                                @endcan
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <form action="{{route('awd.excel_case_pack_ready')}}" method="post" id="excel_format">
                                @csrf
                                <input type="hidden" id="store_id2" name="store_id2" value=""/>
                            </form>
                            
                            <form method="POST" id="assign_form" class="mt-3">
                                @csrf
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="posts" cellspacing="0" width="100%" data-start='' data-end=''>
                                        <thead >
                                            <tr class="thead-light">
                                                <th colspan="4" class="text-right">TOTAL</th>
                                                <th id="box_qty">0</th>
                                                <th id="inv_qty">0</th>
                                            </tr>
                                            <tr class="thead-dark">
                                                <th>Product Image</th>
                                                <th>Variation Design</th>
                                                <th>Product Name</th>
                                                <th>Size</th>
                                                <th>Ready Boxes</th>
                                                <th>Box QTY</th>
                                            </tr>
                                        </thead>
                                        <tfoot>
                                            <tr>
                                                <th colspan="4" class="text-right">TOTAL</th>
                                                <th>0</th>
                                                <th>0</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                
                            </form>
                            <hr>
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
    </div>
</div>
@endsection

@section('add_js')
<x-datatable-js type="js"/>

<script>
   

    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "pageLength": 50,
        lengthMenu: [
            [10, 25, 50,100,500],
            [10, 25, 50,100,500],
        ],
        fixedHeader: {
            header: true,
            footer: true
        },
        scrollX: true,
        "dataSrc": "",
        "ajax":{
                    "url": "{{ route('awd.ReadyCasePack') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.store= $('#store_id option:selected').val();
                        
                        $('#store_id2').val($('#store_id option:selected').val())
                        
                        get_ready_count($('#store_id option:selected').val(),$('#shipment_type option:selected').val())
                        
                    }
                },
        "columnDefs": [
            { "orderable": false, "targets": [0,1] },
            { "searchable": false, "targets": [0,1,2,3,4,5] },
            // { "width": "5%", "targets": [0] },
        ],
        bSort: false,
        "ordering": false,
        "columns":[
            { "data": "product_img","name":"product_img" },
            { "data": "variation_design","name":"variation_design" },
            { "data": "product_name","name":"product_name" },
            { "data": "size","name":"size" },
            { "data": "filled_qty","name":"filled_qty" },
            { "data": "receive_inv_qty","name":"receive_inv_qty" },
        ],
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
            
            var info = $('#posts').DataTable().page.info();
            tot = info.recordsTotal;
                
            if (tot > 0) {
                $('#export_excel').show();
                $('#download_div').show();
            } else {
                $('#export_excel').hide();
                $('#download_div').hide();
            }
        },
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            
                    
            var wedTotal = api
                .column( 4 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                
            var thuTotal = api
                .column( 5 )
                .data()
                .reduce( function (a, b) {
                    b = b.replace(/<\/?[^>]+(>|$)/g, "");
                    return intVal(a) + intVal(b);
                }, 0 );
                    
                $( api.column( 3 ).footer() ).html('TOTAL');
                $('#box_qty').text(wedTotal);
                $( api.column( 4 ).footer() ).html(wedTotal);
                
                $('#inv_qty').text(thuTotal);
                $( api.column( 5 ).footer() ).html(thuTotal);
        },
    });
    
    new $.fn.dataTable.FixedHeader($('#posts'));
    
    $('.select2').on('change',function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    
    $('#search_change').click(function(){
        $('#posts').DataTable().ajax.reload().draw();
    });
    
    
    function get_ready_count($store_id){
        $.ajax({
            url:"{{route('awd.get_readyCase_count')}}",
            data:{
                store_id:$store_id,
                _token:"{{csrf_token()}}"
            },
            type:'POST',
            dataType:'JSON',
            success:function(data){
                $('#total_pending_single').text(data.single_pending);
                $('#total_pending_bundle').text(data.bundle_pending);
            }
        })
    }
    
    $('#export_excel').click(function(){
        $("#excel_format").submit();
    })

    

    

    
    
</script>

    
@endsection