@extends('layouts.app')
@section('title','Print label | Mini Opex')
@section('add_css')
<x-datatable-js type="css"/>

</style>


    
@endsection

@section('content')
<!-- modal color -->
<div class="modal fade" id="excelModal" tabindex="-1" role="dialog" aria-labelledby="excelModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="excelModalLabel">Upload FNSKU</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Download Template: <a href="{{asset('backend/fnsku_upload_format.xlsx')}}" download="fnsku_upload_format.xlsx" class="btn btn-dark btn-sm float-right"><i class="fa fa-download"></i></a>
                <hr>
                <i class="fa fa-spinner fa-spin fa-2x fa-fw " id="loadingspining" style="display: none"></i>

                <div class="form-group ">
                    <label for="text-input" class=" form-control-label">Excel </label>
                    <input type="file" id="file_img" name="file_img"  class="form-control" onchange="ValidateSingleInput(this,'#errortxt','#fileBtn')">
                    <span class="text-danger text-sm" id="errortxt" style="display: none">Please Upload file in correct format eg excel</span>
                    
                </div>
                <div class="form-group">
                    <label for="text-input" class=" form-control-label">Store </label>
                    <select name="store" id="store" class="form-control select2">
                        <option value="">Select Store</option>
                        @forelse ($stores as $store)
                            <option value="{{ $store->id }}">{{ $store->strong_name}}</option>
                        @empty
                            
                        @endforelse
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-dark btn-sm" id="fileBtn">Add</button>
                
            </div>
        </div>
    </div>
</div>
<!-- end modal color -->
<!-- MAIN CONTENT-->
<div class="main-content">
    <div class="section__content section__content--p30">
        <div class="container-fluid">
            <div class="row ml-2 mr-2 mb-2">
                
                <div class="col-lg-6 col-md-6 col-sm-6 col-12 mt-1">
                    <div class="row custom_filter pt-4 pb-1 border  rounded">
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6">
                            <div class="form-group">
                                <label for="text-input" class=" form-control-label">Store </label>
                                <select name="store_id" id="store_id" class="form-control select2">
                                    <option value="">Select Store</option>
                                    @forelse ($stores as $store)
                                        <option value="{{ $store->id }}">{{ $store->strong_name}}</option>
                                    @empty
                                        
                                    @endforelse
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6 mt-1">
                            <div class="form-group">
                                <label for="text-input" class=" form-control-label">Stock Check </label>
                                <select class="form-control select2" name="type" id="type">
                                    <option value="1">ALL</option>
                                    <option value="2">AV Stock</option>
                                    
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-4 col-sm-4 col-6">
                            <a href="javascript:;" id="upload_Excel" class="btn bg-orange text-dark btn-sm float-right" data-toggle="modal" data-target="#excelModal"><i class="fas fa-upload"></i> Upload FNSKU</a>
                        </div>
            
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-12 mt-1">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-6 col-12 mt-1">
                            <div class="statistic__item border_grey bg-grey">
                                <h2 class="number text-white"><span id="total_tshirt">0</span></h2>
                                <span class="desc text-white">Total Tshirts</span>
                                <div class="icon text-white">
                                    <i class="fas fa-dolly"></i>
                                </div>
                            </div>
                            
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-6 col-12 mt-1">
                            <div class="statistic__item border_orange bg-orange">
                                <h2 class="number text-dark"><span id="total_varsity">0</span></h2>
                                <span class="desc text-dark">Total Varsity</span>
                                <div class="icon text-white">
                                    <i class="fas fa-dolly"></i>
                                </div>
                            </div>
                            
                        </div>
                        
                        <div class="col-lg-4 col-md-4 col-sm-6 col-12 mt-1">
                            <div class="statistic__item border_grey bg-grey">
                                <h2 class="number text-white"><span id="total_bundle">0</span></h2>
                                <span class="desc text-white">Total Bundle</span>
                                <div class="icon text-white">
                                    <i class="fas fa-dolly"></i>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    
                </div>
                
            </div>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-sm">
                    <div class="card">
                        <div class="card-header">
                            <strong>AWD Print Label</strong>
                            <a href="javascript:;" id="assign_qty" class="float-right btn btn-dark btn-sm ml-1 assign_qty" style="display:none"><i class="fas fa-check"></i> Update Quantity</a>
                        </div>
                        <div class="card-body card-block">
                            @if (session('has_error'))
                                <div class="alert alert-danger" role="alert">
                                    {{ session('has_error') }}
                                </div>
                            @endif
                            @if (session('has_success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('has_success') }}
                                </div>
                            @endif
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="posts">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th class="notexport">Image</th>
                                            <th>SKU</th>
                                            <th>Title</th>
                                            <th>In Stock</th>
                                            <th>AV Box</th>
                                            <th>Req QTY</th>
                                            <th>Req Box</th>
                                            <th>ASIN</th>
                                            <th>FNSKU</th>
                                            <th>Amazon SKU</th>
                                            <th class="notexport">Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <hr>
                            <a href="javascript:;" id="assign_qty2" class="float-right btn btn-dark btn-sm ml-1 mt-1 assign_qty" style="display:none"><i class="fas fa-check"></i> Update Quantity</a>
                            
                            
                            
                    </div>
                    
            </div>
            @include('partials.copyrights')
        </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('add_js')
<x-datatable-js type="js"/>

<script>
    $('#posts').DataTable({
        "processing": true,
        "serverSide": true,
        "dataSrc": "",
        "pageLength": 10,
        "lengthMenu": [[10, 25, 50, 100, 500], [10, 25, 50, 100, 500]],
        "ajax":{
                    "url": "{{ route('awd.printLabel') }}",
                //  "dataType": "json",
                    "type": "POST",
                    "data":function(d){ 
                        d._token= "{{csrf_token()}}";
                        d.store_id=$('#store_id option:selected').val();
                        
                        pending_CasePack_count($('#store_id option:selected').val());
                    }
                },
        "columnDefs": [
            { "searchable": false, "targets": [0,1,2,3,4,5,6] },
        ],
        bSort: false,
        "ordering": false,
        "columns":[
            
            { "data": "product_img","name":"product_img" },
            { "data": "opex_sku","name":"opex_sku" },
            { "data": "product_name","name":"product_name" },
            { "data": "instock","name":"instock" },
            { "data": "boxMake","name":"boxMake" },
            { "data": "req_qty","name":"req_qty" },
            { "data": "reqBox","name":"reqBox" },
            { "data": "asin","name":"asin" },
            { "data": "fnsku","name":"fnsku" },
            { "data": "amazon_sku","name":"amazon_sku" },
            { "data": "action","name":"action" },
        ],
        initComplete: function () {
            $('#posts_filter input').addClass('form-control-sm');
        },
        
        "drawCallback": function( settings ) {
            loader('#posts',0);
        },
        'preDrawCallback': function(settings) {
            loader('#posts');
        },
        rowCallback: function( row, data, index ) {
            // console.log(data);
            var b=data.boxMake;
            // b = b.replace(/<\/?[^>]+(>|$)/g, "");
            if (b == 0 && $("#type option:selected").val()=='2') {
                console.log('zero stock');
                $(row).hide();
            }
        },
        
        dom: 'lBfrtip',
        buttons: [
            {   extend: 'excelHtml5', 
                className: 'btn btn-dark btn-sm ml-5',
                text: '<i class="fas fa-file-excel"></i> Excel',
                footer: true,
                header:true,
                download: 'open',
                exportOptions: {
                    modifier: {
                        search: 'none'
                    },
                    columns: ':not(.notexport)'
                },
            }
        ],
        
        initComplete: function () {
            $('.buttons-excel').html('<i class="fas fa-file-excel"></i> Excel').removeClass('dt-button').addClass('btn btn-dark btn-sm ml-5');
        },
    });
    
    
    $('#posts').on('click','tbody .print_label',function(){
       var id=$(this).attr('data-id');
       var approve_qty=$(this).attr('data-approve_qty');
       $.ajax({
           url:"{{route('awd.showPrintLabel')}}",
           type:'POST',
           data:{
               _token:"{{csrf_token()}}",
               id:id,
               approve_qty:approve_qty
           },
           success:function(data){
               if(data.success==true){
                    var w = window.open('about:blank','pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
                    w.document.open();
                    w.document.write(data.html);
                    w.document.close();
                    setTimeout(function(){ w.print(); }, 1000);
                    
                }
           }
       })
    });
    
    
    $('.select2').on('change',function(){
        $('#posts').DataTable().ajax.reload().draw();
    })
    
    $('#fileBtn').click(function(){
        var file_data = $("#file_img").prop("files")[0]; 
        
        var form_data = new FormData(); 
        form_data.append("file_img", file_data);
        form_data.append("_token", "{{csrf_token()}}");
        form_data.append('store_id',$('#store option:selected').val());
        
        if($('#store option:selected').val() ==''){
            $.toast({
                heading: 'Error',
                text: 'Store are Required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            return false;
        }
        
        if( $("#file_img")[0].files.length == 0  && $('#store option:selected').val() ==''){
            $.toast({
                heading: 'Error',
                text: 'All fields are Required',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            
            return false;
        }
        
        
        $('#loadingspining').show();
        $.ajax({
            url:"{{ route('awd.uploadFNSKU') }}",
            type:"POST",
            dataType: 'json',
            cache: false,
            contentType: false,
            processData: false,
            data: form_data, // Setting the data attribute of ajax with file_data
            success:function(data){
                $('#loadingspining').hide();
                $('#file_img').val('');
                
                if(data.code=='200'){
                    $.toast({
                        heading: 'Success',
                        text: data.message,
                        showHideTransition: 'slide',
                        icon: 'success',
                        position: 'top-right',
                    });
                    
                    $('#excelModal').modal('hide');
                    location.reload();
                    
                }else{
                   $.toast({
                        heading: 'Error',
                        text: data.message,
                        showHideTransition: 'slide',
                        icon: 'error',
                        position: 'top-right',
                    });
                }
                
            }
        });
        
        
    });
    
    $(document).on('input','.input_filled',function(){
        var self=$(this);
        var id=self.attr('data-id');
        var instock=parseInt(self.data('box'));
        var rec_qty=parseInt(self.val().trim());
        var rec_box=parseInt(self.data('reqBox'));
        
        if(rec_qty ==0){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('.assign_qty').hide();
            return false;
        }
        if(!/^[0-9]+$/.test(rec_qty) && rec_qty !=0){
            $('#error_'+id).text('Receive Quantity Only Numbers');
            $('#error_'+id).show();
            $.toast({
                heading: 'Error',
                text: 'Receive Quantity Only Numbers',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-right',
            });
            $('#id_check_'+id).prop('checked',false);
            $('.assign_qty').hide();
            return false;
        }else{
            if(rec_qty<= instock){
                $('#id_check_'+id).prop('checked','checked');
                $('#error_'+id).hide();
                $('.assign_qty').show();
            }else{
                $('#error_'+id).text('Receive Quantity Exceed from Box Quantity');
                $('#error_'+id).show();
                $('#id_check_'+id).prop('checked',false);
                $('#assign_qty_'+id).hide();
                $('.assign_qty').hide();
                $.toast({
                    heading: 'Error',
                    text: 'Receive Quantity Exceed from Box Quantity',
                    showHideTransition: 'slide',
                    icon: 'error',
                    position: 'top-right',
                }); 
                return false;
            }
        }
    });
    
    $('#assign_qty2').click(function(){
        $('#assign_qty').click();
    })
    
    $('#assign_qty').click(function(){
        var reqSupplier=$('.id_check').filter(':checked').length;
        if(reqSupplier ==0){
            row = $('#posts_wrapper tbody tr:first-child');
            $(row).addClass('table-warning');
            $.toast({
                heading: 'Error',
                text: 'Please Enter the Supply',
                showHideTransition: 'slide',
                icon: 'error',
                position: 'top-center',
            });
            return false; 
        }
        var obj= {};
        var array=[];
        var id,filled_qty;
        var value = $('.id_check').filter(':checked').filter(function () {
            id=$(this).val();
            filled_qty=$('#filled_qty_'+id);
            obj.variation_id=filled_qty.data('variation_id');
            obj.variation_design=filled_qty.data('variation_design');
            obj.approve_qty=filled_qty.data('approve_qty');
            obj.fnsku=filled_qty.data('fnsku');
            obj.filled_qty=filled_qty.val();
            

            array.push(obj);
            obj={};
            
        });
        
        console.log(array);
        
        if(array.length>0){
            $.ajax({
                url:"{{ route('awd.sentToReadyCasePack') }}",
                type:"POST",
                data:{
                    array:array,
                    store_id:$('#store_id option:selected').val(),
                    _token: "{{csrf_token()}}"
                },
                dataType:'JSON',
                success:function(data){
                    if(data.code=='200'){
                        $.toast({
                            heading: 'Success',
                            text: 'Assign Quantity Successfully',
                            showHideTransition: 'slide',
                            icon: 'success',
                            position: 'top-center',
                        });
                        $('#posts').DataTable().ajax.reload().draw();
                        $('.assign_qty').hide();
                    }else{
                        $.toast({
                            heading: 'Error',
                            text: 'Error in Assign Quantity',
                            showHideTransition: 'slide',
                            icon: 'error',
                            position: 'top-center',
                        });
                    }
                }
            }) 
        }
    });
    
    function pending_CasePack_count($store_id){
        $.ajax({
            url:"{{route('awd.pending_CasePack_count')}}",
            data:{
                store_id:$store_id,
                _token:"{{csrf_token()}}"
            },
            type:'POST',
            dataType:'JSON',
            success:function(data){
                $('#total_tshirt').text(data.total_tshirt);
                $('#total_bundle').text(data.total_bundle);
                $('#total_varsity').text(data.total_varsity);
            }
        })
    }

    
        

</script>

    
@endsection