@php
    $logoImgDark='logo/miniopex_dark.png';
    if(env('APP_NAME') =='SampMini'){
        $logoImgDark='logo/miniopex_dark_12.png';
    }
    
@endphp


@extends('layouts.loginlayout')
@section('title','Login | Mini Opex')
@section('content')
<div class="page-wrapper">
    <div class="page-content--bge5">
        <div class="container">
            <div class="login-wrap">
                <div class="login-content">
                    <div class="login-logo">
                        <a href="javascript:;" >
                            
                                <img src="{{asset($logoImgDark)}}" alt="{{env('APP_NAME')}}">
                                <h5 class="text-warning">
                                    @isset($url)
                                        {{ $url }} Login
                                    @else
                                        
                                    @endisset
                                </h5>
                        </a>
                    </div>
                    <div class="login-form">
                        @if (session('has_error'))
                            <div class="alert alert-danger" role="alert">
                                {{ session('has_error') }}
                            </div>
                        @endif
                        @if (session('has_success'))
                            <div class="alert alert-success" role="alert">
                                {{ session('has_success') }}
                            </div>
                        @endif
                        @php
                            if(isset($url)){
                                if($url =='Admin'){
                                
                                    $route=route('store');
                                }else if($url =='Supplier'){
                                    $route=route('login.supplier');
                                }
                            }
                            
                        @endphp
                        <form action="{{ $route }}" method="post" id="loginForm">
                            @csrf
                            <div class="@error('email') has-warning @enderror form-group">
                                @if (isset($url))
                                    @if ($url =='Admin')
                                        <label>Email Address</label>
                                        <input class="form-control @error('email')
                                        is-invalid
                                        @enderror" type="email" name="email" placeholder="Email" value="{{ old('email') }}">
    
                                    @elseif($url =='Supplier')
                                        <label>Username</label>
                                        <input class="form-control @error('email')
                                        is-invalid
                                        @enderror" type="text" name="email" placeholder="Email" value="{{ old('email') }}">
                                            
                                    @endif
                                    
                                @endif
                                
                            </div>
                            @error('email')
                                <div class="text-danger text-sm">
                                    {{ $message }}
                                </div>
                            @enderror
                            <div class="@error('password') has-warning @enderror form-group">
                                <label>Password</label>
                                <input class="form-control  @error('password')
                                is-invalid
                               @enderror" type="password" name="password" placeholder="Password">
                            </div>
                            @error('password')
                                <div class="text-danger text-sm">
                                    {{ $message }}
                                </div>
                            @enderror
                            <hr>
                            <div class="login-checkbox">
                                {{-- <label>
                                    <input type="checkbox" name="remember">Remember Me
                                </label> --}}
                                {{-- <label>
                                    <a href="#">Forgotten Password?</a>
                                </label> --}}
                            </div>
                            <button class="au-btn au-btn--block au-btn--green bg-orange m-b-20" type="submit">sign in</button>
                            {{--<div class="social-login-content">
                                 <div class="social-button">
                                    <button class="au-btn au-btn--block au-btn--blue m-b-20">sign in with facebook</button>
                                    <button class="au-btn au-btn--block au-btn--blue2">sign in with twitter</button>
                                </div> --}}
                            </div>
                        </form>
                        {{-- <div class="register-link">
                            <p>
                                Don't you have account?
                                <a href="#">Sign Up Here</a>
                            </p>
                        </div> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('add_js')
<script src="https://www.google.com/recaptcha/api.js?render={{ env('GOOGLE_RECAPTCHA_KEY') }}"></script>
<script type="text/javascript">

    $('#loginForm').submit(function(event) {
        event.preventDefault();
        grecaptcha.ready(function() {
            grecaptcha.execute("{{ env('GOOGLE_RECAPTCHA_KEY') }}", {action: 'subscribe_newsletter'}).then(function(token) {
                console.log(token)
                $('#loginForm').prepend('<input type="hidden" name="g-recaptcha-response" value="' + token + '">');
                $('#loginForm').unbind('submit').submit();
            });;

        });

    });

</script>
@endsection