<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSkuLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sku_log', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->string('variation_design');
            $table->string('type_name');
            $table->dateTime('created_date');
            $table->integer('user_id');
        });
        
        Schema::create('bundle_sku_log', function (Blueprint $table) {
            $table->id();
            $table->string('bundle_variation_id');
            $table->string('bundle_variation_design');
            $table->string('type_name');
            $table->dateTime('created_date');
            $table->integer('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sku_log');
        Schema::dropIfExists('bundle_sku_log');
    }
}
