<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBundleProcessedTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bundle_processed', function (Blueprint $table) {
            $table->id();
            $table->string('bundle_set_variation');
            $table->integer('store_id');
            $table->integer('shipment_type');
            $table->integer('order_qty');
            $table->integer('receiving_qty');
            $table->dateTime('created_date');
            $table->integer('user_id');
            $table->integer('bundle_pr_wise_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bundle_processed');
    }
}
