<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseOrderQtyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_order_quantity', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->integer('store_id');
            $table->integer('shipment_type');
            $table->integer('order_qty');
            $table->integer('pr_id');
            $table->dateTime('created_date');
            $table->integer('created_by');
            $table->dateTime('updated_date');
            $table->integer('updated_by');
            $table->integer('status');
            $table->integer('is_urgent');
        });
        
        Schema::create('instock_reserved_history', function (Blueprint $table) {
            $table->id();
            $table->integer('pr_id');
            $table->integer('po_qty_id');
            $table->integer('store_id');
            $table->integer('shipment_type');
            $table->string('variation_id');
            $table->integer('instock_qty');
            $table->integer('reserved_qty');
            $table->integer('remaining_qty');
            $table->integer('created_by');
            $table->dateTime('created_date');
        });
        
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_order_quantity');
    }
}
