<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProcessOrderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('process_orders', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->string('variation_design');
            $table->integer('approve_qty');
            $table->integer('given_qty');
            $table->integer('urgent_status');
            $table->integer('processed_status');
            $table->integer('pr_id');
            $table->integer('user_id');
            $table->integer('store-id');
            $table->integer('shipment_type');
            $table->dateTime('created_date');
            
        });
        
        Schema::create('processed_orders', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->string('variation_design');
            $table->integer('approve_qty');
            $table->integer('filled_qty');
            $table->integer('urgent_status');
            $table->integer('shipment_ready_status');
            $table->integer('pr_id');
            $table->integer('user_id');
            $table->integer('store-id');
            $table->integer('shipment_type');
            $table->dateTime('created_date');
            
        });
        
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('process_order');
    }
}
