<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFbaInventoryReportTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fba_inventory_report', function (Blueprint $table) {
            $table->id();
            $table->string('sku');
            $table->string('fnsku');
            $table->string('asin');
            $table->longText('product_name');
            $table->string('condition');
            $table->string('your_price');
            $table->string('mfn_listing_exists');
            $table->string('mfn_fulfillable_quantity'); 
            $table->string('afn_listing_exists');
            $table->string('afn_warehouse_quantity');
            $table->string('afn_fulfillable_quantity');
            $table->string('afn_unsellable_quantity');
            $table->string('afn_reserved_quantity');
            $table->string('afn_total_quantity');
            $table->string('per_unit_volume');
            $table->string('afn_inbound_working_quantity');
            $table->string('afn_inbound_shipped_quantity');
            $table->string('afn_inbound_receiving_quantity');
            $table->string('afn_researching_quantity');
            $table->string('afn_reserved_future_supply');
            $table->string('afn_future_supply_buyable');
            $table->dateTime('created_date');
            $table->integer('file_id');
            $table->integer('store_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fba_inventory_report');
    }
}
