<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReportInventory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('report_inventory_upload', function (Blueprint $table) {
            $table->id();
            $table->string('file_name');
            $table->string('original_name');
            $table->integer('report_type');
            $table->integer('store_id');
            $table->integer('user_id');
            $table->dateTime('created_date');
        });
        
        Schema::create('report_inventory_json', function (Blueprint $table) {
            $table->id();
            $table->string('json_name');
            $table->integer('filename_id');
            $table->integer('report_type');
            $table->integer('store_id');
            $table->integer('user_id');
            $table->dateTime('created_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('report_inventory_upload');
        Schema::dropIfExists('report_inventory_json');
    }
}
