<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBundleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bundle', function (Blueprint $table) {
            $table->id();
            $table->string('bundle_name');
            $table->integer('variation_type');
            $table->longText('image_url');
            $table->integer('variation_qty');
            $table->string('bundle_group');
            $table->integer('set_no');
            $table->integer('bundle_no');
            $table->longText('bundle_set_name');
            $table->integer('prod_size');
            $table->string('bundle_set_variation');
            $table->integer('user_id');
            $table->integer('status');
            $table->dateTime('created_date');
        });
        
        Schema::create('bundle_sets', function (Blueprint $table) {
            $table->id();
            $table->integer('bundle_id');
            $table->integer('bundle_no');
            $table->integer('set_no');
            $table->string('variation_id');
            $table->integer('variation_type');
            $table->string('bundle_set_variation');
            $table->string('bundle_group');
            $table->integer('quantity');
            $table->dateTime('created_date');
            $table->integer('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bundle');
        Schema::dropIfExists('bundle_sets');
    }
}
