<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDesignAlphaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('design_alpha', function (Blueprint $table) {
            $table->id();
            $table->integer('design_number');
            $table->string('design_alpha');
        });
        
        Schema::table('product_info', function (Blueprint $table) {
            $table->string('variation_design');
            $table->longText('prod_asin');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('design_alpha');
        
        Schema::table('product_info', function (Blueprint $table) {
            $table->dropColumn('variation_design');
            $table->dropColumn('prod_asin');
        });
    }
}
