<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateShippmentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('shipment', function (Blueprint $table) {
            $table->id();
            $table->string('file_name');
            $table->string('orignal_name');
            $table->integer('store_id');
            $table->longText('shipment_id');
            $table->string('city_name');
            $table->string('state_name');
            $table->longText('comment_box');
            $table->dateTime('created_at');
            $table->integer('status');
            $table->integer('user_id');
        });
        
        Schema::create('shipment_info', function (Blueprint $table) {
            $table->id();
            $table->string('shipment_id');
            $table->string('sku');
            $table->string('asin');
            $table->string('fnsku');
            $table->longText('product');
            $table->integer('expected_qnt');
            $table->dateTime('created_at');
            $table->integer('user_id');
            $table->string('opex_sku');
        });
        
        Schema::create('scanning', function (Blueprint $table) {
            $table->id();
            $table->string('shipment_id');
            $table->integer('box_id');
            $table->string('fnsku');
            $table->integer('qty');
            $table->dateTime('created_at');
            $table->integer('user_id');
        });
        
        Schema::create('box_info', function (Blueprint $table) {
            $table->id();
            $table->string('shipment_id');
            $table->integer('box_id');
            $table->string('box_weight');
            $table->string('box_length');
            $table->string('box_width');
            $table->string('box_height');
            $table->longText('comment');
            $table->dateTime('created_at');
            $table->integer('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shipment');
        Schema::dropIfExists('shipment_info');
        Schema::dropIfExists('box_info');
        Schema::dropIfExists('scanning');
    }
}
