<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItemReturnTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('item_return', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->integer('product_info_id');
            $table->integer('quantity');
            $table->integer('return_check');
            $table->integer('supplier_id');
            $table->integer('status');
            $table->integer('user_id');
            $table->dateTime('created_date');
        });

        Schema::create('item_return_log', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->integer('quantity');
            $table->string('return_check');
            $table->integer('supplier_id');
            $table->integer('user_id');
            $table->dateTime('created_date');
        });

        Schema::create('alteration_item_received', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->integer('product_info_id');
            $table->integer('item_return_id');
            $table->integer('in_stock');
            $table->integer('receive_qty');
            $table->integer('receiving_qty');
            $table->integer('supplier_id');
            $table->integer('status');
            $table->integer('user_id');
            $table->dateTime('created_date');
            $table->integer('received_by');
            $table->dateTime('received_date');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_return');
        Schema::dropIfExists('item_return_log');
        Schema::dropIfExists('alteration_item_received');

    }
}
