<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItemAdjustmentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('damage_reason', function (Blueprint $table) {
            $table->id();
            $table->string('reason_name');
            $table->integer('status');
            $table->dateTime('created_date');
            
        });
        Schema::create('item_adjustment', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->integer('product_info_id');
            $table->integer('reason_id');
            $table->integer('quantity');
            $table->integer('old_stock');
            $table->integer('new_stock');
            $table->integer('user_id');
            $table->dateTime('created_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_adjustment');
        Schema::dropIfExists('damage_reason');

    }
}
