<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApproveSaleOrderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('approve_sale_order', function (Blueprint $table) {
            $table->id(); 
            $table->integer('sale_order_list_id');
            $table->string('variation_id');
            $table->integer('sale_order_qty');
            $table->integer('status'); 
            $table->dateTime('created_at');
            $table->integer('user_id');
        });
        Schema::create('pending_sale_order', function (Blueprint $table) {
            $table->id(); 
            $table->integer('sale_order_list_id');
            $table->string('variation_id');
            $table->integer('sale_order_qty');
            $table->integer('status'); 
            $table->dateTime('created_at');
            $table->integer('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('approve_sale_order');
        Schema::dropIfExists('pending_sale_order');

    }
}
