<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sale_orders', function (Blueprint $table) {
            $table->id();
            $table->string('file_name');
            $table->string('orignal_name');
            $table->integer('store_id');
            $table->integer('cargo_select');
            $table->longText('shippment_id');
            $table->longText('comment_box');
            $table->dateTime('created_at');
            $table->integer('status');
            $table->integer('total_items');
            $table->integer('sale_order_qty');
            $table->integer('user_id');
        });

        Schema::create('sale_order_list', function (Blueprint $table) {
            $table->id();
            $table->integer('sale_order_id');
            $table->string('variation_id');
            $table->integer('sale_order_qty');
            $table->dateTime('created_at');
            $table->integer('status');
            $table->integer('user_id');
        });
        Schema::create('sale_order_adjust', function (Blueprint $table) {
            $table->id();
            $table->integer('sale_order_list_id');
            $table->integer('sale_order_qty');
            $table->integer('sale_adjust_qty');
            $table->dateTime('created_at');
            $table->integer('user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_orders');
        Schema::dropIfExists('sale_order_list');
        Schema::dropIfExists('sale_order_adjust');

    }
}
