<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddReceiveColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('product_barcodes', function (Blueprint $table) {
            $table->integer('received_by');
        });

        Schema::table('assign_quantity', function (Blueprint $table) {
            $table->integer('received_by');
            $table->dateTime('received_at');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('product_barcodes', function (Blueprint $table) {
            $table->dropColumn('received_by');
        });
        Schema::table('assign_quantity', function (Blueprint $table) {
            $table->dropColumn('received_by');
            $table->dropColumn('received_at');
        });
    }
}
