<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductBarcodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_receiving', function (Blueprint $table) {
            $table->id();
            $table->integer('order_id');
            $table->integer('assign_id');
            $table->string('variation_id');
            $table->integer('last_receiving');
            $table->integer('supplier_id');
            $table->integer('pr_id');
            $table->integer('user_id'); 
            $table->dateTime('created_date');
            $table->integer('barcode_id');
        });

        Schema::create('product_barcodes', function (Blueprint $table) {
            $table->id();
            $table->integer('blister_qty');
            $table->integer('barcode_id');// $table->integer('barcode_id');
            $table->integer('order_id');
            $table->integer('assign_id');
            $table->string('variation_id');
            $table->integer('team_id');
            $table->integer('supplier_id');
            $table->integer('pr_id');
            $table->integer('serial_no');
            $table->string('pr_string');
            $table->string('hash');
            $table->integer('received_by');
            $table->date('created_date'); 
        });

        Schema::create('barcodes', function (Blueprint $table) {
            $table->id();
            $table->integer('blister_qty');
            $table->integer('no_of_labels');
            $table->integer('actual_qty');
            $table->integer('order_id');
            $table->integer('assign_id');
            $table->string('variation_id');
            $table->integer('supplier_id');
            $table->integer('pr_id');
            $table->integer('warehouse_status');
            $table->integer('first_status');
            $table->longText('first_comment');
            $table->integer('first_agreed_status');
            $table->integer('second_status');
            $table->longText('second_comment');
            $table->integer('second_agreed_status');
            $table->integer('received_by');
            $table->integer('barcode_old_id');
            $table->dateTime('created_date');
        });

        Schema::create('barcodes_log', function (Blueprint $table) {
            $table->id();
            $table->integer('barcode_id');
            $table->integer('last_receiving_id');
            $table->integer('no_of_labels');
            $table->integer('blister_qty');
            $table->integer('receiving_qty');
            $table->integer('order_id');
            $table->integer('assign_id');
            $table->string('variation_id');
            $table->integer('supplier_id');
            $table->integer('pr_id');
            $table->string('type_name');
            $table->integer('user_id');
            $table->dateTime('created_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_barcodes');
        Schema::dropIfExists('product_receiving');
        Schema::dropIfExists('barcodes');
        Schema::dropIfExists('barcodes_log');
        
    }
}
