<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssignQuantityTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assign_quantity', function (Blueprint $table) {
            $table->id();
            $table->string('variation_id');
            $table->string('main_type');
            $table->integer('prod_size');
            $table->integer('in_stock');
            $table->integer('order_qty_given');
            $table->integer('supplier_id');
            $table->date('assign_date');
            $table->integer('receive_qty');
            $table->integer('pr_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assign_quantity');
    }
}
