<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveColumnProductView extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('view_products_orders', function (Blueprint $table) {
            $table->dropColumn('product_id');
            $table->dropColumn('in_stock');
            $table->dropColumn('last_30_day_sale');
            $table->dropColumn('recommendation');
            $table->integer('approve_qtn');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('view_products_orders', function (Blueprint $table) {
            $table->integer('product_id');
            $table->integer('in_stock');
            $table->integer('last_30_day_sale');
            $table->integer('recommendation'); 
            $table->dropColumn('approve_qtn');
        });
    }
}
