<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ProductInfo extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_color', function (Blueprint $table) {
            $table->id();
            $table->string('color');
            $table->integer('status');
        });
        Schema::create('product_gender', function (Blueprint $table) {
            $table->id();
            $table->string('gender');
            $table->integer('status');
        });

        Schema::create('type_images', function (Blueprint $table) {
            $table->id();
            $table->string('code');
            $table->longText('image');
        });

        Schema::create('product_info', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->references('id')->on('users');
            $table->longText('product_name');
            $table->integer('prod_status');
            $table->integer('prod_gender');
            $table->integer('prod_type');
            $table->integer('prod_color');
            $table->integer('prod_size');
            $table->longText('prod_img');
            $table->string('prod_variation');
            $table->integer('prod_design');
            $table->integer('Quantity');
            $table->date('created_at');
        });

        Schema::create('product_size', function (Blueprint $table) {
            $table->id();
            $table->string('size');
            $table->integer('status');
        });

        Schema::create('product_type', function (Blueprint $table) {
            $table->id();
            $table->text('product_type');
            $table->integer('status');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
        Schema::drop('product_color');
        Schema::drop('product_gender');
        Schema::drop('type_images');
        Schema::drop('product_info');
        Schema::drop('product_size');
        Schema::drop('product_type');


    }
}
