<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    public $details;
    public $subject;
    public $view;

    public function __construct($details,$subject,$view)
    {
       $this->details = $details;
       $this->subject = $subject;
       $this->view = $view;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject($this->subject)
                    // ->markdown('emails.etemplate')
                    ->view($this->view)
                    ->with('details', $this->details);
    }
}
