<?php


namespace App\Http\Controllers;


use DB;
use Hash;
use DataTables;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;


class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    function __construct(){
        $this->middleware('auth');
         $this->middleware('permission:user-list');
         
    }

    public function index(Request $request){
        if($request->ajax()){
            $records=User::orderBy('id','ASC')->latest()->get();
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('role_name', function($data){
                $role='';
                if(!empty($data->getRoleNames())){
                    foreach ($data->getRoleNames() as $v) {
                        $role.='<label class="badge badge-success">'.$v.'</label>';
                    }
                }
                return $role;
            })
            ->addColumn('action', function($data){
                if($data->id == '1'){
                    $delete='';
                }else{
                    $delete='<a class="btn btn-sm btn-danger delete_btn" id="edit_'.$data->id.'"href="javascript:;"><i class="fas fa-trash"></i> Delete</a>';
                }
               $button='
                    <a class="btn btn-sm btn-primary edit_btn" id="delete_'.$data->id.'" href="javascript:;"><i class="fas fa-pencil-alt"></i> Edit</a>
                    '.$delete;
               return $button;
            })
            ->addColumn('created_at', function($data){
                return date('d-m-Y',strtotime($data->created_at));
             })
            ->rawColumns(['role_name','action'])//'id','name','email','created_at',
            ->make(true);


        }else{
            $roles = Role::pluck('name','name')->all();
            return view('users.index',compact('roles'));
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function get_roles_list()
    {
        $roles = Role::pluck('name','name')->all();
        dd($roles);
        $role_list='<option value="">Please select</option>';

        foreach ($roles as $key => $value) {
            $role_list.='<option value="">Please select</option>';
        }

        return view('users.create',compact('roles'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $input = $request->all();
        $input['password'] = Hash::make($input['password']);
        $insert=[
            'name' => $input['user_name'],
            'email' => $input['user_email'],
            'password' => $input['password'],
        ];
        $user = User::create($insert);
        $user->assignRole($request->input('role_name'));
        if($user){
            echo '1';
            
        }else{
            echo '0';
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::find($id);
        return view('users.show',compact('user'));
    }
    
    public function check_email(Request $request){
        $input = $request->all();
        
        $user=User::where('email',$input['email']);
        if(isset($request->id)){
            $user->where('id','!=',$input['id']);
        }
        
        
        $user->count();
        
        if($user->count()>0){
            $data=1;
            echo $data; 
        }else{
            $data=0;
            echo $data;
        }
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::pluck('name','name')->all();
        $userRole = $user->roles->pluck('name','name')->all();


        return view('users.edit',compact('user','roles','userRole'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        if(!empty($input['password'])){ 
            $input['password'] = Hash::make($input['password']);
            $update=[
                'name' => $input['user_name'],
                'email' => $input['user_email'],
                'password' => $input['password'],
            ];
        }else{
            $update=[
                'name' => $input['user_name'],
                'email' => $input['user_email'],
            ];
            // $input = array_except($input,array('password'));    
        }


        $user = User::find($id);
        $user->update($update);

        DB::table('model_has_roles')->where('model_id',$id)->delete();


        $user->assignRole($request->input('role_name'));


        echo '1';
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        echo '1';
    }
}