<?php

namespace App\Http\Controllers;

use DataTables;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class UploadExcelController extends Controller
{
    public function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:excel-list');
    }

    public function index(Request $request){
        if($request->ajax()){
            $records=DB::table('upload_excel')
                        ->join('users','users.id','=','upload_excel.uploaded_by')
                        ->select(['upload_excel.*','users.name']);
            if($request->type !=''){
                $records->where('type',$request->type);
            }
            return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('action', function($data){
               $button='
                    <a class="btn btn-sm btn-primary download_btn" id="download_'.$data->id.'" href="'.asset('uploads/upload_excel/'.$data->file_name).'" download ="'.$data->original_name.'"><i class="fas fa-download"></i> Download</a>';
               return $button;
            })
            ->addColumn('created_at', function($data){
                return date('d-m-Y',strtotime($data->upload_date));
             })
            ->filterColumn('created_at',function($query,$keyword){
                $keyword=date('Y-m-d',strtotime($keyword));
                $query->orWhereRaw("upload_excel.upload_date LIKE ?", ["%{$keyword}%"]);
            })
            ->orderColumn('created_at', function ($query, $order) {
                $query->orderBy('upload_excel.upload_date', $order);
            })
            ->rawColumns(['created_at','action'])
            ->make(true); 

        }else{
            $list=DB::table('upload_excel')->groupBy('type')->groupBy('type_name')->get(['type','type_name']);
            // dd($list);
            return view('upload_excel.index',['list' => $list]);
        }
        
    }
}
