<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;

class SPReportController extends Controller
{
    public function get_decrum_inventory($country='US'){
        
        $url=env('SP_URL');
        
        if($country =='US'){
            $decrumurl=$url."decruminv/decrum_response.json";
            $tableName='inventory_report_decrum';
        }elseif($country =='CA'){
            $decrumurl=$url."decrumcainv/decrumca_response.json";
            $tableName='inventory_report_decrum_ca';
        }
        
    	$filepath = file_get_contents($decrumurl);
        $fileres = json_encode(utf8_encode($filepath), true);
        $exp = str_replace('"','',$fileres);
        $inv = explode('\n',$exp);
        
        DB::table($tableName)->delete();
        
        foreach($inv as $key => $value){
            if($key > 0){
                $data = explode('\t',$inv[$key]);
                
                $title = trim($data[3]);
                $prod_name=str_replace("[RT]","",$title);
                preg_match('#\[(.*?)\]#', $prod_name, $match);
                $variation_design=(isset($match[1]))?$match[1]:'';
                
                $start_number=isset($variation_design[0])?$variation_design[0]:'0';
                    
                
                if(isset($match[1]) &&  $start_number =='4'){
                    $exp=explode('-',$variation_design);
                    $variation_id=$exp[0];
                    
                    $group_id=substr($variation_id, 0, -1);
                    
                    $insert=[
                       'sku' => isset($data[0])?$data[0]:0, 
                       'fnsku' => isset($data[1])?$data[1]:0,
                       'asin' => isset($data[2])?$data[2]:0,
                       'product_name' => isset($data[3])?$data[3]:0,
                       'product_condition' => isset($data[4])?$data[4]:0,
                       'your_price' => isset($data[5])?$data[5]:0,
                       'mfn_listing_exists' => isset($data[6])?$data[6]:0,
                       'mfn_fulfillable_quantity' => isset($data[7])?$data[7]:0 ,
                       'afn_listing_exists' =>  isset($data[8])?$data[8]:0,
                       'afn_warehouse_quantity' => isset($data[9])?$data[9]:0,
                       'afn_fulfillable_quantity' => isset($data[10])?$data[10]:0,
                       'afn_unsellable_quantity' => isset($data[11])?$data[11]:0, 
                       'afn_reserved_quantity' => isset($data[12])?$data[12]:0,
                       'afn_total_quantity' => isset($data[13])?$data[13]:0,
                       'per_unit_volume' => isset($data[14])?$data[14]:0,
                       'afn_inbound_working_quantity' => isset($data[15])?$data[15]:0,
                       'afn_inbound_shipped_quantity' => isset($data[16])?$data[16]:0,
                       'afn_inbound_receiving_quantity' => isset($data[17])?$data[17]:0,
                       'afn_researching_quantity' => isset($data[18])?$data[18]:0,
                       'afn_reserved_future_supply' => isset($data[19])?$data[19]:0,    
                       'afn_future_supply_buyable' => isset($data[20])?$data[20]:0,
                       'variation_design' => $variation_design,
                       'variation_id' => $variation_id,
                       'group_id' => $group_id,
                       'cronjob_date' => now(),
                    ];
                    
                    DB::table($tableName)->insert($insert);
                }
            }
        }
        
        return response()->json([
            'code' => '200',
            'message' => 'Decrum '.$country.' Inventory Updated Successfully'
        ]);
        
        
    }
    
    public function get_decrum_orders(){
        $url=env('SP_URL');
        
        $decrumurl=$url."decrumord/decrum_response.json";
    	$filepath = file_get_contents($decrumurl);
        $fileres = json_encode(utf8_encode($filepath), true);
        $exp = str_replace('"','',$fileres);
        $expp = explode('\n',$exp);
        
        $now_date = date('Y-m-d H:i:s');
        $inserts = [];
        
        foreach($expp as $key => $ord){
            if($key > 0){
                $data = explode('\t', $expp[$key]);
                
                if($data[0] ==''){
                    continue;
                }
                
                $title = trim($data[9]);
                $prod_name=str_replace("[RT]","",$title);
                preg_match('#\[(.*?)\]#', $prod_name, $match);
                $variation_design=(isset($match[1]))?$match[1]:'';
                
                $start_number=isset($variation_design[0])?$variation_design[0]:'0';
                
                if(isset($match[1]) &&  $start_number =='4'){
                    $exp=explode('-',$variation_design);
                    $variation_id=$exp[0];
                    
                    $group_id=substr($variation_id, 0, -1);
                    
                    $inserts[] = [
                        'amazon_order_id' => $data[0] ?? 0,
                        'merchant_order_id' => $data[1] ?? 0,
                        'purchase_date' => $data[2] ?? 0,
                        'order_status' => $data[4] ?? 0,
                        'fulfillment_channel' => $data[5] ?? 0,
                        'sales_channel' => $data[6] ?? 0,
                        'product_name' => $data[9] ?? 0,
                        'sku' => $data[10] ?? 0,
                        'asin' => $data[11] ?? 0,
                        'item_status' => $data[12] ?? 0,
                        'quantity' => $data[13] ?? 0,
                        'currency' => $data[26] ?? 0,
                        'item_price' => $data[15] ?? 0,
                        'shipping_amount' => $data[17] ?? 0,
                        'created_at' => $now_date,
                        'created_by' => 28,
                        'variation_design' => $variation_design,
                        'variation_id' => $variation_id,
                        'group_id' => $group_id,
                        'file_id' => 1
                    ];
                }
            }
            
        }
        
        // dd($inserts);
        
        $existingAsins = DB::table('amazon_order_report_decrum')->whereIn('amazon_order_id', array_column($inserts, 'amazon_order_id'))->pluck('amazon_order_id')->all();
                
        $inserts = array_filter($inserts, function($insert) use ($existingAsins) {
            return !in_array($insert['amazon_order_id'], $existingAsins);
        });
    
        $chunks = array_chunk($inserts, 500);
        foreach ($chunks as $chunk) {
            DB::table('amazon_order_report_decrum')->insert($chunk);
        }
        
        return response()->json(['code' => '200','message' => 'Decrum Orders Report Updated Successfully']);
    }
    
    public function awd_inventory(){
        $url=env('SP_URL');
    }
    
    public function get_decrum_returns(){
        $url=env('SP_URL');
        
        $decrumurl=$url."decrumreturn/decrum_response.json";
    	$filepath = file_get_contents($decrumurl);
        $fileres = json_encode(utf8_encode($filepath), true);
        $exp = str_replace('"','',$fileres);
        $expp = explode('\n',$exp);
        
        $now_date = date('Y-m-d H:i:s');
        $inserts = [];
        
        foreach($expp as $key => $ord){
            if($key > 0){
                $data = explode('\t', $expp[$key]);
                
                if($data[0] ==''){
                    continue;
                }
                
                $title = trim($data[5]);
                $prod_name=str_replace("[RT]","",$title);
                preg_match('#\[(.*?)\]#', $prod_name, $match);
                $variation_design=(isset($match[1]))?$match[1]:'';
                
                $start_number=isset($variation_design[0])?$variation_design[0]:'0';
                
                if(isset($match[1]) &&  $start_number =='4'){
                    $exp=explode('-',$variation_design);
                    $variation_id=$exp[0];
                    
                    $group_id=substr($variation_id, 0, -1);
                    
                    $comments=$data[12] ?? '';
                    $comments=str_replace('\r','',$comments);
                    
                    $inserts[] = [
                        'return_date' => $data[0] ?? 0,
                        'order_id' => $data[1] ?? 0,
                        'sku' => $data[2] ?? 0,
                        'asin' => $data[3] ?? 0,	
                        'fnsku' => $data[4] ?? 0,
                        'product_name' => $data[5] ?? 0,
                        'quantity' => $data[6] ?? 0,
                        'fulfillment_center_id' => $data[7] ?? 0,
                        'detailed_disposition' => $data[8] ?? 0,
                        'reason' =>	 $data[9] ?? 0,
                        'status' => $data[10] ?? 0,
                        'license_plate_number' => $data[11] ?? 0,
                        'customer_comments' => $comments,
                        'created_date' => $now_date,
                        'created_by' => 28,
                        'variation_design' => $variation_design,
                        'variation_id' => $variation_id,
                        'group_id' => $group_id,
                    ];
                }
            }
            
        }
        
        
        
        $existingAsins = DB::table('amazon_return_report_decrum')->whereIn('order_id', array_column($inserts, 'order_id'))->pluck('order_id')->all();
                
        $inserts = array_filter($inserts, function($insert) use ($existingAsins) {
            return !in_array($insert['order_id'], $existingAsins);
        });
        
        // dd($inserts);
        
        $chunks = array_chunk($inserts, 500);
        foreach ($chunks as $chunk) {
            DB::table('amazon_return_report_decrum')->insert($chunk);
        }
        
        return response()->json(['code' => '200','message' => 'Decrum Return Report Updated Successfully']);
    }
    
}
