<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Illuminate\Support\Facades\DB;

class ExtraController extends Controller
{
    private $db_reset_key;
    function __construct(){
        $this->middleware('guest');
        $this->db_reset_key='9891231465';
        
    }
    
    public function dbReset(Request $request){
        if($request->isMethod('post')){
            
        }else{
            return view('extra.db_reset');
        }
    }
    
    public function get_excel(){
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load(public_path('backend/stock.xlsx'));
        
        
            // $spreadsheet = $reader->load($_FILES['file_img']['tmp_name']);

            $allDataInSheet = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

            $arrayCount = count($allDataInSheet);
            $flag = 0;
            $createArray = array('variation_id','Prouduct_Name','approve_qty','In_Hand_Qty');
            $makeArray = array(
                    'variation_id'=>'variation_id',
                    'Prouduct_Name'=>'Prouduct_Name' ,
                    'approve_qty' => 'approve_qty', 
                    'In_Hand_Qty' => 'In_Hand_Qty',
            );
            $SheetDataKey = array();

            foreach ($allDataInSheet as $dataInSheet) {
                foreach ($dataInSheet as $key => $value) {
                    if (in_array(trim($value), $createArray)) {
                        $value = preg_replace('/\s+/', '', $value);
                        $SheetDataKey[trim($value)] = $key;
                    } 
                }
            }
            
            // dd($SheetDataKey);
            $dataDiff = array_diff_key($makeArray, $SheetDataKey);
            // dd($dataDiff);  

            if (empty($dataDiff)) {
                $flag = 1;
            }
            $fetchData=array();
            if($flag==1){
                for ($i = 2; $i <= $arrayCount; $i++) {
                    $variation_id = $SheetDataKey['variation_id'];
                    $Prouduct_Name = $SheetDataKey['Prouduct_Name'];
                    $approve_qty = $SheetDataKey['approve_qty'];
                    $In_Hand_Qty = $SheetDataKey['In_Hand_Qty'];
                
                    $variation_id = filter_var(trim($allDataInSheet[$i][$variation_id]), FILTER_SANITIZE_STRING);
                    $Prouduct_Name = filter_var(trim($allDataInSheet[$i][$Prouduct_Name]), FILTER_SANITIZE_STRING);
                    $approve_qty = filter_var(trim($allDataInSheet[$i][$approve_qty]), FILTER_SANITIZE_STRING);
                    $In_Hand_Qty = filter_var(trim($allDataInSheet[$i][$In_Hand_Qty]), FILTER_SANITIZE_STRING);
                    
                    $output = preg_replace( '/[^0-9]/', '',$In_Hand_Qty);
                    if($output){
                        $where=[
                            'variation_id' => $variation_id
                        ];
                        
                        $update=[
                            'Quantity' => $In_Hand_Qty
                        ];
                        DB::table('product_info')->where($where)->update($update);
                    }
                    
                }
                
                echo "done";
            }else{
                $error= "Please import correct file, did not match excel sheet column";
                $type=1;
            }
    }
    
    public function test_mail(){
        
        // \Mail::raw('Test Mail from Amazon Ses', function($message) {
        //   $message->subject('Mail from Amazon Ses')->to(['smsufian.esire@gmail.com','tahir.esire@gmail.com']);
        //   $message->Attach(asset('uploads/sku_images/1622114540.jpg'));
        //   $message->Attach(asset('uploads/upload_excel/1628078612.xlsx'));
        // });
        
        
        
        // return response()->json(['code' => 200, 'message' =>'Email Send Successfully']);
        
        
        $arr=[
            0 => ['variation_id' => '40001012','group_id' => 4000101,'product_url' => 'https://m.media-amazon.com/images/I/31KLrkQaLdL.jpg'],
            1 => ['variation_id' => '40001013','group_id' => 4000101,'product_url' => 'https://m.media-amazon.com/images/I/31KLrkQaLdL.jpg'],
            2 => ['variation_id' => '40001014','group_id' => 4000101,'product_url' => 'https://m.media-amazon.com/images/I/31KLrkQaLdL.jpg'],
            3 => ['variation_id' => '40001015','group_id' => 4000101,'product_url' => 'https://m.media-amazon.com/images/I/31KLrkQaLdL.jpg'],
            4 => ['variation_id' => '40001016','group_id' => 4000101,'product_url' => 'https://m.media-amazon.com/images/I/31KLrkQaLdL.jpg'],
            5 => ['variation_id' => '40001022','group_id' => 4000102,'product_url' => 'https://m.media-amazon.com/images/I/41zwN1CPFWL.jpg'],
            6 => ['variation_id' => '40001023','group_id' => 4000102,'product_url' => 'https://m.media-amazon.com/images/I/41zwN1CPFWL.jpg'],
            7 => ['variation_id' => '40001024','group_id' => 4000102,'product_url' => 'https://m.media-amazon.com/images/I/41zwN1CPFWL.jpg'],
            8 => ['variation_id' => '40001025','group_id' => 4000102,'product_url' => 'https://m.media-amazon.com/images/I/41zwN1CPFWL.jpg'],
            9 => ['variation_id' => '40001026','group_id' => 4000102,'product_url' => 'https://m.media-amazon.com/images/I/41zwN1CPFWL.jpg'],
            10 => ['variation_id' => '40001032','group_id' => 4000103,'product_url' => 'https://m.media-amazon.com/images/I/41zgMRfRvHL.jpg'],
            11 => ['variation_id' => '40001033','group_id' => 4000103,'product_url' => 'https://m.media-amazon.com/images/I/41zgMRfRvHL.jpg'],
            12 => ['variation_id' => '40001034','group_id' => 4000103,'product_url' => 'https://m.media-amazon.com/images/I/41zgMRfRvHL.jpg'],
            13 => ['variation_id' => '40001035','group_id' => 4000103,'product_url' => 'https://m.media-amazon.com/images/I/41zgMRfRvHL.jpg'],
            14 => ['variation_id' => '40001036','group_id' => 4000103,'product_url' => 'https://m.media-amazon.com/images/I/41zgMRfRvHL.jpg'],
            15 => ['variation_id' => '40001042','group_id' => 4000104,'product_url' => 'https://m.media-amazon.com/images/I/41TyhnGRqmL.jpg'],
            16 => ['variation_id' => '40001043','group_id' => 4000104,'product_url' => 'https://m.media-amazon.com/images/I/41TyhnGRqmL.jpg'],
            17 => ['variation_id' => '40001044','group_id' => 4000104,'product_url' => 'https://m.media-amazon.com/images/I/41TyhnGRqmL.jpg'],
            18 => ['variation_id' => '40001045','group_id' => 4000104,'product_url' => 'https://m.media-amazon.com/images/I/41TyhnGRqmL.jpg'],
            19 => ['variation_id' => '40001046','group_id' => 4000104,'product_url' => 'https://m.media-amazon.com/images/I/41TyhnGRqmL.jpg'],
            20 => ['variation_id' => '40001052','group_id' => 4000105,'product_url' => 'https://m.media-amazon.com/images/I/51TylaymuWL.jpg'],
            21 => ['variation_id' => '40001053','group_id' => 4000105,'product_url' => 'https://m.media-amazon.com/images/I/51TylaymuWL.jpg'],
            22 => ['variation_id' => '40001054','group_id' => 4000105,'product_url' => 'https://m.media-amazon.com/images/I/51TylaymuWL.jpg'],
            23 => ['variation_id' => '40001055','group_id' => 4000105,'product_url' => 'https://m.media-amazon.com/images/I/51TylaymuWL.jpg'],
            24 => ['variation_id' => '40001056','group_id' => 4000105,'product_url' => 'https://m.media-amazon.com/images/I/51TylaymuWL.jpg'],
            25 => ['variation_id' => '40001062','group_id' => 4000106,'product_url' => 'https://i.imgur.com/LpwbsNZ.jpg'],
            26 => ['variation_id' => '40001063','group_id' => 4000106,'product_url' => 'https://i.imgur.com/LpwbsNZ.jpg'],
            27 => ['variation_id' => '40001064','group_id' => 4000106,'product_url' => 'https://i.imgur.com/LpwbsNZ.jpg'],
            28 => ['variation_id' => '40001065','group_id' => 4000106,'product_url' => 'https://i.imgur.com/LpwbsNZ.jpg'],
            29 => ['variation_id' => '40001066','group_id' => 4000106,'product_url' => 'https://i.imgur.com/LpwbsNZ.jpg'],
            30 => ['variation_id' => '40001092','group_id' => 4000109,'product_url' => 'https://m.media-amazon.com/images/I/31qBfGJew5L.jpg'],
            31 => ['variation_id' => '40001093','group_id' => 4000109,'product_url' => 'https://m.media-amazon.com/images/I/31qBfGJew5L.jpg'],
            32 => ['variation_id' => '40001094','group_id' => 4000109,'product_url' => 'https://m.media-amazon.com/images/I/31qBfGJew5L.jpg'],
            33 => ['variation_id' => '40001095','group_id' => 4000109,'product_url' => 'https://m.media-amazon.com/images/I/31qBfGJew5L.jpg'],
            34 => ['variation_id' => '40001096','group_id' => 4000109,'product_url' => 'https://m.media-amazon.com/images/I/31qBfGJew5L.jpg'],
            35 => ['variation_id' => '40002012','group_id' => 4000201,'product_url' => 'https://m.media-amazon.com/images/I/31LXqkHGZ+S.jpg'],
            36 => ['variation_id' => '40002013','group_id' => 4000201,'product_url' => 'https://m.media-amazon.com/images/I/31LXqkHGZ+S.jpg'],
            37 => ['variation_id' => '40002014','group_id' => 4000201,'product_url' => 'https://m.media-amazon.com/images/I/31LXqkHGZ+S.jpg'],
            38 => ['variation_id' => '40002015','group_id' => 4000201,'product_url' => 'https://m.media-amazon.com/images/I/31LXqkHGZ+S.jpg'],
            39 => ['variation_id' => '40002016','group_id' => 4000201,'product_url' => 'https://m.media-amazon.com/images/I/31LXqkHGZ+S.jpg'],
            40 => ['variation_id' => '40002022','group_id' => 4000202,'product_url' => 'https://m.media-amazon.com/images/I/61kz8xHQWKS.jpg'],
            41 => ['variation_id' => '40002023','group_id' => 4000202,'product_url' => 'https://m.media-amazon.com/images/I/61kz8xHQWKS.jpg'],
            42 => ['variation_id' => '40002024','group_id' => 4000202,'product_url' => 'https://m.media-amazon.com/images/I/61kz8xHQWKS.jpg'],
            43 => ['variation_id' => '40002025','group_id' => 4000202,'product_url' => 'https://m.media-amazon.com/images/I/61kz8xHQWKS.jpg'],
            44 => ['variation_id' => '40002026','group_id' => 4000202,'product_url' => 'https://m.media-amazon.com/images/I/61kz8xHQWKS.jpg'],
            45 => ['variation_id' => '40002031','group_id' => 4000203,'product_url' => 'https://i.imgur.com/fWirg4J.jpg'],
            46 => ['variation_id' => '40002032','group_id' => 4000203,'product_url' => 'https://i.imgur.com/fWirg4J.jpg'],
            47 => ['variation_id' => '40002033','group_id' => 4000203,'product_url' => 'https://i.imgur.com/fWirg4J.jpg'],
            48 => ['variation_id' => '40002034','group_id' => 4000203,'product_url' => 'https://i.imgur.com/fWirg4J.jpg'],
            49 => ['variation_id' => '40002035','group_id' => 4000203,'product_url' => 'https://i.imgur.com/fWirg4J.jpg'],
            50 => ['variation_id' => '40002036','group_id' => 4000203,'product_url' => 'https://i.imgur.com/fWirg4J.jpg'],
            51 => ['variation_id' => '40002042','group_id' => 4000204,'product_url' => 'https://m.media-amazon.com/images/I/717oiX20JOS.jpg'],
            52 => ['variation_id' => '40002043','group_id' => 4000204,'product_url' => 'https://m.media-amazon.com/images/I/717oiX20JOS.jpg'],
            53 => ['variation_id' => '40002044','group_id' => 4000204,'product_url' => 'https://m.media-amazon.com/images/I/717oiX20JOS.jpg'],
            54 => ['variation_id' => '40002045','group_id' => 4000204,'product_url' => 'https://m.media-amazon.com/images/I/717oiX20JOS.jpg'],
            55 => ['variation_id' => '40002046','group_id' => 4000204,'product_url' => 'https://m.media-amazon.com/images/I/717oiX20JOS.jpg'],
            56 => ['variation_id' => '40002052','group_id' => 4000205,'product_url' => 'https://m.media-amazon.com/images/I/71C9l35mTcS.jpg'],
            57 => ['variation_id' => '40002053','group_id' => 4000205,'product_url' => 'https://m.media-amazon.com/images/I/71C9l35mTcS.jpg'],
            58 => ['variation_id' => '40002054','group_id' => 4000205,'product_url' => 'https://m.media-amazon.com/images/I/71C9l35mTcS.jpg'],
            59 => ['variation_id' => '40002055','group_id' => 4000205,'product_url' => 'https://m.media-amazon.com/images/I/71C9l35mTcS.jpg'],
            60 => ['variation_id' => '40002056','group_id' => 4000205,'product_url' => 'https://m.media-amazon.com/images/I/71C9l35mTcS.jpg'],
            61 => ['variation_id' => '40002062','group_id' => 4000206,'product_url' => 'https://i.imgur.com/0V8D0pl.jpg'],
            62 => ['variation_id' => '40002063','group_id' => 4000206,'product_url' => 'https://i.imgur.com/0V8D0pl.jpg'],
            63 => ['variation_id' => '40002064','group_id' => 4000206,'product_url' => 'https://i.imgur.com/0V8D0pl.jpg'],
            64 => ['variation_id' => '40002065','group_id' => 4000206,'product_url' => 'https://i.imgur.com/0V8D0pl.jpg'],
            65 => ['variation_id' => '40002066','group_id' => 4000206,'product_url' => 'https://i.imgur.com/0V8D0pl.jpg'],
            66 => ['variation_id' => '40002091','group_id' => 4000209,'product_url' => 'https://i.imgur.com/1HI5TCN.jpg'],
            67 => ['variation_id' => '40002092','group_id' => 4000209,'product_url' => 'https://i.imgur.com/1HI5TCN.jpg'],
            68 => ['variation_id' => '40002093','group_id' => 4000209,'product_url' => 'https://i.imgur.com/1HI5TCN.jpg'],
            69 => ['variation_id' => '40002094','group_id' => 4000209,'product_url' => 'https://i.imgur.com/1HI5TCN.jpg'],
            70 => ['variation_id' => '40002095','group_id' => 4000209,'product_url' => 'https://i.imgur.com/1HI5TCN.jpg'],
            71 => ['variation_id' => '40002096','group_id' => 4000209,'product_url' => 'https://i.imgur.com/1HI5TCN.jpg'],
            72 => ['variation_id' => '40003012','group_id' => 4000301,'product_url' => 'https://m.media-amazon.com/images/I/61ow8VjS0eL.jpg'],
            73 => ['variation_id' => '40003013','group_id' => 4000301,'product_url' => 'https://m.media-amazon.com/images/I/61ow8VjS0eL.jpg'],
            74 => ['variation_id' => '40003014','group_id' => 4000301,'product_url' => 'https://m.media-amazon.com/images/I/61ow8VjS0eL.jpg'],
            75 => ['variation_id' => '40003015','group_id' => 4000301,'product_url' => 'https://m.media-amazon.com/images/I/61ow8VjS0eL.jpg'],
            76 => ['variation_id' => '40003016','group_id' => 4000301,'product_url' => 'https://m.media-amazon.com/images/I/61ow8VjS0eL.jpg'],
            77 => ['variation_id' => '40003022','group_id' => 4000302,'product_url' => 'https://m.media-amazon.com/images/I/61z2sEw3CVL.jpg'],
            78 => ['variation_id' => '40003023','group_id' => 4000302,'product_url' => 'https://m.media-amazon.com/images/I/61z2sEw3CVL.jpg'],
            79 => ['variation_id' => '40003024','group_id' => 4000302,'product_url' => 'https://m.media-amazon.com/images/I/61z2sEw3CVL.jpg'],
            80 => ['variation_id' => '40003025','group_id' => 4000302,'product_url' => 'https://m.media-amazon.com/images/I/61z2sEw3CVL.jpg'],
            81 => ['variation_id' => '40003026','group_id' => 4000302,'product_url' => 'https://m.media-amazon.com/images/I/61z2sEw3CVL.jpg'],
            82 => ['variation_id' => '40003032','group_id' => 4000303,'product_url' => 'https://m.media-amazon.com/images/I/612TnGYvrwL._AC_UY679_.jpg'],
            83 => ['variation_id' => '40003033','group_id' => 4000303,'product_url' => 'https://m.media-amazon.com/images/I/612TnGYvrwL._AC_UY679_.jpg'],
            84 => ['variation_id' => '40003034','group_id' => 4000303,'product_url' => 'https://m.media-amazon.com/images/I/612TnGYvrwL._AC_UY679_.jpg'],
            85 => ['variation_id' => '40003035','group_id' => 4000303,'product_url' => 'https://m.media-amazon.com/images/I/612TnGYvrwL._AC_UY679_.jpg'],
            86 => ['variation_id' => '40003036','group_id' => 4000303,'product_url' => 'https://m.media-amazon.com/images/I/612TnGYvrwL._AC_UY679_.jpg'],
            87 => ['variation_id' => '40003042','group_id' => 4000304,'product_url' => 'https://m.media-amazon.com/images/I/61LWmiuwmnL.jpg'],
            88 => ['variation_id' => '40003043','group_id' => 4000304,'product_url' => 'https://m.media-amazon.com/images/I/61LWmiuwmnL.jpg'],
            89 => ['variation_id' => '40003044','group_id' => 4000304,'product_url' => 'https://m.media-amazon.com/images/I/61LWmiuwmnL.jpg'],
            90 => ['variation_id' => '40003045','group_id' => 4000304,'product_url' => 'https://m.media-amazon.com/images/I/61LWmiuwmnL.jpg'],
            91 => ['variation_id' => '40003046','group_id' => 4000304,'product_url' => 'https://m.media-amazon.com/images/I/61LWmiuwmnL.jpg'],
            92 => ['variation_id' => '40003052','group_id' => 4000305,'product_url' => 'https://m.media-amazon.com/images/I/71tyfiiS4JS.jpg'],
            93 => ['variation_id' => '40003053','group_id' => 4000305,'product_url' => 'https://m.media-amazon.com/images/I/71tyfiiS4JS.jpg'],
            94 => ['variation_id' => '40003054','group_id' => 4000305,'product_url' => 'https://m.media-amazon.com/images/I/71tyfiiS4JS.jpg'],
            95 => ['variation_id' => '40003055','group_id' => 4000305,'product_url' => 'https://m.media-amazon.com/images/I/71tyfiiS4JS.jpg'],
            96 => ['variation_id' => '40003056','group_id' => 4000305,'product_url' => 'https://m.media-amazon.com/images/I/71tyfiiS4JS.jpg'],
            97 => ['variation_id' => '40003062','group_id' => 4000306,'product_url' => 'https://m.media-amazon.com/images/I/61fgrtTeEbL.jpg'],
            98 => ['variation_id' => '40003063','group_id' => 4000306,'product_url' => 'https://m.media-amazon.com/images/I/61fgrtTeEbL.jpg'],
            99 => ['variation_id' => '40003064','group_id' => 4000306,'product_url' => 'https://m.media-amazon.com/images/I/61fgrtTeEbL.jpg'],
            100 => ['variation_id' => '40003065','group_id' => 4000306,'product_url' => 'https://m.media-amazon.com/images/I/61fgrtTeEbL.jpg'],
            101 => ['variation_id' => '40003066','group_id' => 4000306,'product_url' => 'https://m.media-amazon.com/images/I/61fgrtTeEbL.jpg'],
            102 => ['variation_id' => '40003072','group_id' => 4000307,'product_url' => 'https://m.media-amazon.com/images/I/71QGT9ys87L.jpg'],
            103 => ['variation_id' => '40003073','group_id' => 4000307,'product_url' => 'https://m.media-amazon.com/images/I/71QGT9ys87L.jpg'],
            104 => ['variation_id' => '40003074','group_id' => 4000307,'product_url' => 'https://m.media-amazon.com/images/I/71QGT9ys87L.jpg'],
            105 => ['variation_id' => '40003075','group_id' => 4000307,'product_url' => 'https://m.media-amazon.com/images/I/71QGT9ys87L.jpg'],
            106 => ['variation_id' => '40003076','group_id' => 4000307,'product_url' => 'https://m.media-amazon.com/images/I/71QGT9ys87L.jpg'],
            107 => ['variation_id' => '40003122','group_id' => 4000312,'product_url' => 'https://m.media-amazon.com/images/I/71F9VUNj0-S.jpg'],
            108 => ['variation_id' => '40003123','group_id' => 4000312,'product_url' => 'https://m.media-amazon.com/images/I/71F9VUNj0-S.jpg'],
            109 => ['variation_id' => '40003124','group_id' => 4000312,'product_url' => 'https://m.media-amazon.com/images/I/71F9VUNj0-S.jpg'],
            110 => ['variation_id' => '40003125','group_id' => 4000312,'product_url' => 'https://m.media-amazon.com/images/I/71F9VUNj0-S.jpg'],
            111 => ['variation_id' => '40003126','group_id' => 4000312,'product_url' => 'https://m.media-amazon.com/images/I/71F9VUNj0-S.jpg'],
            112 => ['variation_id' => '40003132','group_id' => 4000313,'product_url' => 'https://m.media-amazon.com/images/I/71BtJlPr07S.jpg'],
            113 => ['variation_id' => '40003133','group_id' => 4000313,'product_url' => 'https://m.media-amazon.com/images/I/71BtJlPr07S.jpg'],
            114 => ['variation_id' => '40003134','group_id' => 4000313,'product_url' => 'https://m.media-amazon.com/images/I/71BtJlPr07S.jpg'],
            115 => ['variation_id' => '40003135','group_id' => 4000313,'product_url' => 'https://m.media-amazon.com/images/I/71BtJlPr07S.jpg'],
            116 => ['variation_id' => '40003136','group_id' => 4000313,'product_url' => 'https://m.media-amazon.com/images/I/71BtJlPr07S.jpg'],
            117 => ['variation_id' => '40004022','group_id' => 4000402,'product_url' => 'https://m.media-amazon.com/images/I/51B30LdR4LL.jpg'],
            118 => ['variation_id' => '40004023','group_id' => 4000402,'product_url' => 'https://m.media-amazon.com/images/I/51B30LdR4LL.jpg'],
            119 => ['variation_id' => '40004024','group_id' => 4000402,'product_url' => 'https://m.media-amazon.com/images/I/51B30LdR4LL.jpg'],
            120 => ['variation_id' => '40004025','group_id' => 4000402,'product_url' => 'https://m.media-amazon.com/images/I/51B30LdR4LL.jpg'],
            121 => ['variation_id' => '40004026','group_id' => 4000402,'product_url' => 'https://m.media-amazon.com/images/I/51B30LdR4LL.jpg'],
            122 => ['variation_id' => '40004032','group_id' => 4000403,'product_url' => 'https://m.media-amazon.com/images/I/51hOWk7o4ML.jpg'],
            123 => ['variation_id' => '40004033','group_id' => 4000403,'product_url' => 'https://m.media-amazon.com/images/I/51hOWk7o4ML.jpg'],
            124 => ['variation_id' => '40004034','group_id' => 4000403,'product_url' => 'https://m.media-amazon.com/images/I/51hOWk7o4ML.jpg'],
            125 => ['variation_id' => '40004035','group_id' => 4000403,'product_url' => 'https://m.media-amazon.com/images/I/51hOWk7o4ML.jpg'],
            126 => ['variation_id' => '40004036','group_id' => 4000403,'product_url' => 'https://m.media-amazon.com/images/I/51hOWk7o4ML.jpg'],
            127 => ['variation_id' => '40004042','group_id' => 4000404,'product_url' => 'https://m.media-amazon.com/images/I/61vmQm1zdIL.jpg'],
            128 => ['variation_id' => '40004043','group_id' => 4000404,'product_url' => 'https://m.media-amazon.com/images/I/61vmQm1zdIL.jpg'],
            129 => ['variation_id' => '40004044','group_id' => 4000404,'product_url' => 'https://m.media-amazon.com/images/I/61vmQm1zdIL.jpg'],
            130 => ['variation_id' => '40004045','group_id' => 4000404,'product_url' => 'https://m.media-amazon.com/images/I/61vmQm1zdIL.jpg'],
            131 => ['variation_id' => '40004046','group_id' => 4000404,'product_url' => 'https://m.media-amazon.com/images/I/61vmQm1zdIL.jpg'],
            132 => ['variation_id' => '40004052','group_id' => 4000405,'product_url' => 'https://m.media-amazon.com/images/I/61mijq6KiuS.jpg'],
            133 => ['variation_id' => '40004053','group_id' => 4000405,'product_url' => 'https://m.media-amazon.com/images/I/61mijq6KiuS.jpg'],
            134 => ['variation_id' => '40004054','group_id' => 4000405,'product_url' => 'https://m.media-amazon.com/images/I/61mijq6KiuS.jpg'],
            135 => ['variation_id' => '40004055','group_id' => 4000405,'product_url' => 'https://m.media-amazon.com/images/I/61mijq6KiuS.jpg'],
            136 => ['variation_id' => '40004056','group_id' => 4000405,'product_url' => 'https://m.media-amazon.com/images/I/61mijq6KiuS.jpg'],
            137 => ['variation_id' => '40004072','group_id' => 4000407,'product_url' => 'https://m.media-amazon.com/images/I/61A5M6CmWzL.jpg'],
            138 => ['variation_id' => '40004073','group_id' => 4000407,'product_url' => 'https://m.media-amazon.com/images/I/61A5M6CmWzL.jpg'],
            139 => ['variation_id' => '40004074','group_id' => 4000407,'product_url' => 'https://m.media-amazon.com/images/I/61A5M6CmWzL.jpg'],
            140 => ['variation_id' => '40004075','group_id' => 4000407,'product_url' => 'https://m.media-amazon.com/images/I/61A5M6CmWzL.jpg'],
            141 => ['variation_id' => '40004076','group_id' => 4000407,'product_url' => 'https://m.media-amazon.com/images/I/61A5M6CmWzL.jpg'],
            142 => ['variation_id' => '40004122','group_id' => 4000412,'product_url' => 'https://m.media-amazon.com/images/I/81z3iaaBYdL.jpg'],
            143 => ['variation_id' => '40004123','group_id' => 4000412,'product_url' => 'https://m.media-amazon.com/images/I/81z3iaaBYdL.jpg'],
            144 => ['variation_id' => '40004124','group_id' => 4000412,'product_url' => 'https://m.media-amazon.com/images/I/81z3iaaBYdL.jpg'],
            145 => ['variation_id' => '40004125','group_id' => 4000412,'product_url' => 'https://m.media-amazon.com/images/I/81z3iaaBYdL.jpg'],
            146 => ['variation_id' => '40004126','group_id' => 4000412,'product_url' => 'https://m.media-amazon.com/images/I/81z3iaaBYdL.jpg'],
            147 => ['variation_id' => '40004132','group_id' => 4000413,'product_url' => 'https://m.media-amazon.com/images/I/81IqAbtCM2L.jpg'],
            148 => ['variation_id' => '40004133','group_id' => 4000413,'product_url' => 'https://m.media-amazon.com/images/I/81IqAbtCM2L.jpg'],
            149 => ['variation_id' => '40004134','group_id' => 4000413,'product_url' => 'https://m.media-amazon.com/images/I/81IqAbtCM2L.jpg'],
            150 => ['variation_id' => '40004135','group_id' => 4000413,'product_url' => 'https://m.media-amazon.com/images/I/81IqAbtCM2L.jpg'],
            151 => ['variation_id' => '40004136','group_id' => 4000413,'product_url' => 'https://m.media-amazon.com/images/I/81IqAbtCM2L.jpg'],
            152 => ['variation_id' => '40005012','group_id' => 4000501,'product_url' => 'https://m.media-amazon.com/images/I/61ztR2bMkEL.jpg'],
            153 => ['variation_id' => '40005013','group_id' => 4000501,'product_url' => 'https://m.media-amazon.com/images/I/61ztR2bMkEL.jpg'],
            154 => ['variation_id' => '40005014','group_id' => 4000501,'product_url' => 'https://m.media-amazon.com/images/I/61ztR2bMkEL.jpg'],
            155 => ['variation_id' => '40005015','group_id' => 4000501,'product_url' => 'https://m.media-amazon.com/images/I/61ztR2bMkEL.jpg'],
            156 => ['variation_id' => '40005016','group_id' => 4000501,'product_url' => 'https://m.media-amazon.com/images/I/61ztR2bMkEL.jpg'],
            157 => ['variation_id' => '40005022','group_id' => 4000502,'product_url' => 'https://m.media-amazon.com/images/I/61lSICtdBUL.jpg'],
            158 => ['variation_id' => '40005023','group_id' => 4000502,'product_url' => 'https://m.media-amazon.com/images/I/61lSICtdBUL.jpg'],
            159 => ['variation_id' => '40005024','group_id' => 4000502,'product_url' => 'https://m.media-amazon.com/images/I/61lSICtdBUL.jpg'],
            160 => ['variation_id' => '40005025','group_id' => 4000502,'product_url' => 'https://m.media-amazon.com/images/I/61lSICtdBUL.jpg'],
            161 => ['variation_id' => '40005026','group_id' => 4000502,'product_url' => 'https://m.media-amazon.com/images/I/61lSICtdBUL.jpg'],
            162 => ['variation_id' => '40005032','group_id' => 4000503,'product_url' => 'https://m.media-amazon.com/images/I/71AiYv0cfnL.jpg'],
            163 => ['variation_id' => '40005033','group_id' => 4000503,'product_url' => 'https://m.media-amazon.com/images/I/71AiYv0cfnL.jpg'],
            164 => ['variation_id' => '40005034','group_id' => 4000503,'product_url' => 'https://m.media-amazon.com/images/I/71AiYv0cfnL.jpg'],
            165 => ['variation_id' => '40005035','group_id' => 4000503,'product_url' => 'https://m.media-amazon.com/images/I/71AiYv0cfnL.jpg'],
            166 => ['variation_id' => '40005036','group_id' => 4000503,'product_url' => 'https://m.media-amazon.com/images/I/71AiYv0cfnL.jpg'],
            167 => ['variation_id' => '40005042','group_id' => 4000504,'product_url' => 'https://m.media-amazon.com/images/I/71d6RtgSKjL.jpg'],
            168 => ['variation_id' => '40005043','group_id' => 4000504,'product_url' => 'https://m.media-amazon.com/images/I/71d6RtgSKjL.jpg'],
            169 => ['variation_id' => '40005044','group_id' => 4000504,'product_url' => 'https://m.media-amazon.com/images/I/71d6RtgSKjL.jpg'],
            170 => ['variation_id' => '40005045','group_id' => 4000504,'product_url' => 'https://m.media-amazon.com/images/I/71d6RtgSKjL.jpg'],
            171 => ['variation_id' => '40005046','group_id' => 4000504,'product_url' => 'https://m.media-amazon.com/images/I/71d6RtgSKjL.jpg'],
            172 => ['variation_id' => '40005052','group_id' => 4000505,'product_url' => 'https://m.media-amazon.com/images/I/71KYBWSjceL.jpg'],
            173 => ['variation_id' => '40005053','group_id' => 4000505,'product_url' => 'https://m.media-amazon.com/images/I/71KYBWSjceL.jpg'],
            174 => ['variation_id' => '40005054','group_id' => 4000505,'product_url' => 'https://m.media-amazon.com/images/I/71KYBWSjceL.jpg'],
            175 => ['variation_id' => '40005055','group_id' => 4000505,'product_url' => 'https://m.media-amazon.com/images/I/71KYBWSjceL.jpg'],
            176 => ['variation_id' => '40005056','group_id' => 4000505,'product_url' => 'https://m.media-amazon.com/images/I/71KYBWSjceL.jpg'],
            177 => ['variation_id' => '40005062','group_id' => 4000506,'product_url' => 'https://m.media-amazon.com/images/I/71B0nKONsIL.jpg'],
            178 => ['variation_id' => '40005063','group_id' => 4000506,'product_url' => 'https://m.media-amazon.com/images/I/71B0nKONsIL.jpg'],
            179 => ['variation_id' => '40005064','group_id' => 4000506,'product_url' => 'https://m.media-amazon.com/images/I/71B0nKONsIL.jpg'],
            180 => ['variation_id' => '40005065','group_id' => 4000506,'product_url' => 'https://m.media-amazon.com/images/I/71B0nKONsIL.jpg'],
            181 => ['variation_id' => '40005066','group_id' => 4000506,'product_url' => 'https://m.media-amazon.com/images/I/71B0nKONsIL.jpg'],
            182 => ['variation_id' => '40005072','group_id' => 4000507,'product_url' => 'https://m.media-amazon.com/images/I/81zIXAPN8TL.jpg'],
            183 => ['variation_id' => '40005073','group_id' => 4000507,'product_url' => 'https://m.media-amazon.com/images/I/81zIXAPN8TL.jpg'],
            184 => ['variation_id' => '40005074','group_id' => 4000507,'product_url' => 'https://m.media-amazon.com/images/I/81zIXAPN8TL.jpg'],
            185 => ['variation_id' => '40005075','group_id' => 4000507,'product_url' => 'https://m.media-amazon.com/images/I/81zIXAPN8TL.jpg'],
            186 => ['variation_id' => '40005076','group_id' => 4000507,'product_url' => 'https://m.media-amazon.com/images/I/81zIXAPN8TL.jpg'],
            187 => ['variation_id' => '40005092','group_id' => 4000509,'product_url' => 'https://m.media-amazon.com/images/I/61+1v3cUbZL.jpg'],
            188 => ['variation_id' => '40005093','group_id' => 4000509,'product_url' => 'https://m.media-amazon.com/images/I/61+1v3cUbZL.jpg'],
            189 => ['variation_id' => '40005094','group_id' => 4000509,'product_url' => 'https://m.media-amazon.com/images/I/61+1v3cUbZL.jpg'],
            190 => ['variation_id' => '40005095','group_id' => 4000509,'product_url' => 'https://m.media-amazon.com/images/I/61+1v3cUbZL.jpg'],
            191 => ['variation_id' => '40005096','group_id' => 4000509,'product_url' => 'https://m.media-amazon.com/images/I/61+1v3cUbZL.jpg'],
            192 => ['variation_id' => '40006012','group_id' => 4000601,'product_url' => 'https://m.media-amazon.com/images/I/61CzmQz68fL.jpg'],
            193 => ['variation_id' => '40006013','group_id' => 4000601,'product_url' => 'https://m.media-amazon.com/images/I/61CzmQz68fL.jpg'],
            194 => ['variation_id' => '40006014','group_id' => 4000601,'product_url' => 'https://m.media-amazon.com/images/I/61CzmQz68fL.jpg'],
            195 => ['variation_id' => '40006015','group_id' => 4000601,'product_url' => 'https://m.media-amazon.com/images/I/61CzmQz68fL.jpg'],
            196 => ['variation_id' => '40006016','group_id' => 4000601,'product_url' => 'https://m.media-amazon.com/images/I/61CzmQz68fL.jpg'],
            197 => ['variation_id' => '40006022','group_id' => 4000602,'product_url' => 'https://m.media-amazon.com/images/I/61cH0Z3epyL.jpg'],
            198 => ['variation_id' => '40006023','group_id' => 4000602,'product_url' => 'https://m.media-amazon.com/images/I/61cH0Z3epyL.jpg'],
            199 => ['variation_id' => '40006024','group_id' => 4000602,'product_url' => 'https://m.media-amazon.com/images/I/61cH0Z3epyL.jpg'],
            200 => ['variation_id' => '40006025','group_id' => 4000602,'product_url' => 'https://m.media-amazon.com/images/I/61cH0Z3epyL.jpg'],
            201 => ['variation_id' => '40006026','group_id' => 4000602,'product_url' => 'https://m.media-amazon.com/images/I/61cH0Z3epyL.jpg'],
            202 => ['variation_id' => '40006042','group_id' => 4000604,'product_url' => 'https://m.media-amazon.com/images/I/71wLQPz2KbL.jpg'],
            203 => ['variation_id' => '40006043','group_id' => 4000604,'product_url' => 'https://m.media-amazon.com/images/I/71wLQPz2KbL.jpg'],
            204 => ['variation_id' => '40006044','group_id' => 4000604,'product_url' => 'https://m.media-amazon.com/images/I/71wLQPz2KbL.jpg'],
            205 => ['variation_id' => '40006045','group_id' => 4000604,'product_url' => 'https://m.media-amazon.com/images/I/71wLQPz2KbL.jpg'],
            206 => ['variation_id' => '40006046','group_id' => 4000604,'product_url' => 'https://m.media-amazon.com/images/I/71wLQPz2KbL.jpg'],
            207 => ['variation_id' => '40006052','group_id' => 4000605,'product_url' => 'https://m.media-amazon.com/images/I/71Ij4mmuptL.jpg'],
            208 => ['variation_id' => '40006053','group_id' => 4000605,'product_url' => 'https://m.media-amazon.com/images/I/71Ij4mmuptL.jpg'],
            209 => ['variation_id' => '40006054','group_id' => 4000605,'product_url' => 'https://m.media-amazon.com/images/I/71Ij4mmuptL.jpg'],
            210 => ['variation_id' => '40006055','group_id' => 4000605,'product_url' => 'https://m.media-amazon.com/images/I/71Ij4mmuptL.jpg'],
            211 => ['variation_id' => '40006056','group_id' => 4000605,'product_url' => 'https://m.media-amazon.com/images/I/71Ij4mmuptL.jpg'],
            212 => ['variation_id' => '40006062','group_id' => 4000606,'product_url' => 'https://m.media-amazon.com/images/I/61v9+8Lfg3L.jpg'],
            213 => ['variation_id' => '40006063','group_id' => 4000606,'product_url' => 'https://m.media-amazon.com/images/I/61v9+8Lfg3L.jpg'],
            214 => ['variation_id' => '40006064','group_id' => 4000606,'product_url' => 'https://m.media-amazon.com/images/I/61v9+8Lfg3L.jpg'],
            215 => ['variation_id' => '40006065','group_id' => 4000606,'product_url' => 'https://m.media-amazon.com/images/I/61v9+8Lfg3L.jpg'],
            216 => ['variation_id' => '40006066','group_id' => 4000606,'product_url' => 'https://m.media-amazon.com/images/I/61v9+8Lfg3L.jpg'],
            217 => ['variation_id' => '40006092','group_id' => 4000609,'product_url' => 'https://m.media-amazon.com/images/I/6160cRH9EIL.jpg'],
            218 => ['variation_id' => '40006093','group_id' => 4000609,'product_url' => 'https://m.media-amazon.com/images/I/6160cRH9EIL.jpg'],
            219 => ['variation_id' => '40006094','group_id' => 4000609,'product_url' => 'https://m.media-amazon.com/images/I/6160cRH9EIL.jpg'],
            220 => ['variation_id' => '40006095','group_id' => 4000609,'product_url' => 'https://m.media-amazon.com/images/I/6160cRH9EIL.jpg'],
            221 => ['variation_id' => '40006096','group_id' => 4000609,'product_url' => 'https://m.media-amazon.com/images/I/6160cRH9EIL.jpg'],
            222 => ['variation_id' => '40007011','group_id' => 4000701,'product_url' => 'https://i.imgur.com/HKgPHaE.jpg'],
            223 => ['variation_id' => '40007012','group_id' => 4000701,'product_url' => 'https://i.imgur.com/HKgPHaE.jpg'],
            224 => ['variation_id' => '40007013','group_id' => 4000701,'product_url' => 'https://i.imgur.com/HKgPHaE.jpg'],
            225 => ['variation_id' => '40007014','group_id' => 4000701,'product_url' => 'https://i.imgur.com/HKgPHaE.jpg'],
            226 => ['variation_id' => '40007015','group_id' => 4000701,'product_url' => 'https://i.imgur.com/HKgPHaE.jpg'],
            227 => ['variation_id' => '40007016','group_id' => 4000701,'product_url' => 'https://i.imgur.com/HKgPHaE.jpg'],
            228 => ['variation_id' => '40007022','group_id' => 4000702,'product_url' => 'https://i.imgur.com/yFOMP6j.png'],
            229 => ['variation_id' => '40007023','group_id' => 4000702,'product_url' => 'https://i.imgur.com/yFOMP6j.png'],
            230 => ['variation_id' => '40007024','group_id' => 4000702,'product_url' => 'https://i.imgur.com/yFOMP6j.png'],
            231 => ['variation_id' => '40007025','group_id' => 4000702,'product_url' => 'https://i.imgur.com/yFOMP6j.png'],
            232 => ['variation_id' => '40007026','group_id' => 4000702,'product_url' => 'https://i.imgur.com/yFOMP6j.png'],
            233 => ['variation_id' => '40007032','group_id' => 4000703,'product_url' => 'https://i.imgur.com/bC8OiXQ.png'],
            234 => ['variation_id' => '40007033','group_id' => 4000703,'product_url' => 'https://i.imgur.com/bC8OiXQ.png'],
            235 => ['variation_id' => '40007034','group_id' => 4000703,'product_url' => 'https://i.imgur.com/bC8OiXQ.png'],
            236 => ['variation_id' => '40007035','group_id' => 4000703,'product_url' => 'https://i.imgur.com/bC8OiXQ.png'],
            237 => ['variation_id' => '40007036','group_id' => 4000703,'product_url' => 'https://i.imgur.com/bC8OiXQ.png'],
            238 => ['variation_id' => '40007041','group_id' => 4000704,'product_url' => 'https://i.imgur.com/J1AuTBy.jpg'],
            239 => ['variation_id' => '40007042','group_id' => 4000704,'product_url' => 'https://i.imgur.com/J1AuTBy.jpg'],
            240 => ['variation_id' => '40007043','group_id' => 4000704,'product_url' => 'https://i.imgur.com/J1AuTBy.jpg'],
            241 => ['variation_id' => '40007044','group_id' => 4000704,'product_url' => 'https://i.imgur.com/J1AuTBy.jpg'],
            242 => ['variation_id' => '40007045','group_id' => 4000704,'product_url' => 'https://i.imgur.com/J1AuTBy.jpg'],
            243 => ['variation_id' => '40007046','group_id' => 4000704,'product_url' => 'https://i.imgur.com/J1AuTBy.jpg'],
            244 => ['variation_id' => '40007091','group_id' => 4000709,'product_url' => 'https://i.imgur.com/0gXrYvv.jpg'],
            245 => ['variation_id' => '40007092','group_id' => 4000709,'product_url' => 'https://i.imgur.com/0gXrYvv.jpg'],
            246 => ['variation_id' => '40007093','group_id' => 4000709,'product_url' => 'https://i.imgur.com/0gXrYvv.jpg'],
            247 => ['variation_id' => '40007094','group_id' => 4000709,'product_url' => 'https://i.imgur.com/0gXrYvv.jpg'],
            248 => ['variation_id' => '40007095','group_id' => 4000709,'product_url' => 'https://i.imgur.com/0gXrYvv.jpg'],
            249 => ['variation_id' => '40007096','group_id' => 4000709,'product_url' => 'https://i.imgur.com/0gXrYvv.jpg'],
            250 => ['variation_id' => '40007111','group_id' => 4000711,'product_url' => 'https://i.imgur.com/A2OhPle.jpg'],
            251 => ['variation_id' => '40007112','group_id' => 4000711,'product_url' => 'https://i.imgur.com/A2OhPle.jpg'],
            252 => ['variation_id' => '40007113','group_id' => 4000711,'product_url' => 'https://i.imgur.com/A2OhPle.jpg'],
            253 => ['variation_id' => '40007114','group_id' => 4000711,'product_url' => 'https://i.imgur.com/A2OhPle.jpg'],
            254 => ['variation_id' => '40007115','group_id' => 4000711,'product_url' => 'https://i.imgur.com/A2OhPle.jpg'],
            255 => ['variation_id' => '40007116','group_id' => 4000711,'product_url' => 'https://i.imgur.com/A2OhPle.jpg'],
            256 => ['variation_id' => '40008012','group_id' => 4000801,'product_url' => 'https://m.media-amazon.com/images/I/61Ugv9MmgnS.jpg'],
            257 => ['variation_id' => '40008013','group_id' => 4000801,'product_url' => 'https://m.media-amazon.com/images/I/61Ugv9MmgnS.jpg'],
            258 => ['variation_id' => '40008014','group_id' => 4000801,'product_url' => 'https://m.media-amazon.com/images/I/61Ugv9MmgnS.jpg'],
            259 => ['variation_id' => '40008015','group_id' => 4000801,'product_url' => 'https://m.media-amazon.com/images/I/61Ugv9MmgnS.jpg'],
            260 => ['variation_id' => '40008016','group_id' => 4000801,'product_url' => 'https://m.media-amazon.com/images/I/61Ugv9MmgnS.jpg'],
            261 => ['variation_id' => '40008022','group_id' => 4000802,'product_url' => 'https://m.media-amazon.com/images/I/513ezSFbIEL.jpg'],
            262 => ['variation_id' => '40008023','group_id' => 4000802,'product_url' => 'https://m.media-amazon.com/images/I/513ezSFbIEL.jpg'],
            263 => ['variation_id' => '40008024','group_id' => 4000802,'product_url' => 'https://m.media-amazon.com/images/I/513ezSFbIEL.jpg'],
            264 => ['variation_id' => '40008025','group_id' => 4000802,'product_url' => 'https://m.media-amazon.com/images/I/513ezSFbIEL.jpg'],
            265 => ['variation_id' => '40008026','group_id' => 4000802,'product_url' => 'https://m.media-amazon.com/images/I/513ezSFbIEL.jpg'],
            266 => ['variation_id' => '40008032','group_id' => 4000803,'product_url' => 'https://m.media-amazon.com/images/I/51yRljqyonL.jpg'],
            267 => ['variation_id' => '40008033','group_id' => 4000803,'product_url' => 'https://m.media-amazon.com/images/I/51yRljqyonL.jpg'],
            268 => ['variation_id' => '40008034','group_id' => 4000803,'product_url' => 'https://m.media-amazon.com/images/I/51yRljqyonL.jpg'],
            269 => ['variation_id' => '40008035','group_id' => 4000803,'product_url' => 'https://m.media-amazon.com/images/I/51yRljqyonL.jpg'],
            270 => ['variation_id' => '40008036','group_id' => 4000803,'product_url' => 'https://m.media-amazon.com/images/I/51yRljqyonL.jpg'],
            271 => ['variation_id' => '40008042','group_id' => 4000804,'product_url' => 'https://m.media-amazon.com/images/I/410p-amRJjL.jpg'],
            272 => ['variation_id' => '40008043','group_id' => 4000804,'product_url' => 'https://m.media-amazon.com/images/I/410p-amRJjL.jpg'],
            273 => ['variation_id' => '40008044','group_id' => 4000804,'product_url' => 'https://m.media-amazon.com/images/I/410p-amRJjL.jpg'],
            274 => ['variation_id' => '40008045','group_id' => 4000804,'product_url' => 'https://m.media-amazon.com/images/I/410p-amRJjL.jpg'],
            275 => ['variation_id' => '40008046','group_id' => 4000804,'product_url' => 'https://m.media-amazon.com/images/I/410p-amRJjL.jpg'],
            276 => ['variation_id' => '40008091','group_id' => 4000809,'product_url' => 'https://i.imgur.com/pf4nnVw.jpg'],
            277 => ['variation_id' => '40008092','group_id' => 4000809,'product_url' => 'https://i.imgur.com/pf4nnVw.jpg'],
            278 => ['variation_id' => '40008093','group_id' => 4000809,'product_url' => 'https://i.imgur.com/pf4nnVw.jpg'],
            279 => ['variation_id' => '40008094','group_id' => 4000809,'product_url' => 'https://i.imgur.com/pf4nnVw.jpg'],
            280 => ['variation_id' => '40008095','group_id' => 4000809,'product_url' => 'https://i.imgur.com/pf4nnVw.jpg'],
            281 => ['variation_id' => '40008096','group_id' => 4000809,'product_url' => 'https://i.imgur.com/pf4nnVw.jpg'],
            282 => ['variation_id' => '40009012','group_id' => 4000901,'product_url' => 'https://m.media-amazon.com/images/I/61-ZgLsWq4L.jpg'],
            283 => ['variation_id' => '40009013','group_id' => 4000901,'product_url' => 'https://m.media-amazon.com/images/I/61-ZgLsWq4L.jpg'],
            284 => ['variation_id' => '40009014','group_id' => 4000901,'product_url' => 'https://m.media-amazon.com/images/I/61-ZgLsWq4L.jpg'],
            285 => ['variation_id' => '40009015','group_id' => 4000901,'product_url' => 'https://m.media-amazon.com/images/I/61-ZgLsWq4L.jpg'],
            286 => ['variation_id' => '40009016','group_id' => 4000901,'product_url' => 'https://m.media-amazon.com/images/I/61-ZgLsWq4L.jpg'],
            287 => ['variation_id' => '40009022','group_id' => 4000902,'product_url' => 'https://m.media-amazon.com/images/I/616CBKZH-OL.jpg'],
            288 => ['variation_id' => '40009023','group_id' => 4000902,'product_url' => 'https://m.media-amazon.com/images/I/616CBKZH-OL.jpg'],
            289 => ['variation_id' => '40009024','group_id' => 4000902,'product_url' => 'https://m.media-amazon.com/images/I/616CBKZH-OL.jpg'],
            290 => ['variation_id' => '40009025','group_id' => 4000902,'product_url' => 'https://m.media-amazon.com/images/I/616CBKZH-OL.jpg'],
            291 => ['variation_id' => '40009026','group_id' => 4000902,'product_url' => 'https://m.media-amazon.com/images/I/616CBKZH-OL.jpg'],
            292 => ['variation_id' => '40009062','group_id' => 4000906,'product_url' => 'https://m.media-amazon.com/images/I/51dRQ+8u1yL.jpg'],
            293 => ['variation_id' => '40009063','group_id' => 4000906,'product_url' => 'https://m.media-amazon.com/images/I/51dRQ+8u1yL.jpg'],
            294 => ['variation_id' => '40009064','group_id' => 4000906,'product_url' => 'https://m.media-amazon.com/images/I/51dRQ+8u1yL.jpg'],
            295 => ['variation_id' => '40009065','group_id' => 4000906,'product_url' => 'https://m.media-amazon.com/images/I/51dRQ+8u1yL.jpg'],
            296 => ['variation_id' => '40009066','group_id' => 4000906,'product_url' => 'https://m.media-amazon.com/images/I/51dRQ+8u1yL.jpg'],
            297 => ['variation_id' => '40009092','group_id' => 4000909,'product_url' => 'https://m.media-amazon.com/images/I/61waQ-R8CEL.jpg'],
            298 => ['variation_id' => '40009093','group_id' => 4000909,'product_url' => 'https://m.media-amazon.com/images/I/61waQ-R8CEL.jpg'],
            299 => ['variation_id' => '40009094','group_id' => 4000909,'product_url' => 'https://m.media-amazon.com/images/I/61waQ-R8CEL.jpg'],
            300 => ['variation_id' => '40009095','group_id' => 4000909,'product_url' => 'https://m.media-amazon.com/images/I/61waQ-R8CEL.jpg'],
            301 => ['variation_id' => '40009096','group_id' => 4000909,'product_url' => 'https://m.media-amazon.com/images/I/61waQ-R8CEL.jpg'],
            302 => ['variation_id' => '40009161','group_id' => 4000916,'product_url' => 'https://m.media-amazon.com/images/I/51ILnxTPqsL.jpg'],
            303 => ['variation_id' => '40009162','group_id' => 4000916,'product_url' => 'https://m.media-amazon.com/images/I/51ILnxTPqsL.jpg'],
            304 => ['variation_id' => '40009163','group_id' => 4000916,'product_url' => 'https://m.media-amazon.com/images/I/51ILnxTPqsL.jpg'],
            305 => ['variation_id' => '40009164','group_id' => 4000916,'product_url' => 'https://m.media-amazon.com/images/I/51ILnxTPqsL.jpg'],
            306 => ['variation_id' => '40009165','group_id' => 4000916,'product_url' => 'https://m.media-amazon.com/images/I/51ILnxTPqsL.jpg'],
            307 => ['variation_id' => '40009166','group_id' => 4000916,'product_url' => 'https://m.media-amazon.com/images/I/51ILnxTPqsL.jpg'],
            308 => ['variation_id' => '40010012','group_id' => 4001001,'product_url' => 'https://m.media-amazon.com/images/I/41LivpP2JoL.jpg'],
            309 => ['variation_id' => '40010013','group_id' => 4001001,'product_url' => 'https://m.media-amazon.com/images/I/41LivpP2JoL.jpg'],
            310 => ['variation_id' => '40010014','group_id' => 4001001,'product_url' => 'https://m.media-amazon.com/images/I/41LivpP2JoL.jpg'],
            311 => ['variation_id' => '40010015','group_id' => 4001001,'product_url' => 'https://m.media-amazon.com/images/I/41LivpP2JoL.jpg'],
            312 => ['variation_id' => '40010016','group_id' => 4001001,'product_url' => 'https://m.media-amazon.com/images/I/41LivpP2JoL.jpg'],
            313 => ['variation_id' => '40010022','group_id' => 4001002,'product_url' => 'https://m.media-amazon.com/images/I/61rH1YsCWuL.jpg'],
            314 => ['variation_id' => '40010023','group_id' => 4001002,'product_url' => 'https://m.media-amazon.com/images/I/61rH1YsCWuL.jpg'],
            315 => ['variation_id' => '40010024','group_id' => 4001002,'product_url' => 'https://m.media-amazon.com/images/I/61rH1YsCWuL.jpg'],
            316 => ['variation_id' => '40010025','group_id' => 4001002,'product_url' => 'https://m.media-amazon.com/images/I/61rH1YsCWuL.jpg'],
            317 => ['variation_id' => '40010026','group_id' => 4001002,'product_url' => 'https://m.media-amazon.com/images/I/61rH1YsCWuL.jpg'],
            318 => ['variation_id' => '40010062','group_id' => 4001006,'product_url' => 'https://m.media-amazon.com/images/I/61d8PWOd1-S.jpg'],
            319 => ['variation_id' => '40010063','group_id' => 4001006,'product_url' => 'https://m.media-amazon.com/images/I/61d8PWOd1-S.jpg'],
            320 => ['variation_id' => '40010064','group_id' => 4001006,'product_url' => 'https://m.media-amazon.com/images/I/61d8PWOd1-S.jpg'],
            321 => ['variation_id' => '40010065','group_id' => 4001006,'product_url' => 'https://m.media-amazon.com/images/I/61d8PWOd1-S.jpg'],
            322 => ['variation_id' => '40010066','group_id' => 4001006,'product_url' => 'https://m.media-amazon.com/images/I/61d8PWOd1-S.jpg'],
            323 => ['variation_id' => '40010092','group_id' => 4001009,'product_url' => 'https://m.media-amazon.com/images/I/61IgpHSGfYL.jpg'],
            324 => ['variation_id' => '40010093','group_id' => 4001009,'product_url' => 'https://m.media-amazon.com/images/I/61IgpHSGfYL.jpg'],
            325 => ['variation_id' => '40010094','group_id' => 4001009,'product_url' => 'https://m.media-amazon.com/images/I/61IgpHSGfYL.jpg'],
            326 => ['variation_id' => '40010095','group_id' => 4001009,'product_url' => 'https://m.media-amazon.com/images/I/61IgpHSGfYL.jpg'],
            327 => ['variation_id' => '40010096','group_id' => 4001009,'product_url' => 'https://m.media-amazon.com/images/I/61IgpHSGfYL.jpg'],
            328 => ['variation_id' => '40010161','group_id' => 4001016,'product_url' => 'https://m.media-amazon.com/images/I/51pDegYOI4L.jpg'],
            329 => ['variation_id' => '40010162','group_id' => 4001016,'product_url' => 'https://m.media-amazon.com/images/I/51pDegYOI4L.jpg'],
            330 => ['variation_id' => '40010163','group_id' => 4001016,'product_url' => 'https://m.media-amazon.com/images/I/51pDegYOI4L.jpg'],
            331 => ['variation_id' => '40010164','group_id' => 4001016,'product_url' => 'https://m.media-amazon.com/images/I/51pDegYOI4L.jpg'],
            332 => ['variation_id' => '40010165','group_id' => 4001016,'product_url' => 'https://m.media-amazon.com/images/I/51pDegYOI4L.jpg'],
            333 => ['variation_id' => '40010166','group_id' => 4001016,'product_url' => 'https://m.media-amazon.com/images/I/51pDegYOI4L.jpg'],
            334 => ['variation_id' => '40011022','group_id' => 4001102,'product_url' => 'https://m.media-amazon.com/images/I/617ZVHipe7L.jpg'],
            335 => ['variation_id' => '40011023','group_id' => 4001102,'product_url' => 'https://m.media-amazon.com/images/I/617ZVHipe7L.jpg'],
            336 => ['variation_id' => '40011024','group_id' => 4001102,'product_url' => 'https://m.media-amazon.com/images/I/617ZVHipe7L.jpg'],
            337 => ['variation_id' => '40011025','group_id' => 4001102,'product_url' => 'https://m.media-amazon.com/images/I/617ZVHipe7L.jpg'],
            338 => ['variation_id' => '40011026','group_id' => 4001102,'product_url' => 'https://m.media-amazon.com/images/I/617ZVHipe7L.jpg'],
            339 => ['variation_id' => '40011032','group_id' => 4001103,'product_url' => 'https://m.media-amazon.com/images/I/61b+EtgGUsL.jpg'],
            340 => ['variation_id' => '40011033','group_id' => 4001103,'product_url' => 'https://m.media-amazon.com/images/I/61b+EtgGUsL.jpg'],
            341 => ['variation_id' => '40011034','group_id' => 4001103,'product_url' => 'https://m.media-amazon.com/images/I/61b+EtgGUsL.jpg'],
            342 => ['variation_id' => '40011035','group_id' => 4001103,'product_url' => 'https://m.media-amazon.com/images/I/61b+EtgGUsL.jpg'],
            343 => ['variation_id' => '40011036','group_id' => 4001103,'product_url' => 'https://m.media-amazon.com/images/I/61b+EtgGUsL.jpg'],
            344 => ['variation_id' => '40011052','group_id' => 4001105,'product_url' => 'https://m.media-amazon.com/images/I/71lVS70AnxL.jpg'],
            345 => ['variation_id' => '40011053','group_id' => 4001105,'product_url' => 'https://m.media-amazon.com/images/I/71lVS70AnxL.jpg'],
            346 => ['variation_id' => '40011054','group_id' => 4001105,'product_url' => 'https://m.media-amazon.com/images/I/71lVS70AnxL.jpg'],
            347 => ['variation_id' => '40011055','group_id' => 4001105,'product_url' => 'https://m.media-amazon.com/images/I/71lVS70AnxL.jpg'],
            348 => ['variation_id' => '40011056','group_id' => 4001105,'product_url' => 'https://m.media-amazon.com/images/I/71lVS70AnxL.jpg'],
            349 => ['variation_id' => '40011061','group_id' => 4001106,'product_url' => 'https://m.media-amazon.com/images/I/61YTzD6lm2L.jpg'],
            350 => ['variation_id' => '40011062','group_id' => 4001106,'product_url' => 'https://m.media-amazon.com/images/I/61YTzD6lm2L.jpg'],
            351 => ['variation_id' => '40011063','group_id' => 4001106,'product_url' => 'https://m.media-amazon.com/images/I/61YTzD6lm2L.jpg'],
            352 => ['variation_id' => '40011064','group_id' => 4001106,'product_url' => 'https://m.media-amazon.com/images/I/61YTzD6lm2L.jpg'],
            353 => ['variation_id' => '40011065','group_id' => 4001106,'product_url' => 'https://m.media-amazon.com/images/I/61YTzD6lm2L.jpg'],
            354 => ['variation_id' => '40011066','group_id' => 4001106,'product_url' => 'https://m.media-amazon.com/images/I/61YTzD6lm2L.jpg'],
            355 => ['variation_id' => '40011072','group_id' => 4001107,'product_url' => 'https://m.media-amazon.com/images/I/81ecN-BqVYL.jpg'],
            356 => ['variation_id' => '40011073','group_id' => 4001107,'product_url' => 'https://m.media-amazon.com/images/I/81ecN-BqVYL.jpg'],
            357 => ['variation_id' => '40011074','group_id' => 4001107,'product_url' => 'https://m.media-amazon.com/images/I/81ecN-BqVYL.jpg'],
            358 => ['variation_id' => '40011075','group_id' => 4001107,'product_url' => 'https://m.media-amazon.com/images/I/81ecN-BqVYL.jpg'],
            359 => ['variation_id' => '40011076','group_id' => 4001107,'product_url' => 'https://m.media-amazon.com/images/I/81ecN-BqVYL.jpg'],
            360 => ['variation_id' => '40011161','group_id' => 4001116,'product_url' => 'https://m.media-amazon.com/images/I/61PQrq0rq8L.jpg'],
            361 => ['variation_id' => '40011162','group_id' => 4001116,'product_url' => 'https://m.media-amazon.com/images/I/61PQrq0rq8L.jpg'],
            362 => ['variation_id' => '40011163','group_id' => 4001116,'product_url' => 'https://m.media-amazon.com/images/I/61PQrq0rq8L.jpg'],
            363 => ['variation_id' => '40011164','group_id' => 4001116,'product_url' => 'https://m.media-amazon.com/images/I/61PQrq0rq8L.jpg'],
            364 => ['variation_id' => '40011165','group_id' => 4001116,'product_url' => 'https://m.media-amazon.com/images/I/61PQrq0rq8L.jpg'],
            365 => ['variation_id' => '40011166','group_id' => 4001116,'product_url' => 'https://m.media-amazon.com/images/I/61PQrq0rq8L.jpg'],
            366 => ['variation_id' => '40012022','group_id' => 4001202,'product_url' => 'https://m.media-amazon.com/images/I/61-he1hj6XL.jpg'],
            367 => ['variation_id' => '40012023','group_id' => 4001202,'product_url' => 'https://m.media-amazon.com/images/I/61-he1hj6XL.jpg'],
            368 => ['variation_id' => '40012024','group_id' => 4001202,'product_url' => 'https://m.media-amazon.com/images/I/61-he1hj6XL.jpg'],
            369 => ['variation_id' => '40012025','group_id' => 4001202,'product_url' => 'https://m.media-amazon.com/images/I/61-he1hj6XL.jpg'],
            370 => ['variation_id' => '40012026','group_id' => 4001202,'product_url' => 'https://m.media-amazon.com/images/I/61-he1hj6XL.jpg'],
            371 => ['variation_id' => '40012032','group_id' => 4001203,'product_url' => 'https://m.media-amazon.com/images/I/61bs6k6gH0L.jpg'],
            372 => ['variation_id' => '40012033','group_id' => 4001203,'product_url' => 'https://m.media-amazon.com/images/I/61bs6k6gH0L.jpg'],
            373 => ['variation_id' => '40012034','group_id' => 4001203,'product_url' => 'https://m.media-amazon.com/images/I/61bs6k6gH0L.jpg'],
            374 => ['variation_id' => '40012035','group_id' => 4001203,'product_url' => 'https://m.media-amazon.com/images/I/61bs6k6gH0L.jpg'],
            375 => ['variation_id' => '40012036','group_id' => 4001203,'product_url' => 'https://m.media-amazon.com/images/I/61bs6k6gH0L.jpg'],
            376 => ['variation_id' => '40012052','group_id' => 4001205,'product_url' => 'https://m.media-amazon.com/images/I/71tudyXEt4L.jpg'],
            377 => ['variation_id' => '40012053','group_id' => 4001205,'product_url' => 'https://m.media-amazon.com/images/I/71tudyXEt4L.jpg'],
            378 => ['variation_id' => '40012054','group_id' => 4001205,'product_url' => 'https://m.media-amazon.com/images/I/71tudyXEt4L.jpg'],
            379 => ['variation_id' => '40012055','group_id' => 4001205,'product_url' => 'https://m.media-amazon.com/images/I/71tudyXEt4L.jpg'],
            380 => ['variation_id' => '40012056','group_id' => 4001205,'product_url' => 'https://m.media-amazon.com/images/I/71tudyXEt4L.jpg'],
            381 => ['variation_id' => '40012061','group_id' => 4001206,'product_url' => 'https://m.media-amazon.com/images/I/610FgHgV5ML.jpg'],
            382 => ['variation_id' => '40012062','group_id' => 4001206,'product_url' => 'https://m.media-amazon.com/images/I/610FgHgV5ML.jpg'],
            383 => ['variation_id' => '40012063','group_id' => 4001206,'product_url' => 'https://m.media-amazon.com/images/I/610FgHgV5ML.jpg'],
            384 => ['variation_id' => '40012064','group_id' => 4001206,'product_url' => 'https://m.media-amazon.com/images/I/610FgHgV5ML.jpg'],
            385 => ['variation_id' => '40012065','group_id' => 4001206,'product_url' => 'https://m.media-amazon.com/images/I/610FgHgV5ML.jpg'],
            386 => ['variation_id' => '40012066','group_id' => 4001206,'product_url' => 'https://m.media-amazon.com/images/I/610FgHgV5ML.jpg'],
            387 => ['variation_id' => '40012072','group_id' => 4001207,'product_url' => 'https://m.media-amazon.com/images/I/81DoRhZeopL.jpg'],
            388 => ['variation_id' => '40012073','group_id' => 4001207,'product_url' => 'https://m.media-amazon.com/images/I/81DoRhZeopL.jpg'],
            389 => ['variation_id' => '40012074','group_id' => 4001207,'product_url' => 'https://m.media-amazon.com/images/I/81DoRhZeopL.jpg'],
            390 => ['variation_id' => '40012075','group_id' => 4001207,'product_url' => 'https://m.media-amazon.com/images/I/81DoRhZeopL.jpg'],
            391 => ['variation_id' => '40012076','group_id' => 4001207,'product_url' => 'https://m.media-amazon.com/images/I/81DoRhZeopL.jpg'],
            392 => ['variation_id' => '40012161','group_id' => 4001216,'product_url' => 'https://m.media-amazon.com/images/I/61e5SkHlX-L.jpg'],
            393 => ['variation_id' => '40012162','group_id' => 4001216,'product_url' => 'https://m.media-amazon.com/images/I/61e5SkHlX-L.jpg'],
            394 => ['variation_id' => '40012163','group_id' => 4001216,'product_url' => 'https://m.media-amazon.com/images/I/61e5SkHlX-L.jpg'],
            395 => ['variation_id' => '40012164','group_id' => 4001216,'product_url' => 'https://m.media-amazon.com/images/I/61e5SkHlX-L.jpg'],
            396 => ['variation_id' => '40012165','group_id' => 4001216,'product_url' => 'https://m.media-amazon.com/images/I/61e5SkHlX-L.jpg'],
            397 => ['variation_id' => '40012166','group_id' => 4001216,'product_url' => 'https://m.media-amazon.com/images/I/61e5SkHlX-L.jpg'],
            398 => ['variation_id' => '40013012','group_id' => 4001301,'product_url' => 'https://m.media-amazon.com/images/I/712zxbjbvaL.jpg'],
            399 => ['variation_id' => '40013013','group_id' => 4001301,'product_url' => 'https://m.media-amazon.com/images/I/712zxbjbvaL.jpg'],
            400 => ['variation_id' => '40013014','group_id' => 4001301,'product_url' => 'https://m.media-amazon.com/images/I/712zxbjbvaL.jpg'],
            401 => ['variation_id' => '40013015','group_id' => 4001301,'product_url' => 'https://m.media-amazon.com/images/I/712zxbjbvaL.jpg'],
            402 => ['variation_id' => '40013016','group_id' => 4001301,'product_url' => 'https://m.media-amazon.com/images/I/712zxbjbvaL.jpg'],
            403 => ['variation_id' => '40014022','group_id' => 4001402,'product_url' => 'https://m.media-amazon.com/images/I/61hVt9zaY6S.jpg'],
            404 => ['variation_id' => '40014023','group_id' => 4001402,'product_url' => 'https://m.media-amazon.com/images/I/61hVt9zaY6S.jpg'],
            405 => ['variation_id' => '40014024','group_id' => 4001402,'product_url' => 'https://m.media-amazon.com/images/I/61hVt9zaY6S.jpg'],
            406 => ['variation_id' => '40014025','group_id' => 4001402,'product_url' => 'https://m.media-amazon.com/images/I/61hVt9zaY6S.jpg'],
            407 => ['variation_id' => '40014026','group_id' => 4001402,'product_url' => 'https://m.media-amazon.com/images/I/61hVt9zaY6S.jpg'],
            408 => ['variation_id' => '40014032','group_id' => 4001403,'product_url' => 'https://m.media-amazon.com/images/I/61rX9MPL4fS.jpg'],
            409 => ['variation_id' => '40014033','group_id' => 4001403,'product_url' => 'https://m.media-amazon.com/images/I/61rX9MPL4fS.jpg'],
            410 => ['variation_id' => '40014034','group_id' => 4001403,'product_url' => 'https://m.media-amazon.com/images/I/61rX9MPL4fS.jpg'],
            411 => ['variation_id' => '40014035','group_id' => 4001403,'product_url' => 'https://m.media-amazon.com/images/I/61rX9MPL4fS.jpg'],
            412 => ['variation_id' => '40014036','group_id' => 4001403,'product_url' => 'https://m.media-amazon.com/images/I/61rX9MPL4fS.jpg'],
            413 => ['variation_id' => '40014052','group_id' => 4001405,'product_url' => 'https://m.media-amazon.com/images/I/61f3OnPQZSS.jpg'],
            414 => ['variation_id' => '40014053','group_id' => 4001405,'product_url' => 'https://m.media-amazon.com/images/I/61f3OnPQZSS.jpg'],
            415 => ['variation_id' => '40014054','group_id' => 4001405,'product_url' => 'https://m.media-amazon.com/images/I/61f3OnPQZSS.jpg'],
            416 => ['variation_id' => '40014055','group_id' => 4001405,'product_url' => 'https://m.media-amazon.com/images/I/61f3OnPQZSS.jpg'],
            417 => ['variation_id' => '40014056','group_id' => 4001405,'product_url' => 'https://m.media-amazon.com/images/I/61f3OnPQZSS.jpg'],
            418 => ['variation_id' => '40015012','group_id' => 4001501,'product_url' => 'https://m.media-amazon.com/images/I/61IJGV6VrHL.jpg'],
            419 => ['variation_id' => '40015013','group_id' => 4001501,'product_url' => 'https://m.media-amazon.com/images/I/61IJGV6VrHL.jpg'],
            420 => ['variation_id' => '40015014','group_id' => 4001501,'product_url' => 'https://m.media-amazon.com/images/I/61IJGV6VrHL.jpg'],
            421 => ['variation_id' => '40015015','group_id' => 4001501,'product_url' => 'https://m.media-amazon.com/images/I/61IJGV6VrHL.jpg'],
            422 => ['variation_id' => '40015016','group_id' => 4001501,'product_url' => 'https://m.media-amazon.com/images/I/61IJGV6VrHL.jpg'],
            423 => ['variation_id' => '40015022','group_id' => 4001502,'product_url' => 'https://m.media-amazon.com/images/I/61nqnh65AdL.jpg'],
            424 => ['variation_id' => '40015023','group_id' => 4001502,'product_url' => 'https://m.media-amazon.com/images/I/61nqnh65AdL.jpg'],
            425 => ['variation_id' => '40015024','group_id' => 4001502,'product_url' => 'https://m.media-amazon.com/images/I/61nqnh65AdL.jpg'],
            426 => ['variation_id' => '40015025','group_id' => 4001502,'product_url' => 'https://m.media-amazon.com/images/I/61nqnh65AdL.jpg'],
            427 => ['variation_id' => '40015026','group_id' => 4001502,'product_url' => 'https://m.media-amazon.com/images/I/61nqnh65AdL.jpg'],
            428 => ['variation_id' => '40015032','group_id' => 4001503,'product_url' => 'https://m.media-amazon.com/images/I/61l7Ilb13aL.jpg'],
            429 => ['variation_id' => '40015033','group_id' => 4001503,'product_url' => 'https://m.media-amazon.com/images/I/61l7Ilb13aL.jpg'],
            430 => ['variation_id' => '40015034','group_id' => 4001503,'product_url' => 'https://m.media-amazon.com/images/I/61l7Ilb13aL.jpg'],
            431 => ['variation_id' => '40015035','group_id' => 4001503,'product_url' => 'https://m.media-amazon.com/images/I/61l7Ilb13aL.jpg'],
            432 => ['variation_id' => '40015036','group_id' => 4001503,'product_url' => 'https://m.media-amazon.com/images/I/61l7Ilb13aL.jpg'],
            433 => ['variation_id' => '40015052','group_id' => 4001505,'product_url' => 'https://m.media-amazon.com/images/I/71jBbTIl-VL.jpg'],
            434 => ['variation_id' => '40015053','group_id' => 4001505,'product_url' => 'https://m.media-amazon.com/images/I/71jBbTIl-VL.jpg'],
            435 => ['variation_id' => '40015054','group_id' => 4001505,'product_url' => 'https://m.media-amazon.com/images/I/71jBbTIl-VL.jpg'],
            436 => ['variation_id' => '40015055','group_id' => 4001505,'product_url' => 'https://m.media-amazon.com/images/I/71jBbTIl-VL.jpg'],
            437 => ['variation_id' => '40015056','group_id' => 4001505,'product_url' => 'https://m.media-amazon.com/images/I/71jBbTIl-VL.jpg'],
            438 => ['variation_id' => '40016012','group_id' => 4001601,'product_url' => 'https://m.media-amazon.com/images/I/51ab1QzoxjS.jpg'],
            439 => ['variation_id' => '40016013','group_id' => 4001601,'product_url' => 'https://m.media-amazon.com/images/I/51ab1QzoxjS.jpg'],
            440 => ['variation_id' => '40016014','group_id' => 4001601,'product_url' => 'https://m.media-amazon.com/images/I/51ab1QzoxjS.jpg'],
            441 => ['variation_id' => '40016015','group_id' => 4001601,'product_url' => 'https://m.media-amazon.com/images/I/51ab1QzoxjS.jpg'],
            442 => ['variation_id' => '40016016','group_id' => 4001601,'product_url' => 'https://m.media-amazon.com/images/I/51ab1QzoxjS.jpg'],
            443 => ['variation_id' => '40016022','group_id' => 4001602,'product_url' => 'https://m.media-amazon.com/images/I/61-GorMuynS.jpg'],
            444 => ['variation_id' => '40016023','group_id' => 4001602,'product_url' => 'https://m.media-amazon.com/images/I/61-GorMuynS.jpg'],
            445 => ['variation_id' => '40016024','group_id' => 4001602,'product_url' => 'https://m.media-amazon.com/images/I/61-GorMuynS.jpg'],
            446 => ['variation_id' => '40016025','group_id' => 4001602,'product_url' => 'https://m.media-amazon.com/images/I/61-GorMuynS.jpg'],
            447 => ['variation_id' => '40016026','group_id' => 4001602,'product_url' => 'https://m.media-amazon.com/images/I/61-GorMuynS.jpg'],
            448 => ['variation_id' => '40018011','group_id' => 4001801,'product_url' => 'https://m.media-amazon.com/images/I/71371VfV1GL.jpg'],
            449 => ['variation_id' => '40018012','group_id' => 4001801,'product_url' => 'https://m.media-amazon.com/images/I/71371VfV1GL.jpg'],
            450 => ['variation_id' => '40018013','group_id' => 4001801,'product_url' => 'https://m.media-amazon.com/images/I/71371VfV1GL.jpg'],
            451 => ['variation_id' => '40018014','group_id' => 4001801,'product_url' => 'https://m.media-amazon.com/images/I/71371VfV1GL.jpg'],
            452 => ['variation_id' => '40018015','group_id' => 4001801,'product_url' => 'https://m.media-amazon.com/images/I/71371VfV1GL.jpg'],
            453 => ['variation_id' => '40018016','group_id' => 4001801,'product_url' => 'https://m.media-amazon.com/images/I/71371VfV1GL.jpg'],
            454 => ['variation_id' => '40018022','group_id' => 4001802,'product_url' => 'https://m.media-amazon.com/images/I/313p4mJQyDL.jpg'],
            455 => ['variation_id' => '40018023','group_id' => 4001802,'product_url' => 'https://m.media-amazon.com/images/I/313p4mJQyDL.jpg'],
            456 => ['variation_id' => '40018024','group_id' => 4001802,'product_url' => 'https://m.media-amazon.com/images/I/313p4mJQyDL.jpg'],
            457 => ['variation_id' => '40018025','group_id' => 4001802,'product_url' => 'https://m.media-amazon.com/images/I/313p4mJQyDL.jpg'],
            458 => ['variation_id' => '40018026','group_id' => 4001802,'product_url' => 'https://m.media-amazon.com/images/I/313p4mJQyDL.jpg'],
            459 => ['variation_id' => '40018042','group_id' => 4001804,'product_url' => 'https://m.media-amazon.com/images/I/41jkoNBSi7L.jpg'],
            460 => ['variation_id' => '40018043','group_id' => 4001804,'product_url' => 'https://m.media-amazon.com/images/I/41jkoNBSi7L.jpg'],
            461 => ['variation_id' => '40018044','group_id' => 4001804,'product_url' => 'https://m.media-amazon.com/images/I/41jkoNBSi7L.jpg'],
            462 => ['variation_id' => '40018045','group_id' => 4001804,'product_url' => 'https://m.media-amazon.com/images/I/41jkoNBSi7L.jpg'],
            463 => ['variation_id' => '40018046','group_id' => 4001804,'product_url' => 'https://m.media-amazon.com/images/I/41jkoNBSi7L.jpg'],
            464 => ['variation_id' => '40018052','group_id' => 4001805,'product_url' => 'https://m.media-amazon.com/images/I/312FbB9lI1L.jpg'],
            465 => ['variation_id' => '40018053','group_id' => 4001805,'product_url' => 'https://m.media-amazon.com/images/I/312FbB9lI1L.jpg'],
            466 => ['variation_id' => '40018054','group_id' => 4001805,'product_url' => 'https://m.media-amazon.com/images/I/312FbB9lI1L.jpg'],
            467 => ['variation_id' => '40018055','group_id' => 4001805,'product_url' => 'https://m.media-amazon.com/images/I/312FbB9lI1L.jpg'],
            468 => ['variation_id' => '40018056','group_id' => 4001805,'product_url' => 'https://m.media-amazon.com/images/I/312FbB9lI1L.jpg'],
            469 => ['variation_id' => '40018061','group_id' => 4001806,'product_url' => 'https://m.media-amazon.com/images/I/61kFkkaGCHL.jpg'],
            470 => ['variation_id' => '40018062','group_id' => 4001806,'product_url' => 'https://m.media-amazon.com/images/I/61kFkkaGCHL.jpg'],
            471 => ['variation_id' => '40018063','group_id' => 4001806,'product_url' => 'https://m.media-amazon.com/images/I/61kFkkaGCHL.jpg'],
            472 => ['variation_id' => '40018064','group_id' => 4001806,'product_url' => 'https://m.media-amazon.com/images/I/61kFkkaGCHL.jpg'],
            473 => ['variation_id' => '40018065','group_id' => 4001806,'product_url' => 'https://m.media-amazon.com/images/I/61kFkkaGCHL.jpg'],
            474 => ['variation_id' => '40018066','group_id' => 4001806,'product_url' => 'https://m.media-amazon.com/images/I/61kFkkaGCHL.jpg'],
            475 => ['variation_id' => '40018091','group_id' => 4001809,'product_url' => 'https://m.media-amazon.com/images/I/71zlKVTlogS._AC_UL1500_.jpg'],
            476 => ['variation_id' => '40018092','group_id' => 4001809,'product_url' => 'https://m.media-amazon.com/images/I/71zlKVTlogS._AC_UL1500_.jpg'],
            477 => ['variation_id' => '40018093','group_id' => 4001809,'product_url' => 'https://m.media-amazon.com/images/I/71zlKVTlogS._AC_UL1500_.jpg'],
            478 => ['variation_id' => '40018094','group_id' => 4001809,'product_url' => 'https://m.media-amazon.com/images/I/71zlKVTlogS._AC_UL1500_.jpg'],
            479 => ['variation_id' => '40018095','group_id' => 4001809,'product_url' => 'https://m.media-amazon.com/images/I/71zlKVTlogS._AC_UL1500_.jpg'],
            480 => ['variation_id' => '40018096','group_id' => 4001809,'product_url' => 'https://m.media-amazon.com/images/I/71zlKVTlogS._AC_UL1500_.jpg'],
            481 => ['variation_id' => '40018112','group_id' => 4001811,'product_url' => 'https://m.media-amazon.com/images/I/31LV7qbZgSL.jpg'],
            482 => ['variation_id' => '40018113','group_id' => 4001811,'product_url' => 'https://m.media-amazon.com/images/I/31LV7qbZgSL.jpg'],
            483 => ['variation_id' => '40018114','group_id' => 4001811,'product_url' => 'https://m.media-amazon.com/images/I/31LV7qbZgSL.jpg'],
            484 => ['variation_id' => '40018115','group_id' => 4001811,'product_url' => 'https://m.media-amazon.com/images/I/31LV7qbZgSL.jpg'],
            485 => ['variation_id' => '40018116','group_id' => 4001811,'product_url' => 'https://m.media-amazon.com/images/I/31LV7qbZgSL.jpg'],
            486 => ['variation_id' => '40019011','group_id' => 4001901,'product_url' => 'https://m.media-amazon.com/images/I/71rZXdPM6LL.jpg'],
            487 => ['variation_id' => '40019012','group_id' => 4001901,'product_url' => 'https://m.media-amazon.com/images/I/71rZXdPM6LL.jpg'],
            488 => ['variation_id' => '40019013','group_id' => 4001901,'product_url' => 'https://m.media-amazon.com/images/I/71rZXdPM6LL.jpg'],
            489 => ['variation_id' => '40019014','group_id' => 4001901,'product_url' => 'https://m.media-amazon.com/images/I/71rZXdPM6LL.jpg'],
            490 => ['variation_id' => '40019015','group_id' => 4001901,'product_url' => 'https://m.media-amazon.com/images/I/71rZXdPM6LL.jpg'],
            491 => ['variation_id' => '40019016','group_id' => 4001901,'product_url' => 'https://m.media-amazon.com/images/I/71rZXdPM6LL.jpg'],
            492 => ['variation_id' => '40019051','group_id' => 4001905,'product_url' => 'https://m.media-amazon.com/images/I/81a7aRKKO8L.jpg'],
            493 => ['variation_id' => '40019052','group_id' => 4001905,'product_url' => 'https://m.media-amazon.com/images/I/81a7aRKKO8L.jpg'],
            494 => ['variation_id' => '40019053','group_id' => 4001905,'product_url' => 'https://m.media-amazon.com/images/I/81a7aRKKO8L.jpg'],
            495 => ['variation_id' => '40019054','group_id' => 4001905,'product_url' => 'https://m.media-amazon.com/images/I/81a7aRKKO8L.jpg'],
            496 => ['variation_id' => '40019055','group_id' => 4001905,'product_url' => 'https://m.media-amazon.com/images/I/81a7aRKKO8L.jpg'],
            497 => ['variation_id' => '40019056','group_id' => 4001905,'product_url' => 'https://m.media-amazon.com/images/I/81a7aRKKO8L.jpg'],
            498 => ['variation_id' => '40019061','group_id' => 4001906,'product_url' => 'https://m.media-amazon.com/images/I/71vFzjNR9UL.jpg'],
            499 => ['variation_id' => '40019062','group_id' => 4001906,'product_url' => 'https://m.media-amazon.com/images/I/71vFzjNR9UL.jpg'],
            500 => ['variation_id' => '40019063','group_id' => 4001906,'product_url' => 'https://m.media-amazon.com/images/I/71vFzjNR9UL.jpg'],
            501 => ['variation_id' => '40019064','group_id' => 4001906,'product_url' => 'https://m.media-amazon.com/images/I/71vFzjNR9UL.jpg'],
            502 => ['variation_id' => '40019065','group_id' => 4001906,'product_url' => 'https://m.media-amazon.com/images/I/71vFzjNR9UL.jpg'],
            503 => ['variation_id' => '40019066','group_id' => 4001906,'product_url' => 'https://m.media-amazon.com/images/I/71vFzjNR9UL.jpg'],
            504 => ['variation_id' => '40019071','group_id' => 4001907,'product_url' => 'https://m.media-amazon.com/images/I/91sq-m-fBJL.jpg'],
            505 => ['variation_id' => '40019072','group_id' => 4001907,'product_url' => 'https://m.media-amazon.com/images/I/91sq-m-fBJL.jpg'],
            506 => ['variation_id' => '40019073','group_id' => 4001907,'product_url' => 'https://m.media-amazon.com/images/I/91sq-m-fBJL.jpg'],
            507 => ['variation_id' => '40019074','group_id' => 4001907,'product_url' => 'https://m.media-amazon.com/images/I/91sq-m-fBJL.jpg'],
            508 => ['variation_id' => '40019075','group_id' => 4001907,'product_url' => 'https://m.media-amazon.com/images/I/91sq-m-fBJL.jpg'],
            509 => ['variation_id' => '40019076','group_id' => 4001907,'product_url' => 'https://m.media-amazon.com/images/I/91sq-m-fBJL.jpg'],
            510 => ['variation_id' => '40020021','group_id' => 4002002,'product_url' => 'https://m.media-amazon.com/images/I/41okjQrldVL.jpg'],
            511 => ['variation_id' => '40020022','group_id' => 4002002,'product_url' => 'https://m.media-amazon.com/images/I/41okjQrldVL.jpg'],
            512 => ['variation_id' => '40020023','group_id' => 4002002,'product_url' => 'https://m.media-amazon.com/images/I/41okjQrldVL.jpg'],
            513 => ['variation_id' => '40020024','group_id' => 4002002,'product_url' => 'https://m.media-amazon.com/images/I/41okjQrldVL.jpg'],
            514 => ['variation_id' => '40020025','group_id' => 4002002,'product_url' => 'https://m.media-amazon.com/images/I/41okjQrldVL.jpg'],
            515 => ['variation_id' => '40020026','group_id' => 4002002,'product_url' => 'https://m.media-amazon.com/images/I/41okjQrldVL.jpg'],
            516 => ['variation_id' => '40020041','group_id' => 4002004,'product_url' => 'https://m.media-amazon.com/images/I/91TX5cellrL.jpg'],
            517 => ['variation_id' => '40020042','group_id' => 4002004,'product_url' => 'https://m.media-amazon.com/images/I/91TX5cellrL.jpg'],
            518 => ['variation_id' => '40020043','group_id' => 4002004,'product_url' => 'https://m.media-amazon.com/images/I/91TX5cellrL.jpg'],
            519 => ['variation_id' => '40020044','group_id' => 4002004,'product_url' => 'https://m.media-amazon.com/images/I/91TX5cellrL.jpg'],
            520 => ['variation_id' => '40020045','group_id' => 4002004,'product_url' => 'https://m.media-amazon.com/images/I/91TX5cellrL.jpg'],
            521 => ['variation_id' => '40020046','group_id' => 4002004,'product_url' => 'https://m.media-amazon.com/images/I/91TX5cellrL.jpg'],
            522 => ['variation_id' => '40020061','group_id' => 4002006,'product_url' => 'https://m.media-amazon.com/images/I/71z+HOEI3jL.jpg'],
            523 => ['variation_id' => '40020062','group_id' => 4002006,'product_url' => 'https://m.media-amazon.com/images/I/71z+HOEI3jL.jpg'],
            524 => ['variation_id' => '40020063','group_id' => 4002006,'product_url' => 'https://m.media-amazon.com/images/I/71z+HOEI3jL.jpg'],
            525 => ['variation_id' => '40020064','group_id' => 4002006,'product_url' => 'https://m.media-amazon.com/images/I/71z+HOEI3jL.jpg'],
            526 => ['variation_id' => '40020065','group_id' => 4002006,'product_url' => 'https://m.media-amazon.com/images/I/71z+HOEI3jL.jpg'],
            527 => ['variation_id' => '40020066','group_id' => 4002006,'product_url' => 'https://m.media-amazon.com/images/I/71z+HOEI3jL.jpg'],
            528 => ['variation_id' => '40020081','group_id' => 4002008,'product_url' => 'https://m.media-amazon.com/images/I/81gKGfvYh2L.jpg'],
            529 => ['variation_id' => '40020082','group_id' => 4002008,'product_url' => 'https://m.media-amazon.com/images/I/81gKGfvYh2L.jpg'],
            530 => ['variation_id' => '40020083','group_id' => 4002008,'product_url' => 'https://m.media-amazon.com/images/I/81gKGfvYh2L.jpg'],
            531 => ['variation_id' => '40020084','group_id' => 4002008,'product_url' => 'https://m.media-amazon.com/images/I/81gKGfvYh2L.jpg'],
            532 => ['variation_id' => '40020085','group_id' => 4002008,'product_url' => 'https://m.media-amazon.com/images/I/81gKGfvYh2L.jpg'],
            533 => ['variation_id' => '40020086','group_id' => 4002008,'product_url' => 'https://m.media-amazon.com/images/I/81gKGfvYh2L.jpg'],
            534 => ['variation_id' => '40021011','group_id' => 4002101,'product_url' => 'https://i.imgur.com/WrViZ3a.jpg'],
            535 => ['variation_id' => '40021012','group_id' => 4002101,'product_url' => 'https://i.imgur.com/WrViZ3a.jpg'],
            536 => ['variation_id' => '40021013','group_id' => 4002101,'product_url' => 'https://i.imgur.com/WrViZ3a.jpg'],
            537 => ['variation_id' => '40021014','group_id' => 4002101,'product_url' => 'https://i.imgur.com/WrViZ3a.jpg'],
            538 => ['variation_id' => '40021015','group_id' => 4002101,'product_url' => 'https://i.imgur.com/WrViZ3a.jpg'],
            539 => ['variation_id' => '40021016','group_id' => 4002101,'product_url' => 'https://i.imgur.com/WrViZ3a.jpg'],
            540 => ['variation_id' => '40021021','group_id' => 4002102,'product_url' => 'https://i.imgur.com/xyh1wyI.jpg'],
            541 => ['variation_id' => '40021022','group_id' => 4002102,'product_url' => 'https://i.imgur.com/xyh1wyI.jpg'],
            542 => ['variation_id' => '40021023','group_id' => 4002102,'product_url' => 'https://i.imgur.com/xyh1wyI.jpg'],
            543 => ['variation_id' => '40021024','group_id' => 4002102,'product_url' => 'https://i.imgur.com/xyh1wyI.jpg'],
            544 => ['variation_id' => '40021025','group_id' => 4002102,'product_url' => 'https://i.imgur.com/xyh1wyI.jpg'],
            545 => ['variation_id' => '40021026','group_id' => 4002102,'product_url' => 'https://i.imgur.com/xyh1wyI.jpg'],
            546 => ['variation_id' => '40021032','group_id' => 4002103,'product_url' => 'https://i.imgur.com/FmOghzx.jpeg'],
            547 => ['variation_id' => '40021033','group_id' => 4002103,'product_url' => 'https://i.imgur.com/FmOghzx.jpeg'],
            548 => ['variation_id' => '40021034','group_id' => 4002103,'product_url' => 'https://i.imgur.com/FmOghzx.jpeg'],
            549 => ['variation_id' => '40021035','group_id' => 4002103,'product_url' => 'https://i.imgur.com/FmOghzx.jpeg'],
            550 => ['variation_id' => '40021036','group_id' => 4002103,'product_url' => 'https://i.imgur.com/FmOghzx.jpeg'],
            551 => ['variation_id' => '40021041','group_id' => 4002104,'product_url' => 'https://i.imgur.com/RekH1M5.jpg'],
            552 => ['variation_id' => '40021042','group_id' => 4002104,'product_url' => 'https://i.imgur.com/RekH1M5.jpg'],
            553 => ['variation_id' => '40021043','group_id' => 4002104,'product_url' => 'https://i.imgur.com/RekH1M5.jpg'],
            554 => ['variation_id' => '40021044','group_id' => 4002104,'product_url' => 'https://i.imgur.com/RekH1M5.jpg'],
            555 => ['variation_id' => '40021045','group_id' => 4002104,'product_url' => 'https://i.imgur.com/RekH1M5.jpg'],
            556 => ['variation_id' => '40021046','group_id' => 4002104,'product_url' => 'https://i.imgur.com/RekH1M5.jpg'],
            557 => ['variation_id' => '40021112','group_id' => 4002111,'product_url' => 'https://i.imgur.com/Bi2nlTZ.jpg'],
            558 => ['variation_id' => '40021113','group_id' => 4002111,'product_url' => 'https://i.imgur.com/Bi2nlTZ.jpg'],
            559 => ['variation_id' => '40021114','group_id' => 4002111,'product_url' => 'https://i.imgur.com/Bi2nlTZ.jpg'],
            560 => ['variation_id' => '40021115','group_id' => 4002111,'product_url' => 'https://i.imgur.com/Bi2nlTZ.jpg'],
            561 => ['variation_id' => '40021116','group_id' => 4002111,'product_url' => 'https://i.imgur.com/Bi2nlTZ.jpg'],
            562 => ['variation_id' => '40022011','group_id' => 4002201,'product_url' => 'https://m.media-amazon.com/images/I/41DhRnxbv7S.jpg'],
            563 => ['variation_id' => '40022012','group_id' => 4002201,'product_url' => 'https://m.media-amazon.com/images/I/41DhRnxbv7S.jpg'],
            564 => ['variation_id' => '40022013','group_id' => 4002201,'product_url' => 'https://m.media-amazon.com/images/I/41DhRnxbv7S.jpg'],
            565 => ['variation_id' => '40022014','group_id' => 4002201,'product_url' => 'https://m.media-amazon.com/images/I/41DhRnxbv7S.jpg'],
            566 => ['variation_id' => '40022015','group_id' => 4002201,'product_url' => 'https://m.media-amazon.com/images/I/41DhRnxbv7S.jpg'],
            567 => ['variation_id' => '40022016','group_id' => 4002201,'product_url' => 'https://m.media-amazon.com/images/I/41DhRnxbv7S.jpg'],
            568 => ['variation_id' => '40022022','group_id' => 4002202,'product_url' => 'https://m.media-amazon.com/images/I/51v53p8UZQS.jpg'],
            569 => ['variation_id' => '40022023','group_id' => 4002202,'product_url' => 'https://m.media-amazon.com/images/I/51v53p8UZQS.jpg'],
            570 => ['variation_id' => '40022024','group_id' => 4002202,'product_url' => 'https://m.media-amazon.com/images/I/51v53p8UZQS.jpg'],
            571 => ['variation_id' => '40022025','group_id' => 4002202,'product_url' => 'https://m.media-amazon.com/images/I/51v53p8UZQS.jpg'],
            572 => ['variation_id' => '40022026','group_id' => 4002202,'product_url' => 'https://m.media-amazon.com/images/I/51v53p8UZQS.jpg'],
            573 => ['variation_id' => '40022042','group_id' => 4002204,'product_url' => 'https://m.media-amazon.com/images/I/71BFVzNDb0S.jpg'],
            574 => ['variation_id' => '40022043','group_id' => 4002204,'product_url' => 'https://m.media-amazon.com/images/I/71BFVzNDb0S.jpg'],
            575 => ['variation_id' => '40022044','group_id' => 4002204,'product_url' => 'https://m.media-amazon.com/images/I/71BFVzNDb0S.jpg'],
            576 => ['variation_id' => '40022045','group_id' => 4002204,'product_url' => 'https://m.media-amazon.com/images/I/71BFVzNDb0S.jpg'],
            577 => ['variation_id' => '40022046','group_id' => 4002204,'product_url' => 'https://m.media-amazon.com/images/I/71BFVzNDb0S.jpg'],
            578 => ['variation_id' => '40022052','group_id' => 4002205,'product_url' => 'https://m.media-amazon.com/images/I/71S83Kc1q0S.jpg'],
            579 => ['variation_id' => '40022053','group_id' => 4002205,'product_url' => 'https://m.media-amazon.com/images/I/71S83Kc1q0S.jpg'],
            580 => ['variation_id' => '40022054','group_id' => 4002205,'product_url' => 'https://m.media-amazon.com/images/I/71S83Kc1q0S.jpg'],
            581 => ['variation_id' => '40022055','group_id' => 4002205,'product_url' => 'https://m.media-amazon.com/images/I/71S83Kc1q0S.jpg'],
            582 => ['variation_id' => '40022056','group_id' => 4002205,'product_url' => 'https://m.media-amazon.com/images/I/71S83Kc1q0S.jpg'],
            583 => ['variation_id' => '40022062','group_id' => 4002206,'product_url' => 'https://m.media-amazon.com/images/I/41N+-Ut+xML.jpg'],
            584 => ['variation_id' => '40022063','group_id' => 4002206,'product_url' => 'https://m.media-amazon.com/images/I/41N+-Ut+xML.jpg'],
            585 => ['variation_id' => '40022064','group_id' => 4002206,'product_url' => 'https://m.media-amazon.com/images/I/41N+-Ut+xML.jpg'],
            586 => ['variation_id' => '40022065','group_id' => 4002206,'product_url' => 'https://m.media-amazon.com/images/I/41N+-Ut+xML.jpg'],
            587 => ['variation_id' => '40022066','group_id' => 4002206,'product_url' => 'https://m.media-amazon.com/images/I/41N+-Ut+xML.jpg'],
            588 => ['variation_id' => '40022102','group_id' => 4002210,'product_url' => 'https://m.media-amazon.com/images/I/31iK0c5BPqL.jpg'],
            589 => ['variation_id' => '40022103','group_id' => 4002210,'product_url' => 'https://m.media-amazon.com/images/I/31iK0c5BPqL.jpg'],
            590 => ['variation_id' => '40022104','group_id' => 4002210,'product_url' => 'https://m.media-amazon.com/images/I/31iK0c5BPqL.jpg'],
            591 => ['variation_id' => '40022105','group_id' => 4002210,'product_url' => 'https://m.media-amazon.com/images/I/31iK0c5BPqL.jpg'],
            592 => ['variation_id' => '40022106','group_id' => 4002210,'product_url' => 'https://m.media-amazon.com/images/I/31iK0c5BPqL.jpg'],
            593 => ['variation_id' => '40023012','group_id' => 4002301,'product_url' => 'https://m.media-amazon.com/images/I/51N3d+1ERLS._AC_UY679_.jpg'],
            594 => ['variation_id' => '40023013','group_id' => 4002301,'product_url' => 'https://m.media-amazon.com/images/I/51N3d+1ERLS._AC_UY679_.jpg'],
            595 => ['variation_id' => '40023014','group_id' => 4002301,'product_url' => 'https://m.media-amazon.com/images/I/51N3d+1ERLS._AC_UY679_.jpg'],
            596 => ['variation_id' => '40023015','group_id' => 4002301,'product_url' => 'https://m.media-amazon.com/images/I/51N3d+1ERLS._AC_UY679_.jpg'],
            597 => ['variation_id' => '40023016','group_id' => 4002301,'product_url' => 'https://m.media-amazon.com/images/I/51N3d+1ERLS._AC_UY679_.jpg'],
            598 => ['variation_id' => '40023022','group_id' => 4002302,'product_url' => 'https://m.media-amazon.com/images/I/61BU3opwgVL.jpg'],
            599 => ['variation_id' => '40023023','group_id' => 4002302,'product_url' => 'https://m.media-amazon.com/images/I/61BU3opwgVL.jpg'],
            600 => ['variation_id' => '40023024','group_id' => 4002302,'product_url' => 'https://m.media-amazon.com/images/I/61BU3opwgVL.jpg'],
            601 => ['variation_id' => '40023025','group_id' => 4002302,'product_url' => 'https://m.media-amazon.com/images/I/61BU3opwgVL.jpg'],
            602 => ['variation_id' => '40023026','group_id' => 4002302,'product_url' => 'https://m.media-amazon.com/images/I/61BU3opwgVL.jpg'],
            603 => ['variation_id' => '40023042','group_id' => 4002304,'product_url' => 'https://m.media-amazon.com/images/I/71HNyP0YvCL.jpg'],
            604 => ['variation_id' => '40023043','group_id' => 4002304,'product_url' => 'https://m.media-amazon.com/images/I/71HNyP0YvCL.jpg'],
            605 => ['variation_id' => '40023044','group_id' => 4002304,'product_url' => 'https://m.media-amazon.com/images/I/71HNyP0YvCL.jpg'],
            606 => ['variation_id' => '40023045','group_id' => 4002304,'product_url' => 'https://m.media-amazon.com/images/I/71HNyP0YvCL.jpg'],
            607 => ['variation_id' => '40023046','group_id' => 4002304,'product_url' => 'https://m.media-amazon.com/images/I/71HNyP0YvCL.jpg'],
            608 => ['variation_id' => '40023052','group_id' => 4002305,'product_url' => 'https://m.media-amazon.com/images/I/61bRmaoQmTL.jpg'],
            609 => ['variation_id' => '40023053','group_id' => 4002305,'product_url' => 'https://m.media-amazon.com/images/I/61bRmaoQmTL.jpg'],
            610 => ['variation_id' => '40023054','group_id' => 4002305,'product_url' => 'https://m.media-amazon.com/images/I/61bRmaoQmTL.jpg'],
            611 => ['variation_id' => '40023055','group_id' => 4002305,'product_url' => 'https://m.media-amazon.com/images/I/61bRmaoQmTL.jpg'],
            612 => ['variation_id' => '40023056','group_id' => 4002305,'product_url' => 'https://m.media-amazon.com/images/I/61bRmaoQmTL.jpg'],
            613 => ['variation_id' => '40023062','group_id' => 4002306,'product_url' => 'https://m.media-amazon.com/images/I/51X916YNJWL.jpg'],
            614 => ['variation_id' => '40023063','group_id' => 4002306,'product_url' => 'https://m.media-amazon.com/images/I/51X916YNJWL.jpg'],
            615 => ['variation_id' => '40023064','group_id' => 4002306,'product_url' => 'https://m.media-amazon.com/images/I/51X916YNJWL.jpg'],
            616 => ['variation_id' => '40023065','group_id' => 4002306,'product_url' => 'https://m.media-amazon.com/images/I/51X916YNJWL.jpg'],
            617 => ['variation_id' => '40023066','group_id' => 4002306,'product_url' => 'https://m.media-amazon.com/images/I/51X916YNJWL.jpg'],
            618 => ['variation_id' => '40024012','group_id' => 4002401,'product_url' => 'https://m.media-amazon.com/images/I/41vL8zV5jGL.jpg'],
            619 => ['variation_id' => '40024013','group_id' => 4002401,'product_url' => 'https://m.media-amazon.com/images/I/41vL8zV5jGL.jpg'],
            620 => ['variation_id' => '40024014','group_id' => 4002401,'product_url' => 'https://m.media-amazon.com/images/I/41vL8zV5jGL.jpg'],
            621 => ['variation_id' => '40024015','group_id' => 4002401,'product_url' => 'https://m.media-amazon.com/images/I/41vL8zV5jGL.jpg'],
            622 => ['variation_id' => '40024016','group_id' => 4002401,'product_url' => 'https://m.media-amazon.com/images/I/41vL8zV5jGL.jpg'],
            623 => ['variation_id' => '40024022','group_id' => 4002402,'product_url' => 'https://m.media-amazon.com/images/I/51ctjinii9S.jpg'],
            624 => ['variation_id' => '40024023','group_id' => 4002402,'product_url' => 'https://m.media-amazon.com/images/I/51ctjinii9S.jpg'],
            625 => ['variation_id' => '40024024','group_id' => 4002402,'product_url' => 'https://m.media-amazon.com/images/I/51ctjinii9S.jpg'],
            626 => ['variation_id' => '40024025','group_id' => 4002402,'product_url' => 'https://m.media-amazon.com/images/I/51ctjinii9S.jpg'],
            627 => ['variation_id' => '40024026','group_id' => 4002402,'product_url' => 'https://m.media-amazon.com/images/I/51ctjinii9S.jpg'],
            628 => ['variation_id' => '40024042','group_id' => 4002404,'product_url' => 'https://m.media-amazon.com/images/I/71Y9lY5C68S.jpg'],
            629 => ['variation_id' => '40024043','group_id' => 4002404,'product_url' => 'https://m.media-amazon.com/images/I/71Y9lY5C68S.jpg'],
            630 => ['variation_id' => '40024044','group_id' => 4002404,'product_url' => 'https://m.media-amazon.com/images/I/71Y9lY5C68S.jpg'],
            631 => ['variation_id' => '40024045','group_id' => 4002404,'product_url' => 'https://m.media-amazon.com/images/I/71Y9lY5C68S.jpg'],
            632 => ['variation_id' => '40024046','group_id' => 4002404,'product_url' => 'https://m.media-amazon.com/images/I/71Y9lY5C68S.jpg'],
            633 => ['variation_id' => '40024052','group_id' => 4002405,'product_url' => 'https://m.media-amazon.com/images/I/71VJDUp+T9S.jpg'],
            634 => ['variation_id' => '40024053','group_id' => 4002405,'product_url' => 'https://m.media-amazon.com/images/I/71VJDUp+T9S.jpg'],
            635 => ['variation_id' => '40024054','group_id' => 4002405,'product_url' => 'https://m.media-amazon.com/images/I/71VJDUp+T9S.jpg'],
            636 => ['variation_id' => '40024055','group_id' => 4002405,'product_url' => 'https://m.media-amazon.com/images/I/71VJDUp+T9S.jpg'],
            637 => ['variation_id' => '40024056','group_id' => 4002405,'product_url' => 'https://m.media-amazon.com/images/I/71VJDUp+T9S.jpg'],
            638 => ['variation_id' => '40024102','group_id' => 4002410,'product_url' => 'https://m.media-amazon.com/images/I/411fK6qy0tL.jpg'],
            639 => ['variation_id' => '40024103','group_id' => 4002410,'product_url' => 'https://m.media-amazon.com/images/I/411fK6qy0tL.jpg'],
            640 => ['variation_id' => '40024104','group_id' => 4002410,'product_url' => 'https://m.media-amazon.com/images/I/411fK6qy0tL.jpg'],
            641 => ['variation_id' => '40024105','group_id' => 4002410,'product_url' => 'https://m.media-amazon.com/images/I/411fK6qy0tL.jpg'],
            642 => ['variation_id' => '40024106','group_id' => 4002410,'product_url' => 'https://m.media-amazon.com/images/I/411fK6qy0tL.jpg'],
            643 => ['variation_id' => '40025012','group_id' => 4002501,'product_url' => 'https://m.media-amazon.com/images/I/51dtluQ591S.jpg'],
            644 => ['variation_id' => '40025013','group_id' => 4002501,'product_url' => 'https://m.media-amazon.com/images/I/51dtluQ591S.jpg'],
            645 => ['variation_id' => '40025014','group_id' => 4002501,'product_url' => 'https://m.media-amazon.com/images/I/51dtluQ591S.jpg'],
            646 => ['variation_id' => '40025015','group_id' => 4002501,'product_url' => 'https://m.media-amazon.com/images/I/51dtluQ591S.jpg'],
            647 => ['variation_id' => '40025016','group_id' => 4002501,'product_url' => 'https://m.media-amazon.com/images/I/51dtluQ591S.jpg'],
            648 => ['variation_id' => '40025022','group_id' => 4002502,'product_url' => 'https://m.media-amazon.com/images/I/61uq0nYHFwS.jpg'],
            649 => ['variation_id' => '40025023','group_id' => 4002502,'product_url' => 'https://m.media-amazon.com/images/I/61uq0nYHFwS.jpg'],
            650 => ['variation_id' => '40025024','group_id' => 4002502,'product_url' => 'https://m.media-amazon.com/images/I/61uq0nYHFwS.jpg'],
            651 => ['variation_id' => '40025025','group_id' => 4002502,'product_url' => 'https://m.media-amazon.com/images/I/61uq0nYHFwS.jpg'],
            652 => ['variation_id' => '40025026','group_id' => 4002502,'product_url' => 'https://m.media-amazon.com/images/I/61uq0nYHFwS.jpg'],
            653 => ['variation_id' => '40025042','group_id' => 4002504,'product_url' => 'https://m.media-amazon.com/images/I/71Frat4t++L.jpg'],
            654 => ['variation_id' => '40025043','group_id' => 4002504,'product_url' => 'https://m.media-amazon.com/images/I/71Frat4t++L.jpg'],
            655 => ['variation_id' => '40025044','group_id' => 4002504,'product_url' => 'https://m.media-amazon.com/images/I/71Frat4t++L.jpg'],
            656 => ['variation_id' => '40025045','group_id' => 4002504,'product_url' => 'https://m.media-amazon.com/images/I/71Frat4t++L.jpg'],
            657 => ['variation_id' => '40025046','group_id' => 4002504,'product_url' => 'https://m.media-amazon.com/images/I/71Frat4t++L.jpg'],
            658 => ['variation_id' => '40025052','group_id' => 4002505,'product_url' => 'https://m.media-amazon.com/images/I/71jA4V6iiuS.jpg'],
            659 => ['variation_id' => '40025053','group_id' => 4002505,'product_url' => 'https://m.media-amazon.com/images/I/71jA4V6iiuS.jpg'],
            660 => ['variation_id' => '40025054','group_id' => 4002505,'product_url' => 'https://m.media-amazon.com/images/I/71jA4V6iiuS.jpg'],
            661 => ['variation_id' => '40025055','group_id' => 4002505,'product_url' => 'https://m.media-amazon.com/images/I/71jA4V6iiuS.jpg'],
            662 => ['variation_id' => '40025056','group_id' => 4002505,'product_url' => 'https://m.media-amazon.com/images/I/71jA4V6iiuS.jpg'],
            663 => ['variation_id' => '40027012','group_id' => 4002701,'product_url' => 'https://m.media-amazon.com/images/I/61WF9fIsIES.jpg'],
            664 => ['variation_id' => '40027013','group_id' => 4002701,'product_url' => 'https://m.media-amazon.com/images/I/61WF9fIsIES.jpg'],
            665 => ['variation_id' => '40027014','group_id' => 4002701,'product_url' => 'https://m.media-amazon.com/images/I/61WF9fIsIES.jpg'],
            666 => ['variation_id' => '40027015','group_id' => 4002701,'product_url' => 'https://m.media-amazon.com/images/I/61WF9fIsIES.jpg'],
            667 => ['variation_id' => '40027016','group_id' => 4002701,'product_url' => 'https://m.media-amazon.com/images/I/61WF9fIsIES.jpg'],
            668 => ['variation_id' => '40027022','group_id' => 4002702,'product_url' => 'https://m.media-amazon.com/images/I/41atr4GzxLS.jpg'],
            669 => ['variation_id' => '40027023','group_id' => 4002702,'product_url' => 'https://m.media-amazon.com/images/I/41atr4GzxLS.jpg'],
            670 => ['variation_id' => '40027024','group_id' => 4002702,'product_url' => 'https://m.media-amazon.com/images/I/41atr4GzxLS.jpg'],
            671 => ['variation_id' => '40027025','group_id' => 4002702,'product_url' => 'https://m.media-amazon.com/images/I/41atr4GzxLS.jpg'],
            672 => ['variation_id' => '40027026','group_id' => 4002702,'product_url' => 'https://m.media-amazon.com/images/I/41atr4GzxLS.jpg'],
            673 => ['variation_id' => '40028012','group_id' => 4002801,'product_url' => 'https://m.media-amazon.com/images/I/61ENUVGLj2S.jpg'],
            674 => ['variation_id' => '40028013','group_id' => 4002801,'product_url' => 'https://m.media-amazon.com/images/I/61ENUVGLj2S.jpg'],
            675 => ['variation_id' => '40028014','group_id' => 4002801,'product_url' => 'https://m.media-amazon.com/images/I/61ENUVGLj2S.jpg'],
            676 => ['variation_id' => '40028015','group_id' => 4002801,'product_url' => 'https://m.media-amazon.com/images/I/61ENUVGLj2S.jpg'],
            677 => ['variation_id' => '40028016','group_id' => 4002801,'product_url' => 'https://m.media-amazon.com/images/I/61ENUVGLj2S.jpg'],
            678 => ['variation_id' => '40028022','group_id' => 4002802,'product_url' => 'https://m.media-amazon.com/images/I/6171euejRXS.jpg'],
            679 => ['variation_id' => '40028023','group_id' => 4002802,'product_url' => 'https://m.media-amazon.com/images/I/6171euejRXS.jpg'],
            680 => ['variation_id' => '40028024','group_id' => 4002802,'product_url' => 'https://m.media-amazon.com/images/I/6171euejRXS.jpg'],
            681 => ['variation_id' => '40028025','group_id' => 4002802,'product_url' => 'https://m.media-amazon.com/images/I/6171euejRXS.jpg'],
            682 => ['variation_id' => '40028026','group_id' => 4002802,'product_url' => 'https://m.media-amazon.com/images/I/6171euejRXS.jpg'],
            683 => ['variation_id' => '40029022','group_id' => 4002902,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/514kyXoS22S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            684 => ['variation_id' => '40029023','group_id' => 4002902,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/514kyXoS22S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            685 => ['variation_id' => '40029024','group_id' => 4002902,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/514kyXoS22S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            686 => ['variation_id' => '40029025','group_id' => 4002902,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/514kyXoS22S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            687 => ['variation_id' => '40029026','group_id' => 4002902,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/514kyXoS22S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            688 => ['variation_id' => '40029032','group_id' => 4002903,'product_url' => 'https://m.media-amazon.com/images/I/51yw6zvB88S._AC_UY679_.jpg'],
            689 => ['variation_id' => '40029033','group_id' => 4002903,'product_url' => 'https://m.media-amazon.com/images/I/51yw6zvB88S._AC_UY679_.jpg'],
            690 => ['variation_id' => '40029034','group_id' => 4002903,'product_url' => 'https://m.media-amazon.com/images/I/51yw6zvB88S._AC_UY679_.jpg'],
            691 => ['variation_id' => '40029035','group_id' => 4002903,'product_url' => 'https://m.media-amazon.com/images/I/51yw6zvB88S._AC_UY679_.jpg'],
            692 => ['variation_id' => '40029036','group_id' => 4002903,'product_url' => 'https://m.media-amazon.com/images/I/51yw6zvB88S._AC_UY679_.jpg'],
            693 => ['variation_id' => '40029052','group_id' => 4002905,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/61GTKsW0B3S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            694 => ['variation_id' => '40029053','group_id' => 4002905,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/61GTKsW0B3S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            695 => ['variation_id' => '40029054','group_id' => 4002905,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/61GTKsW0B3S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            696 => ['variation_id' => '40029055','group_id' => 4002905,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/61GTKsW0B3S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            697 => ['variation_id' => '40029056','group_id' => 4002905,'product_url' => 'https://images-na.ssl-images-amazon.com/images/I/61GTKsW0B3S.__AC_SX342_SY445_QL70_FMwebp_.jpg'],
            698 => ['variation_id' => '40029072','group_id' => 4002907,'product_url' => 'https://m.media-amazon.com/images/I/51ZqtC36hnS.jpg'],
            699 => ['variation_id' => '40029073','group_id' => 4002907,'product_url' => 'https://m.media-amazon.com/images/I/51ZqtC36hnS.jpg'],
            700 => ['variation_id' => '40029074','group_id' => 4002907,'product_url' => 'https://m.media-amazon.com/images/I/51ZqtC36hnS.jpg'],
            701 => ['variation_id' => '40029075','group_id' => 4002907,'product_url' => 'https://m.media-amazon.com/images/I/51ZqtC36hnS.jpg'],
            702 => ['variation_id' => '40029076','group_id' => 4002907,'product_url' => 'https://m.media-amazon.com/images/I/51ZqtC36hnS.jpg'],
            703 => ['variation_id' => '40030011','group_id' => 4003001,'product_url' => 'https://m.media-amazon.com/images/I/41zAUVDTuBL.jpg'],
            704 => ['variation_id' => '40030012','group_id' => 4003001,'product_url' => 'https://m.media-amazon.com/images/I/41zAUVDTuBL.jpg'],
            705 => ['variation_id' => '40030013','group_id' => 4003001,'product_url' => 'https://m.media-amazon.com/images/I/41zAUVDTuBL.jpg'],
            706 => ['variation_id' => '40030014','group_id' => 4003001,'product_url' => 'https://m.media-amazon.com/images/I/41zAUVDTuBL.jpg'],
            707 => ['variation_id' => '40030015','group_id' => 4003001,'product_url' => 'https://m.media-amazon.com/images/I/41zAUVDTuBL.jpg'],
            708 => ['variation_id' => '40030016','group_id' => 4003001,'product_url' => 'https://m.media-amazon.com/images/I/41zAUVDTuBL.jpg'],
            709 => ['variation_id' => '40030021','group_id' => 4003002,'product_url' => 'https://m.media-amazon.com/images/I/51a+XD0v7yL.jpg'],
            710 => ['variation_id' => '40030022','group_id' => 4003002,'product_url' => 'https://m.media-amazon.com/images/I/51a+XD0v7yL.jpg'],
            711 => ['variation_id' => '40030023','group_id' => 4003002,'product_url' => 'https://m.media-amazon.com/images/I/51a+XD0v7yL.jpg'],
            712 => ['variation_id' => '40030024','group_id' => 4003002,'product_url' => 'https://m.media-amazon.com/images/I/51a+XD0v7yL.jpg'],
            713 => ['variation_id' => '40030025','group_id' => 4003002,'product_url' => 'https://m.media-amazon.com/images/I/51a+XD0v7yL.jpg'],
            714 => ['variation_id' => '40030026','group_id' => 4003002,'product_url' => 'https://m.media-amazon.com/images/I/51a+XD0v7yL.jpg'],
            715 => ['variation_id' => '40030051','group_id' => 4003005,'product_url' => 'https://m.media-amazon.com/images/I/712ROIRxprL.jpg'],
            716 => ['variation_id' => '40030052','group_id' => 4003005,'product_url' => 'https://m.media-amazon.com/images/I/712ROIRxprL.jpg'],
            717 => ['variation_id' => '40030053','group_id' => 4003005,'product_url' => 'https://m.media-amazon.com/images/I/712ROIRxprL.jpg'],
            718 => ['variation_id' => '40030054','group_id' => 4003005,'product_url' => 'https://m.media-amazon.com/images/I/712ROIRxprL.jpg'],
            719 => ['variation_id' => '40030055','group_id' => 4003005,'product_url' => 'https://m.media-amazon.com/images/I/712ROIRxprL.jpg'],
            720 => ['variation_id' => '40030056','group_id' => 4003005,'product_url' => 'https://m.media-amazon.com/images/I/712ROIRxprL.jpg'],
            721 => ['variation_id' => '40031021','group_id' => 4003102,'product_url' => 'https://m.media-amazon.com/images/I/617u5Baj0UL.jpg'],
            722 => ['variation_id' => '40031022','group_id' => 4003102,'product_url' => 'https://m.media-amazon.com/images/I/617u5Baj0UL.jpg'],
            723 => ['variation_id' => '40031023','group_id' => 4003102,'product_url' => 'https://m.media-amazon.com/images/I/617u5Baj0UL.jpg'],
            724 => ['variation_id' => '40031024','group_id' => 4003102,'product_url' => 'https://m.media-amazon.com/images/I/617u5Baj0UL.jpg'],
            725 => ['variation_id' => '40031025','group_id' => 4003102,'product_url' => 'https://m.media-amazon.com/images/I/617u5Baj0UL.jpg'],
            726 => ['variation_id' => '40031026','group_id' => 4003102,'product_url' => 'https://m.media-amazon.com/images/I/617u5Baj0UL.jpg'],
            727 => ['variation_id' => '40031051','group_id' => 4003105,'product_url' => 'https://m.media-amazon.com/images/I/61KfH2e7MQL.jpg'],
            728 => ['variation_id' => '40031052','group_id' => 4003105,'product_url' => 'https://m.media-amazon.com/images/I/61KfH2e7MQL.jpg'],
            729 => ['variation_id' => '40031053','group_id' => 4003105,'product_url' => 'https://m.media-amazon.com/images/I/61KfH2e7MQL.jpg'],
            730 => ['variation_id' => '40031054','group_id' => 4003105,'product_url' => 'https://m.media-amazon.com/images/I/61KfH2e7MQL.jpg'],
            731 => ['variation_id' => '40031055','group_id' => 4003105,'product_url' => 'https://m.media-amazon.com/images/I/61KfH2e7MQL.jpg'],
            732 => ['variation_id' => '40031056','group_id' => 4003105,'product_url' => 'https://m.media-amazon.com/images/I/61KfH2e7MQL.jpg'],
            733 => ['variation_id' => '40032021','group_id' => 4003202,'product_url' => 'https://m.media-amazon.com/images/I/610nvy6wmzL.jpg'],
            734 => ['variation_id' => '40032022','group_id' => 4003202,'product_url' => 'https://m.media-amazon.com/images/I/610nvy6wmzL.jpg'],
            735 => ['variation_id' => '40032023','group_id' => 4003202,'product_url' => 'https://m.media-amazon.com/images/I/610nvy6wmzL.jpg'],
            736 => ['variation_id' => '40032024','group_id' => 4003202,'product_url' => 'https://m.media-amazon.com/images/I/610nvy6wmzL.jpg'],
            737 => ['variation_id' => '40032025','group_id' => 4003202,'product_url' => 'https://m.media-amazon.com/images/I/610nvy6wmzL.jpg'],
            738 => ['variation_id' => '40032026','group_id' => 4003202,'product_url' => 'https://m.media-amazon.com/images/I/610nvy6wmzL.jpg'],
            739 => ['variation_id' => '40032051','group_id' => 4003205,'product_url' => 'https://m.media-amazon.com/images/I/71OIqvpR19L.jpg'],
            740 => ['variation_id' => '40032052','group_id' => 4003205,'product_url' => 'https://m.media-amazon.com/images/I/71OIqvpR19L.jpg'],
            741 => ['variation_id' => '40032053','group_id' => 4003205,'product_url' => 'https://m.media-amazon.com/images/I/71OIqvpR19L.jpg'],
            742 => ['variation_id' => '40032054','group_id' => 4003205,'product_url' => 'https://m.media-amazon.com/images/I/71OIqvpR19L.jpg'],
            743 => ['variation_id' => '40032055','group_id' => 4003205,'product_url' => 'https://m.media-amazon.com/images/I/71OIqvpR19L.jpg'],
            744 => ['variation_id' => '40032056','group_id' => 4003205,'product_url' => 'https://m.media-amazon.com/images/I/71OIqvpR19L.jpg'],
            745 => ['variation_id' => '40033021','group_id' => 4003302,'product_url' => 'https://m.media-amazon.com/images/I/71mr1YHymPL.jpg'],
            746 => ['variation_id' => '40033022','group_id' => 4003302,'product_url' => 'https://m.media-amazon.com/images/I/71mr1YHymPL.jpg'],
            747 => ['variation_id' => '40033023','group_id' => 4003302,'product_url' => 'https://m.media-amazon.com/images/I/71mr1YHymPL.jpg'],
            748 => ['variation_id' => '40033024','group_id' => 4003302,'product_url' => 'https://m.media-amazon.com/images/I/71mr1YHymPL.jpg'],
            749 => ['variation_id' => '40033025','group_id' => 4003302,'product_url' => 'https://m.media-amazon.com/images/I/71mr1YHymPL.jpg'],
            750 => ['variation_id' => '40033026','group_id' => 4003302,'product_url' => 'https://m.media-amazon.com/images/I/71mr1YHymPL.jpg'],
            751 => ['variation_id' => '40033051','group_id' => 4003305,'product_url' => 'https://m.media-amazon.com/images/I/71xkZXZBwUL.jpg'],
            752 => ['variation_id' => '40033052','group_id' => 4003305,'product_url' => 'https://m.media-amazon.com/images/I/71xkZXZBwUL.jpg'],
            753 => ['variation_id' => '40033053','group_id' => 4003305,'product_url' => 'https://m.media-amazon.com/images/I/71xkZXZBwUL.jpg'],
            754 => ['variation_id' => '40033054','group_id' => 4003305,'product_url' => 'https://m.media-amazon.com/images/I/71xkZXZBwUL.jpg'],
            755 => ['variation_id' => '40033055','group_id' => 4003305,'product_url' => 'https://m.media-amazon.com/images/I/71xkZXZBwUL.jpg'],
            756 => ['variation_id' => '40033056','group_id' => 4003305,'product_url' => 'https://m.media-amazon.com/images/I/71xkZXZBwUL.jpg'],
            757 => ['variation_id' => '40033061','group_id' => 4003306,'product_url' => 'https://m.media-amazon.com/images/I/41MAPeKmfzL.jpg'],
            758 => ['variation_id' => '40033062','group_id' => 4003306,'product_url' => 'https://m.media-amazon.com/images/I/41MAPeKmfzL.jpg'],
            759 => ['variation_id' => '40033063','group_id' => 4003306,'product_url' => 'https://m.media-amazon.com/images/I/41MAPeKmfzL.jpg'],
            760 => ['variation_id' => '40033064','group_id' => 4003306,'product_url' => 'https://m.media-amazon.com/images/I/41MAPeKmfzL.jpg'],
            761 => ['variation_id' => '40033065','group_id' => 4003306,'product_url' => 'https://m.media-amazon.com/images/I/41MAPeKmfzL.jpg'],
            762 => ['variation_id' => '40033066','group_id' => 4003306,'product_url' => 'https://m.media-amazon.com/images/I/41MAPeKmfzL.jpg'],
            763 => ['variation_id' => '40034021','group_id' => 4003402,'product_url' => 'https://m.media-amazon.com/images/I/41KJtLIVEvL.jpg'],
            764 => ['variation_id' => '40034022','group_id' => 4003402,'product_url' => 'https://m.media-amazon.com/images/I/41KJtLIVEvL.jpg'],
            765 => ['variation_id' => '40034023','group_id' => 4003402,'product_url' => 'https://m.media-amazon.com/images/I/41KJtLIVEvL.jpg'],
            766 => ['variation_id' => '40034024','group_id' => 4003402,'product_url' => 'https://m.media-amazon.com/images/I/41KJtLIVEvL.jpg'],
            767 => ['variation_id' => '40034025','group_id' => 4003402,'product_url' => 'https://m.media-amazon.com/images/I/41KJtLIVEvL.jpg'],
            768 => ['variation_id' => '40034026','group_id' => 4003402,'product_url' => 'https://m.media-amazon.com/images/I/41KJtLIVEvL.jpg'],
            769 => ['variation_id' => '40034061','group_id' => 4003406,'product_url' => 'https://m.media-amazon.com/images/I/81CHNcKNoML.jpg'],
            770 => ['variation_id' => '40034062','group_id' => 4003406,'product_url' => 'https://m.media-amazon.com/images/I/81CHNcKNoML.jpg'],
            771 => ['variation_id' => '40034063','group_id' => 4003406,'product_url' => 'https://m.media-amazon.com/images/I/81CHNcKNoML.jpg'],
            772 => ['variation_id' => '40034064','group_id' => 4003406,'product_url' => 'https://m.media-amazon.com/images/I/81CHNcKNoML.jpg'],
            773 => ['variation_id' => '40034065','group_id' => 4003406,'product_url' => 'https://m.media-amazon.com/images/I/81CHNcKNoML.jpg'],
            774 => ['variation_id' => '40034066','group_id' => 4003406,'product_url' => 'https://m.media-amazon.com/images/I/81CHNcKNoML.jpg'],
            775 => ['variation_id' => '40034091','group_id' => 4003409,'product_url' => 'https://m.media-amazon.com/images/I/41xzhYKJo0L.jpg'],
            776 => ['variation_id' => '40034092','group_id' => 4003409,'product_url' => 'https://m.media-amazon.com/images/I/41xzhYKJo0L.jpg'],
            777 => ['variation_id' => '40034093','group_id' => 4003409,'product_url' => 'https://m.media-amazon.com/images/I/41xzhYKJo0L.jpg'],
            778 => ['variation_id' => '40034094','group_id' => 4003409,'product_url' => 'https://m.media-amazon.com/images/I/41xzhYKJo0L.jpg'],
            779 => ['variation_id' => '40034095','group_id' => 4003409,'product_url' => 'https://m.media-amazon.com/images/I/41xzhYKJo0L.jpg'],
            780 => ['variation_id' => '40034096','group_id' => 4003409,'product_url' => 'https://m.media-amazon.com/images/I/41xzhYKJo0L.jpg'],
            781 => ['variation_id' => '40035021','group_id' => 4003502,'product_url' => 'https://m.media-amazon.com/images/I/61O205IYH2L.jpg'],
            782 => ['variation_id' => '40035022','group_id' => 4003502,'product_url' => 'https://m.media-amazon.com/images/I/61O205IYH2L.jpg'],
            783 => ['variation_id' => '40035023','group_id' => 4003502,'product_url' => 'https://m.media-amazon.com/images/I/61O205IYH2L.jpg'],
            784 => ['variation_id' => '40035024','group_id' => 4003502,'product_url' => 'https://m.media-amazon.com/images/I/61O205IYH2L.jpg'],
            785 => ['variation_id' => '40035025','group_id' => 4003502,'product_url' => 'https://m.media-amazon.com/images/I/61O205IYH2L.jpg'],
            786 => ['variation_id' => '40035026','group_id' => 4003502,'product_url' => 'https://m.media-amazon.com/images/I/61O205IYH2L.jpg'],
            787 => ['variation_id' => '40035061','group_id' => 4003506,'product_url' => 'https://m.media-amazon.com/images/I/31+YohIDkPL.jpg'],
            788 => ['variation_id' => '40035062','group_id' => 4003506,'product_url' => 'https://m.media-amazon.com/images/I/31+YohIDkPL.jpg'],
            789 => ['variation_id' => '40035063','group_id' => 4003506,'product_url' => 'https://m.media-amazon.com/images/I/31+YohIDkPL.jpg'],
            790 => ['variation_id' => '40035064','group_id' => 4003506,'product_url' => 'https://m.media-amazon.com/images/I/31+YohIDkPL.jpg'],
            791 => ['variation_id' => '40035065','group_id' => 4003506,'product_url' => 'https://m.media-amazon.com/images/I/31+YohIDkPL.jpg'],
            792 => ['variation_id' => '40035066','group_id' => 4003506,'product_url' => 'https://m.media-amazon.com/images/I/31+YohIDkPL.jpg'],
            793 => ['variation_id' => '40036021','group_id' => 4003602,'product_url' => 'https://m.media-amazon.com/images/I/71oWMYFKWzL.jpg'],
            794 => ['variation_id' => '40036022','group_id' => 4003602,'product_url' => 'https://m.media-amazon.com/images/I/71oWMYFKWzL.jpg'],
            795 => ['variation_id' => '40036023','group_id' => 4003602,'product_url' => 'https://m.media-amazon.com/images/I/71oWMYFKWzL.jpg'],
            796 => ['variation_id' => '40036024','group_id' => 4003602,'product_url' => 'https://m.media-amazon.com/images/I/71oWMYFKWzL.jpg'],
            797 => ['variation_id' => '40036025','group_id' => 4003602,'product_url' => 'https://m.media-amazon.com/images/I/71oWMYFKWzL.jpg'],
            798 => ['variation_id' => '40036026','group_id' => 4003602,'product_url' => 'https://m.media-amazon.com/images/I/71oWMYFKWzL.jpg'],
            799 => ['variation_id' => '40036061','group_id' => 4003606,'product_url' => 'https://m.media-amazon.com/images/I/71zVA-Ukz+L.jpg'],
            800 => ['variation_id' => '40036062','group_id' => 4003606,'product_url' => 'https://m.media-amazon.com/images/I/71zVA-Ukz+L.jpg'],
            801 => ['variation_id' => '40036063','group_id' => 4003606,'product_url' => 'https://m.media-amazon.com/images/I/71zVA-Ukz+L.jpg'],
            802 => ['variation_id' => '40036064','group_id' => 4003606,'product_url' => 'https://m.media-amazon.com/images/I/71zVA-Ukz+L.jpg'],
            803 => ['variation_id' => '40036065','group_id' => 4003606,'product_url' => 'https://m.media-amazon.com/images/I/71zVA-Ukz+L.jpg'],
            804 => ['variation_id' => '40036066','group_id' => 4003606,'product_url' => 'https://m.media-amazon.com/images/I/71zVA-Ukz+L.jpg'],
            805 => ['variation_id' => '40037021','group_id' => 4003702,'product_url' => 'https://m.media-amazon.com/images/I/81xpFxE4c9L.jpg'],
            806 => ['variation_id' => '40037022','group_id' => 4003702,'product_url' => 'https://m.media-amazon.com/images/I/81xpFxE4c9L.jpg'],
            807 => ['variation_id' => '40037023','group_id' => 4003702,'product_url' => 'https://m.media-amazon.com/images/I/81xpFxE4c9L.jpg'],
            808 => ['variation_id' => '40037024','group_id' => 4003702,'product_url' => 'https://m.media-amazon.com/images/I/81xpFxE4c9L.jpg'],
            809 => ['variation_id' => '40037025','group_id' => 4003702,'product_url' => 'https://m.media-amazon.com/images/I/81xpFxE4c9L.jpg'],
            810 => ['variation_id' => '40037026','group_id' => 4003702,'product_url' => 'https://m.media-amazon.com/images/I/81xpFxE4c9L.jpg'],
            811 => ['variation_id' => '40037051','group_id' => 4003705,'product_url' => 'https://m.media-amazon.com/images/I/51N4NetKp8L.jpg'],
            812 => ['variation_id' => '40037052','group_id' => 4003705,'product_url' => 'https://m.media-amazon.com/images/I/51N4NetKp8L.jpg'],
            813 => ['variation_id' => '40037053','group_id' => 4003705,'product_url' => 'https://m.media-amazon.com/images/I/51N4NetKp8L.jpg'],
            814 => ['variation_id' => '40037054','group_id' => 4003705,'product_url' => 'https://m.media-amazon.com/images/I/51N4NetKp8L.jpg'],
            815 => ['variation_id' => '40037055','group_id' => 4003705,'product_url' => 'https://m.media-amazon.com/images/I/51N4NetKp8L.jpg'],
            816 => ['variation_id' => '40037056','group_id' => 4003705,'product_url' => 'https://m.media-amazon.com/images/I/51N4NetKp8L.jpg'],
            817 => ['variation_id' => '40037061','group_id' => 4003706,'product_url' => 'https://m.media-amazon.com/images/I/514+d9SSSnL.jpg'],
            818 => ['variation_id' => '40037062','group_id' => 4003706,'product_url' => 'https://m.media-amazon.com/images/I/514+d9SSSnL.jpg'],
            819 => ['variation_id' => '40037063','group_id' => 4003706,'product_url' => 'https://m.media-amazon.com/images/I/514+d9SSSnL.jpg'],
            820 => ['variation_id' => '40037064','group_id' => 4003706,'product_url' => 'https://m.media-amazon.com/images/I/514+d9SSSnL.jpg'],
            821 => ['variation_id' => '40037065','group_id' => 4003706,'product_url' => 'https://m.media-amazon.com/images/I/514+d9SSSnL.jpg'],
            822 => ['variation_id' => '40037066','group_id' => 4003706,'product_url' => 'https://m.media-amazon.com/images/I/514+d9SSSnL.jpg'],
            823 => ['variation_id' => '40038021','group_id' => 4003802,'product_url' => 'https://m.media-amazon.com/images/I/71XMSuSjR4L.jpg'],
            824 => ['variation_id' => '40038022','group_id' => 4003802,'product_url' => 'https://m.media-amazon.com/images/I/71XMSuSjR4L.jpg'],
            825 => ['variation_id' => '40038023','group_id' => 4003802,'product_url' => 'https://m.media-amazon.com/images/I/71XMSuSjR4L.jpg'],
            826 => ['variation_id' => '40038024','group_id' => 4003802,'product_url' => 'https://m.media-amazon.com/images/I/71XMSuSjR4L.jpg'],
            827 => ['variation_id' => '40038025','group_id' => 4003802,'product_url' => 'https://m.media-amazon.com/images/I/71XMSuSjR4L.jpg'],
            828 => ['variation_id' => '40038026','group_id' => 4003802,'product_url' => 'https://m.media-amazon.com/images/I/71XMSuSjR4L.jpg'],
            829 => ['variation_id' => '40039021','group_id' => 4003902,'product_url' => 'https://m.media-amazon.com/images/I/41a7T9VGdSL.jpg'],
            830 => ['variation_id' => '40039022','group_id' => 4003902,'product_url' => 'https://m.media-amazon.com/images/I/41a7T9VGdSL.jpg'],
            831 => ['variation_id' => '40039023','group_id' => 4003902,'product_url' => 'https://m.media-amazon.com/images/I/41a7T9VGdSL.jpg'],
            832 => ['variation_id' => '40039024','group_id' => 4003902,'product_url' => 'https://m.media-amazon.com/images/I/41a7T9VGdSL.jpg'],
            833 => ['variation_id' => '40039025','group_id' => 4003902,'product_url' => 'https://m.media-amazon.com/images/I/41a7T9VGdSL.jpg'],
            834 => ['variation_id' => '40039026','group_id' => 4003902,'product_url' => 'https://m.media-amazon.com/images/I/41a7T9VGdSL.jpg'],
            835 => ['variation_id' => '40039041','group_id' => 4003904,'product_url' => 'https://m.media-amazon.com/images/I/41XmGywFiPL.jpg'],
            836 => ['variation_id' => '40039042','group_id' => 4003904,'product_url' => 'https://m.media-amazon.com/images/I/41XmGywFiPL.jpg'],
            837 => ['variation_id' => '40039043','group_id' => 4003904,'product_url' => 'https://m.media-amazon.com/images/I/41XmGywFiPL.jpg'],
            838 => ['variation_id' => '40039044','group_id' => 4003904,'product_url' => 'https://m.media-amazon.com/images/I/41XmGywFiPL.jpg'],
            839 => ['variation_id' => '40039045','group_id' => 4003904,'product_url' => 'https://m.media-amazon.com/images/I/41XmGywFiPL.jpg'],
            840 => ['variation_id' => '40039046','group_id' => 4003904,'product_url' => 'https://m.media-amazon.com/images/I/41XmGywFiPL.jpg'],
            841 => ['variation_id' => '40039081','group_id' => 4003908,'product_url' => 'https://m.media-amazon.com/images/I/41mr87FXZyS.jpg'],
            842 => ['variation_id' => '40039082','group_id' => 4003908,'product_url' => 'https://m.media-amazon.com/images/I/41mr87FXZyS.jpg'],
            843 => ['variation_id' => '40039083','group_id' => 4003908,'product_url' => 'https://m.media-amazon.com/images/I/41mr87FXZyS.jpg'],
            844 => ['variation_id' => '40039084','group_id' => 4003908,'product_url' => 'https://m.media-amazon.com/images/I/41mr87FXZyS.jpg'],
            845 => ['variation_id' => '40039085','group_id' => 4003908,'product_url' => 'https://m.media-amazon.com/images/I/41mr87FXZyS.jpg'],
            846 => ['variation_id' => '40039086','group_id' => 4003908,'product_url' => 'https://m.media-amazon.com/images/I/41mr87FXZyS.jpg'],
            847 => ['variation_id' => '40040041','group_id' => 4004004,'product_url' => 'https://m.media-amazon.com/images/I/41n+e3pavLS.jpg'],
            848 => ['variation_id' => '40040042','group_id' => 4004004,'product_url' => 'https://m.media-amazon.com/images/I/41n+e3pavLS.jpg'],
            849 => ['variation_id' => '40040043','group_id' => 4004004,'product_url' => 'https://m.media-amazon.com/images/I/41n+e3pavLS.jpg'],
            850 => ['variation_id' => '40040044','group_id' => 4004004,'product_url' => 'https://m.media-amazon.com/images/I/41n+e3pavLS.jpg'],
            851 => ['variation_id' => '40040045','group_id' => 4004004,'product_url' => 'https://m.media-amazon.com/images/I/41n+e3pavLS.jpg'],
            852 => ['variation_id' => '40040046','group_id' => 4004004,'product_url' => 'https://m.media-amazon.com/images/I/41n+e3pavLS.jpg'],
            853 => ['variation_id' => '40040081','group_id' => 4004008,'product_url' => 'https://m.media-amazon.com/images/I/41Gct0ZnqML.jpg'],
            854 => ['variation_id' => '40040082','group_id' => 4004008,'product_url' => 'https://m.media-amazon.com/images/I/41Gct0ZnqML.jpg'],
            855 => ['variation_id' => '40040083','group_id' => 4004008,'product_url' => 'https://m.media-amazon.com/images/I/41Gct0ZnqML.jpg'],
            856 => ['variation_id' => '40040084','group_id' => 4004008,'product_url' => 'https://m.media-amazon.com/images/I/41Gct0ZnqML.jpg'],
            857 => ['variation_id' => '40040085','group_id' => 4004008,'product_url' => 'https://m.media-amazon.com/images/I/41Gct0ZnqML.jpg'],
            858 => ['variation_id' => '40040086','group_id' => 4004008,'product_url' => 'https://m.media-amazon.com/images/I/41Gct0ZnqML.jpg'],
            859 => ['variation_id' => '40041021','group_id' => 4004102,'product_url' => 'https://m.media-amazon.com/images/I/6117B2kcNGL.jpg'],
            860 => ['variation_id' => '40041022','group_id' => 4004102,'product_url' => 'https://m.media-amazon.com/images/I/6117B2kcNGL.jpg'],
            861 => ['variation_id' => '40041023','group_id' => 4004102,'product_url' => 'https://m.media-amazon.com/images/I/6117B2kcNGL.jpg'],
            862 => ['variation_id' => '40041024','group_id' => 4004102,'product_url' => 'https://m.media-amazon.com/images/I/6117B2kcNGL.jpg'],
            863 => ['variation_id' => '40041025','group_id' => 4004102,'product_url' => 'https://m.media-amazon.com/images/I/6117B2kcNGL.jpg'],
            864 => ['variation_id' => '40041026','group_id' => 4004102,'product_url' => 'https://m.media-amazon.com/images/I/6117B2kcNGL.jpg'],
            865 => ['variation_id' => '40041032','group_id' => 4004103,'product_url' => 'https://m.media-amazon.com/images/I/41t5nH4ny-L.jpg'],
            866 => ['variation_id' => '40041033','group_id' => 4004103,'product_url' => 'https://m.media-amazon.com/images/I/41t5nH4ny-L.jpg'],
            867 => ['variation_id' => '40041034','group_id' => 4004103,'product_url' => 'https://m.media-amazon.com/images/I/41t5nH4ny-L.jpg'],
            868 => ['variation_id' => '40041035','group_id' => 4004103,'product_url' => 'https://m.media-amazon.com/images/I/41t5nH4ny-L.jpg'],
            869 => ['variation_id' => '40041036','group_id' => 4004103,'product_url' => 'https://m.media-amazon.com/images/I/41t5nH4ny-L.jpg'],
            870 => ['variation_id' => '40041042','group_id' => 4004104,'product_url' => 'https://m.media-amazon.com/images/I/41jLMuBzAtL.jpg'],
            871 => ['variation_id' => '40041043','group_id' => 4004104,'product_url' => 'https://m.media-amazon.com/images/I/41jLMuBzAtL.jpg'],
            872 => ['variation_id' => '40041044','group_id' => 4004104,'product_url' => 'https://m.media-amazon.com/images/I/41jLMuBzAtL.jpg'],
            873 => ['variation_id' => '40041045','group_id' => 4004104,'product_url' => 'https://m.media-amazon.com/images/I/41jLMuBzAtL.jpg'],
            874 => ['variation_id' => '40041046','group_id' => 4004104,'product_url' => 'https://m.media-amazon.com/images/I/41jLMuBzAtL.jpg'],
            875 => ['variation_id' => '40041051','group_id' => 4004105,'product_url' => 'https://m.media-amazon.com/images/I/71VfSsjL6NL.jpg'],
            876 => ['variation_id' => '40041052','group_id' => 4004105,'product_url' => 'https://m.media-amazon.com/images/I/71VfSsjL6NL.jpg'],
            877 => ['variation_id' => '40041053','group_id' => 4004105,'product_url' => 'https://m.media-amazon.com/images/I/71VfSsjL6NL.jpg'],
            878 => ['variation_id' => '40041054','group_id' => 4004105,'product_url' => 'https://m.media-amazon.com/images/I/71VfSsjL6NL.jpg'],
            879 => ['variation_id' => '40041055','group_id' => 4004105,'product_url' => 'https://m.media-amazon.com/images/I/71VfSsjL6NL.jpg'],
            880 => ['variation_id' => '40041056','group_id' => 4004105,'product_url' => 'https://m.media-amazon.com/images/I/71VfSsjL6NL.jpg'],
            881 => ['variation_id' => '40041061','group_id' => 4004106,'product_url' => 'https://m.media-amazon.com/images/I/61uklnSr05L.jpg'],
            882 => ['variation_id' => '40041062','group_id' => 4004106,'product_url' => 'https://m.media-amazon.com/images/I/61uklnSr05L.jpg'],
            883 => ['variation_id' => '40041063','group_id' => 4004106,'product_url' => 'https://m.media-amazon.com/images/I/61uklnSr05L.jpg'],
            884 => ['variation_id' => '40041064','group_id' => 4004106,'product_url' => 'https://m.media-amazon.com/images/I/61uklnSr05L.jpg'],
            885 => ['variation_id' => '40041065','group_id' => 4004106,'product_url' => 'https://m.media-amazon.com/images/I/61uklnSr05L.jpg'],
            886 => ['variation_id' => '40041066','group_id' => 4004106,'product_url' => 'https://m.media-amazon.com/images/I/61uklnSr05L.jpg'],
            887 => ['variation_id' => '40041072','group_id' => 4004107,'product_url' => 'https://m.media-amazon.com/images/I/41s73WMLZcL.jpg'],
            888 => ['variation_id' => '40041073','group_id' => 4004107,'product_url' => 'https://m.media-amazon.com/images/I/41s73WMLZcL.jpg'],
            889 => ['variation_id' => '40041074','group_id' => 4004107,'product_url' => 'https://m.media-amazon.com/images/I/41s73WMLZcL.jpg'],
            890 => ['variation_id' => '40041075','group_id' => 4004107,'product_url' => 'https://m.media-amazon.com/images/I/41s73WMLZcL.jpg'],
            891 => ['variation_id' => '40041076','group_id' => 4004107,'product_url' => 'https://m.media-amazon.com/images/I/41s73WMLZcL.jpg'],
            892 => ['variation_id' => '40042021','group_id' => 4004202,'product_url' => 'https://m.media-amazon.com/images/I/41+IEv7+-gL.jpg'],
            893 => ['variation_id' => '40042022','group_id' => 4004202,'product_url' => 'https://m.media-amazon.com/images/I/41+IEv7+-gL.jpg'],
            894 => ['variation_id' => '40042023','group_id' => 4004202,'product_url' => 'https://m.media-amazon.com/images/I/41+IEv7+-gL.jpg'],
            895 => ['variation_id' => '40042024','group_id' => 4004202,'product_url' => 'https://m.media-amazon.com/images/I/41+IEv7+-gL.jpg'],
            896 => ['variation_id' => '40042025','group_id' => 4004202,'product_url' => 'https://m.media-amazon.com/images/I/41+IEv7+-gL.jpg'],
            897 => ['variation_id' => '40042026','group_id' => 4004202,'product_url' => 'https://m.media-amazon.com/images/I/41+IEv7+-gL.jpg'],
            898 => ['variation_id' => '40042042','group_id' => 4004204,'product_url' => 'https://m.media-amazon.com/images/I/418BAa6BIFL.jpg'],
            899 => ['variation_id' => '40042043','group_id' => 4004204,'product_url' => 'https://m.media-amazon.com/images/I/418BAa6BIFL.jpg'],
            900 => ['variation_id' => '40042044','group_id' => 4004204,'product_url' => 'https://m.media-amazon.com/images/I/418BAa6BIFL.jpg'],
            901 => ['variation_id' => '40042045','group_id' => 4004204,'product_url' => 'https://m.media-amazon.com/images/I/418BAa6BIFL.jpg'],
            902 => ['variation_id' => '40042046','group_id' => 4004204,'product_url' => 'https://m.media-amazon.com/images/I/418BAa6BIFL.jpg'],
            903 => ['variation_id' => '40042051','group_id' => 4004205,'product_url' => 'https://m.media-amazon.com/images/I/41pz1jKRc5L.jpg'],
            904 => ['variation_id' => '40042052','group_id' => 4004205,'product_url' => 'https://m.media-amazon.com/images/I/41pz1jKRc5L.jpg'],
            905 => ['variation_id' => '40042053','group_id' => 4004205,'product_url' => 'https://m.media-amazon.com/images/I/41pz1jKRc5L.jpg'],
            906 => ['variation_id' => '40042054','group_id' => 4004205,'product_url' => 'https://m.media-amazon.com/images/I/41pz1jKRc5L.jpg'],
            907 => ['variation_id' => '40042055','group_id' => 4004205,'product_url' => 'https://m.media-amazon.com/images/I/41pz1jKRc5L.jpg'],
            908 => ['variation_id' => '40042056','group_id' => 4004205,'product_url' => 'https://m.media-amazon.com/images/I/41pz1jKRc5L.jpg'],
            909 => ['variation_id' => '40042061','group_id' => 4004206,'product_url' => 'https://m.media-amazon.com/images/I/61edSAUIVXL.jpg'],
            910 => ['variation_id' => '40042062','group_id' => 4004206,'product_url' => 'https://m.media-amazon.com/images/I/61edSAUIVXL.jpg'],
            911 => ['variation_id' => '40042063','group_id' => 4004206,'product_url' => 'https://m.media-amazon.com/images/I/61edSAUIVXL.jpg'],
            912 => ['variation_id' => '40042064','group_id' => 4004206,'product_url' => 'https://m.media-amazon.com/images/I/61edSAUIVXL.jpg'],
            913 => ['variation_id' => '40042065','group_id' => 4004206,'product_url' => 'https://m.media-amazon.com/images/I/61edSAUIVXL.jpg'],
            914 => ['variation_id' => '40042066','group_id' => 4004206,'product_url' => 'https://m.media-amazon.com/images/I/61edSAUIVXL.jpg'],
            915 => ['variation_id' => '40042071','group_id' => 4004207,'product_url' => 'https://m.media-amazon.com/images/I/51EWGKXN-NL.jpg'],
            916 => ['variation_id' => '40042072','group_id' => 4004207,'product_url' => 'https://m.media-amazon.com/images/I/51EWGKXN-NL.jpg'],
            917 => ['variation_id' => '40042073','group_id' => 4004207,'product_url' => 'https://m.media-amazon.com/images/I/51EWGKXN-NL.jpg'],
            918 => ['variation_id' => '40042074','group_id' => 4004207,'product_url' => 'https://m.media-amazon.com/images/I/51EWGKXN-NL.jpg'],
            919 => ['variation_id' => '40042075','group_id' => 4004207,'product_url' => 'https://m.media-amazon.com/images/I/51EWGKXN-NL.jpg'],
            920 => ['variation_id' => '40042076','group_id' => 4004207,'product_url' => 'https://m.media-amazon.com/images/I/51EWGKXN-NL.jpg'],
            921 => ['variation_id' => '40043011','group_id' => 4004301,'product_url' => 'https://m.media-amazon.com/images/I/31uB6UuKYSL.jpg'],
            922 => ['variation_id' => '40043012','group_id' => 4004301,'product_url' => 'https://m.media-amazon.com/images/I/31uB6UuKYSL.jpg'],
            923 => ['variation_id' => '40043013','group_id' => 4004301,'product_url' => 'https://m.media-amazon.com/images/I/31uB6UuKYSL.jpg'],
            924 => ['variation_id' => '40043014','group_id' => 4004301,'product_url' => 'https://m.media-amazon.com/images/I/31uB6UuKYSL.jpg'],
            925 => ['variation_id' => '40043015','group_id' => 4004301,'product_url' => 'https://m.media-amazon.com/images/I/31uB6UuKYSL.jpg'],
            926 => ['variation_id' => '40043016','group_id' => 4004301,'product_url' => 'https://m.media-amazon.com/images/I/31uB6UuKYSL.jpg'],
            927 => ['variation_id' => '40043051','group_id' => 4004305,'product_url' => 'https://m.media-amazon.com/images/I/411PjNw2eZL.jpg'],
            928 => ['variation_id' => '40043052','group_id' => 4004305,'product_url' => 'https://m.media-amazon.com/images/I/411PjNw2eZL.jpg'],
            929 => ['variation_id' => '40043053','group_id' => 4004305,'product_url' => 'https://m.media-amazon.com/images/I/411PjNw2eZL.jpg'],
            930 => ['variation_id' => '40043054','group_id' => 4004305,'product_url' => 'https://m.media-amazon.com/images/I/411PjNw2eZL.jpg'],
            931 => ['variation_id' => '40043055','group_id' => 4004305,'product_url' => 'https://m.media-amazon.com/images/I/411PjNw2eZL.jpg'],
            932 => ['variation_id' => '40043056','group_id' => 4004305,'product_url' => 'https://m.media-amazon.com/images/I/411PjNw2eZL.jpg'],
            933 => ['variation_id' => '40043061','group_id' => 4004306,'product_url' => 'https://m.media-amazon.com/images/I/31xyA8PzB1L.jpg'],
            934 => ['variation_id' => '40043062','group_id' => 4004306,'product_url' => 'https://m.media-amazon.com/images/I/31xyA8PzB1L.jpg'],
            935 => ['variation_id' => '40043063','group_id' => 4004306,'product_url' => 'https://m.media-amazon.com/images/I/31xyA8PzB1L.jpg'],
            936 => ['variation_id' => '40043064','group_id' => 4004306,'product_url' => 'https://m.media-amazon.com/images/I/31xyA8PzB1L.jpg'],
            937 => ['variation_id' => '40043065','group_id' => 4004306,'product_url' => 'https://m.media-amazon.com/images/I/31xyA8PzB1L.jpg'],
            938 => ['variation_id' => '40043066','group_id' => 4004306,'product_url' => 'https://m.media-amazon.com/images/I/31xyA8PzB1L.jpg'],
            939 => ['variation_id' => '40043091','group_id' => 4004309,'product_url' => 'https://m.media-amazon.com/images/I/31m1olE-0tL.jpg'],
            940 => ['variation_id' => '40043092','group_id' => 4004309,'product_url' => 'https://m.media-amazon.com/images/I/31m1olE-0tL.jpg'],
            941 => ['variation_id' => '40043093','group_id' => 4004309,'product_url' => 'https://m.media-amazon.com/images/I/31m1olE-0tL.jpg'],
            942 => ['variation_id' => '40043094','group_id' => 4004309,'product_url' => 'https://m.media-amazon.com/images/I/31m1olE-0tL.jpg'],
            943 => ['variation_id' => '40043095','group_id' => 4004309,'product_url' => 'https://m.media-amazon.com/images/I/31m1olE-0tL.jpg'],
            944 => ['variation_id' => '40043096','group_id' => 4004309,'product_url' => 'https://m.media-amazon.com/images/I/31m1olE-0tL.jpg'],
            945 => ['variation_id' => '40044011','group_id' => 4004401,'product_url' => 'https://m.media-amazon.com/images/I/310x4kxpJNL.jpg'],
            946 => ['variation_id' => '40044012','group_id' => 4004401,'product_url' => 'https://m.media-amazon.com/images/I/310x4kxpJNL.jpg'],
            947 => ['variation_id' => '40044013','group_id' => 4004401,'product_url' => 'https://m.media-amazon.com/images/I/310x4kxpJNL.jpg'],
            948 => ['variation_id' => '40044014','group_id' => 4004401,'product_url' => 'https://m.media-amazon.com/images/I/310x4kxpJNL.jpg'],
            949 => ['variation_id' => '40044015','group_id' => 4004401,'product_url' => 'https://m.media-amazon.com/images/I/310x4kxpJNL.jpg'],
            950 => ['variation_id' => '40044016','group_id' => 4004401,'product_url' => 'https://m.media-amazon.com/images/I/310x4kxpJNL.jpg'],
            951 => ['variation_id' => '40044041','group_id' => 4004404,'product_url' => 'https://m.media-amazon.com/images/I/41BbFUv5dZL.jpg'],
            952 => ['variation_id' => '40044042','group_id' => 4004404,'product_url' => 'https://m.media-amazon.com/images/I/41BbFUv5dZL.jpg'],
            953 => ['variation_id' => '40044043','group_id' => 4004404,'product_url' => 'https://m.media-amazon.com/images/I/41BbFUv5dZL.jpg'],
            954 => ['variation_id' => '40044044','group_id' => 4004404,'product_url' => 'https://m.media-amazon.com/images/I/41BbFUv5dZL.jpg'],
            955 => ['variation_id' => '40044045','group_id' => 4004404,'product_url' => 'https://m.media-amazon.com/images/I/41BbFUv5dZL.jpg'],
            956 => ['variation_id' => '40044046','group_id' => 4004404,'product_url' => 'https://m.media-amazon.com/images/I/41BbFUv5dZL.jpg'],
            957 => ['variation_id' => '40044051','group_id' => 4004405,'product_url' => 'https://m.media-amazon.com/images/I/418nIYi2-tL.jpg'],
            958 => ['variation_id' => '40044052','group_id' => 4004405,'product_url' => 'https://m.media-amazon.com/images/I/418nIYi2-tL.jpg'],
            959 => ['variation_id' => '40044053','group_id' => 4004405,'product_url' => 'https://m.media-amazon.com/images/I/418nIYi2-tL.jpg'],
            960 => ['variation_id' => '40044054','group_id' => 4004405,'product_url' => 'https://m.media-amazon.com/images/I/418nIYi2-tL.jpg'],
            961 => ['variation_id' => '40044055','group_id' => 4004405,'product_url' => 'https://m.media-amazon.com/images/I/418nIYi2-tL.jpg'],
            962 => ['variation_id' => '40044056','group_id' => 4004405,'product_url' => 'https://m.media-amazon.com/images/I/418nIYi2-tL.jpg'],
            963 => ['variation_id' => '40044061','group_id' => 4004406,'product_url' => 'https://m.media-amazon.com/images/I/31lk7qmbw8L.jpg'],
            964 => ['variation_id' => '40044062','group_id' => 4004406,'product_url' => 'https://m.media-amazon.com/images/I/31lk7qmbw8L.jpg'],
            965 => ['variation_id' => '40044063','group_id' => 4004406,'product_url' => 'https://m.media-amazon.com/images/I/31lk7qmbw8L.jpg'],
            966 => ['variation_id' => '40044064','group_id' => 4004406,'product_url' => 'https://m.media-amazon.com/images/I/31lk7qmbw8L.jpg'],
            967 => ['variation_id' => '40044065','group_id' => 4004406,'product_url' => 'https://m.media-amazon.com/images/I/31lk7qmbw8L.jpg'],
            968 => ['variation_id' => '40044066','group_id' => 4004406,'product_url' => 'https://m.media-amazon.com/images/I/31lk7qmbw8L.jpg'],
            969 => ['variation_id' => '40045031','group_id' => 4004503,'product_url' => 'https://m.media-amazon.com/images/I/61jlQULPRTL.jpg'],
            970 => ['variation_id' => '40045032','group_id' => 4004503,'product_url' => 'https://m.media-amazon.com/images/I/61jlQULPRTL.jpg'],
            971 => ['variation_id' => '40045033','group_id' => 4004503,'product_url' => 'https://m.media-amazon.com/images/I/61jlQULPRTL.jpg'],
            972 => ['variation_id' => '40045034','group_id' => 4004503,'product_url' => 'https://m.media-amazon.com/images/I/61jlQULPRTL.jpg'],
            973 => ['variation_id' => '40045035','group_id' => 4004503,'product_url' => 'https://m.media-amazon.com/images/I/61jlQULPRTL.jpg'],
            974 => ['variation_id' => '40045036','group_id' => 4004503,'product_url' => 'https://m.media-amazon.com/images/I/61jlQULPRTL.jpg'],
            975 => ['variation_id' => '40045061','group_id' => 4004506,'product_url' => 'https://m.media-amazon.com/images/I/61FylLK3SVL.jpg'],
            976 => ['variation_id' => '40045062','group_id' => 4004506,'product_url' => 'https://m.media-amazon.com/images/I/61FylLK3SVL.jpg'],
            977 => ['variation_id' => '40045063','group_id' => 4004506,'product_url' => 'https://m.media-amazon.com/images/I/61FylLK3SVL.jpg'],
            978 => ['variation_id' => '40045064','group_id' => 4004506,'product_url' => 'https://m.media-amazon.com/images/I/61FylLK3SVL.jpg'],
            979 => ['variation_id' => '40045065','group_id' => 4004506,'product_url' => 'https://m.media-amazon.com/images/I/61FylLK3SVL.jpg'],
            980 => ['variation_id' => '40045066','group_id' => 4004506,'product_url' => 'https://m.media-amazon.com/images/I/61FylLK3SVL.jpg'],
            981 => ['variation_id' => '40046011','group_id' => 4004601,'product_url' => 'https://m.media-amazon.com/images/I/71PuBZmPvKL.jpg'],
            982 => ['variation_id' => '40046012','group_id' => 4004601,'product_url' => 'https://m.media-amazon.com/images/I/71PuBZmPvKL.jpg'],
            983 => ['variation_id' => '40046013','group_id' => 4004601,'product_url' => 'https://m.media-amazon.com/images/I/71PuBZmPvKL.jpg'],
            984 => ['variation_id' => '40046014','group_id' => 4004601,'product_url' => 'https://m.media-amazon.com/images/I/71PuBZmPvKL.jpg'],
            985 => ['variation_id' => '40046015','group_id' => 4004601,'product_url' => 'https://m.media-amazon.com/images/I/71PuBZmPvKL.jpg'],
            986 => ['variation_id' => '40046016','group_id' => 4004601,'product_url' => 'https://m.media-amazon.com/images/I/71PuBZmPvKL.jpg'],
            987 => ['variation_id' => '40046151','group_id' => 4004615,'product_url' => 'https://m.media-amazon.com/images/I/71rTTiWxKAL.jpg'],
            988 => ['variation_id' => '40046152','group_id' => 4004615,'product_url' => 'https://m.media-amazon.com/images/I/71rTTiWxKAL.jpg'],
            989 => ['variation_id' => '40046153','group_id' => 4004615,'product_url' => 'https://m.media-amazon.com/images/I/71rTTiWxKAL.jpg'],
            990 => ['variation_id' => '40046154','group_id' => 4004615,'product_url' => 'https://m.media-amazon.com/images/I/71rTTiWxKAL.jpg'],
            991 => ['variation_id' => '40046155','group_id' => 4004615,'product_url' => 'https://m.media-amazon.com/images/I/71rTTiWxKAL.jpg'],
            992 => ['variation_id' => '40046156','group_id' => 4004615,'product_url' => 'https://m.media-amazon.com/images/I/71rTTiWxKAL.jpg'],
            993 => ['variation_id' => '40047011','group_id' => 4004701,'product_url' => 'https://m.media-amazon.com/images/I/31z65ELcE2L.jpg'],
            994 => ['variation_id' => '40047012','group_id' => 4004701,'product_url' => 'https://m.media-amazon.com/images/I/31z65ELcE2L.jpg'],
            995 => ['variation_id' => '40047013','group_id' => 4004701,'product_url' => 'https://m.media-amazon.com/images/I/31z65ELcE2L.jpg'],
            996 => ['variation_id' => '40047014','group_id' => 4004701,'product_url' => 'https://m.media-amazon.com/images/I/31z65ELcE2L.jpg'],
            997 => ['variation_id' => '40047015','group_id' => 4004701,'product_url' => 'https://m.media-amazon.com/images/I/31z65ELcE2L.jpg'],
            998 => ['variation_id' => '40047016','group_id' => 4004701,'product_url' => 'https://m.media-amazon.com/images/I/31z65ELcE2L.jpg'],
            999 => ['variation_id' => '40047021','group_id' => 4004702,'product_url' => 'https://m.media-amazon.com/images/I/61uDOrnJYQL.jpg'],
            1000 => ['variation_id' => '40047022','group_id' => 4004702,'product_url' => 'https://m.media-amazon.com/images/I/61uDOrnJYQL.jpg'],
            1001 => ['variation_id' => '40047023','group_id' => 4004702,'product_url' => 'https://m.media-amazon.com/images/I/61uDOrnJYQL.jpg'],
            1002 => ['variation_id' => '40047024','group_id' => 4004702,'product_url' => 'https://m.media-amazon.com/images/I/61uDOrnJYQL.jpg'],
            1003 => ['variation_id' => '40047025','group_id' => 4004702,'product_url' => 'https://m.media-amazon.com/images/I/61uDOrnJYQL.jpg'],
            1004 => ['variation_id' => '40047026','group_id' => 4004702,'product_url' => 'https://m.media-amazon.com/images/I/61uDOrnJYQL.jpg'],
            1005 => ['variation_id' => '40047051','group_id' => 4004705,'product_url' => 'https://m.media-amazon.com/images/I/41Rpw9EvhmL.jpg'],
            1006 => ['variation_id' => '40047052','group_id' => 4004705,'product_url' => 'https://m.media-amazon.com/images/I/41Rpw9EvhmL.jpg'],
            1007 => ['variation_id' => '40047053','group_id' => 4004705,'product_url' => 'https://m.media-amazon.com/images/I/41Rpw9EvhmL.jpg'],
            1008 => ['variation_id' => '40047054','group_id' => 4004705,'product_url' => 'https://m.media-amazon.com/images/I/41Rpw9EvhmL.jpg'],
            1009 => ['variation_id' => '40047055','group_id' => 4004705,'product_url' => 'https://m.media-amazon.com/images/I/41Rpw9EvhmL.jpg'],
            1010 => ['variation_id' => '40047056','group_id' => 4004705,'product_url' => 'https://m.media-amazon.com/images/I/41Rpw9EvhmL.jpg'],
            1011 => ['variation_id' => '40047061','group_id' => 4004706,'product_url' => 'https://m.media-amazon.com/images/I/41aLgBl7joL.jpg'],
            1012 => ['variation_id' => '40047062','group_id' => 4004706,'product_url' => 'https://m.media-amazon.com/images/I/41aLgBl7joL.jpg'],
            1013 => ['variation_id' => '40047063','group_id' => 4004706,'product_url' => 'https://m.media-amazon.com/images/I/41aLgBl7joL.jpg'],
            1014 => ['variation_id' => '40047064','group_id' => 4004706,'product_url' => 'https://m.media-amazon.com/images/I/41aLgBl7joL.jpg'],
            1015 => ['variation_id' => '40047065','group_id' => 4004706,'product_url' => 'https://m.media-amazon.com/images/I/41aLgBl7joL.jpg'],
            1016 => ['variation_id' => '40047066','group_id' => 4004706,'product_url' => 'https://m.media-amazon.com/images/I/41aLgBl7joL.jpg'],
            1017 => ['variation_id' => '40048011','group_id' => 4004801,'product_url' => 'https://m.media-amazon.com/images/I/61tCahtMzCL.jpg'],
            1018 => ['variation_id' => '40048012','group_id' => 4004801,'product_url' => 'https://m.media-amazon.com/images/I/61tCahtMzCL.jpg'],
            1019 => ['variation_id' => '40048013','group_id' => 4004801,'product_url' => 'https://m.media-amazon.com/images/I/61tCahtMzCL.jpg'],
            1020 => ['variation_id' => '40048014','group_id' => 4004801,'product_url' => 'https://m.media-amazon.com/images/I/61tCahtMzCL.jpg'],
            1021 => ['variation_id' => '40048015','group_id' => 4004801,'product_url' => 'https://m.media-amazon.com/images/I/61tCahtMzCL.jpg'],
            1022 => ['variation_id' => '40048016','group_id' => 4004801,'product_url' => 'https://m.media-amazon.com/images/I/61tCahtMzCL.jpg'],
            1023 => ['variation_id' => '40048021','group_id' => 4004802,'product_url' => 'https://m.media-amazon.com/images/I/31CZ03SDkTL.jpg'],
            1024 => ['variation_id' => '40048022','group_id' => 4004802,'product_url' => 'https://m.media-amazon.com/images/I/31CZ03SDkTL.jpg'],
            1025 => ['variation_id' => '40048023','group_id' => 4004802,'product_url' => 'https://m.media-amazon.com/images/I/31CZ03SDkTL.jpg'],
            1026 => ['variation_id' => '40048024','group_id' => 4004802,'product_url' => 'https://m.media-amazon.com/images/I/31CZ03SDkTL.jpg'],
            1027 => ['variation_id' => '40048025','group_id' => 4004802,'product_url' => 'https://m.media-amazon.com/images/I/31CZ03SDkTL.jpg'],
            1028 => ['variation_id' => '40048026','group_id' => 4004802,'product_url' => 'https://m.media-amazon.com/images/I/31CZ03SDkTL.jpg'],
            1029 => ['variation_id' => '40048051','group_id' => 4004805,'product_url' => 'https://m.media-amazon.com/images/I/615lIvClejL.jpg'],
            1030 => ['variation_id' => '40048052','group_id' => 4004805,'product_url' => 'https://m.media-amazon.com/images/I/615lIvClejL.jpg'],
            1031 => ['variation_id' => '40048053','group_id' => 4004805,'product_url' => 'https://m.media-amazon.com/images/I/615lIvClejL.jpg'],
            1032 => ['variation_id' => '40048054','group_id' => 4004805,'product_url' => 'https://m.media-amazon.com/images/I/615lIvClejL.jpg'],
            1033 => ['variation_id' => '40048055','group_id' => 4004805,'product_url' => 'https://m.media-amazon.com/images/I/615lIvClejL.jpg'],
            1034 => ['variation_id' => '40048056','group_id' => 4004805,'product_url' => 'https://m.media-amazon.com/images/I/615lIvClejL.jpg'],
            1035 => ['variation_id' => '40048061','group_id' => 4004806,'product_url' => 'https://m.media-amazon.com/images/I/61Cy9ZAfXuL.jpg'],
            1036 => ['variation_id' => '40048062','group_id' => 4004806,'product_url' => 'https://m.media-amazon.com/images/I/61Cy9ZAfXuL.jpg'],
            1037 => ['variation_id' => '40048063','group_id' => 4004806,'product_url' => 'https://m.media-amazon.com/images/I/61Cy9ZAfXuL.jpg'],
            1038 => ['variation_id' => '40048064','group_id' => 4004806,'product_url' => 'https://m.media-amazon.com/images/I/61Cy9ZAfXuL.jpg'],
            1039 => ['variation_id' => '40048065','group_id' => 4004806,'product_url' => 'https://m.media-amazon.com/images/I/61Cy9ZAfXuL.jpg'],
            1040 => ['variation_id' => '40048066','group_id' => 4004806,'product_url' => 'https://m.media-amazon.com/images/I/61Cy9ZAfXuL.jpg'],
            1041 => ['variation_id' => '40049011','group_id' => 4004901,'product_url' => 'https://m.media-amazon.com/images/I/71DWVHOQzUL.jpg'],
            1042 => ['variation_id' => '40049012','group_id' => 4004901,'product_url' => 'https://m.media-amazon.com/images/I/71DWVHOQzUL.jpg'],
            1043 => ['variation_id' => '40049013','group_id' => 4004901,'product_url' => 'https://m.media-amazon.com/images/I/71DWVHOQzUL.jpg'],
            1044 => ['variation_id' => '40049014','group_id' => 4004901,'product_url' => 'https://m.media-amazon.com/images/I/71DWVHOQzUL.jpg'],
            1045 => ['variation_id' => '40049015','group_id' => 4004901,'product_url' => 'https://m.media-amazon.com/images/I/71DWVHOQzUL.jpg'],
            1046 => ['variation_id' => '40049016','group_id' => 4004901,'product_url' => 'https://m.media-amazon.com/images/I/71DWVHOQzUL.jpg'],
            1047 => ['variation_id' => '40049021','group_id' => 4004902,'product_url' => 'https://m.media-amazon.com/images/I/71wGhvtlGzL.jpg'],
            1048 => ['variation_id' => '40049022','group_id' => 4004902,'product_url' => 'https://m.media-amazon.com/images/I/71wGhvtlGzL.jpg'],
            1049 => ['variation_id' => '40049023','group_id' => 4004902,'product_url' => 'https://m.media-amazon.com/images/I/71wGhvtlGzL.jpg'],
            1050 => ['variation_id' => '40049024','group_id' => 4004902,'product_url' => 'https://m.media-amazon.com/images/I/71wGhvtlGzL.jpg'],
            1051 => ['variation_id' => '40049025','group_id' => 4004902,'product_url' => 'https://m.media-amazon.com/images/I/71wGhvtlGzL.jpg'],
            1052 => ['variation_id' => '40049026','group_id' => 4004902,'product_url' => 'https://m.media-amazon.com/images/I/71wGhvtlGzL.jpg'],
            1053 => ['variation_id' => '40049061','group_id' => 4004906,'product_url' => 'https://m.media-amazon.com/images/I/718YUttv5iL.jpg'],
            1054 => ['variation_id' => '40049062','group_id' => 4004906,'product_url' => 'https://m.media-amazon.com/images/I/718YUttv5iL.jpg'],
            1055 => ['variation_id' => '40049063','group_id' => 4004906,'product_url' => 'https://m.media-amazon.com/images/I/718YUttv5iL.jpg'],
            1056 => ['variation_id' => '40049064','group_id' => 4004906,'product_url' => 'https://m.media-amazon.com/images/I/718YUttv5iL.jpg'],
            1057 => ['variation_id' => '40049065','group_id' => 4004906,'product_url' => 'https://m.media-amazon.com/images/I/718YUttv5iL.jpg'],
            1058 => ['variation_id' => '40049066','group_id' => 4004906,'product_url' => 'https://m.media-amazon.com/images/I/718YUttv5iL.jpg'],
            1059 => ['variation_id' => '40050021','group_id' => 4005002,'product_url' => 'https://m.media-amazon.com/images/I/31gaoPBjcuL.jpg'],
            1060 => ['variation_id' => '40050022','group_id' => 4005002,'product_url' => 'https://m.media-amazon.com/images/I/31gaoPBjcuL.jpg'],
            1061 => ['variation_id' => '40050023','group_id' => 4005002,'product_url' => 'https://m.media-amazon.com/images/I/31gaoPBjcuL.jpg'],
            1062 => ['variation_id' => '40050024','group_id' => 4005002,'product_url' => 'https://m.media-amazon.com/images/I/31gaoPBjcuL.jpg'],
            1063 => ['variation_id' => '40050025','group_id' => 4005002,'product_url' => 'https://m.media-amazon.com/images/I/31gaoPBjcuL.jpg'],
            1064 => ['variation_id' => '40050026','group_id' => 4005002,'product_url' => 'https://m.media-amazon.com/images/I/31gaoPBjcuL.jpg'],
            1065 => ['variation_id' => '40050051','group_id' => 4005005,'product_url' => 'https://m.media-amazon.com/images/I/41tubP59o5L.jpg'],
            1066 => ['variation_id' => '40050052','group_id' => 4005005,'product_url' => 'https://m.media-amazon.com/images/I/41tubP59o5L.jpg'],
            1067 => ['variation_id' => '40050053','group_id' => 4005005,'product_url' => 'https://m.media-amazon.com/images/I/41tubP59o5L.jpg'],
            1068 => ['variation_id' => '40050054','group_id' => 4005005,'product_url' => 'https://m.media-amazon.com/images/I/41tubP59o5L.jpg'],
            1069 => ['variation_id' => '40050055','group_id' => 4005005,'product_url' => 'https://m.media-amazon.com/images/I/41tubP59o5L.jpg'],
            1070 => ['variation_id' => '40050056','group_id' => 4005005,'product_url' => 'https://m.media-amazon.com/images/I/41tubP59o5L.jpg'],
            1071 => ['variation_id' => '40050061','group_id' => 4005006,'product_url' => 'https://m.media-amazon.com/images/I/31KcNqi5kBL.jpg'],
            1072 => ['variation_id' => '40050062','group_id' => 4005006,'product_url' => 'https://m.media-amazon.com/images/I/31KcNqi5kBL.jpg'],
            1073 => ['variation_id' => '40050063','group_id' => 4005006,'product_url' => 'https://m.media-amazon.com/images/I/31KcNqi5kBL.jpg'],
            1074 => ['variation_id' => '40050064','group_id' => 4005006,'product_url' => 'https://m.media-amazon.com/images/I/31KcNqi5kBL.jpg'],
            1075 => ['variation_id' => '40050065','group_id' => 4005006,'product_url' => 'https://m.media-amazon.com/images/I/31KcNqi5kBL.jpg'],
            1076 => ['variation_id' => '40050066','group_id' => 4005006,'product_url' => 'https://m.media-amazon.com/images/I/31KcNqi5kBL.jpg'],
            1077 => ['variation_id' => '40051011','group_id' => 4005101,'product_url' => 'https://m.media-amazon.com/images/I/319st+-vLVL.jpg'],
            1078 => ['variation_id' => '40051012','group_id' => 4005101,'product_url' => 'https://m.media-amazon.com/images/I/319st+-vLVL.jpg'],
            1079 => ['variation_id' => '40051013','group_id' => 4005101,'product_url' => 'https://m.media-amazon.com/images/I/319st+-vLVL.jpg'],
            1080 => ['variation_id' => '40051014','group_id' => 4005101,'product_url' => 'https://m.media-amazon.com/images/I/319st+-vLVL.jpg'],
            1081 => ['variation_id' => '40051015','group_id' => 4005101,'product_url' => 'https://m.media-amazon.com/images/I/319st+-vLVL.jpg'],
            1082 => ['variation_id' => '40051016','group_id' => 4005101,'product_url' => 'https://m.media-amazon.com/images/I/319st+-vLVL.jpg'],
            1083 => ['variation_id' => '40051052','group_id' => 4005105,'product_url' => 'https://m.media-amazon.com/images/I/41CwterYCDL.jpg'],
            1084 => ['variation_id' => '40051053','group_id' => 4005105,'product_url' => 'https://m.media-amazon.com/images/I/41CwterYCDL.jpg'],
            1085 => ['variation_id' => '40051054','group_id' => 4005105,'product_url' => 'https://m.media-amazon.com/images/I/41CwterYCDL.jpg'],
            1086 => ['variation_id' => '40051055','group_id' => 4005105,'product_url' => 'https://m.media-amazon.com/images/I/41CwterYCDL.jpg'],
            1087 => ['variation_id' => '40051056','group_id' => 4005105,'product_url' => 'https://m.media-amazon.com/images/I/41CwterYCDL.jpg'],
            1088 => ['variation_id' => '40051062','group_id' => 4005106,'product_url' => 'https://m.media-amazon.com/images/I/41IsdzOzVrL.jpg'],
            1089 => ['variation_id' => '40051063','group_id' => 4005106,'product_url' => 'https://m.media-amazon.com/images/I/41IsdzOzVrL.jpg'],
            1090 => ['variation_id' => '40051064','group_id' => 4005106,'product_url' => 'https://m.media-amazon.com/images/I/41IsdzOzVrL.jpg'],
            1091 => ['variation_id' => '40051065','group_id' => 4005106,'product_url' => 'https://m.media-amazon.com/images/I/41IsdzOzVrL.jpg'],
            1092 => ['variation_id' => '40051066','group_id' => 4005106,'product_url' => 'https://m.media-amazon.com/images/I/41IsdzOzVrL.jpg'],
            1093 => ['variation_id' => '40052011','group_id' => 4005201,'product_url' => 'https://m.media-amazon.com/images/I/313uelcbBnL.jpg'],
            1094 => ['variation_id' => '40052012','group_id' => 4005201,'product_url' => 'https://m.media-amazon.com/images/I/313uelcbBnL.jpg'],
            1095 => ['variation_id' => '40052013','group_id' => 4005201,'product_url' => 'https://m.media-amazon.com/images/I/313uelcbBnL.jpg'],
            1096 => ['variation_id' => '40052014','group_id' => 4005201,'product_url' => 'https://m.media-amazon.com/images/I/313uelcbBnL.jpg'],
            1097 => ['variation_id' => '40052015','group_id' => 4005201,'product_url' => 'https://m.media-amazon.com/images/I/313uelcbBnL.jpg'],
            1098 => ['variation_id' => '40052016','group_id' => 4005201,'product_url' => 'https://m.media-amazon.com/images/I/313uelcbBnL.jpg'],
            1099 => ['variation_id' => '40052021','group_id' => 4005202,'product_url' => 'https://m.media-amazon.com/images/I/41oMeMIoEML.jpg'],
            1100 => ['variation_id' => '40052022','group_id' => 4005202,'product_url' => 'https://m.media-amazon.com/images/I/41oMeMIoEML.jpg'],
            1101 => ['variation_id' => '40052023','group_id' => 4005202,'product_url' => 'https://m.media-amazon.com/images/I/41oMeMIoEML.jpg'],
            1102 => ['variation_id' => '40052024','group_id' => 4005202,'product_url' => 'https://m.media-amazon.com/images/I/41oMeMIoEML.jpg'],
            1103 => ['variation_id' => '40052025','group_id' => 4005202,'product_url' => 'https://m.media-amazon.com/images/I/41oMeMIoEML.jpg'],
            1104 => ['variation_id' => '40052026','group_id' => 4005202,'product_url' => 'https://m.media-amazon.com/images/I/41oMeMIoEML.jpg'],
            1105 => ['variation_id' => '40052051','group_id' => 4005205,'product_url' => 'https://m.media-amazon.com/images/I/31AxvbGFLtL.jpg'],
            1106 => ['variation_id' => '40052052','group_id' => 4005205,'product_url' => 'https://m.media-amazon.com/images/I/31AxvbGFLtL.jpg'],
            1107 => ['variation_id' => '40052053','group_id' => 4005205,'product_url' => 'https://m.media-amazon.com/images/I/31AxvbGFLtL.jpg'],
            1108 => ['variation_id' => '40052054','group_id' => 4005205,'product_url' => 'https://m.media-amazon.com/images/I/31AxvbGFLtL.jpg'],
            1109 => ['variation_id' => '40052055','group_id' => 4005205,'product_url' => 'https://m.media-amazon.com/images/I/31AxvbGFLtL.jpg'],
            1110 => ['variation_id' => '40052056','group_id' => 4005205,'product_url' => 'https://m.media-amazon.com/images/I/31AxvbGFLtL.jpg'],
            1111 => ['variation_id' => '40052061','group_id' => 4005206,'product_url' => 'https://m.media-amazon.com/images/I/31A7Y8oQdML.jpg'],
            1112 => ['variation_id' => '40052062','group_id' => 4005206,'product_url' => 'https://m.media-amazon.com/images/I/31A7Y8oQdML.jpg'],
            1113 => ['variation_id' => '40052063','group_id' => 4005206,'product_url' => 'https://m.media-amazon.com/images/I/31A7Y8oQdML.jpg'],
            1114 => ['variation_id' => '40052064','group_id' => 4005206,'product_url' => 'https://m.media-amazon.com/images/I/31A7Y8oQdML.jpg'],
            1115 => ['variation_id' => '40052065','group_id' => 4005206,'product_url' => 'https://m.media-amazon.com/images/I/31A7Y8oQdML.jpg'],
            1116 => ['variation_id' => '40052066','group_id' => 4005206,'product_url' => 'https://m.media-amazon.com/images/I/31A7Y8oQdML.jpg'],
            1117 => ['variation_id' => '40053021','group_id' => 4005302,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655790731.jpg'],
            1118 => ['variation_id' => '40053022','group_id' => 4005302,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655790731.jpg'],
            1119 => ['variation_id' => '40053023','group_id' => 4005302,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655790731.jpg'],
            1120 => ['variation_id' => '40053024','group_id' => 4005302,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655790731.jpg'],
            1121 => ['variation_id' => '40053025','group_id' => 4005302,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655790731.jpg'],
            1122 => ['variation_id' => '40053026','group_id' => 4005302,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655790731.jpg'],
            1123 => ['variation_id' => '40053171','group_id' => 4005317,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655791264.jpg'],
            1124 => ['variation_id' => '40053172','group_id' => 4005317,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655791264.jpg'],
            1125 => ['variation_id' => '40053173','group_id' => 4005317,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655791264.jpg'],
            1126 => ['variation_id' => '40053174','group_id' => 4005317,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655791264.jpg'],
            1127 => ['variation_id' => '40053175','group_id' => 4005317,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655791264.jpg'],
            1128 => ['variation_id' => '40053176','group_id' => 4005317,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655791264.jpg'],
            1129 => ['variation_id' => '40054022','group_id' => 4005402,'product_url' => 'https://m.media-amazon.com/images/I/31+8A8x9NsL.jpg'],
            1130 => ['variation_id' => '40054023','group_id' => 4005402,'product_url' => 'https://m.media-amazon.com/images/I/31+8A8x9NsL.jpg'],
            1131 => ['variation_id' => '40054024','group_id' => 4005402,'product_url' => 'https://m.media-amazon.com/images/I/31+8A8x9NsL.jpg'],
            1132 => ['variation_id' => '40054025','group_id' => 4005402,'product_url' => 'https://m.media-amazon.com/images/I/31+8A8x9NsL.jpg'],
            1133 => ['variation_id' => '40054026','group_id' => 4005402,'product_url' => 'https://m.media-amazon.com/images/I/31+8A8x9NsL.jpg'],
            1134 => ['variation_id' => '40054082','group_id' => 4005408,'product_url' => 'https://m.media-amazon.com/images/I/31md5bbyK-L.jpg'],
            1135 => ['variation_id' => '40054083','group_id' => 4005408,'product_url' => 'https://m.media-amazon.com/images/I/31md5bbyK-L.jpg'],
            1136 => ['variation_id' => '40054084','group_id' => 4005408,'product_url' => 'https://m.media-amazon.com/images/I/31md5bbyK-L.jpg'],
            1137 => ['variation_id' => '40054085','group_id' => 4005408,'product_url' => 'https://m.media-amazon.com/images/I/31md5bbyK-L.jpg'],
            1138 => ['variation_id' => '40054086','group_id' => 4005408,'product_url' => 'https://m.media-amazon.com/images/I/31md5bbyK-L.jpg'],
            1139 => ['variation_id' => '40054172','group_id' => 4005417,'product_url' => 'https://m.media-amazon.com/images/I/31xQoN6-A2L.jpg'],
            1140 => ['variation_id' => '40054173','group_id' => 4005417,'product_url' => 'https://m.media-amazon.com/images/I/31xQoN6-A2L.jpg'],
            1141 => ['variation_id' => '40054174','group_id' => 4005417,'product_url' => 'https://m.media-amazon.com/images/I/31xQoN6-A2L.jpg'],
            1142 => ['variation_id' => '40054175','group_id' => 4005417,'product_url' => 'https://m.media-amazon.com/images/I/31xQoN6-A2L.jpg'],
            1143 => ['variation_id' => '40054176','group_id' => 4005417,'product_url' => 'https://m.media-amazon.com/images/I/31xQoN6-A2L.jpg'],
            1144 => ['variation_id' => '40055172','group_id' => 4005517,'product_url' => 'https://m.media-amazon.com/images/I/41Wtvde7BxL.jpg'],
            1145 => ['variation_id' => '40055173','group_id' => 4005517,'product_url' => 'https://m.media-amazon.com/images/I/41Wtvde7BxL.jpg'],
            1146 => ['variation_id' => '40055174','group_id' => 4005517,'product_url' => 'https://m.media-amazon.com/images/I/41Wtvde7BxL.jpg'],
            1147 => ['variation_id' => '40055175','group_id' => 4005517,'product_url' => 'https://m.media-amazon.com/images/I/41Wtvde7BxL.jpg'],
            1148 => ['variation_id' => '40055176','group_id' => 4005517,'product_url' => 'https://m.media-amazon.com/images/I/41Wtvde7BxL.jpg'],
            1149 => ['variation_id' => '40056082','group_id' => 4005608,'product_url' => 'https://m.media-amazon.com/images/I/413cTw05R9L.jpg'],
            1150 => ['variation_id' => '40056083','group_id' => 4005608,'product_url' => 'https://m.media-amazon.com/images/I/413cTw05R9L.jpg'],
            1151 => ['variation_id' => '40056084','group_id' => 4005608,'product_url' => 'https://m.media-amazon.com/images/I/413cTw05R9L.jpg'],
            1152 => ['variation_id' => '40056085','group_id' => 4005608,'product_url' => 'https://m.media-amazon.com/images/I/413cTw05R9L.jpg'],
            1153 => ['variation_id' => '40056086','group_id' => 4005608,'product_url' => 'https://m.media-amazon.com/images/I/413cTw05R9L.jpg'],
            1154 => ['variation_id' => '40056172','group_id' => 4005617,'product_url' => 'https://m.media-amazon.com/images/I/4115sePFwjL.jpg'],
            1155 => ['variation_id' => '40056173','group_id' => 4005617,'product_url' => 'https://m.media-amazon.com/images/I/4115sePFwjL.jpg'],
            1156 => ['variation_id' => '40056174','group_id' => 4005617,'product_url' => 'https://m.media-amazon.com/images/I/4115sePFwjL.jpg'],
            1157 => ['variation_id' => '40056175','group_id' => 4005617,'product_url' => 'https://m.media-amazon.com/images/I/4115sePFwjL.jpg'],
            1158 => ['variation_id' => '40056176','group_id' => 4005617,'product_url' => 'https://m.media-amazon.com/images/I/4115sePFwjL.jpg'],
            1159 => ['variation_id' => '40057172','group_id' => 4005717,'product_url' => 'https://m.media-amazon.com/images/I/41xm5WR0azL.jpg'],
            1160 => ['variation_id' => '40057173','group_id' => 4005717,'product_url' => 'https://m.media-amazon.com/images/I/41xm5WR0azL.jpg'],
            1161 => ['variation_id' => '40057174','group_id' => 4005717,'product_url' => 'https://m.media-amazon.com/images/I/41xm5WR0azL.jpg'],
            1162 => ['variation_id' => '40057175','group_id' => 4005717,'product_url' => 'https://m.media-amazon.com/images/I/41xm5WR0azL.jpg'],
            1163 => ['variation_id' => '40057176','group_id' => 4005717,'product_url' => 'https://m.media-amazon.com/images/I/41xm5WR0azL.jpg'],
            1164 => ['variation_id' => '40058022','group_id' => 4005802,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472920.jpg'],
            1165 => ['variation_id' => '40058023','group_id' => 4005802,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472920.jpg'],
            1166 => ['variation_id' => '40058024','group_id' => 4005802,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472920.jpg'],
            1167 => ['variation_id' => '40058025','group_id' => 4005802,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472920.jpg'],
            1168 => ['variation_id' => '40058026','group_id' => 4005802,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472920.jpg'],
            1169 => ['variation_id' => '40058062','group_id' => 4005806,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472840.jpg'],
            1170 => ['variation_id' => '40058063','group_id' => 4005806,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472840.jpg'],
            1171 => ['variation_id' => '40058064','group_id' => 4005806,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472840.jpg'],
            1172 => ['variation_id' => '40058065','group_id' => 4005806,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472840.jpg'],
            1173 => ['variation_id' => '40058066','group_id' => 4005806,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655472840.jpg'],
            1174 => ['variation_id' => '40058082','group_id' => 4005808,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655471099.jpg'],
            1175 => ['variation_id' => '40058083','group_id' => 4005808,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655471099.jpg'],
            1176 => ['variation_id' => '40058084','group_id' => 4005808,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655471099.jpg'],
            1177 => ['variation_id' => '40058085','group_id' => 4005808,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655471099.jpg'],
            1178 => ['variation_id' => '40058086','group_id' => 4005808,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655471099.jpg'],
            1179 => ['variation_id' => '40059022','group_id' => 4005902,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655470696.jpg'],
            1180 => ['variation_id' => '40059023','group_id' => 4005902,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655470696.jpg'],
            1181 => ['variation_id' => '40059024','group_id' => 4005902,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655470696.jpg'],
            1182 => ['variation_id' => '40059025','group_id' => 4005902,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655470696.jpg'],
            1183 => ['variation_id' => '40059026','group_id' => 4005902,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655470696.jpg'],
            1184 => ['variation_id' => '40061172','group_id' => 4006117,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655533643.jpg'],
            1185 => ['variation_id' => '40061173','group_id' => 4006117,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655533643.jpg'],
            1186 => ['variation_id' => '40061174','group_id' => 4006117,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655533643.jpg'],
            1187 => ['variation_id' => '40061175','group_id' => 4006117,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655533643.jpg'],
            1188 => ['variation_id' => '40061176','group_id' => 4006117,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655533643.jpg'],
            1189 => ['variation_id' => '40062022','group_id' => 4006202,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655792129.jpg'],
            1190 => ['variation_id' => '40062023','group_id' => 4006202,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655792129.jpg'],
            1191 => ['variation_id' => '40062024','group_id' => 4006202,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655792129.jpg'],
            1192 => ['variation_id' => '40062025','group_id' => 4006202,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655792129.jpg'],
            1193 => ['variation_id' => '40062026','group_id' => 4006202,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1655792129.jpg'],
            1194 => ['variation_id' => '40020172','group_id' => 4002017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926871.jpg'],
            1195 => ['variation_id' => '40020173','group_id' => 4002017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926871.jpg'],
            1196 => ['variation_id' => '40020174','group_id' => 4002017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926871.jpg'],
            1197 => ['variation_id' => '40020175','group_id' => 4002017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926871.jpg'],
            1198 => ['variation_id' => '40020176','group_id' => 4002017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926871.jpg'],
            1199 => ['variation_id' => '40040172','group_id' => 4004017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926999.jpg'],
            1200 => ['variation_id' => '40040173','group_id' => 4004017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926999.jpg'],
            1201 => ['variation_id' => '40040174','group_id' => 4004017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926999.jpg'],
            1202 => ['variation_id' => '40040175','group_id' => 4004017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926999.jpg'],
            1203 => ['variation_id' => '40040176','group_id' => 4004017,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658926999.jpg'],
            1204 => ['variation_id' => '40078172','group_id' => 4007817,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927203.jpg'],
            1205 => ['variation_id' => '40078173','group_id' => 4007817,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927203.jpg'],
            1206 => ['variation_id' => '40078174','group_id' => 4007817,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927203.jpg'],
            1207 => ['variation_id' => '40078175','group_id' => 4007817,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927203.jpg'],
            1208 => ['variation_id' => '40078176','group_id' => 4007817,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927203.jpg'],
            1209 => ['variation_id' => '40080012','group_id' => 4008001,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1659005559.jpg'],
            1210 => ['variation_id' => '40080013','group_id' => 4008001,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1659005559.jpg'],
            1211 => ['variation_id' => '40080014','group_id' => 4008001,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1659005559.jpg'],
            1212 => ['variation_id' => '40080015','group_id' => 4008001,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1659005559.jpg'],
            1213 => ['variation_id' => '40080016','group_id' => 4008001,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1659005559.jpg'],
            1214 => ['variation_id' => '40071082','group_id' => 4007108,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927326.jpg'],
            1215 => ['variation_id' => '40071083','group_id' => 4007108,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927326.jpg'],
            1216 => ['variation_id' => '40071084','group_id' => 4007108,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927326.jpg'],
            1217 => ['variation_id' => '40071085','group_id' => 4007108,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927326.jpg'],
            1218 => ['variation_id' => '40071086','group_id' => 4007108,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927326.jpg'],
            1219 => ['variation_id' => '40071042','group_id' => 4007104,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927375.jpg'],
            1220 => ['variation_id' => '40071043','group_id' => 4007104,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927375.jpg'],
            1221 => ['variation_id' => '40071044','group_id' => 4007104,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927375.jpg'],
            1222 => ['variation_id' => '40071045','group_id' => 4007104,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927375.jpg'],
            1223 => ['variation_id' => '40071046','group_id' => 4007104,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927375.jpg'],
            1224 => ['variation_id' => '40079012','group_id' => 4007901,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927554.jpg'],
            1225 => ['variation_id' => '40079013','group_id' => 4007901,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927554.jpg'],
            1226 => ['variation_id' => '40079014','group_id' => 4007901,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927554.jpg'],
            1227 => ['variation_id' => '40079015','group_id' => 4007901,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927554.jpg'],
            1228 => ['variation_id' => '40079016','group_id' => 4007901,'product_url' => 'https://esireopex.com/miniopex_pro/uploads/sku_images/1658927554.jpg'],

        ];
        
        foreach($arr as $key =>  $val){
            $variation_id=$val['variation_id'];
            $group_id=$val['group_id'];
            $product_url=$val['product_url'];
            
            $where=['variation_design' => $variation_id];
            
            $update=['product_url' => $product_url];
            
            $check=\DB::table('product_info_design')->where($where)->get();
            
            if($check->count()>0){
                \DB::table('product_info_design')->where($where)->update($update);
            }
            
            
            
            
        }
        
        return response()->json(['code' => 200]);
        
    }
    
    public function db_reset(){
        $array=['assign_quantity',
            'barcodes',
            'barcodes_log',
            'product_barcodes',
            'bundle_list_pr_wise',
            'bundle_processed',
            'gatepass_reverse_history',
            'gatepass_serial',
            'processed_orders',
            'processed_order_quantity',
            'process_orders',
            'process_order_quantity',
            'product_barcodes',
            'product_receiving',
            'pr_data',
            'purchase_order_quantity',
            'view_products_orders',
            'scanning',
            'shipment_info',
            'shipment',
            'box_info',
            'item_adjustment',
            'upload_box_label'
        ];
        
        foreach($array as  $val){
            DB::table($val)->truncate();
        }
        
         return response()->json(['code' => 200, 'message' =>'Db reset Successfully']);
    }
}
