<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Illuminate\Support\Facades\DB;

use Helper;

class ExtraController extends Controller
{
    private $db_reset_key;
    function __construct(){
        $this->middleware('guest');
        $this->db_reset_key='9891231465';
        
    }
    
    public function extraNice(){
        $cool='nice one check';
        $wonder='nice coool nce';
    }
    
    public function extraFunction(){
        $variation='40013013';
        $minus_qty='2';
        $store_id=1;
        Helper::inStock_minus($variation,$minus_qty,$store_id);
        echo 'done';
    }
    
    public function dbReset(Request $request){
        if($request->isMethod('post')){
            
        }else{
            return view('extra.db_reset');
        }
    }
    
    public function get_excel(){
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load(public_path('backend/stock.xlsx'));
        
        
            // $spreadsheet = $reader->load($_FILES['file_img']['tmp_name']);

            $allDataInSheet = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

            $arrayCount = count($allDataInSheet);
            $flag = 0;
            $createArray = array('variation_id','Prouduct_Name','approve_qty','In_Hand_Qty');
            $makeArray = array(
                    'variation_id'=>'variation_id',
                    'Prouduct_Name'=>'Prouduct_Name' ,
                    'approve_qty' => 'approve_qty', 
                    'In_Hand_Qty' => 'In_Hand_Qty',
            );
            $SheetDataKey = array();

            foreach ($allDataInSheet as $dataInSheet) {
                foreach ($dataInSheet as $key => $value) {
                    if (in_array(trim($value), $createArray)) {
                        $value = preg_replace('/\s+/', '', $value);
                        $SheetDataKey[trim($value)] = $key;
                    } 
                }
            }
            
            // dd($SheetDataKey);
            $dataDiff = array_diff_key($makeArray, $SheetDataKey);
            // dd($dataDiff);  

            if (empty($dataDiff)) {
                $flag = 1;
            }
            $fetchData=array();
            if($flag==1){
                for ($i = 2; $i <= $arrayCount; $i++) {
                    $variation_id = $SheetDataKey['variation_id'];
                    $Prouduct_Name = $SheetDataKey['Prouduct_Name'];
                    $approve_qty = $SheetDataKey['approve_qty'];
                    $In_Hand_Qty = $SheetDataKey['In_Hand_Qty'];
                
                    $variation_id = filter_var(trim($allDataInSheet[$i][$variation_id]), FILTER_SANITIZE_STRING);
                    $Prouduct_Name = filter_var(trim($allDataInSheet[$i][$Prouduct_Name]), FILTER_SANITIZE_STRING);
                    $approve_qty = filter_var(trim($allDataInSheet[$i][$approve_qty]), FILTER_SANITIZE_STRING);
                    $In_Hand_Qty = filter_var(trim($allDataInSheet[$i][$In_Hand_Qty]), FILTER_SANITIZE_STRING);
                    
                    $output = preg_replace( '/[^0-9]/', '',$In_Hand_Qty);
                    if($output){
                        $where=[
                            'variation_id' => $variation_id
                        ];
                        
                        $update=[
                            'Quantity' => $In_Hand_Qty
                        ];
                        DB::table('product_info')->where($where)->update($update);
                    }
                    
                }
                
                echo "done";
            }else{
                $error= "Please import correct file, did not match excel sheet column";
                $type=1;
            }
    }
    
    public function get_sup_po_no($supplier){
        $check=\DB::table('suppliers')->where('id',$supplier)->get();
        $ponumber='';
        if($check->count()>0){
            $row=$check->first();
            $today=strtotime(date("Y-m-d"));
            $update_date= strtotime($row->sup_po_no_date);
            
            $datediff = $today - $update_date;
            $difference = floor($datediff/(60*60*24));
            if($difference==0){
                $serial=$row->sup_po_no;
                $ponumber=$row->short_name.$serial;
            }else{
                $serial=(int)$row->sup_po_no+1;
                $ponumber=$row->short_name.$serial;
               
                $update_re=[
                    'sup_po_no' => $serial,
                    'sup_po_no_date' => date('Y-m-d')
                ];
                
                \DB::table('suppliers')->where('id',$supplier)->update($update_re);
            }
        }
        return $ponumber;
    }
    
    public function test_mail(){
        
        // \Mail::raw('Test Mail from Amazon Ses', function($message) {
        //   $message->subject('Mail from Amazon Ses')->to(['smsufian.esire@gmail.com','tahir.esire@gmail.com']);
        //   $message->Attach(asset('uploads/sku_images/1622114540.jpg'));
        //   $message->Attach(asset('uploads/upload_excel/1628078612.xlsx'));
        // });
        
        
        
       
        
        
        
        
        
        
        return response()->json(['code' => 200]);
        
    }
    
    public function process_order_minus($variation_id,$variation_design,$store_id,$shipment_type,$qty){
        $where=[
            'variation_id' => $variation_id,
            'variation_design' => $variation_design,
            'store_id' => $store_id,
            'shipment_type' => $shipment_type,
            'processed_status' => 0,
        ];
        
        $list=DB::table('process_orders')->where($where)->get();
        if($list->count()>0){
            foreach($list as $record){
                $given_qty=$record->given_qty;
                $approve_qty=$record->approve_qty;
                
                if($qty<=$given_qty){
                    $up_qty=$qty;
                    $given_qty=$given_qty-$qty;
                    $qty=0;
                }else{
                    $up_qty=$given_qty;
                    $given_qty=0;
                    $qty=(int)$qty - (int)$given_qty;
                    
                }
                
                
                $update_rec=['given_qty' => $given_qty];
                
                $up=DB::table('process_orders')->where('id',$record->id);
                
                $up->update($update_rec);
                
                if($given_qty <=0){
                    $up->update(['processed_status' => 1]);
                }
                
                if($qty==0){
                    break;
                }
            }
        }
    }
    
    public function db_reset(){
        // $array=[
        //     'assign_quantity',
        //     'barcodes',
        //     'barcodes_log',
        //     'product_barcodes',
        //     'bundle_list_pr_wise',
        //     'bundle_processed',
        //     'gatepass_reverse_history',
        //     // 'gatepass_serial',
        //     'processed_orders',
        //     'processed_order_quantity',
        //     'process_orders',
        //     'process_order_quantity',
        //     'product_barcodes',
        //     'product_receiving',
        //     'pr_data',
        //     'purchase_order_quantity',
        //     'view_products_orders',
        //     'scanning',
        //     'shipment_info',
        //     'shipment',
        //     'box_info',
        //     // 'item_adjustment',
        //     'upload_box_label'
        // ];
        
        // foreach($array as  $val){
        //     DB::table($val)->truncate();
        // }
        
        //  return response()->json(['code' => 200, 'message' =>'Db reset Successfully']);
        
        
    }
    
    //backup Adding Sizes All
    public function test_mail_copy_product_info(){
        
        // \Mail::raw('Test Mail from Amazon Ses', function($message) {
        //   $message->subject('Mail from Amazon Ses')->to(['smsufian.esire@gmail.com','tahir.esire@gmail.com']);
        //   $message->Attach(asset('uploads/sku_images/1622114540.jpg'));
        //   $message->Attach(asset('uploads/upload_excel/1628078612.xlsx'));
        // });
        
        
        
        // return response()->json(['code' => 200, 'message' =>'Email Send Successfully']);
        
        // $where=[
        
        
       
        // $groupId = DB::table('product_info_design')
        //     ->select('group_id')
        //     ->where('is_deleted', 0)
        //     ->where('prod_size', $size_id)
        //     // ->where('prod_design','!=',0)
        //     ->where('group_id','NOT LIKE','%4BUN%')
        //     // ->where('prod_status', 1)
        //     ->groupBy('group_id')
        //     ->get();
        
        // // If you want to retrieve the result as an array
        // $groupIdArray = $groupId->pluck('group_id')->toArray();
        
        $size_id='7';
        $size_name='XXXL';
        
        $groupId = DB::table('product_info')
            ->select('*')
            ->where('is_deleted', 0)
            // ->where('prod_status', 1)
            // ->where('prod_design',0)
            ->where('group_id','NOT LIKE','%4BUN%')
            ->orderBy('id','desc')
            ->get();
        $groupIdArray = $groupId->pluck('variation_id')->toArray();
        // echo "<pre>";print_r($groupId);
        // dd($groupIdArray);
        
        
        
        $arr=[];
        $arr_new=[];
        foreach ($groupId as $gi){
            $p=explode(',', $gi->product_name);
            $p=$p[0].', '.$size_name;
            
            $v=explode('-',$gi->variation_design);
            
            if(isset($v[1])){
                $variation_design=$gi->group_id.$size_id.'-'.$v[1];
            }else{
                $variation_design=$gi->group_id.$size_id;
            }
            
            if(!in_array($variation_design,$groupIdArray)){
                $in_product_info=[
                   'product_name' => $p,
                   'variation_id' => $gi->group_id.$size_id,
                   'variation_design' => $variation_design,
                   'user_id' => 26,
                   'group_id' => $gi->group_id,
                   'prod_status' => $gi->prod_status,
                   'team' => $gi->team,
                   'prod_gender' =>  $gi->prod_gender,
                   'prod_type'   => $gi->prod_type,
                   'prod_color' => $gi->prod_color,
                   'prod_size' => $size_id,
                   'Quantity' => '0',
                   'prod_variation' => $gi->prod_variation,
                   'prod_design' =>$gi->prod_design,
                   'prod_img'=>$gi->prod_img,
                   'product_url' => $gi->product_url,
                   'created_at' => date('Y-m-d')
                ];
                
                $arr[]=$in_product_info;
                
                
                
            }
            
            
        }
        
        $arrN = array_map("unserialize", array_unique(array_map("serialize", $arr)));
        $arrN = array_map("unserialize", array_unique(array_map("serialize", $arrN)));
        
        foreach ($arrN as $a){
            $arr_new[]=$a['variation_design'];
        }
        // dd($arr_new);
        $arr11=array_diff_assoc($arr_new, array_unique($arr_new));
        echo "<pre>";print_r($arr11);
        echo "<pre>";print_r($arrN);exit;
        
        
        //// DB::table('product_info_design')->insert($arrN);
        
        
        
        
        return response()->json(['code' => 200]);
        
    }
    
    public function test_mail_bundle(){
        
        // \Mail::raw('Test Mail from Amazon Ses', function($message) {
        //   $message->subject('Mail from Amazon Ses')->to(['smsufian.esire@gmail.com','tahir.esire@gmail.com']);
        //   $message->Attach(asset('uploads/sku_images/1622114540.jpg'));
        //   $message->Attach(asset('uploads/upload_excel/1628078612.xlsx'));
        // });
        
        
        
        // return response()->json(['code' => 200, 'message' =>'Email Send Successfully']);
        
        // $where=[
        
        
       
        // $groupId = DB::table('product_info_design')
        //     ->select('group_id')
        //     ->where('is_deleted', 0)
        //     ->where('prod_size', $size_id)
        //     // ->where('prod_design','!=',0)
        //     ->where('group_id','NOT LIKE','%4BUN%')
        //     // ->where('prod_status', 1)
        //     ->groupBy('group_id')
        //     ->get();
        
        // // If you want to retrieve the result as an array
        // $groupIdArray = $groupId->pluck('group_id')->toArray();
        
        $size_id='8';
        $size_name='XXS';
        
        $groupId = DB::table('bundle')
            ->select('*')
            ->where('is_deleted', 0)
            // ->where('prod_status', 1)
            // ->where('prod_design',0)
            ->orderBy('id','desc')
            ->get();
        $groupIdArray = $groupId->pluck('bundle_set_variation')->toArray();
        // echo "<pre>";print_r($groupId); exit;
        // dd($groupIdArray);
        
        
        
        $arr=[];
        $arr_new=[];
        $arr_new1=[];
        $n_arr=[];
        foreach ($groupId as $gi){
            $p=explode(',', $gi->bundle_set_name);
            $p=$p[0].', '.$size_name;
            
            // $v=explode('-',$gi->bundle_set_name);
            
            // if(isset($v[1])){
            //     $variation_design=$gi->bundle_group.$size_id.'-'.$v[1];
            // }else{
                $variation_design=$gi->bundle_group.$size_id;
            // }
            
            if(!in_array($variation_design,$groupIdArray)){
                $insert=[
                    'bundle_name' => $gi->bundle_name,
                    'variation_type' => $gi->variation_type,
                    'image_url' => $gi->image_url,
                    'variation_qty' => $gi->variation_qty,
                    'bundle_group' => $gi->bundle_group,
                    'set_no' => $gi->set_no,
                    'bundle_no' => $gi->bundle_no,
                    'bundle_set_name' => $p,
                    'prod_size' => $size_id,
                    'bundle_set_variation' => $gi->bundle_group.$size_id,
                    'user_id' => 26,
                    'status' =>$gi->status,
                    'created_date' => date('Y-m-d H:i:s'),
                ];
                
                
                
                $arr[]=$insert;
                
                $nn=DB::table('bundle_sets')->where('bundle_group',$gi->bundle_group)->get();
                
                
                
                foreach($nn as $n){
                    $gid=substr($n->variation_id, 0, -1);
                    $variation_id=$gid.$size_id;
                    
                    $p=explode('-',$n->variation_design);
                    if(isset($p[1])){
                        $variation_designn=$variation_id.'-'.$p[1];
                    }else{
                        $variation_designn=$variation_id;
                    }
                    
                    $insert_sku =[
                        'bundle_id' => 181,//$insert_id
                        'bundle_no' => $n->bundle_no,
                        'set_no' => $n->set_no,
                        'variation_id' => $variation_id,
                        'variation_design' => $variation_designn,
                        'variation_type' => $n->variation_type,
                        'bundle_set_variation' => $gi->bundle_group.$size_id,
                        'bundle_group' => $n->bundle_group,
                        'quantity' => 1,
                        'created_date' => date('Y-m-d H:i:s'),
                        'user_id' => 26,
                        'prod_design' => $n->prod_design
                    ];
                    
                    $n_arr[]=$insert_sku;
                }
                
            }
            
            
        }
        
        $arrN = array_map("unserialize", array_unique(array_map("serialize", $arr)));
        $arrN = array_map("unserialize", array_unique(array_map("serialize", $arrN)));
        
        
        
        foreach ($arrN as $a){
            $arr_new[]=$a['bundle_set_variation'];
        }
        
        $arr11=array_diff_assoc($arr_new, array_unique($arr_new));
        // echo "<pre>";print_r($arr11);
        // echo "<pre>";print_r($arrN);
        
        
        $n_arrN = array_map("unserialize", array_unique(array_map("serialize", $n_arr)));
        $n_arrN = array_map("unserialize", array_unique(array_map("serialize", $n_arrN)));
        foreach ($n_arrN as $a1){
            $arr_new1[]=$a1['variation_design'];
        }
        // dd($arr_new);
        
        
        $arr_new1=array_diff_assoc($arr_new1, array_unique($arr_new1));
        // echo "<pre>";print_r($arr_new1);
        // echo "<pre>";print_r($n_arrN);exit;
        
        
        // exit;
        
        foreach ($arrN as $n1){
            $insert=[
                'bundle_name' => $n1['bundle_name'],
                'variation_type' => $n1['variation_type'],
                'image_url' => $n1['image_url'],
                'variation_qty' => $n1['variation_qty'],
                'bundle_group' => $n1['bundle_group'],
                'set_no' => $n1['set_no'],
                'bundle_no' => $n1['bundle_no'],
                'bundle_set_name' => $n1['bundle_set_name'],
                'prod_size' => $n1['prod_size'],
                'bundle_set_variation' => $n1['bundle_set_variation'],
                'user_id' => 26,
                'status' =>$n1['status'],
                'created_date' => date('Y-m-d H:i:s'),
            ];
            
            $insert_id=DB::table('bundle')->insertGetId($insert);
            $nn11=[];
            foreach ($n_arrN as $n2){
                if($n2['bundle_set_variation'] == $n1['bundle_set_variation']){
                    $insert_sku =[
                        'bundle_id' => $insert_id,//$insert_id
                        'bundle_no' => $n2['bundle_no'],
                        'set_no' => $n2['set_no'],
                        'variation_id' => $n2['variation_id'],
                        'variation_design' => $n2['variation_design'],
                        'variation_type' => $n2['variation_type'],
                        'bundle_set_variation' => $n2['bundle_set_variation'],
                        'bundle_group' => $n2['bundle_group'],
                        'quantity' => 1,
                        'created_date' => date('Y-m-d H:i:s'),
                        'user_id' => 26,
                        'prod_design' => $n2['prod_design']
                    ];
                    
                    $nn11[]=$insert_sku;
                    
                }
            }
            
            
            
            // echo "<pre>";print_r($insert);
            // echo "<pre>";print_r($nn11);
            
            DB::table('bundle_sets')->insert($nn11);
        }
        
        // exit;
        
        
        //// DB::table('product_info_design')->insert($arrN);
        
        
        
        
        return response()->json(['code' => 200]);
        
    }
}
