<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class DashboardController extends Controller
{
    public $active_store =[1,6,11];
    
    public function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:dashboard');
    }
    
    public function get_received_by_days($sup_id,$days)
    {
         $query=DB::table('product_receiving')
                ->select([DB::raw('SUM(last_receiving) total_received_qty')])
                ->where('supplier_id',$sup_id)
                ->whereRaw("DATE_FORMAT(created_date,'%Y-%m-%d') BETWEEN DATE_FORMAT(DATE_SUB(NOW(),INTERVAL $days DAY),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d')")
               ->get();
                
        $received = "";
        
        if($query->count() > 0)
        {
            $row = $query->first();    
            
            $received=(int)($row->total_received_qty !="") ? $row->total_received_qty : 0 ;
        }
        
        return $received;
    }
    
    public function get_assigned_info($sup_id)
    {
        $data = [];
        
        
        
        $assign=DB::table('assign_quantity')
                ->where('supplier_id',$sup_id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('switch_status','0')
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    'switch_status',
                ])->first();    
                
        $assign2=DB::table('assign_quantity')
                ->where('supplier_id',$sup_id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('switch_status','1')
                ->where('receiving_qty','!=','0')
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    'switch_status',
                ])->first();
        $cancelled=DB::table('assign_quantity')
                ->where('supplier_id',$sup_id)
                ->where('supplier_id','!=',1)
                ->where('supplier_id','!=',2)
                ->where('is_cancelled','1')
                ->select([
                    DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                    DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                    DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                    'switch_status',
                ])->first();
        
        
            $total_actual_order_qty=(int)($assign->order_qty_given !="") ? $assign->order_qty_given : 0 ;
            $total_assigned_order_qty=(int)($assign->receive_qty !="") ? $assign->receive_qty : 0 ;
            $total_received_order_qty=($assign->receiving_qty!="") ? $assign->receiving_qty: 0 ;
            
            $switch_order=(int)($assign2->receive_qty !="") ? $assign2->receive_qty : 0 ;
            $switch_receive_qty=($assign2->receiving_qty!="") ? $assign2->receiving_qty : 0 ;
            
            $cancelled_assigned_order_qty=(int)($cancelled->receive_qty !="") ? $cancelled->receive_qty : 0 ;
            $cancelled_received_order_qty=(int)($cancelled->receiving_qty!="") ? $cancelled->receiving_qty: 0 ;
            $cancelled_qty=$cancelled_assigned_order_qty - $cancelled_received_order_qty;
            
            $data['total_actual_order_qty'] = $total_actual_order_qty;
            $data['total_assigned_order_qty'] = $total_assigned_order_qty;
            $data['total_received_order_qty']= $total_received_order_qty;
            
            $remaining_qty=(int)$total_assigned_order_qty - (int)$total_received_order_qty;
            $remaining_qty-=$cancelled_qty;
            
            $total_assigned_order_qty+=$switch_receive_qty;
            
            $total_received_order_qty+=$switch_receive_qty;
            
            return array_merge($data,[
                'switch_order'=>$switch_order,
                'switch_receive_qty'=>$switch_receive_qty,
                'total_assigned_order_qty_sum'=>$total_assigned_order_qty,
                'total_received_order_qty_sum'=>$total_received_order_qty,
                'remaining_qty'=>$remaining_qty,
                'cancelled_qty' =>$cancelled_qty 
                ]);
    }
    
    
   
    
    public function get_inventory_summary()
    {
        $html ='';
        
        $sup_list=DB::table('suppliers')->where('id','!=',1)->where('id','!=',2)->where('status','=',1)->get();
        
        $total_assign=$total_received=$total_cancelled=$total_remaining=$total_seven=$total_thirty=0;
    
        foreach($sup_list as $r)
        {
            $info = $this->get_assigned_info($r->id);
            
            $seven_days = $this->get_received_by_days($r->id,7);
            
            $thirty_days = $this->get_received_by_days($r->id,30);
            
            $total_assign+=$info['total_assigned_order_qty_sum'];
            $total_received+=$info['total_received_order_qty_sum'];
            $total_cancelled+=$info['cancelled_qty'];
            $total_remaining+=$info['remaining_qty'];
            $total_seven+=$seven_days;
            $total_thirty+=$thirty_days;
            
            $html.='<tr>
              <td>'.$r->supplier_name.'</td>
              <td>'.$info['total_assigned_order_qty_sum'].'</td>
              <td>'.$info['total_received_order_qty_sum'].'</td>
              <td>'.$info['cancelled_qty'].'</td>
              <td>'.$info['remaining_qty'].'</td>
              <td>'.$seven_days.'</td>
              <td>'.$thirty_days.'</td>
            </tr>';
        }
        
        $html.='<tr class="font-weight-bold table-warning">
              <td>Total</td>
              <td>'.$total_assign.'</td>
              <td>'.$total_received.'</td>
              <td>'.$total_cancelled.'</td>
              <td>'.$total_remaining.'</td>
              <td>'.$total_seven.'</td>
              <td>'.$total_thirty.'</td>
            </tr>';
        
        return $html;
    }
    
    public function get_shipped_by_store_id($days)
    {
        $arr  = [];
        
        $query = DB::table('shipment')
        ->select([DB::raw('store_id,cargo_select,SUM(total_shipment_qty) total_shipped_qty,SUM(total_remaining_quantity) total_rem_qty')])
        ->where('complete_status',1)
        ->groupBy('store_id')
        ->groupBy('cargo_select');
        
        // if($shipment_type!=''){
            // $query->where('cargo_select',1);
        // }
        if($days!=0)
        {
            $query->whereRaw("DATE_FORMAT(completed_date,'%Y-%m-%d') BETWEEN DATE_FORMAT(DATE_SUB(NOW(),INTERVAL $days DAY),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d')");
        }
        $result = $query->get();
        
        if($result->count() > 0)
        {
            
            foreach($result as $r)
            {
                $arr[$r->store_id.'-'.$r->cargo_select] = $r->total_shipped_qty - $r->total_rem_qty;
            }
            
        }
        
        return $arr;
        
    }
    public function get_bundle_qty_by_pr_id($store_id,$shipment_type)
    {
        $total_bundle = 0;
        
        $query = DB::table('bundle_list_pr_wise')
                    ->select([DB::raw('SUM(approve_qty) total_pending_qty')])
                    // ->where('status',0)
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)
                    // ->where('pr_id',$pr_id)
                    ->get();
        
        if($query->count() > 0)
        {
            $total_bundle = $query->first()->total_pending_qty;
        }
        
        return $total_bundle;//* 3

    }
    public function get_bundle_qty_by_pr_id_rem($store_id,$shipment_type)
    {
        $total_bundle = 0;
        
        $query = DB::table('bundle_list_pr_wise')
                    ->select([DB::raw('SUM(given_qty) total_pending_qty')])
                    ->where('status',0)
                    // ->where('pr_id',$pr_id)
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)
                    ->get();
        
        if($query->count() > 0)
        {
            $total_bundle = $query->first()->total_pending_qty;
        }
        
        return $total_bundle;//* 3

    }
    
    // public function ready_ship_bundle_wise($store_id,$shipment_type){
    //     $where=['store_id' =>$store_id ,'shipment_type' =>$shipment_type];
    //     $query_bundle =DB::table('bundle_list_pr_wise as bpo')
    //     ->select([DB::raw('bpo.store_id,bpo.pr_id,bpo.shipment_type,SUM(bpo.approve_qty) total_given_orders,SUM(bpo.given_qty) total_pending_orders')])
    //     ->where($where)
    //     ->groupBy('bpo.store_id')
    //     ->groupBy('bpo.shipment_type')
    //     ->first();
        
    //     $given=$pending=$ready=0;
    //     if($query_bundle !=null){
    //         $given=(int)$query_bundle->total_given_orders;
    //         $pending=(int)$query_bundle->total_pending_orders;
    //         $ready=$given-$pending;
    //     }
        
    //     return $ready;
    // }
    
    public function ready_ship_bundle_wise($store_id,$shipment_type){
        $where=['store_id' =>$store_id ,'shipment_type' =>$shipment_type];
        $query_bundle =DB::table('bundle_list_pr_wise as bpo')
        ->select([DB::raw('bpo.store_id,bpo.pr_id,bpo.shipment_type,SUM(bpo.approve_qty) total_given_orders,SUM(bpo.given_qty) total_pending_orders')])
        ->where($where)
        ->groupBy('bpo.store_id')
        ->groupBy('bpo.shipment_type')
        ->first();
        
        // $
        
        $given=$pending=$ready=0;
        if($query_bundle !=null){
            $given=(int)$query_bundle->total_given_orders;
            $pending=(int)$query_bundle->total_pending_orders;
            $ready=$given-$pending;
        }
        
        return $ready;
    }
    
    public function process_cancelled($store_id,$shipment_type){
        $where=['store_id' =>$store_id ,'shipment_type' =>$shipment_type,'is_cancelled' => 1];
        $query =DB::table('process_orders as po')
        ->select([DB::raw('SUM(po.approve_qty) total_given_orders,SUM(po.given_qty) total_pending_orders')])
        ->where($where)
        ->groupBy('po.store_id')
        ->groupBy('po.shipment_type')
        ->first();
        $total_cancelled_orders=isset($query->total_pending_orders)?(int)$query->total_pending_orders:0;
        // dd($total_cancelled_orders);
        $where=['store_id' =>$store_id ,'shipment_type' =>$shipment_type,'is_cancelled' => 1];
        $query_bundle =DB::table('bundle_list_pr_wise as bpo')
        ->select([DB::raw('bpo.store_id,bpo.pr_id,bpo.shipment_type,SUM(bpo.approve_qty) total_given_orders,SUM(bpo.given_qty) total_pending_orders')])
        ->where($where)
        ->groupBy('bpo.store_id')
        ->groupBy('bpo.shipment_type')
        ->first();
        
        $total_cancelled_orders+=isset($query_bundle->total_pending_orders)?(int)($query_bundle->total_pending_orders*3):0;
        // dd($total_cancelled_orders);
        
        return $total_cancelled_orders;
    }
    public function store_wise_summary()
    {
        

        $query =DB::table('process_order_quantity as po')
        ->select([DB::raw('po.store_id,po.shipment_type,s.strong_name,SUM(po.process_qty) total_given_orders,SUM(po.receiving_qty) total_pending_orders')])
        ->join('store as s','s.id','=','po.store_id')
        ->groupBy('po.store_id')
        ->groupBy('po.shipment_type')
        ->whereIn('s.id',$this->active_store)
        ->where('po.status','=',0)
        ->get();
        
        // $query_bundle =DB::table('bundle_list_pr_wise as bpo')
        // ->select([DB::raw('bpo.store_id,bpo.pr_id,bpo.shipment_type,s.strong_name,SUM(bpo.approve_qty) total_given_orders,SUM(bpo.given_qty) total_pending_orders')])
        // ->join('store as s','s.id','=','bpo.store_id')
        // ->groupBy('bpo.store_id')
        // ->groupBy('bpo.shipment_type')
        // ->get();
        
    
        
        $html ='';
        
        if($query->count() > 0){
            $shipped_data_seven_days = $this->get_shipped_by_store_id(7);
            $shipped_data_thirty_days = $this->get_shipped_by_store_id(30);
            
            $actual_total_given=$actual_total_single_ready=$actual_total_bundle_ready=$actual_cancelled=$actual_pending=$actual_total_shipped=$actual_total_shipped_seven=$actual_total_shipped_thirty=0;
            
            foreach($query as $r)
            {
                $s_sk=$r->store_id.'-'.$r->shipment_type;
                $total_shipped_seven = isset($shipped_data_seven_days[$s_sk]) && !empty($shipped_data_seven_days[$s_sk]) ? $shipped_data_seven_days[$s_sk] : 0 ;
                $total_shipped_thirty = isset($shipped_data_thirty_days[$s_sk]) && !empty($shipped_data_thirty_days[$s_sk]) ? $shipped_data_thirty_days[$s_sk] : 0 ;
                
                
            
                $ready_bundle=$this->ready_to_ship_bundle_qty($r->store_id,$r->shipment_type); 
                // dd($ready_bundle);
                $pending=($r->total_pending_orders+ $this->get_bundle_qty_by_pr_id_rem($r->store_id,$r->shipment_type));
                
                
                $actual_total_single_ready+=((int)$this->ready_to_ship_single_qty($r->store_id,$r->shipment_type));
                $actual_total_bundle_ready+=$ready_bundle;
                $actual_pending+=$pending;
                $actual_total_shipped_seven+=$total_shipped_seven;
                $actual_total_shipped_thirty+=$total_shipped_thirty;
                
                
                $html .='<tr>
                          <td>'.$r->strong_name.'</td>
                          <td>'.($r->shipment_type==1 ? 'Air Cargo' : 'Sea Cargo').'</td>
                          <td>'.$pending.'</td>
                          <td>'.((int)$this->ready_to_ship_single_qty($r->store_id,$r->shipment_type)).'</td>
                          <td>'.($ready_bundle*3).' BUN ('.$ready_bundle.')'.'</td>
                          <td>'.$total_shipped_seven.'</td>
                          <td>'.$total_shipped_thirty.'</td>
                        </tr>';
            }
            
            $html .='<tr class="font-weight-bold table-warning">
              <td colspan="2">Total</td>
              <td>'.$actual_pending.'</td>
              <td>'.$actual_total_single_ready.'</td>
              <td>'.($actual_total_bundle_ready*3).' BUN ('.$actual_total_bundle_ready.')'.'</td>
              <td>'.$actual_total_shipped_seven.'</td>
              <td>'.$actual_total_shipped_thirty.'</td>
            </tr>';
        }
        
        return $html;
    }
    
    public function ready_to_ship_single_qty($store_id,$shipment_type){
        $query = DB::table('processed_order_quantity')
                    ->select(
                        [DB::raw('SUM(receiving_qty) total_pending_qty')])
                    ->where('status',0)
                    ->whereRaw('variation_design NOT like "%4BUN%"')
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)->first();
        $total_pending_qty=0;
        if($query !=NULL){
            $total_pending_qty=(int)$query->total_pending_qty;  
        }
        
        return $total_pending_qty;
    }
    
    public function ready_to_ship_bundle_qty($store_id,$shipment_type){
        $query = DB::table('processed_order_quantity')
                    ->select(
                        [DB::raw('SUM(receiving_qty) total_pending_qty')])
                    ->where('status',0)
                    ->whereRaw('variation_design like "%4BUN%"')
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)->first();
        $total_pending_qty=0;
        if($query !=NULL){
            $total_pending_qty=(int)($query->total_pending_qty);  
        }
        
        return $total_pending_qty;
    }
    
    public function pending_order_data_by_type($type)
    {   
        $total_pending = 0;
        
        $query = DB::table('process_order_quantity')->select([DB::raw('SUM(receiving_qty) total_pending_qty')])->where('status',0)->where('shipment_type',$type)->get();

        if($query->count() > 0)
        {
           
           $row = $query->first();
           
           $total_pending = !empty($row->total_pending_qty) ? $row->total_pending_qty : 0;
            
        }
        
        $query = DB::table('bundle_list_pr_wise')->select([DB::raw('SUM((given_qty)*3) total_pending_qty')])->where('status',0)->where('shipment_type',$type)->get();

        if($query->count() > 0)
        {
           
           $row = $query->first();
           
           $total_pending += !empty($row->total_pending_qty) ? $row->total_pending_qty : 0;
            
        }
        
        
        return $total_pending;
        
    }
    
    
    
    
    public function order_data_by_type($type)
    {
            $total_qty=DB::table('view_products_orders')
                        ->where('shipment_type',$type)
                        ->where('bundle_check',0)
                        ->whereraw('pr_id NOT LIKE "%BULK%"')
                        ->select([
                            DB::raw('sum(approve_qtn) as approve_qtn'),
                        ])->first();
                        
            $total_bundle_qty=DB::table('view_products_orders')
                       // ->groupBy('bundle_set_variation')
                        ->where('shipment_type',$type)
                        ->where('bundle_check',1)
                        ->whereraw('pr_id NOT LIKE "%BULK%"')
                        ->select([
                          DB::raw("(SUM(approve_qtn)) approve_qtn")
                        ])->get();
            
            $approve_qty=(int)$total_qty->approve_qtn;
           
            
           
            
            if($total_bundle_qty->count()>0){
                    $approve_qty+=(int)$total_bundle_qty->first()->approve_qtn;
            }
            
            return $approve_qty;
    }
    
    
    public function order_data_by_type_bulk()
    {
            $total_qty=DB::table('view_products_orders')
                        // ->where('shipment_type',$type)
                        ->where('bundle_check',0)
                        ->whereraw('pr_id LIKE "%BULK%"')
                        ->select([
                            DB::raw('sum(approve_qtn) as approve_qtn'),
                        ])->first();
                        
            $total_bundle_qty=DB::table('view_products_orders')
                       // ->groupBy('bundle_set_variation')
                        // ->where('shipment_type',$type)
                        ->where('bundle_check',1)
                        ->whereraw('pr_id LIKE "%BULK%"')
                        ->select([
                          DB::raw("(SUM(approve_qtn)) approve_qtn")
                        ])->get();
            
            $approve_qty=(int)$total_qty->approve_qtn;
            
            $single=$approve_qty;
            
           
            
           $bundle=0;
            
            if($total_bundle_qty->count()>0){
               
                        
                    $approve_qty+=(int)$total_bundle_qty->first()->approve_qtn;
                    $bundle=(int)$total_bundle_qty->first()->approve_qtn;
                    
                    
             
            
            }
            
            return $approve_qty;
    }
    
    public function order_data_by_type_bulk_sing_bund()
    {
            $total_qty=DB::table('view_products_orders')
                        // ->where('shipment_type',$type)
                        ->where('bundle_check',0)
                        ->whereraw('pr_id LIKE "%BULK%"')
                        ->select([
                            DB::raw('sum(approve_qtn) as approve_qtn'),
                        ])->first();
                        
            $total_bundle_qty=DB::table('view_products_orders')
                       // ->groupBy('bundle_set_variation')
                        // ->where('shipment_type',$type)
                        ->where('bundle_check',1)
                        ->whereraw('pr_id LIKE "%BULK%"')
                        ->select([
                          DB::raw("(SUM(approve_qtn)) approve_qtn")
                        ])->get();
            
            $approve_qty=(int)$total_qty->approve_qtn;
            
            $single=$approve_qty;
            
           
            
           $bundle=0;
            
            if($total_bundle_qty->count()>0){
               
                        
                    $approve_qty+=(int)$total_bundle_qty->first()->approve_qtn;
                    $bundle=(int)$total_bundle_qty->first()->approve_qtn;
                    
                    
             
            
            }
            
            return '(SIN : '.$single.' BUN : '.$bundle.')';
    }
    
    public function get_drop_in_data($days)
    {
        $query=DB::table('product_receiving')
                ->select([DB::raw('SUM(last_receiving) total_received_qty')])
                ->whereRaw("DATE_FORMAT(created_date,'%Y-%m-%d') BETWEEN DATE_FORMAT(DATE_SUB(NOW(),INTERVAL $days DAY),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d')")
               ->get();
                
        $received = "";
        
        if($query->count() > 0)
        {
            $row = $query->first();    
            
            $received=(int)($row->total_received_qty !="") ? $row->total_received_qty : 0 ;
        }
        
        return $received;
    }
    
    public function get_bulk_received()
    {
         $total_received = 0;
         
         $rtso = DB::table('assign_quantity')->select([DB::raw("SUM(order_qty_given) order_qty_given,SUM(receive_qty) receive_qty,SUM(receiving_qty) receiving_qty")])
        ->whereraw("pr_id LIKE '%BULK%'")
        ->whereraw("pr_id NOT LIKE '%OTWHBULK%'")
        ->get();

         if($rtso->count() > 0)
        {
            $rowproc = $rtso->first();
            
            $total_received = !empty($rowproc->receiving_qty) ? $rowproc->receiving_qty : 0;
        }
        
        return $total_received;

    }
    
    
    public function get_bulk_cancelled(){
        $cancelled_qty = 0;
        $rtso = DB::table('assign_quantity')->select([DB::raw("SUM(order_qty_given) order_qty_given,SUM(receive_qty) receive_qty,SUM(receiving_qty) receiving_qty")])
        ->whereraw("pr_id LIKE '%BULK%'")
        ->where('is_cancelled','1')
        ->get();
        
        if($rtso->count() > 0){
            $cancelled = $rtso->first();
            
            $cancelled_assigned_order_qty=(int)($cancelled->receive_qty !="") ? $cancelled->receive_qty : 0 ;
            $cancelled_received_order_qty=(int)($cancelled->receiving_qty!="") ? $cancelled->receiving_qty: 0 ;
            $cancelled_qty=$cancelled_assigned_order_qty - $cancelled_received_order_qty;
        }
        
        return $cancelled_qty;
    }
    public function system_statistics()
    {
        $arr = [];
       
        $total_process_ord = 0;
        
        $total_process_bundle = 0;
        
        $total_ready_to_ship_orders = 0;
        
        $total_ready_to_ship_bundles = 0;
        
        $process_ord_query = DB::table('process_order_quantity')->select([DB::raw('SUM(receiving_qty) total_process_orders')])->where('status',0)->get();
        
        if($process_ord_query->count() > 0)
        {
            $rowproc = $process_ord_query->first();
            
            $total_process_ord = !empty($rowproc->total_process_orders) ? $rowproc->total_process_orders : 0;
        }
        
        $process_bunle_query = DB::table('bundle_list_pr_wise')->select([DB::raw('SUM(given_qty) as total_bundle_processed')])->where('status',0)->get();
        
        if($process_bunle_query->count() > 0)
        {
            $rowproc = $process_bunle_query->first();
            
            $total_process_bundle = !empty($rowproc->total_bundle_processed) ? $rowproc->total_bundle_processed : 0;
        }
        
        
        $rtso = DB::table('processed_order_quantity')->select([DB::raw('SUM(receiving_qty) total_ready_to_ship_orders')])
        ->where('status',0)
        ->whereraw("variation_design NOT LIKE '%BUN%'")
        ->get();

         if($rtso->count() > 0)
        {
            $rowproc = $rtso->first();
            
            $total_ready_to_ship_orders = !empty($rowproc->total_ready_to_ship_orders) ? $rowproc->total_ready_to_ship_orders : 0;
        }
        

        $rtsbundle = DB::table('processed_order_quantity')->select([DB::raw('SUM(receiving_qty) total_ready_to_ship_orders')])
        ->where('status',0)
        ->whereraw("variation_design LIKE '%BUN%'")
        ->get();
        
        

         if($rtsbundle->count() > 0)
        {
            $rowproc = $rtsbundle->first();
            
            $total_ready_to_ship_bundles = !empty($rowproc->total_ready_to_ship_orders) ? $rowproc->total_ready_to_ship_orders : 0;
        }
        
      
        $pending_mos_query = DB::table('purchase_order_quantity')->where('status',0)->groupBy('pr_id')->get();
        
        
        $pending_mos_query_bulk = DB::table('purchase_order_quantity')->where('status',0)->whereraw("pr_id LIKE '%BULK%'")->groupBy('pr_id')->get();
        
        $arr['total_pending_mos']=$pending_mos_query->count();
        
        $arr['air_cargo_orders']= $this->order_data_by_type(1);
        
        $arr['sea_cargo_orders']= $this->order_data_by_type(2);
        
        $air_pending = $this->pending_order_data_by_type(1);
        
        $sea_pending = $this->pending_order_data_by_type(2);
        
        $arr['air_pending_orders']=$air_pending;
        
        $arr['sea_pending_orders']=$sea_pending;
        
        $arr['total_pending_orders']= $air_pending + $sea_pending;
        
        $arr['drop_in_today'] = $this->get_drop_in_data(0);

        $arr['drop_in_seven'] = $this->get_drop_in_data(7);
        
        $arr['total_process_orders'] = $total_process_ord;
        
        $arr['total_bundle_process'] = ($total_process_bundle*3).' BUN ('.$total_process_bundle.')';
        
        $arr['total_ready_to_ship_orders'] = $total_ready_to_ship_orders;
        
        $arr['total_ready_to_ship_bundles'] = (int)($total_ready_to_ship_bundles*3).' BUN ('.$total_ready_to_ship_bundles.')';
        
        $arr['total_bulk_mos']=$pending_mos_query_bulk->count();
        
        $arr['total_bulk_orders'] = $this->order_data_by_type_bulk();
        
        $arr['total_bulk_received'] = $this->get_bulk_received();
        
        return $arr;
        
    }
    
    public function system_statistics_view()
    {
        $data = $this->system_statistics();
        
        $html_one =' <tr>
      <td>'.$data['total_pending_mos'].'</td>
      <td>'.$data['air_cargo_orders'].'</td>
      <td>'.$data['sea_cargo_orders'].'</td>
      <td>'.$data['air_pending_orders'].'</td>
      <td>'.$data['sea_pending_orders'].'</td>
      <td>'.$data['total_pending_orders'].'</td>
    </tr>';
    
    
     $html_two =' <tr>
      <td>'.$data['drop_in_today'].'</td>
      <td>'.$data['drop_in_seven'].'</td>
      <td>'.$data['total_process_orders'].'</td>
      <td>'.$data['total_bundle_process'].'</td>
      <td>'.$data['total_ready_to_ship_orders'].'</td>
      <td>'.$data['total_ready_to_ship_bundles'].'</td>
    </tr>';
    
    $bulk_pending=($data['total_bulk_orders'] - $data['total_bulk_received']);
    $bulk_cancelled=$this->get_bulk_cancelled();
    $bulk_pending-=$bulk_cancelled;
    
    $bulk_pending=($bulk_pending<0)?0:$bulk_pending;
    
    $html_three = '<tr>
      <td>'.$data['total_bulk_mos'].'</td>
      <td>'.$data['total_bulk_orders'].' '.$this->order_data_by_type_bulk_sing_bund().'</td>
      <td>'.$data['total_bulk_received'].'</td>
      <td>'.$bulk_cancelled.'</td>
      <td>'.$bulk_pending.'</td>
      <td></td>
    </tr>';
        
        return ['system_summary_one'=>$html_one,'system_summary_two'=>$html_two,'system_summary_three'=>$html_three];
    }
    
    ///added by sufian 09-05-24
    public function get_store_wise_pending(){
        $totalBundlePendingQty = DB::table('bundle_list_pr_wise')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(given_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->groupBy('store_id', 'shipment_type')
            ->get();
        
        $formatedBundleResult=collect($totalBundlePendingQty)->pluck(null,'store_shipment')->toArray();
        // dd($formatedBundleResult);
        
        $totalSinglePendingQty = DB::table('process_order_quantity')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(receiving_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->groupBy('store_id', 'shipment_type')
            ->get();
        
        $formatedSingleResult=collect($totalSinglePendingQty)->pluck(null,'store_shipment')->toArray();
        
        
        $totalSingleRTS = DB::table('processed_order_quantity')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(receiving_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->where('variation_id','NOT LIKE','%4BUN%')
            ->groupBy('store_id', 'shipment_type')
            ->get();
            
        $formatedSingleResultRTS=collect($totalSingleRTS)->pluck(null,'store_shipment')->toArray();
        
        $totalBundleRTS = DB::table('processed_order_quantity')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(receiving_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->where('variation_id','LIKE','%4BUN%')
            ->groupBy('store_id', 'shipment_type')
            ->get();
            
        $formatedBundleResultRTS=collect($totalBundleRTS)->pluck(null,'store_shipment')->toArray();
        
        $storeList=DB::table('store')->whereIn('id',$this->active_store)->get();
        
        $html='';
        
        if($storeList->count()>0){
            foreach($storeList as $st){
                $air=$st->id.'-1';
                $sea=$st->id.'-2';
                
                
                $total_bundle_air=$total_single_air=$total_air=0;
                if(isset($formatedBundleResult[$air])){
                    $total_bundle_air=$formatedBundleResult[$air]->total_pending_qty;
                }
                
                
                
                if(isset($formatedSingleResult[$air])){
                    $total_single_air=$formatedSingleResult[$air]->total_pending_qty;
                }
                
                $total_air=$total_bundle_air + $total_single_air;
                
                
                $total_bundle_sea=$total_single_sea=$total_sea=0;
                if(isset($formatedBundleResult[$sea])){
                    $total_bundle_sea=$formatedBundleResult[$sea]->total_pending_qty;
                }
                
                if(isset($formatedSingleResult[$sea])){
                    $total_single_sea=$formatedSingleResult[$sea]->total_pending_qty;
                }
                
                $total_sea=$total_bundle_sea + $total_single_sea;
                
                $total_bundle_air_rts=$total_single_air_rts=0;
                if(isset($formatedSingleResultRTS[$air])){
                    $total_single_air_rts=$formatedSingleResultRTS[$air]->total_pending_qty;
                }
                
                
                if(isset($formatedBundleResultRTS[$air])){
                    $total_bundle_air_rts=$formatedBundleResultRTS[$air]->total_pending_qty;
                }
                
                $total_bundle_sea_rts=$total_single_sea_rts=0;
                if(isset($formatedSingleResultRTS[$sea])){
                    $total_single_sea_rts=$formatedSingleResultRTS[$sea]->total_pending_qty;
                }
                
                
                if(isset($formatedBundleResultRTS[$sea])){
                    $total_bundle_sea_rts=$formatedBundleResultRTS[$sea]->total_pending_qty;
                }
                
                $air_url=route('excel_store',[$st->id,1]);
                $sea_url=route('excel_store',[$st->id,2]);
                
                $html.='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>'.$st->strong_name.'</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-airplane"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_air.'</h2>
                                                    <span class="text-white">Air Cargo Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-white">Single: '.$total_single_air.'</span>
                                                    <span class="text-white float-right">Bundle: '.$total_bundle_air.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-white">RTS Single: '.$total_single_air_rts.'</span>
                                                    <span class="text-white float-right">RTS Bundle: '.$total_bundle_air_rts.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$air_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon text-dark">
                                                    <i class="zmdi zmdi-boat text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_sea.'</h2>
                                                    <span class="text-dark">Sea Cargo Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-dark">Single: '.$total_single_sea.'</span>
                                                    <span class="text-dark float-right">Bundle: '.$total_bundle_sea.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-dark">RTS Single: '.$total_single_sea_rts.'</span>
                                                    <span class="text-dark float-right">RTS Bundle: '.$total_bundle_sea_rts.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$sea_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            }
        }
        
        
        
        
        
        return $html;
    }
    
    public function get_wh_inventory(){
        $totals = DB::table('product_info')
                    ->selectRaw('SUM(Quantity) as decrum_wh, SUM(uc_quantity) as urban_wh')
                    ->where('prod_status', 1)
                    ->where('is_deleted', 0)
                    ->first();
        
        $total_decrum_wh=$total_urban_wh=0;
        if($totals){
            $total_decrum_wh=$totals->decrum_wh;
            $total_urban_wh=$totals->urban_wh;
        }
        
        $decrum_url=route("ExportNewInventory",'decrum');
        $urban_url=route("ExportNewInventory",'urban');
        
        
        
        $html='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Warehouse Inventory</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-store"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_decrum_wh.'</h2>
                                                    <span class="text-white">Decrum Warehouse</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$decrum_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-store text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_urban_wh.'</h2>
                                                    <span class="text-dark">UrbanCrest Warehouse</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$urban_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function get_supplier_pending(){
        $totalDecrumPending = DB::table('assign_quantity')
            ->selectRaw('SUM(receive_qty) - SUM(receiving_qty) as total_pending')
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->first();
        
        $total_decrum=$total_urban=0;
        if($totalDecrumPending){
            $total_decrum=$totalDecrumPending->total_pending;
        }
        
        $totalUrbanPending = DB::table('assign_quantity')
            ->selectRaw('SUM(receive_qty) - SUM(receiving_qty) as total_pending')
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%UC%')
            ->first();
        
        if($totalUrbanPending){
            $total_urban=$totalUrbanPending->total_pending;
        }
        
        $decrum_url=route("supplier_excel",'decrum');
        $urban_url=route("supplier_excel",'urban');
        
        
        $html='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Supplier Pending</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-caret-left-circle"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_decrum.'</h2>
                                                    <span class="text-white">Decrum Supplier Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$decrum_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-caret-left-circle text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_urban.'</h2>
                                                    <span class="text-dark">UrbanCrest Supplier Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$urban_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function get_wh_urgent_tag(){
        $totalDecrumQty = DB::table('process_order_quantity')
            ->select(DB::raw("count(id) as total_urgent"))
            ->where('status', 0)
            ->where('urgent_status',1)
            ->where('store_id','!=',11)
            ->first();
        
        $total_decrum_wh=$total_urban_wh=0;
        if($totalDecrumQty){
            $total_decrum_wh=$totalDecrumQty->total_urgent;
        }
        
        $totalUrbanQty = DB::table('process_order_quantity')
            ->select(DB::raw("count(id) as total_urgent"))
            ->where('status', 0)
            ->where('urgent_status',1)
            ->where('store_id','=',11)
            ->first();
        if($totalUrbanQty){
            $total_urban_wh=$totalUrbanQty->total_urgent;
        }
        
        $decrum_url=route("storeWiseUrgent",'decrum');
        $urban_url=route("storeWiseUrgent",'urban');
        
        
        
        $html='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Urgent Pending</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-alert-triangle"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_decrum_wh.'</h2>
                                                    <span class="text-white">Decrum Urgent Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$decrum_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-alert-triangle text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_urban_wh.'</h2>
                                                    <span class="text-dark">UrbanCrest Urgent Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$urban_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    
    
    
    
    public function index(){
        return view('dashboard.dashboard',[
            //old fields
            'store_view'  => $this->get_store_wise_pending(),
            'warehouse_view' => $this->get_wh_inventory(),
            'supplier_view' => $this->get_supplier_pending(),
            'urgent_view' => $this->get_wh_urgent_tag(),
            
        ]);
    }
    
    public function get_supplier_pending_decrum(){
        $supplierList=DB::table('suppliers')->where('status','1')->where('id','!=',1)->get();
        
        $formatedBundleResult = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) as total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->where('status', 0)
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        // dd($formatedBundleResult);
        
        $results_air = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%AIR%')
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_sea = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%SEA%')
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_bulk = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%BULK%')
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
            
        $nhtml='';
        $decrum_url='';
        $count=1;
        foreach ($supplierList as $sl){
            $total_bundle_sea=0;
            if(isset($formatedBundleResult[$sl->id])){
                $total_bundle_sea=$formatedBundleResult[$sl->id];
            }
            
            $total_air=0;
            if(isset($results_air[$sl->id])){
                $total_air=$results_air[$sl->id];
            }
            
            $total_sea=0;
            if(isset($results_sea[$sl->id])){
                $total_sea=$results_sea[$sl->id];
            }
            
            $total_bulk=0;
            if(isset($results_bulk[$sl->id])){
                $total_bulk=$results_bulk[$sl->id];
            }
            
            $bg='bg-dark';
            $text='text-white';
            if($count% 2==0){
                $bg='bg-orange';
                $text='text-dark';
            }
            
            $decrum_url=route("skuWise_pending",['decrum',$sl->id]);
            
            $nhtml.='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="overview-item '.$bg.'">
                        <div class="overview__inner">
                            <div class="overview-box clearfix">
                                <div class="icon">
                                    <i class="zmdi zmdi-caret-left-circle '.$text.'"></i>
                                </div>
                                <div class="text mb-3">
                                    <h2 class="'.$text.'">'.$total_bundle_sea.'</h2>
                                    <span class="'.$text.'">'.$sl->supplier_name.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Air: '.$total_air.'</span>
                                    <span class="'.$text.' float-right">Sea: '.$total_sea.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Bulk: '.$total_bulk.'</span>
                                </div>
                                <div class="mb-1">
                                    <hr class="mb-1">
                                    <span class="'.$text.' float-right mb-1"><a href="'.$decrum_url.'" class="'.$text.'"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            $count++;
        }
            
        
        
        
        $html='<div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Decrum PK Warehouse Pending</h5>
                            <div class="row mt-3">
                                '.$nhtml.'
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function get_supplier_pending_urban(){
        $supplierList=DB::table('suppliers')->where('status','1')->where('id','!=',1)->get();
        
        $formatedBundleResult = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) as total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('pr_id', 'LIKE', '%UC%')
            ->where('status', 0)
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
            
        $results_air = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%AIR%')
            ->where('pr_id', 'LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_sea = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%SEA%')
            ->where('pr_id', 'LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_bulk = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%BULK%')
            ->where('pr_id', 'LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
            
        
        $nhtml='';
        $decrum_url='';
        $count=1;
        foreach ($supplierList as $sl){
            $total_bundle_sea=0;
            if(isset($formatedBundleResult[$sl->id])){
                $total_bundle_sea=$formatedBundleResult[$sl->id];
            }
            
            $total_air=0;
            if(isset($results_air[$sl->id])){
                $total_air=$results_air[$sl->id];
            }
            
            $total_sea=0;
            if(isset($results_sea[$sl->id])){
                $total_sea=$results_sea[$sl->id];
            }
            
            $total_bulk=0;
            if(isset($results_bulk[$sl->id])){
                $total_bulk=$results_bulk[$sl->id];
            }
            
            $bg='bg-dark';
            $text='text-white';
            if($count% 2==0){
                $bg='bg-orange';
                $text='text-dark';
            }
            
            $decrum_url=route("skuWise_pending",['urban',$sl->id]);
            
            
            $nhtml.='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="overview-item '.$bg.'">
                        <div class="overview__inner">
                            <div class="overview-box clearfix">
                                <div class="icon">
                                    <i class="zmdi zmdi-caret-left-circle '.$text.'"></i>
                                </div>
                                <div class="text mb-3">
                                    <h2 class="'.$text.'">'.$total_bundle_sea.'</h2>
                                    <span class="'.$text.'">'.$sl->supplier_name.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Air: '.$total_air.'</span>
                                    <span class="'.$text.' float-right">Sea: '.$total_sea.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Bulk: '.$total_bulk.'</span>
                                </div>
                                <div class="mb-1">
                                    <hr class="mb-1">
                                    <span class="'.$text.' float-right mb-1"><a href="'.$decrum_url.'" class="'.$text.'"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            
            $count++;
        }
            
        
        
        
        $html='<div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Urban Crest PK Warehouse Pending</h5>
                            <div class="row mt-3">
                                '.$nhtml.'
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function supplier_pending_dashboard(){
        return view('dashboard.supplier_pending',[
            //old fields
            'decrum_view'  => $this->get_supplier_pending_decrum(),
            'urban_view' => $this->get_supplier_pending_urban(),
            
        ]);
    }
    
    public function operational_dashboard(){
        
        return view('dashboard.index',[
            
            'inventory_summary_supplier_wise'=>$this->get_inventory_summary(),
            'store_wise_summary'=>$this->store_wise_summary(),
            'system_summary'=>$this->system_statistics_view(),
        
            //old fields
            'pending_orders'  => 0,//($pending_orders->pending_order !='')?$pending_orders->pending_order:'0',
            'receiving_order' => 0,//($receiving_order->receiving_qty !='')?$receiving_order->receiving_qty:'0',
            'total_reeiving'  => 0,//($total->receiving_qty !='')?$total->receiving_qty:'0',
            'total_instock' => 0,//($total_instock->total_qty !='')?$total_instock->total_qty:'0',
            'total_ready_shipment' => 0,//($total_ready_shipment->total_qty !='')?$total_ready_shipment->total_qty:'0',
        ]);
    }
    
    public function excel_store($store_id,$shipment_type){
            $store_name=DB::table('store')->where('id',$store_id)->first('strong_name')->strong_name;
            if($shipment_type =="1"){
                $shipment_name='air_cargo';
            }else{
                $shipment_name='sea_cargo';
            }
            
            $title ='Store Name : '.$store_name.' Shipment Type :'.$shipment_name;
            $file_name=$store_name.'_'.$shipment_name.'_pending_'.date('Y_m_d_h_i_s');
            
            $records=DB::table('process_order_quantity')
                    ->groupBy('process_order_quantity.variation_design','process_order_quantity.store_id','process_order_quantity.shipment_type')
                    ->join('product_info_design','product_info_design.variation_design','=','process_order_quantity.variation_design')
                    ->orderBy('product_info_design.variation_id','ASC')
                    ->orderBy('product_info_design.variation_design','ASC')
                    ->orderBy('product_info_design.prod_size','ASC')
                    ->orderBy('product_info_design.prod_design','ASC')
                    ->where('process_order_quantity.status','0')
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)
                    ->select([
                        'process_order_quantity.variation_id',
                        'process_order_quantity.id',
                        'process_order_quantity.variation_design',
                        DB::raw('sum(process_order_quantity.receiving_qty) as approve_qty'),
                        'process_order_quantity.created_date',
                        'product_info_design.product_name',
                    ])->get();
            
            $objPHPExcel= new Spreadsheet();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
            $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle("A2:I2")->getFont()->setBold(true);
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'S No');
            $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'SKU');
            $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Product Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Pending QTY');
            
            $counter=3;
            $sno=1;
                
            $total=0;
            
            if($records->count()>0){
                
                
                foreach($records as $row){
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sno);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->variation_design);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->product_name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $row->approve_qty);
                    
                    $total+=$row->approve_qty;
                    
                    $sno++;
                    $counter++;
                }
            }
            
            $records=DB::table('bundle_list_pr_wise')
                ->join('bundle','bundle.bundle_set_variation','=','bundle_list_pr_wise.bundle_set_variation')
                ->where('bundle_list_pr_wise.status',0)
                ->where('bundle_list_pr_wise.store_id',$store_id)
                ->where('bundle_list_pr_wise.shipment_type',$shipment_type)
                ->groupBy('bundle_list_pr_wise.bundle_set_variation','bundle_list_pr_wise.store_id','bundle_list_pr_wise.shipment_type')
                ->select([
                    'bundle.bundle_set_name',
                    DB::raw('sum(bundle_list_pr_wise.approve_qty) as approve_qty'),
                    DB::raw('sum(bundle_list_pr_wise.given_qty) as given_qty'),
                    DB::raw('sum(bundle_list_pr_wise.remaining_qty) as remaining_qty'),
                    'bundle_list_pr_wise.bundle_set_variation',
                    'bundle_list_pr_wise.store_id',
                    'bundle_list_pr_wise.shipment_type'
                ])->get();
                
            if($records->count()>0){
                foreach($records as $row){
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sno);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->bundle_set_variation);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->bundle_set_name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $row->given_qty);
                    
                    $total+=$row->given_qty;
                    $sno++;
                    $counter++;
                }
            }
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $total);
            
            $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
            $objWriter->setPreCalculateFormulas(false);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
            header('Cache-Control: max-age=0');
            set_time_limit(500);
            ini_set('memory_limit', '-1');
            // ob_clean();
            $objWriter->save('php://output');
            exit;
    }
    
    public function excel_store_urgent($string){
            
            
            $title ='Store Name : '.ucfirst($string);
            $file_name=$string.'_urgent_status_'.date('Y_m_d_h_i_s');
            
            $records=DB::table('process_order_quantity')
                    ->groupBy('process_order_quantity.variation_design','process_order_quantity.store_id','process_order_quantity.shipment_type')
                    ->join('product_info_design','product_info_design.variation_design','=','process_order_quantity.variation_design')
                    ->orderBy('product_info_design.variation_id','ASC')
                    ->orderBy('product_info_design.variation_design','ASC')
                    ->orderBy('product_info_design.prod_size','ASC')
                    ->orderBy('product_info_design.prod_design','ASC')
                    ->where('process_order_quantity.status','0')
                    ->where('process_order_quantity.urgent_status',1)
                    ->select([
                        'process_order_quantity.variation_id',
                        'process_order_quantity.id',
                        'process_order_quantity.variation_design',
                        DB::raw('sum(process_order_quantity.receiving_qty) as approve_qty'),
                        'process_order_quantity.created_date',
                        'product_info_design.product_name',
                    ]);
            
            if($string =='decrum'){
                $records->where('store_id','!=','11');
            }else{
                $records->where('store_id','=','11');
            }
            
            $objPHPExcel= new Spreadsheet();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
            $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle("A2:I2")->getFont()->setBold(true);
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'S No');
            $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'SKU');
            $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Product Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Pending QTY');
            
            $counter=3;
            $sno=1;
                
            $total=0;
            
            if($records->count()>0){
                
                
                foreach($records->get() as $row){
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sno);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->variation_design);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->product_name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $row->approve_qty);
                    
                    $total+=$row->approve_qty;
                    
                    $sno++;
                    $counter++;
                }
            }
            
            
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $total);
            
            $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
            $objWriter->setPreCalculateFormulas(false);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
            header('Cache-Control: max-age=0');
            set_time_limit(500);
            ini_set('memory_limit', '-1');
            // ob_clean();
            $objWriter->save('php://output');
            exit;
    }
    
    public function supplier_excel($string){
        $records = \DB::table('assign_quantity as aq')
            ->leftJoin('product_info as pi', 'aq.variation_id', '=', 'pi.variation_id')
            ->select('aq.variation_id', 'pi.product_name', \DB::raw('(SUM(aq.receive_qty) - SUM(aq.receiving_qty)) as total_remaining'))
            ->where('aq.supplier_id', '!=', 1)
            ->where('aq.status', '=', 0)
            ->groupBy('aq.variation_id')
            ;
            
        if($string=='decrum'){
            $records->where('pr_id','NOT LIKE','%UC%');
        }else{
            $records->where('pr_id','LIKE','%UC%');
        }
            
        $title =ucfirst($string).' WH Supplier Pending SKU Wise';
        $file_name=$string.'_wh_supplier_pending_sku_wise_'.date('Y_m_d_h_i_s');
        
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
        $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A2:G2")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Variation Id');
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Product Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Total Remaining');
        
        
        if($records->count()>0){
            $counter=3;
            $sno=1;
            $total_qty=0;
            foreach($records->get() as $row){
                
                $total_qty+=$row->total_remaining;
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $row->variation_id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->product_name);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->total_remaining);
                
                $counter++;
                $sno++;
            }
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $total_qty);
        }
        
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
    
    ///added by sufia n05-03-24
    public function skuWise_pending($string,$supplier_id){
        $records = \DB::table('assign_quantity as aq')
            ->leftJoin('product_info as pi', 'aq.variation_id', '=', 'pi.variation_id')
            ->select('aq.variation_id', 'pi.product_name', \DB::raw('(SUM(aq.receive_qty) - SUM(aq.receiving_qty)) as total_remaining'))
            ->where('aq.supplier_id', '=', $supplier_id)
            ->where('aq.status', '=', 0)
            ->groupBy('aq.variation_id');
            
        if($string=='decrum'){
            $records->where('pr_id','NOT LIKE','%UC%');
        }else{
            $records->where('pr_id','LIKE','%UC%');
        }
            
        $title ='Supplier Pending SKU Wise';
        $file_name='supplier_pending_sku_wise_'.date('Y_m_d_h_i_s');
        
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
        $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A2:G2")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Variation Id');
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Product Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Total Remaining');
        
        
        if($records->count()>0){
            $counter=3;
            $sno=1;
            $total_qty=0;
            foreach($records->get() as $row){
                
                $total_qty+=$row->total_remaining;
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $row->variation_id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->product_name);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->total_remaining);
                
                $counter++;
                $sno++;
            }
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $total_qty);
        }
        
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
}
