<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class DashboardController extends Controller
{
    public $active_store =[1,6,11];
    public $urban_store=[11,13];
    
    public function __construct(){
        $this->middleware(['auth']);
        $this->middleware('permission:dashboard');
    }
    
    public function get_received_by_days($sup_id,$days){
         $query=DB::table('product_receiving')
                ->select([DB::raw('SUM(last_receiving) total_received_qty')])
                ->where('supplier_id',$sup_id)
                ->whereRaw("DATE_FORMAT(created_date,'%Y-%m-%d') BETWEEN DATE_FORMAT(DATE_SUB(NOW(),INTERVAL $days DAY),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d')")
               ->get();
                
        $received = "";
        
        if($query->count() > 0){
            $row = $query->first();    
            $received=(int)($row->total_received_qty !="") ? $row->total_received_qty : 0 ;
        }
        
        return $received;
    }
    
    public function get_assigned_info($sup_id){
        $data = [];
        
        
        
        $assign=DB::table('assign_quantity')
            ->where('supplier_id',$sup_id)
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('switch_status','0')
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                'switch_status',
            ])->first();    
                
        $assign2=DB::table('assign_quantity')
            ->where('supplier_id',$sup_id)
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('switch_status','1')
            ->where('receiving_qty','!=','0')
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                'switch_status',
            ])->first();
        $cancelled=DB::table('assign_quantity')
            ->where('supplier_id',$sup_id)
            ->where('supplier_id','!=',1)
            ->where('supplier_id','!=',2)
            ->where('is_cancelled','1')
            ->select([
                DB::raw('sum(assign_quantity.order_qty_given) as order_qty_given'),  
                DB::raw('sum(assign_quantity.receive_qty) as receive_qty'),
                DB::raw('sum(assign_quantity.receiving_qty) as receiving_qty'),
                'switch_status',
            ])->first();
        
        
        $total_actual_order_qty=(int)($assign->order_qty_given !="") ? $assign->order_qty_given : 0 ;
        $total_assigned_order_qty=(int)($assign->receive_qty !="") ? $assign->receive_qty : 0 ;
        $total_received_order_qty=($assign->receiving_qty!="") ? $assign->receiving_qty: 0 ;
        
        $switch_order=(int)($assign2->receive_qty !="") ? $assign2->receive_qty : 0 ;
        $switch_receive_qty=($assign2->receiving_qty!="") ? $assign2->receiving_qty : 0 ;
        
        $cancelled_assigned_order_qty=(int)($cancelled->receive_qty !="") ? $cancelled->receive_qty : 0 ;
        $cancelled_received_order_qty=(int)($cancelled->receiving_qty!="") ? $cancelled->receiving_qty: 0 ;
        $cancelled_qty=$cancelled_assigned_order_qty - $cancelled_received_order_qty;
        
        $data['total_actual_order_qty'] = $total_actual_order_qty;
        $data['total_assigned_order_qty'] = $total_assigned_order_qty;
        $data['total_received_order_qty']= $total_received_order_qty;
        
        $remaining_qty=(int)$total_assigned_order_qty - (int)$total_received_order_qty;
        $remaining_qty-=$cancelled_qty;
        
        $total_assigned_order_qty+=$switch_receive_qty;
        
        $total_received_order_qty+=$switch_receive_qty;
        
        return array_merge($data,[
            'switch_order'=>$switch_order,
            'switch_receive_qty'=>$switch_receive_qty,
            'total_assigned_order_qty_sum'=>$total_assigned_order_qty,
            'total_received_order_qty_sum'=>$total_received_order_qty,
            'remaining_qty'=>$remaining_qty,
            'cancelled_qty' =>$cancelled_qty 
        ]);
    }
    
    
   
    
    public function get_inventory_summary(){
        $html ='';
        
        $sup_list=DB::table('suppliers')->where('id','!=',1)->where('id','!=',2)->where('status','=',1)->get();
        $total_assign=$total_received=$total_cancelled=$total_remaining=$total_seven=$total_thirty=0;
    
        foreach($sup_list as $r){
            $info = $this->get_assigned_info($r->id);
            $seven_days = $this->get_received_by_days($r->id,7);
            $thirty_days = $this->get_received_by_days($r->id,30);
            
            $total_assign+=$info['total_assigned_order_qty_sum'];
            $total_received+=$info['total_received_order_qty_sum'];
            $total_cancelled+=$info['cancelled_qty'];
            $total_remaining+=$info['remaining_qty'];
            $total_seven+=$seven_days;
            $total_thirty+=$thirty_days;
            
            $html.='<tr>
                <td>'.$r->supplier_name.'</td>
                <td>'.$info['remaining_qty'].'</td>
                <td>'.$seven_days.'</td>
                <td>'.$thirty_days.'</td>
            </tr>';
        }
        
        $html.='<tr class="font-weight-bold table-warning">
              <td>Total</td>
              <td>'.$total_remaining.'</td>
              <td>'.$total_seven.'</td>
              <td>'.$total_thirty.'</td>
            </tr>';
        
        return $html;
    }
    
    public function get_shipped_by_store_id($days){
        $arr  = [];
        
        $query = DB::table('shipment')
        ->select([DB::raw('store_id,cargo_select,SUM(total_shipment_qty) total_shipped_qty,SUM(total_remaining_quantity) total_rem_qty')])
        ->where('complete_status',1)
        ->groupBy('store_id')
        ->groupBy('cargo_select');
        
        // if($shipment_type!=''){
            // $query->where('cargo_select',1);
        // }
        if($days!=0){
            $query->whereRaw("DATE_FORMAT(completed_date,'%Y-%m-%d') BETWEEN DATE_FORMAT(DATE_SUB(NOW(),INTERVAL $days DAY),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d')");
        }
        $result = $query->get();
        
        if($result->count() > 0){
            foreach($result as $r){
                $arr[$r->store_id.'-'.$r->cargo_select] = $r->total_shipped_qty - $r->total_rem_qty;
            }
        }
        return $arr;
    }
    
    
    public function get_bundle_qty_by_pr_id_rem($store_id,$shipment_type){
        $total_bundle = 0;
        
        $query = DB::table('bundle_list_pr_wise')
                    ->select([DB::raw('SUM(given_qty) total_pending_qty')])
                    ->where('status',0)
                    // ->where('pr_id',$pr_id)
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)
                    ->get();
        
        if($query->count() > 0){
            $total_bundle = $query->first()->total_pending_qty;
        }
        
        return $total_bundle;//* 3

    }
    
    
    
    public function ready_ship_bundle_wise($store_id,$shipment_type){
        $where=['store_id' =>$store_id ,'shipment_type' =>$shipment_type];
        $query_bundle =DB::table('bundle_list_pr_wise as bpo')
        ->select([DB::raw('bpo.store_id,bpo.pr_id,bpo.shipment_type,SUM(bpo.approve_qty) total_given_orders,SUM(bpo.given_qty) total_pending_orders')])
        ->where($where)
        ->groupBy('bpo.store_id')
        ->groupBy('bpo.shipment_type')
        ->first();
        
        $given=$pending=$ready=0;
        if($query_bundle !=null){
            $given=(int)$query_bundle->total_given_orders;
            $pending=(int)$query_bundle->total_pending_orders;
            $ready=$given-$pending;
        }
        
        return $ready;
    }
    
    
    public function store_wise_summary(){
        $active_store=$this->active_store;
        $active_store[]=13;
        $query =DB::table('process_order_quantity as po')
            ->select([DB::raw('po.store_id,po.shipment_type,s.strong_name,SUM(po.process_qty) total_given_orders,SUM(po.receiving_qty) total_pending_orders')])
            ->join('store as s','s.id','=','po.store_id')
            ->groupBy('po.store_id')
            ->groupBy('po.shipment_type')
            ->whereIn('s.id',$active_store)
            ->whereIn('shipment_type',[1,2,3])
            ->where('po.status','=',0)
            ->get();
        
            // $storeIds = implode(',', $active_store);
    
            // $query = DB::select("
            //     SELECT 
            //     a.store_id,
            //     a.shipment_type,
            //     s.strong_name,
            //     COALESCE(SUM(po.process_qty), 0) AS total_given_orders,
            //     COALESCE(SUM(po.receiving_qty), 0) AS total_pending_orders
            // FROM 
            //     (
            //         SELECT DISTINCT po.store_id, t.shipment_type
            //         FROM process_order_quantity po
            //         JOIN (
            //             SELECT 1 AS shipment_type UNION ALL
            //             SELECT 2 UNION ALL
            //             SELECT 3
            //         ) t
            //         WHERE po.status = 0 AND po.store_id IN ($storeIds)
            //     ) AS a
            // LEFT JOIN process_order_quantity po 
            //     ON po.store_id = a.store_id 
            //   AND po.shipment_type = a.shipment_type 
            //   AND po.status = 0
            // JOIN store s ON s.id = a.store_id
            // GROUP BY a.store_id, a.shipment_type, s.strong_name");
        
        // dd($query);
            
        $html ='';
        
        if($query->count() > 0){
            $shipped_data_seven_days = $this->get_shipped_by_store_id(7);
            $shipped_data_thirty_days = $this->get_shipped_by_store_id(30);
            
            $actual_total_given=$actual_total_single_ready=$actual_total_bundle_ready=$actual_cancelled=$actual_pending=$actual_total_shipped=$actual_total_shipped_seven=$actual_total_shipped_thirty=0;
            
            foreach($query as $r){
                $s_sk=$r->store_id.'-'.$r->shipment_type;
                $total_shipped_seven = isset($shipped_data_seven_days[$s_sk]) && !empty($shipped_data_seven_days[$s_sk]) ? $shipped_data_seven_days[$s_sk] : 0 ;
                $total_shipped_thirty = isset($shipped_data_thirty_days[$s_sk]) && !empty($shipped_data_thirty_days[$s_sk]) ? $shipped_data_thirty_days[$s_sk] : 0 ;
                
                
                if($r->shipment_type==3){
                    $ready_bundle=$this->ready_to_ship_single_qty_awd($r->store_id,$r->shipment_type,2);
                    $ready_single=$this->ready_to_ship_single_qty_awd($r->store_id,$r->shipment_type,1);
                }else{
                    $ready_bundle=$this->ready_to_ship_bundle_qty($r->store_id,$r->shipment_type); 
                    $ready_single=(int)$this->ready_to_ship_single_qty($r->store_id,$r->shipment_type);
                    
                }
                // dd($ready_bundle);
                $pending=($r->total_pending_orders+ $this->get_bundle_qty_by_pr_id_rem($r->store_id,$r->shipment_type));
                
                
                
                
                $actual_total_single_ready+=$ready_single;
                $actual_total_bundle_ready+=$ready_bundle;
                $actual_pending+=$pending;
                $actual_total_shipped_seven+=$total_shipped_seven;
                $actual_total_shipped_thirty+=$total_shipped_thirty;
                
                if($r->shipment_type==1){
                    $a='Air Cargo';
                }else if($r->shipment_type==2){
                    $a='Sea Cargo';
                }else if($r->shipment_type==3){
                    $a='AWD Shipment';
                }
                
                
                $html .='<tr>
                          <td>'.$r->strong_name.'</td>
                          <td>'.$a.'</td>
                          <td>'.$pending.'</td>
                          <td>'.$ready_single.'</td>
                          <td>'.$ready_bundle.'</td>
                          <td>'.$total_shipped_seven.'</td>
                          <td>'.$total_shipped_thirty.'</td>
                        </tr>'; //<td>'.($ready_bundle*3).' BUN ('.$ready_bundle.')'.'</td> 
            }
            
            $html .='<tr class="font-weight-bold table-warning">
              <td colspan="2">Total</td>
              <td>'.$actual_pending.'</td>
              <td>'.$actual_total_single_ready.'</td>
              <td>'.$actual_total_bundle_ready.'</td>
              <td>'.$actual_total_shipped_seven.'</td>
              <td>'.$actual_total_shipped_thirty.'</td>
            </tr>';//<td>'.($actual_total_bundle_ready*3).' BUN ('.$actual_total_bundle_ready.')'.'</td>
        }
        
        return $html;
    }
    
    public function ready_to_ship_single_qty($store_id,$shipment_type){
        $query = DB::table('processed_order_quantity')
                    ->select(
                        [DB::raw('SUM(receiving_qty) total_pending_qty')])
                    ->where('status',0)
                    ->whereRaw('variation_design NOT like "%4BUN%"')
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)->first();
        $total_pending_qty=0;
        if($query !=NULL){
            $total_pending_qty=(int)$query->total_pending_qty;  
        }
        
        return $total_pending_qty;
    }
    
    public function ready_to_ship_single_qty_awd($store_id,$shipment_type,$type=1){
        if($type ==1){
            $like='NOT like';
        }else{
            $like='like';
        }
        
        $query = DB::table('awd_ready_case_pack_quantity')
                    ->select(
                        [DB::raw('SUM(receiving_qty) total_pending_qty')])
                    ->where('status',0)
                    ->whereRaw('variation_design '.$like.' "%4BUN%"')
                    ->where('store_id',$store_id)
                    ->first();
        $total_pending_qty=0;
        if($query !=NULL){
            $total_pending_qty=(int)$query->total_pending_qty;  
        }
        
        return $total_pending_qty;
    }
    
    public function ready_to_ship_bundle_qty($store_id,$shipment_type){
        $query = DB::table('processed_order_quantity')
                    ->select(
                        [DB::raw('SUM(receiving_qty) total_pending_qty')])
                    ->where('status',0)
                    ->whereRaw('variation_design like "%4BUN%"')
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)->first();
        $total_pending_qty=0;
        if($query !=NULL){
            $total_pending_qty=(int)($query->total_pending_qty);  
        }
        
        return $total_pending_qty;
    }
    
    public function pending_order_data_by_type($type){   
        $total_pending = 0;
        $active_store=$this->active_store;
        $active_store[]=13;
        
        $query = DB::table('process_order_quantity')->select([DB::raw('SUM(receiving_qty) total_pending_qty')])->where('status',0)->where('shipment_type',$type)->whereIn('store_id',$active_store)->get();

        if($query->count() > 0){
           $row = $query->first();
           $total_pending = !empty($row->total_pending_qty) ? $row->total_pending_qty : 0;
        }
        
        $query = DB::table('bundle_list_pr_wise')->select([DB::raw('SUM((given_qty)) total_pending_qty')])->where('status',0)->where('shipment_type',$type)->whereIn('store_id',$active_store)->get();

        if($query->count() > 0){
           $row = $query->first();
           $total_pending += !empty($row->total_pending_qty) ? $row->total_pending_qty : 0;
        }
        return $total_pending;
    }
    
    public function get_drop_in_data($days){
        $query=DB::table('product_receiving')
                ->select([DB::raw('SUM(last_receiving) total_received_qty')])
                ->whereRaw("DATE_FORMAT(created_date,'%Y-%m-%d') BETWEEN DATE_FORMAT(DATE_SUB(NOW(),INTERVAL $days DAY),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d')")
               ->get();
                
        $received = "";
        
        if($query->count() > 0){
            $row = $query->first();
            $received=(int)($row->total_received_qty !="") ? $row->total_received_qty : 0 ;
        }
        return $received;
    }
    
    public function get_bulk_received(){
        $total_received = 0;
         
        $rtso = DB::table('assign_quantity')->select([DB::raw("SUM(order_qty_given) order_qty_given,SUM(receive_qty) receive_qty,SUM(receiving_qty) receiving_qty")])
            ->whereraw("pr_id LIKE '%BULK%'")
            ->whereraw("pr_id NOT LIKE '%OTWHBULK%'")
            ->get();

        if($rtso->count() > 0){
            $rowproc = $rtso->first();
            $total_received = !empty($rowproc->receiving_qty) ? $rowproc->receiving_qty : 0;
        }
        
        return $total_received;

    }
    
    
    public function get_bulk_cancelled(){
        $cancelled_qty = 0;
        $rtso = DB::table('assign_quantity')->select([DB::raw("SUM(order_qty_given) order_qty_given,SUM(receive_qty) receive_qty,SUM(receiving_qty) receiving_qty")])
        ->whereraw("pr_id LIKE '%BULK%'")
        ->where('is_cancelled','1')
        ->get();
        
        if($rtso->count() > 0){
            $cancelled = $rtso->first();
            
            $cancelled_assigned_order_qty=(int)($cancelled->receive_qty !="") ? $cancelled->receive_qty : 0 ;
            $cancelled_received_order_qty=(int)($cancelled->receiving_qty!="") ? $cancelled->receiving_qty: 0 ;
            $cancelled_qty=$cancelled_assigned_order_qty - $cancelled_received_order_qty;
        }
        
        return $cancelled_qty;
    }
    
    public function system_statistics(){
        $arr = [];
       
        $total_ready_to_ship_orders = 0;
        $total_ready_to_ship_bundles = 0;
        
        $active_store=$this->active_store;
        $active_store[]=13;
        
        $rtso = DB::table('processed_order_quantity')->select([DB::raw('SUM(receiving_qty) total_ready_to_ship_orders')])
            ->where('status',0)
            ->whereraw("variation_design NOT LIKE '%BUN%'")
            ->whereIn('store_id',$active_store)
            // ->whereIn('shipment_type',[1,2])
            ->get();

        if($rtso->count() > 0){
            $rowproc = $rtso->first();
            $total_ready_to_ship_orders = !empty($rowproc->total_ready_to_ship_orders) ? $rowproc->total_ready_to_ship_orders : 0;
        }
        

        $rtsbundle = DB::table('processed_order_quantity')->select([DB::raw('SUM(receiving_qty) total_ready_to_ship_orders')])
            ->where('status',0)
            ->whereraw("variation_design LIKE '%BUN%'")
            ->whereIn('store_id',$active_store)
            // ->whereIn('shipment_type',[1,2])
            ->get();
    
        if($rtsbundle->count() > 0){
            $rowproc = $rtsbundle->first();
            $total_ready_to_ship_bundles = !empty($rowproc->total_ready_to_ship_orders) ? $rowproc->total_ready_to_ship_orders : 0;
        }
        
        $pending_mos_query = DB::table('purchase_order_quantity')->where('status',0)->groupBy('pr_id')->get();
        
        extract($this->get_wh_urgent());
        

        
        $air_pending = $this->pending_order_data_by_type(1);
        $sea_pending = $this->pending_order_data_by_type(2);
        $arr['total_pending_mos']=$pending_mos_query->count();
        $arr['air_pending_orders']=$air_pending;
        $arr['sea_pending_orders']=$sea_pending;
        $arr['total_pending_orders']= $air_pending + $sea_pending;
        $arr['drop_in_today'] = $this->get_drop_in_data(0);
        $arr['drop_in_seven'] = $this->get_drop_in_data(7);
        $arr['total_ready_to_ship_orders'] = $total_ready_to_ship_orders;
        // $arr['total_ready_to_ship_bundles'] = (int)($total_ready_to_ship_bundles*3).' BUN ('.$total_ready_to_ship_bundles.')';
        $arr['total_ready_to_ship_bundles'] = $total_ready_to_ship_bundles;
        
        $arr['total_urban_wh'] = $total_urban_wh;
        $arr['total_decrum_wh'] = $total_decrum_wh;
        
        return $arr;
        
    }
    
    public function system_statistics_view($returnData =[]){
        $data = $this->system_statistics();
        
        $html_one =' <tr>
            <td>'.$data['total_pending_mos'].'</td>
            <td>'.$data['drop_in_today'].'</td>
            <td>'.$data['drop_in_seven'].'</td>
            <td>'.$data['air_pending_orders'].'</td>
            <td>'.$data['sea_pending_orders'].'</td>
            <td>'.$data['total_pending_orders'].'</td>
            <td>'.$data['total_ready_to_ship_orders'].'</td>
            <td>'.$data['total_ready_to_ship_bundles'].'</td>
            <td>'.$data['total_urban_wh'].'</td>
            <td>'.$data['total_decrum_wh'].'</td>
            <td>'.($returnData['totalOverAllReturn30Day'] ?? 0).'</td>
            <td>'.($returnData['overAllPercentage30Day'] ?? 0).'%</td>
        </tr>';
        return ['system_summary_one'=>$html_one];
    }
    
    ///added by sufian 09-05-24
    public function get_store_wise_pending(){
        $totalBundlePendingQty = DB::table('bundle_list_pr_wise')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(given_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->groupBy('store_id', 'shipment_type')
            ->get();
        
        $formatedBundleResult=collect($totalBundlePendingQty)->pluck(null,'store_shipment')->toArray();
        // dd($formatedBundleResult);
        
        $totalSinglePendingQty = DB::table('process_order_quantity')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(receiving_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->groupBy('store_id', 'shipment_type')
            ->get();
        
        $formatedSingleResult=collect($totalSinglePendingQty)->pluck(null,'store_shipment')->toArray();
        
        
        $totalSingleRTS = DB::table('processed_order_quantity')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(receiving_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->where('variation_id','NOT LIKE','%4BUN%')
            ->groupBy('store_id', 'shipment_type')
            ->get();
            
        $formatedSingleResultRTS=collect($totalSingleRTS)->pluck(null,'store_shipment')->toArray();
        
        $totalBundleRTS = DB::table('processed_order_quantity')
            ->select(DB::raw("CONCAT(store_id, '-', shipment_type) AS store_shipment, SUM(receiving_qty) AS total_pending_qty"))
            ->where('status', 0)
            ->where('variation_id','LIKE','%4BUN%')
            ->groupBy('store_id', 'shipment_type')
            ->get();
            
        
            
        $formatedBundleResultRTS=collect($totalBundleRTS)->pluck(null,'store_shipment')->toArray();
        
        $totalSingleRCP=DB::table('awd_ready_case_pack_quantity as arcpq')
                        ->groupBy('arcpq.store_id')
                        ->where('arcpq.status','0')
                        ->where('arcpq.variation_id','NOT LIKE','%4BUN%')
                        ->select(['arcpq.store_id',
                            DB::raw('sum(arcpq.receiving_qty) as total_pending_qty'),
                            DB::raw('sum(arcpq.process_qty) as approve_qty')
                        ])->get();
                        
        $formatedSingleResultRCP=collect($totalSingleRCP)->pluck(null,'store_id')->toArray();
        
        $totalBundleRCP=DB::table('awd_ready_case_pack_quantity as arcpq')
                        ->groupBy('arcpq.store_id')
                        ->where('arcpq.status','0')
                        ->where('arcpq.variation_id','LIKE','%4BUN%')
                        ->select(['arcpq.store_id',
                            DB::raw('sum(arcpq.receiving_qty) as total_pending_qty'),
                            DB::raw('sum(arcpq.process_qty) as approve_qty')
                        ])->get();
                        
        $formatedBundleResultRCP=collect($totalBundleRCP)->pluck(null,'store_id')->toArray();
        
        // dd($formatedSingleResultRCP,$formatedBundleResultRCP);
        
        $storeList=DB::table('store')->whereIn('id',$this->active_store)->get();
        
        $html='';
        
        if($storeList->count()>0){
            foreach($storeList as $st){
                $air=$st->id.'-1';
                $sea=$st->id.'-2';
                $awd=$st->id.'-3';
                
                $total_bundle_awd=$total_single_awd=$total_awd=0;
                if(isset($formatedBundleResult[$awd])){
                    $total_bundle_awd=$formatedBundleResult[$awd]->total_pending_qty;
                }
                
                
                
                if(isset($formatedSingleResult[$awd])){
                    $total_single_awd=$formatedSingleResult[$awd]->total_pending_qty;
                }
                
                $total_awd=$total_bundle_awd + $total_single_awd;
                
                
                $total_bundle_air=$total_single_air=$total_air=0;
                if(isset($formatedBundleResult[$air])){
                    $total_bundle_air=$formatedBundleResult[$air]->total_pending_qty;
                }
                
                
                
                if(isset($formatedSingleResult[$air])){
                    $total_single_air=$formatedSingleResult[$air]->total_pending_qty;
                }
                
                $total_air=$total_bundle_air + $total_single_air;
                
                
                $total_bundle_sea=$total_single_sea=$total_sea=0;
                if(isset($formatedBundleResult[$sea])){
                    $total_bundle_sea=$formatedBundleResult[$sea]->total_pending_qty;
                }
                
                if(isset($formatedSingleResult[$sea])){
                    $total_single_sea=$formatedSingleResult[$sea]->total_pending_qty;
                }
                
                $total_sea=$total_bundle_sea + $total_single_sea;
                
                $total_bundle_air_rts=$total_single_air_rts=0;
                if(isset($formatedSingleResultRTS[$air])){
                    $total_single_air_rts=$formatedSingleResultRTS[$air]->total_pending_qty;
                }
                
                
                if(isset($formatedBundleResultRTS[$air])){
                    $total_bundle_air_rts=$formatedBundleResultRTS[$air]->total_pending_qty;
                }
                
                $total_bundle_sea_rts=$total_single_sea_rts=0;
                if(isset($formatedSingleResultRTS[$sea])){
                    $total_single_sea_rts=$formatedSingleResultRTS[$sea]->total_pending_qty;
                }
                
                
                if(isset($formatedBundleResultRTS[$sea])){
                    $total_bundle_sea_rts=$formatedBundleResultRTS[$sea]->total_pending_qty;
                }
                
                $total_bundle_air_rcp=$total_single_air_rcp=0;
                if(isset($formatedSingleResultRCP[$st->id])){
                    $total_single_air_rcp=$formatedSingleResultRCP[$st->id]->total_pending_qty;
                }
                
                
                if(isset($formatedBundleResultRCP[$st->id])){
                    $total_bundle_air_rcp=$formatedBundleResultRCP[$st->id]->total_pending_qty;
                }
                
                $air_url=route('excel_store',[$st->id,1]);
                $sea_url=route('excel_store',[$st->id,2]);
                
                $html.='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>'.$st->strong_name.'</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-airplane"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_air.'</h2>
                                                    <span class="text-white">Air Cargo Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-white">Single: '.$total_single_air.'</span>
                                                    <span class="text-white float-right">Bundle: '.$total_bundle_air.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-white">RTS Single: '.$total_single_air_rts.'</span>
                                                    <span class="text-white float-right">RTS Bundle: '.$total_bundle_air_rts.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$air_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon text-dark">
                                                    <i class="zmdi zmdi-boat text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_sea.'</h2>
                                                    <span class="text-dark">Sea Cargo Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-dark">Single: '.$total_single_sea.'</span>
                                                    <span class="text-dark float-right">Bundle: '.$total_bundle_sea.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-dark">RTS Single: '.$total_single_sea_rts.'</span>
                                                    <span class="text-dark float-right">RTS Bundle: '.$total_bundle_sea_rts.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$sea_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-dropbox"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-white">'.$total_awd.'</h2>
                                                    <span class="text-white">AWD Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-white">Single: '.$total_single_awd.'</span>
                                                    <span class="text-white float-right">Bundle: '.$total_bundle_awd.'</span>
                                                </div>
                                                <div class="mb-1">
                                                    <span class="text-white">RTCP Single: '.$total_single_air_rcp.'</span>
                                                    <span class="text-white float-right">RTCP Bundle: '.$total_bundle_air_rcp.'</span>
                                                </div>
                                                <div class="mb-1 d-none">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1" ><a href="'.$sea_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            }
        }
        
        
        
        
        
        return $html;
    }
    
    public function get_wh_inventory(){
        $totals = DB::table('product_info')
                    ->selectRaw('SUM(Quantity) as decrum_wh, SUM(uc_quantity) as urban_wh')
                    ->where('prod_status', 1)
                    ->where('is_deleted', 0)
                    ->first();
        
        $total_decrum_wh=$total_urban_wh=0;
        if($totals){
            $total_decrum_wh=$totals->decrum_wh;
            $total_urban_wh=$totals->urban_wh;
        }
        
        $decrum_url=route("ExportNewInventory",'decrum');
        $urban_url=route("ExportNewInventory",'urban');
        
        
        
        $html='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Warehouse Inventory</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-store"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_decrum_wh.'</h2>
                                                    <span class="text-white">Decrum Warehouse</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$decrum_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-store text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_urban_wh.'</h2>
                                                    <span class="text-dark">UrbanCrest Warehouse</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$urban_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function get_supplier_pending(){
        $totalDecrumPending = DB::table('assign_quantity')
            ->selectRaw('SUM(receive_qty) - SUM(receiving_qty) as total_pending')
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->first();
        
        $total_decrum=$total_urban=0;
        if($totalDecrumPending){
            $total_decrum=$totalDecrumPending->total_pending;
        }
        
        $totalUrbanPending = DB::table('assign_quantity')
            ->selectRaw('SUM(receive_qty) - SUM(receiving_qty) as total_pending')
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%UC%')
            ->first();
        
        if($totalUrbanPending){
            $total_urban=$totalUrbanPending->total_pending;
        }
        
        $decrum_url=route("supplier_excel",'decrum');
        $urban_url=route("supplier_excel",'urban');
        
        
        $html='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Supplier Pending</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-caret-left-circle"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_decrum.'</h2>
                                                    <span class="text-white">Decrum Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$decrum_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-caret-left-circle text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_urban.'</h2>
                                                    <span class="text-dark">UrbanCrest Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$urban_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function get_wh_urgent(){
        $totalDecrumQty = DB::table('process_order_quantity')
            ->select(DB::raw("sum(receiving_qty) as total_urgent"))
            ->where('status', 0)
            ->where('urgent_status',1)
            ->whereNotIn('store_id',$this->urban_store)
            ->first();
        
        $total_decrum_wh=$total_urban_wh=0;
        if($totalDecrumQty){
            $total_decrum_wh=$totalDecrumQty->total_urgent;
        }
        
        $query = DB::table('bundle_list_pr_wise')
                    ->select([DB::raw('SUM(given_qty) total_urgent')])
                    ->where('status',0)
                    ->where('urgent_status',1)
                    ->whereNotIn('store_id',$this->urban_store)
                    ->first();
        if($query){
            $total_decrum_wh+=$query->total_urgent;
        }
        
        $totalUrbanQty = DB::table('process_order_quantity')
            ->select(DB::raw("sum(receiving_qty) as total_urgent"))
            ->where('status', 0)
            ->where('urgent_status',1)
            ->whereIn('store_id',$this->urban_store)
            ->first();
        if($totalUrbanQty){
            $total_urban_wh=$totalUrbanQty->total_urgent;
        // dd($total_urban_wh,$total_decrum_wh);
        }
        
        $query = DB::table('bundle_list_pr_wise')
                    ->select([DB::raw('SUM(given_qty) total_urgent')])
                    ->where('status',0)
                    ->where('urgent_status',1)
                    ->whereIn('store_id',$this->urban_store)
                    ->first();
        if($query){
            $total_urban_wh+=$query->total_urgent;
        }
        
        
        return [
            'total_decrum_wh' => $total_decrum_wh,
            'total_urban_wh' => $total_urban_wh
        ];
    }
    
    public function get_wh_urgent_tag(){
        extract($this->get_wh_urgent());
        
        $decrum_url=route("storeWiseUrgent",'decrum');
        $urban_url=route("storeWiseUrgent",'urban');
        
        
        
        $html='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Urgent Pending</h5>
                            <div class="row mt-3">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-dark">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-alert-triangle"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2>'.$total_decrum_wh.'</h2>
                                                    <span class="text-white">Decrum Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-white float-right mb-1"><a href="'.$decrum_url.'" class="text-white"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="overview-item bg-orange">
                                        <div class="overview__inner">
                                            <div class="overview-box clearfix">
                                                <div class="icon">
                                                    <i class="zmdi zmdi-alert-triangle text-dark"></i>
                                                </div>
                                                <div class="text mb-3">
                                                    <h2 class="text-dark">'.$total_urban_wh.'</h2>
                                                    <span class="text-dark">UrbanCrest Pending</span>
                                                </div>
                                                <div class="mb-1">
                                                    <hr class="mb-1">
                                                    <span class="text-dark float-right mb-1"><a href="'.$urban_url.'" class="text-dark"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function shipment_receiving_stats(Request $request) {
        // Check if it's an AJAX request and handle date range
        if ($request->ajax()) {
            $start_date = $request->start_date;
            $end_date = $request->end_date;
        } else {
            // For non-AJAX requests, calculate last six months by default
            $start_date = null;
            $end_date = null;
        }
    
        // For product receivings
        $receivingQuery = DB::table('product_receiving')
            ->selectRaw("DATE_FORMAT(MIN(created_date), '%b') AS month_year, SUM(last_receiving) AS total_count");
    
        // Add date filters
        if ($start_date && $end_date) {
            $receivingQuery->whereRaw('DATE(created_date) >= ? AND DATE(created_date) <= ?', [$start_date, $end_date]);
        } else {
            $receivingQuery->where('created_date', '>=', DB::raw('DATE_SUB(CURDATE(), INTERVAL 6 MONTH)'));
        }
    
        $totals_receiving = $receivingQuery
            ->groupBy(DB::raw('YEAR(created_date), MONTH(created_date)'))
            ->orderByRaw('YEAR(created_date), MONTH(created_date)')
            ->get();
    
        $month_name = collect($totals_receiving)->pluck('month_year')->toArray();
        $receivings = collect($totals_receiving)->pluck('total_count')->toArray();
    
        // For shipments
        $shipmentQuery = DB::table('shipment')
            ->selectRaw("DATE_FORMAT(MIN(created_at), '%b') AS month_year, SUM(total_shipment_qty) AS total_count");
    
        if ($start_date && $end_date) {
            $shipmentQuery->whereRaw('DATE(created_at) >= ? AND DATE(created_at) <= ?', [$start_date, $end_date]);
        } else {
            $shipmentQuery->where('created_at', '>=', DB::raw('DATE_SUB(CURDATE(), INTERVAL 6 MONTH)'));
        }
    
        $totals_shipments = $shipmentQuery
            ->groupBy(DB::raw('YEAR(created_at), MONTH(created_at)'))
            ->orderByRaw('YEAR(created_at), MONTH(created_at)')
            ->get();
    
        $shipments = collect($totals_shipments)->pluck('total_count')->toArray();
    
        // For Amazon orders
        $filters = [
            "order_status != 'Cancelled'",
            "item_status != 'Cancelled'",
            "sales_channel != 'Non-Amazon'",
            "fulfillment_channel = 'Amazon'",
            "sales_channel != 'SI CA Prod Marketplace'",
            "product_name LIKE '%[4%'"
        ];
    
        $orderQuery = DB::table('amazon_order_report_decrum')
            ->selectRaw("DATE_FORMAT(MIN(purchase_date), '%b') AS month_year, count(amazon_order_id) AS total_count")
            ->whereRaw(implode(' AND ', $filters));
    
        if ($start_date && $end_date) {
            $orderQuery->whereRaw('DATE(purchase_date) >= ? AND DATE(purchase_date) <= ?', [$start_date, $end_date]);
        } else {
            $orderQuery->where('purchase_date', '>=', DB::raw('DATE_SUB(CURDATE(), INTERVAL 6 MONTH)'));
        }
    
        $totals_sales = $orderQuery
            ->groupBy(DB::raw('YEAR(purchase_date), MONTH(purchase_date)'))
            ->orderByRaw('YEAR(purchase_date), MONTH(purchase_date)')
            ->get();
    
        $sales = collect($totals_sales)->pluck('total_count')->toArray();
    
        // Prepare chart data
        $chart_data = [
            'code' => 200,
            'month_name' => $month_name,
            'receivings' => $receivings,
            'shipments' => $shipments,
            'sales' => $sales
        ];
    
        // Return JSON if it's an AJAX request, otherwise return chart data for other purposes
        if ($request->ajax()) {
            return response()->json($chart_data);
        }
    
        return $chart_data;
    }
    public function index(Request $request){
        $path_new = storage_path() . "/data_reports/DashboardAPI.json";
        $jsonData = file_get_contents($path_new);
        $dataDashboarData = json_decode($jsonData, true);
        
        $returnData=$dataDashboarData['returnData'] ?? [];
        
        return view('dashboard.dashboard',[
            //old fields
            'store_view'  => $this->get_store_wise_pending(),
            // 'warehouse_view' => $this->get_wh_inventory(),
            // 'supplier_view' => $this->get_supplier_pending(),
            // 'urgent_view' => $this->get_wh_urgent_tag(),
            'system_summary'=>$this->system_statistics_view($returnData),
            'chart_data' => $this->shipment_receiving_stats($request),
            'store_wise_summary'=>$this->store_wise_summary(),
            'inventory_summary_supplier_wise'=>$this->get_inventory_summary(),
            'storeWiseSaleStock' => $dataDashboarData['storeWiseSaleStock'] ?? [],
            'getInstockRateAndOverStock' => $dataDashboarData['getInstockRateAndOverStock'] ?? [],
            'returnData' => $dataDashboarData['returnData'] ?? [],
        ]);
    }
    
    public function get_supplier_pending_decrum(){
        $supplierList=DB::table('suppliers')->where('status','1')->where('id','!=',1)->get();
        
        $formatedBundleResult = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) as total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->where('status', 0)
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        // dd($formatedBundleResult);
        
        $results_air = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%AIR%')
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_sea = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%SEA%')
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_bulk = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%BULK%')
            ->where('pr_id', 'NOT LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
            
        $nhtml='';
        $decrum_url='';
        $count=1;
        foreach ($supplierList as $sl){
            $total_bundle_sea=0;
            if(isset($formatedBundleResult[$sl->id])){
                $total_bundle_sea=$formatedBundleResult[$sl->id];
            }
            
            $total_air=0;
            if(isset($results_air[$sl->id])){
                $total_air=$results_air[$sl->id];
            }
            
            $total_sea=0;
            if(isset($results_sea[$sl->id])){
                $total_sea=$results_sea[$sl->id];
            }
            
            $total_bulk=0;
            if(isset($results_bulk[$sl->id])){
                $total_bulk=$results_bulk[$sl->id];
            }
            
            $bg='bg-dark';
            $text='text-white';
            if($count% 2==0){
                $bg='bg-orange';
                $text='text-dark';
            }
            
            $decrum_url=route("skuWise_pending",['decrum',$sl->id]);
            
            $nhtml.='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="overview-item '.$bg.'">
                        <div class="overview__inner">
                            <div class="overview-box clearfix">
                                <div class="icon">
                                    <i class="zmdi zmdi-caret-left-circle '.$text.'"></i>
                                </div>
                                <div class="text mb-3">
                                    <h2 class="'.$text.'">'.$total_bundle_sea.'</h2>
                                    <span class="'.$text.'">'.$sl->supplier_name.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Air: '.$total_air.'</span>
                                    <span class="'.$text.' float-right">Sea: '.$total_sea.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Bulk: '.$total_bulk.'</span>
                                </div>
                                <div class="mb-1">
                                    <hr class="mb-1">
                                    <span class="'.$text.' float-right mb-1"><a href="'.$decrum_url.'" class="'.$text.'"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            $count++;
        }
            
        
        
        
        $html='<div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Decrum PK Warehouse Pending</h5>
                            <div class="row mt-3">
                                '.$nhtml.'
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function get_supplier_pending_urban(){
        $supplierList=DB::table('suppliers')->where('status','1')->where('id','!=',1)->get();
        
        $formatedBundleResult = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) as total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('pr_id', 'LIKE', '%UC%')
            ->where('status', 0)
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
            
        $results_air = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%AIR%')
            ->where('pr_id', 'LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_sea = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%SEA%')
            ->where('pr_id', 'LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
        
        $results_bulk = DB::table('assign_quantity')
            ->select('supplier_id', DB::raw('SUM(receive_qty) - SUM(receiving_qty) AS total_pending'))
            ->where('supplier_id', '!=', 1)
            ->where('status', 0)
            ->where('pr_id', 'LIKE', '%BULK%')
            ->where('pr_id', 'LIKE', '%UC%')
            ->groupBy('supplier_id')
            ->get()->pluck('total_pending','supplier_id')->toArray();
            
        
        $nhtml='';
        $decrum_url='';
        $count=1;
        foreach ($supplierList as $sl){
            $total_bundle_sea=0;
            if(isset($formatedBundleResult[$sl->id])){
                $total_bundle_sea=$formatedBundleResult[$sl->id];
            }
            
            $total_air=0;
            if(isset($results_air[$sl->id])){
                $total_air=$results_air[$sl->id];
            }
            
            $total_sea=0;
            if(isset($results_sea[$sl->id])){
                $total_sea=$results_sea[$sl->id];
            }
            
            $total_bulk=0;
            if(isset($results_bulk[$sl->id])){
                $total_bulk=$results_bulk[$sl->id];
            }
            
            $bg='bg-dark';
            $text='text-white';
            if($count% 2==0){
                $bg='bg-orange';
                $text='text-dark';
            }
            
            $decrum_url=route("skuWise_pending",['urban',$sl->id]);
            
            
            $nhtml.='<div class="col-lg-4 col-md-4 col-sm-12 col-12">
                    <div class="overview-item '.$bg.'">
                        <div class="overview__inner">
                            <div class="overview-box clearfix">
                                <div class="icon">
                                    <i class="zmdi zmdi-caret-left-circle '.$text.'"></i>
                                </div>
                                <div class="text mb-3">
                                    <h2 class="'.$text.'">'.$total_bundle_sea.'</h2>
                                    <span class="'.$text.'">'.$sl->supplier_name.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Air: '.$total_air.'</span>
                                    <span class="'.$text.' float-right">Sea: '.$total_sea.'</span>
                                </div>
                                <div class="mb-1">
                                    <span class="'.$text.'">Bulk: '.$total_bulk.'</span>
                                </div>
                                <div class="mb-1">
                                    <hr class="mb-1">
                                    <span class="'.$text.' float-right mb-1"><a href="'.$decrum_url.'" class="'.$text.'"><i class="zmdi zmdi-file-plus"></i> Excel</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>';
            
            $count++;
        }
            
        
        
        
        $html='<div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card border border-warning">
                        
                        <div class="card-body">
                            <h5>Urban Crest PK Warehouse Pending</h5>
                            <div class="row mt-3">
                                '.$nhtml.'
                            </div>
                        </div>
                    </div>
                </div>';
        return $html;
    }
    
    public function supplier_pending_dashboard(){
        return view('dashboard.supplier_pending',[
            //old fields
            'decrum_view'  => $this->get_supplier_pending_decrum(),
            'urban_view' => $this->get_supplier_pending_urban(),
            
        ]);
    }
    
    public function operational_dashboard(){
        
        return view('dashboard.index',[
            
            'inventory_summary_supplier_wise'=>$this->get_inventory_summary(),
            'store_wise_summary'=>$this->store_wise_summary(),
            'system_summary'=>$this->system_statistics_view(),
            
        
            //old fields
            'pending_orders'  => 0,//($pending_orders->pending_order !='')?$pending_orders->pending_order:'0',
            'receiving_order' => 0,//($receiving_order->receiving_qty !='')?$receiving_order->receiving_qty:'0',
            'total_reeiving'  => 0,//($total->receiving_qty !='')?$total->receiving_qty:'0',
            'total_instock' => 0,//($total_instock->total_qty !='')?$total_instock->total_qty:'0',
            'total_ready_shipment' => 0,//($total_ready_shipment->total_qty !='')?$total_ready_shipment->total_qty:'0',
        ]);
    }
    
    public function excel_store($store_id,$shipment_type){
            $store_name=DB::table('store')->where('id',$store_id)->first('strong_name')->strong_name;
            if($shipment_type =="1"){
                $shipment_name='air_cargo';
            }else{
                $shipment_name='sea_cargo';
            }
            
            $title ='Store Name : '.$store_name.' Shipment Type :'.$shipment_name;
            $file_name=$store_name.'_'.$shipment_name.'_pending_'.date('Y_m_d_h_i_s');
            
            $records=DB::table('process_order_quantity')
                    ->groupBy('process_order_quantity.variation_design','process_order_quantity.store_id','process_order_quantity.shipment_type')
                    ->join('product_info_design','product_info_design.variation_design','=','process_order_quantity.variation_design')
                    ->orderBy('product_info_design.variation_id','ASC')
                    ->orderBy('product_info_design.variation_design','ASC')
                    ->orderBy('product_info_design.prod_size','ASC')
                    ->orderBy('product_info_design.prod_design','ASC')
                    ->where('process_order_quantity.status','0')
                    ->where('store_id',$store_id)
                    ->where('shipment_type',$shipment_type)
                    ->select([
                        'process_order_quantity.variation_id',
                        'process_order_quantity.id',
                        'process_order_quantity.variation_design',
                        DB::raw('sum(process_order_quantity.receiving_qty) as approve_qty'),
                        'process_order_quantity.created_date',
                        'product_info_design.product_name',
                    ])->get();
            
            $objPHPExcel= new Spreadsheet();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
            $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle("A2:I2")->getFont()->setBold(true);
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'S No');
            $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'SKU');
            $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Product Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Pending QTY');
            
            $counter=3;
            $sno=1;
                
            $total=0;
            
            if($records->count()>0){
                
                
                foreach($records as $row){
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sno);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->variation_design);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->product_name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $row->approve_qty);
                    
                    $total+=$row->approve_qty;
                    
                    $sno++;
                    $counter++;
                }
            }
            
            $records=DB::table('bundle_list_pr_wise')
                ->join('bundle','bundle.bundle_set_variation','=','bundle_list_pr_wise.bundle_set_variation')
                ->where('bundle_list_pr_wise.status',0)
                ->where('bundle_list_pr_wise.store_id',$store_id)
                ->where('bundle_list_pr_wise.shipment_type',$shipment_type)
                ->groupBy('bundle_list_pr_wise.bundle_set_variation','bundle_list_pr_wise.store_id','bundle_list_pr_wise.shipment_type')
                ->select([
                    'bundle.bundle_set_name',
                    DB::raw('sum(bundle_list_pr_wise.approve_qty) as approve_qty'),
                    DB::raw('sum(bundle_list_pr_wise.given_qty) as given_qty'),
                    DB::raw('sum(bundle_list_pr_wise.remaining_qty) as remaining_qty'),
                    'bundle_list_pr_wise.bundle_set_variation',
                    'bundle_list_pr_wise.store_id',
                    'bundle_list_pr_wise.shipment_type'
                ])->get();
                
            if($records->count()>0){
                foreach($records as $row){
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sno);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->bundle_set_variation);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->bundle_set_name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $row->given_qty);
                    
                    $total+=$row->given_qty;
                    $sno++;
                    $counter++;
                }
            }
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $total);
            
            $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
            $objWriter->setPreCalculateFormulas(false);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
            header('Cache-Control: max-age=0');
            set_time_limit(500);
            ini_set('memory_limit', '-1');
            // ob_clean();
            $objWriter->save('php://output');
            exit;
    }
    
    public function excel_store_urgent($string){
            
            
            $title ='Store Name : '.ucfirst($string);
            $file_name=$string.'_urgent_status_'.date('Y_m_d_h_i_s');
            
            $records=DB::table('process_order_quantity')
                    ->groupBy('process_order_quantity.variation_design','process_order_quantity.store_id','process_order_quantity.shipment_type')
                    ->join('product_info_design','product_info_design.variation_design','=','process_order_quantity.variation_design')
                    ->orderBy('product_info_design.variation_id','ASC')
                    ->orderBy('product_info_design.variation_design','ASC')
                    ->orderBy('product_info_design.prod_size','ASC')
                    ->orderBy('product_info_design.prod_design','ASC')
                    ->where('process_order_quantity.status','0')
                    ->where('process_order_quantity.urgent_status',1)
                    ->select([
                        'process_order_quantity.variation_id',
                        'process_order_quantity.id',
                        'process_order_quantity.variation_design',
                        DB::raw('sum(process_order_quantity.receiving_qty) as approve_qty'),
                        'process_order_quantity.created_date',
                        'product_info_design.product_name',
                    ]);
            
            if($string =='decrum'){
                $records->where('store_id','!=','11');
            }else{
                $records->where('store_id','=','11');
            }
            
            $objPHPExcel= new Spreadsheet();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
            $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
            $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle("A2:I2")->getFont()->setBold(true);
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'S No');
            $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'SKU');
            $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Product Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('D2', 'Pending QTY');
            
            $counter=3;
            $sno=1;
                
            $total=0;
            
            if($records->count()>0){
                
                
                foreach($records->get() as $row){
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $sno);
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->variation_design);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->product_name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $row->approve_qty);
                    
                    $total+=$row->approve_qty;
                    
                    $sno++;
                    $counter++;
                }
            }
            
            
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$counter, $total);
            
            $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
            $objWriter->setPreCalculateFormulas(false);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
            header('Cache-Control: max-age=0');
            set_time_limit(500);
            ini_set('memory_limit', '-1');
            // ob_clean();
            $objWriter->save('php://output');
            exit;
    }
    
    public function supplier_excel($string){
        $records = \DB::table('assign_quantity as aq')
            ->leftJoin('product_info as pi', 'aq.variation_id', '=', 'pi.variation_id')
            ->select('aq.variation_id', 'pi.product_name', \DB::raw('(SUM(aq.receive_qty) - SUM(aq.receiving_qty)) as total_remaining'))
            ->where('aq.supplier_id', '!=', 1)
            ->where('aq.status', '=', 0)
            ->groupBy('aq.variation_id')
            ;
            
        if($string=='decrum'){
            $records->where('pr_id','NOT LIKE','%UC%');
        }else{
            $records->where('pr_id','LIKE','%UC%');
        }
            
        $title =ucfirst($string).' WH Supplier Pending SKU Wise';
        $file_name=$string.'_wh_supplier_pending_sku_wise_'.date('Y_m_d_h_i_s');
        
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
        $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A2:G2")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Variation Id');
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Product Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Total Remaining');
        
        
        if($records->count()>0){
            $counter=3;
            $sno=1;
            $total_qty=0;
            foreach($records->get() as $row){
                
                $total_qty+=$row->total_remaining;
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $row->variation_id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->product_name);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->total_remaining);
                
                $counter++;
                $sno++;
            }
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $total_qty);
        }
        
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
    
    ///added by sufia n05-03-24
    public function skuWise_pending($string,$supplier_id){
        $records = \DB::table('assign_quantity as aq')
            ->leftJoin('product_info as pi', 'aq.variation_id', '=', 'pi.variation_id')
            ->select('aq.variation_id', 'pi.product_name', \DB::raw('(SUM(aq.receive_qty) - SUM(aq.receiving_qty)) as total_remaining'))
            ->where('aq.supplier_id', '=', $supplier_id)
            ->where('aq.status', '=', 0)
            ->groupBy('aq.variation_id');
            
        if($string=='decrum'){
            $records->where('pr_id','NOT LIKE','%UC%');
        }else{
            $records->where('pr_id','LIKE','%UC%');
        }
            
        $title ='Supplier Pending SKU Wise';
        $file_name='supplier_pending_sku_wise_'.date('Y_m_d_h_i_s');
        
        $objPHPExcel= new Spreadsheet();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->mergeCells("A1:F1");
        $objPHPExcel->getActiveSheet()->setCellValue('A1',$title);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal('center');
        $objPHPExcel->getActiveSheet()->getStyle("A2:G2")->getFont()->setBold(true);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', 'Variation Id');
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', 'Product Name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', 'Total Remaining');
        
        
        if($records->count()>0){
            $counter=3;
            $sno=1;
            $total_qty=0;
            foreach($records->get() as $row){
                
                $total_qty+=$row->total_remaining;
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, $row->variation_id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, $row->product_name);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $row->total_remaining);
                
                $counter++;
                $sno++;
            }
            
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$counter, '');
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$counter, 'Total');
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$counter, $total_qty);
        }
        
        
        $objWriter=new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($objPHPExcel);
        $objWriter->setPreCalculateFormulas(false);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $file_name .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        set_time_limit(500);
        ini_set('memory_limit', '-1');
        // ob_clean();
        $objWriter->save('php://output');
        exit;
    }
}
