<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

use App\Helpers\ReportHelper;

class DashboardAPIController extends Controller
{
    public $active_store =[1,6,11,13];
    public $urban_store=[11,13];
    
    public function storeWiseSaleStock($start_date,$end_date,$teamId){
        $path_new = storage_path() . "/data_reports/storeWiseSaleStock.json";
        
        $child=1;
        
        //decrum US
        $sale_us = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['US'],$child,$teamId);
        $inventory_us = ReportHelper::getAmazonInventory("inventory_report_decrum",$child);
        $awd_us = ReportHelper::getAWDInventory("inventory_report_decrum_awd",$child);
        
        //decrum CA
        $sale_ca = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['CA'],$child,$teamId);
        $inventory_ca = ReportHelper::getAmazonInventory("inventory_report_decrum_ca",$child);
        $awd_ca = ReportHelper::getAWDInventory("inventory_report_decrum_ca_awd",$child);
        
        $child=0;
        
        //decrum US parent
        $sale_us_parent = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['US'],$child,$teamId);
        $inventory_us_parent = ReportHelper::getAmazonInventory("inventory_report_decrum",$child);
        $awd_us_parent = ReportHelper::getAWDInventory("inventory_report_decrum_awd",$child);
        
        //decrum CA parent
        $sale_ca_parent = ReportHelper::AmazonOrders("amazon_order_report_decrum",$start_date,$end_date,['CA'],$child,$teamId);
        $inventory_ca_parent = ReportHelper::getAmazonInventory("inventory_report_decrum_ca",$child);
        $awd_ca_parent = ReportHelper::getAWDInventory("inventory_report_decrum_ca_awd",$child);
        
        $data=[
            'sale_child_us' => $sale_us,
            'inventory_child_us' => $inventory_us,
            'awd_child_us' => $awd_us,
            'sale_child_ca' => $sale_ca,
            'inventory_child_ca' => $inventory_ca,
            'awd_child_ca' => $awd_ca,
            'sale_parent_us' => $sale_us_parent,
            'inventory_parent_us' => $inventory_us_parent,
            'awd_parent_us' => $awd_us_parent,
            'sale_parent_ca' => $sale_ca_parent,
            'inventory_parent_ca' => $inventory_ca_parent,
            'awd_parent_ca' => $awd_ca_parent,
        ];
        
        $json_encode = json_encode($data);
        file_put_contents($path_new,$json_encode);
        
        return $data;
    }
    
    public function getPercentage($total_sale,$available_stock){
        $percentage=0;
        if($total_sale !=0 && $available_stock !=0){
            $percentage=($available_stock/$total_sale)*100;
        }
        
        $percentage=round($percentage);
        
        $usable_stock=$total_sale;
        if($percentage <100){
            $usable_stock= ($usable_stock/100) * $percentage;
            $usable_stock=round($usable_stock);
        }
        
        return [
            'percentage' => $percentage,
            'usable_stock' => $usable_stock
        ];
    }
    
    public function getOverStock($total_sale,$shortTermStock){
        $perDaySale= $total_sale /60;
        $daysOfInventory= ($perDaySale > 0) ?  $shortTermStock / $perDaySale: 0;

        $x = $perDaySale * 150;
        $overStock = $shortTermStock - $x;
        $overStock = ($overStock <0) ?0:$overStock;
        
        $overStock_per = ($overStock != 0 && $shortTermStock !=0) ? ($overStock / $shortTermStock) * 100 : 0;
        
        return [
            'perDaySale' => $perDaySale,
            'daysOfInventory' => $daysOfInventory,
            'overStock' => $overStock,
            'overStock_per' => $overStock_per 
        ];
    }
    
    
    public function getInstockRate($total_usable,$total_avg){
        $instock_per=0;
        if($total_avg>0){
            $instock_per=($total_usable/$total_avg)*100;
            $instock_per=round($instock_per);
            
        }
        
        return $instock_per;
    }
    
    
    
    
    
    public function getInstockRateAndOverStock(){
        $path_new = storage_path() . "/data_reports/storeWiseSaleStock.json";
        $jsonData = file_get_contents($path_new);
        $dataSale = json_decode($jsonData, true);
        
        // dd($dataSale);
        
        $fields_single='prod_status,
                    group_id,
                    variation_design,
                    prod_design,
                    product_name,
                    grade';
    
        $fields_bundle='status as prod_status,
                    bundle_group as group_id,
                    bundle_set_variation as variation_design,
                    decrum_instock as prod_design,
                    bundle_name as product_name,
                    grade';
                    
        $where_single=$where_bundle=' is_deleted = 0';
        $where_single .=' AND prod_status = 1';
        $where_bundle .=' AND status = 1';
        
        $results_bundle = DB::table('bundle')->selectRaw($fields_bundle)->whereRaw($where_bundle);
        $results = DB::table('product_info_design')->selectRaw($fields_single)->whereRaw($where_single);
                            
        $results=$results->union($results_bundle);
        $stable=$results->get();
        
        $all_sale_us=$all_usable_us=$all_stock_us=0;
        $overall_sale_us=$overall_usable_us=$overall_stock_us=0;
        
        $all_sale_ca=$all_usable_ca=$all_stock_ca=0;
        $overall_sale_ca=$overall_usable_ca=$overall_stock_ca=0;
        
        $all_overstock_us=$all_overstock_ca=0;
        
        $total_awd_us = $total_res_us = $total_inbound_us = 0;
        $total_awd_ca = $total_res_ca = $total_inbound_ca = 0;
        
        if(!empty($stable)){
            foreach($stable as $row){
                    
                // dd($row->variation_design);
                
                
                $group_design=$row->variation_design;
                $product_name=$row->product_name;
                
                $sku=$group_design;
                
                $total_sale_us = ReportHelper::totalSale($sku,$dataSale,1,'US');
                $total_sale_ca = ReportHelper::totalSale($sku,$dataSale,1,'CA');
                
                
                $available_stock_us=ReportHelper::stockCheck($sku,$dataSale,1,'US','instock');
                $available_stock_ca=ReportHelper::stockCheck($sku,$dataSale,1,'CA','instock');
                
                $awd_us=ReportHelper::stockCheck($sku,$dataSale,1,'US','awd_instock');
                $awd_ca=ReportHelper::stockCheck($sku,$dataSale,1,'CA','awd_instock');
                
                $total_awd_us +=$awd_us;
                $total_awd_ca +=$awd_ca;
                
                $res_us=ReportHelper::stockCheck($sku,$dataSale,1,'US','reserved');
                $res_ca=ReportHelper::stockCheck($sku,$dataSale,1,'CA','reserved');
                
                $awd_res_us=ReportHelper::stockCheck($sku,$dataSale,1,'US','awd_reserved');
                $awd_res_ca=ReportHelper::stockCheck($sku,$dataSale,1,'CA','awd_reserved');
                
                $rus=$res_us + $awd_res_us;
                $total_res_us+=$rus;
                
                $rca=$res_ca + $awd_res_ca;
                $total_res_ca+=$rca;
                
                $awdResUS= $awd_us + $res_us + $awd_res_us;
                $awdResCA= $awd_ca + $res_ca + $awd_res_ca;
                
                $inbound_us=ReportHelper::stockCheck($sku,$dataSale,1,'US','inbound');
                $inbound_ca=ReportHelper::stockCheck($sku,$dataSale,1,'CA','inbound');
                
                $awd_inbound_us=ReportHelper::stockCheck($sku,$dataSale,1,'US','awd_inbound');
                $awd_inbound_ca=ReportHelper::stockCheck($sku,$dataSale,1,'CA','awd_inbound');
                
                $inboundUS = $inbound_us + $awd_inbound_us;
                $inboundCA = $inbound_ca + $awd_inbound_ca;
                
                $total_inbound_us+=$inboundUS;
                $total_inbound_ca+=$inboundCA;
                
                
                $shortTermStockUS = $available_stock_us;
                $longTermStockUS =  $available_stock_us +  $awdResUS + $inboundUS;
                
                
                $shortTermStockCA = $available_stock_ca;
                $longTermStockCA =  $available_stock_ca +  $awdResCA + $inboundCA;
                
                $totalSaleShortUS = $total_sale_us * 1;
                $totalSaleLongUS = $total_sale_us * 2;
                
                $totalSaleShortCA = $total_sale_ca * 1;
                $totalSaleLongCA = $total_sale_ca * 2;
                
                $perShortUS=$this->getPercentage($totalSaleShortUS,$shortTermStockUS);
                
                $percentageShortUS=$perShortUS['percentage'];
                $usable_stock_us=$perShortUS['usable_stock'];
                
                $all_sale_us+=$totalSaleShortUS;
                $all_usable_us+=$usable_stock_us;
                $all_stock_us+=$shortTermStockUS;
                
                $perLongUS=$this->getPercentage($totalSaleLongUS,$longTermStockUS);
                
                $percentageLongUS=$perLongUS['percentage'];
                $usable_long_us=$perLongUS['usable_stock'];
                
                $overall_sale_us+=$totalSaleLongUS;
                $overall_usable_us+=$usable_long_us;
                $overall_stock_us+=$longTermStockUS;
                
                $perShortCA=$this->getPercentage($totalSaleShortCA,$shortTermStockCA);
                
                $percentageShortCA=$perShortCA['percentage'];
                $usable_stock_ca=$perShortCA['usable_stock'];
                
                $all_sale_ca+=$totalSaleShortCA;
                $all_usable_ca+=$usable_stock_ca;
                $all_stock_ca+=$shortTermStockCA;
                
                $perLongCA=$this->getPercentage($totalSaleLongCA,$longTermStockCA);
                
                $percentageLongCA=$perLongCA['percentage'];
                $usable_long_ca=$perLongCA['usable_stock'];
                
                $overall_sale_ca+=$totalSaleLongCA;
                $overall_usable_ca+=$usable_long_ca;
                $overall_stock_ca+=$longTermStockCA;
                
                $overUS=$this->getOverStock($total_sale_us,$shortTermStockUS);
                
                $perDaySaleUS = $overUS['perDaySale'];
                $daysOfInventoryUS = $overUS['daysOfInventory'];
                $overStockUS = $overUS['overStock'];
                $overStock_per_us = $overUS['overStock_per'];
                
                $overCA=$this->getOverStock($total_sale_ca,$shortTermStockCA);
                
                $perDaySaleCA = $overCA['perDaySale'];
                $daysOfInventoryCA = $overCA['daysOfInventory'];
                $overStockCA = $overCA['overStock'];
                $overStock_per_ca = $overCA['overStock_per'];
                
                $all_overstock_us+=$overStockUS;
                $all_overstock_ca+=$overStockCA;
                
                
            }
            
            
            
            
        }
        
        $instock_per_short_us = $this->getInstockRate($all_usable_us,$all_sale_us);
        $instock_per_short_ca = $this->getInstockRate($all_usable_ca,$all_sale_ca);
        
        $instock_per_long_us = $this->getInstockRate($overall_usable_us,$overall_sale_us);
        $instock_per_long_ca = $this->getInstockRate($overall_usable_ca,$overall_sale_ca);
        
        $alloverStock_per_us = $this->getInstockRate($all_overstock_us,$all_stock_us);
        $alloverStock_per_ca = $this->getInstockRate($all_overstock_ca,$all_stock_ca);
        
        $json_data = [
            'total_sale_short_us' => $all_sale_us,
            'total_sale_long_us' => $overall_sale_us,
            'total_stock_short_us' => $all_stock_us,
            'total_stock_long_us' => $overall_stock_us,
            'total_usable_short_us' => $all_usable_us,
            'total_usable_long_us' => $overall_usable_us,
            'instock_per_short_us' => $instock_per_short_us,
            'instock_per_long_us' => $instock_per_long_us,
            'alloverStock_per_us' => $alloverStock_per_us,
            'all_overstock_us' => $all_overstock_us,
            
            'total_sale_short_ca' => $all_sale_ca,
            'total_sale_long_ca' => $overall_sale_ca,
            'total_stock_short_ca' => $all_stock_ca,
            'total_stock_long_ca' => $overall_stock_ca,
            'total_usable_short_ca' => $all_usable_ca,
            'total_usable_long_ca' => $overall_usable_ca,
            'instock_per_short_ca' => $instock_per_short_ca,
            'instock_per_long_ca' => $instock_per_long_ca,
            'alloverStock_per_ca' => $alloverStock_per_ca,
            'all_overstock_ca' => $all_overstock_ca,
            
            'total_awd_us' => $total_awd_us,
            'total_res_us' => $total_res_us,
            'total_inbound_us' => $total_inbound_us,
            'total_awd_ca' => $total_awd_ca,
            'total_res_ca' => $total_res_ca,
            'total_inbound_ca' => $total_inbound_ca,
        ];
        
        return $json_data;
    }
    
    public function returnData(){
        $days=29;
        $yesterday = new \DateTime('yesterday');
        $last60DaysDate = clone $yesterday;

        $last60DaysDate->modify('-'.$days.' days');

        $start_date= $last60DaysDate->format('Y-m-d');
        $end_date= $yesterday->format('Y-m-d');
        
        $totalOverAllSale = ReportHelper::AmazonTotalOrders("amazon_order_report_decrum", $start_date,$end_date,[],4);
        $totalOverAllReturn = ReportHelper::AmazonTotalReturns("amazon_return_report_decrum", $start_date,$end_date,4);
        
        $overAllPercentage=($totalOverAllSale !=0)?round($totalOverAllReturn*100/$totalOverAllSale):0;
        
        return [
            'totalOverAllSale30Day' => $totalOverAllSale,
            'totalOverAllReturn30Day' => $totalOverAllReturn,
            'overAllPercentage30Day' => $overAllPercentage
        ];
    }
    
    public function getDashboardStats(){
        $path_new = storage_path() . "/data_reports/DashboardAPI.json";
        
        $teamId=4;
        $child=1;
        
        $days=59;
        $yesterday = new \DateTime('yesterday');
        $last60DaysDate = clone $yesterday;

        $last60DaysDate->modify('-'.$days.' days');

        $start_date= $last60DaysDate->format('Y-m-d');
        $end_date= $yesterday->format('Y-m-d');
        
        $storeWiseSaleStock=$this->storeWiseSaleStock($start_date,$end_date,$teamId);
        $getInstockRateAndOverStock=$this->getInstockRateAndOverStock();
        $returnData=$this->returnData();
        
        $data=[
            'storeWiseSaleStock' => $storeWiseSaleStock,
            'getInstockRateAndOverStock' => $getInstockRateAndOverStock,
            'returnData' => $returnData,
            'last_update' => now()
        ];
        
        $json_encode = json_encode($data);
        file_put_contents($path_new,$json_encode);
        
        return response()->json([
            'code' => 200,
            'message' => 'Dashboard API Refresh successfully'
        ]);
    }
}
