<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Rules\ReCaptcha;


class LoginController extends Controller
{
    public function __construct(){
        $this->middleware('guest')->except('logout');
        $this->middleware('guest:supplier')->except('logout');
        
        \Debugbar::disable();
    }

    public function index(){
        session(['url.intended' => url()->previous()]);
        return view('auth.login',['url' => 'Admin']);
    }

    public function supplier(){
        return abort('404');
        return view('auth.login',['url' => 'Supplier']);
    }

    public function supplierLogin(Request $request){
        $this->validate($request,[
            'email' => 'required',
            'password' => 'required',
            'g-recaptcha-response' => ['required', new ReCaptcha]
    	]);
        if (!auth('supplier')->attempt(['username' => $request->email, 'password' => $request->password])) {
    
           return back()->with('has_error','Invalid Login Credentials');
        }
        // echo "login";exit;

        return redirect()->route('supplier.quantity');

    }

    public function store(Request $request,$current_url=''){
        // dd($request->all());
        
    	$this->validate($request,[
            'email' => 'required|email',
            'password' => 'required',
            'g-recaptcha-response' => ['required', new ReCaptcha]
    	]);

        if(!auth()->attempt($request->only('email','password'))){
    		return back()->with('has_error','Invalid Login Credentials');
    	}
    	
    	$current_url=session()->get('url.intended');
    	if($current_url !='' && preg_match('/^esireopex/im',$current_url)){
    	    return redirect()->intended($current_url);
    	}else{
    	    return redirect()->route('dashboard');    
    	}
    	
    }

    public function logout(){
        if(auth('web')->check()){
            auth('web')->logout();
	   	    return redirect()->route('home');

        }else if(auth('supplier')->check()){
            auth('supplier')->logout();
            return redirect()->route('login.supplier');    
        }
    }


    
}
